/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ctbotp.apiparam.CtDeleteBillsArgs;
import kd.bos.entity.ctbotp.apiparam.CtEntryLkDownReq;
import kd.bos.entity.ctbotp.apiparam.CtEntryLkUpReq;
import kd.bos.entity.ctbotp.apiparam.CtGetEntityInfoReq;
import kd.bos.entity.ctbotp.apiparam.CtLkDownQueryReq;
import kd.bos.entity.ctbotp.apiparam.CtQuerySyncResultReq;
import kd.bos.entity.ctbotp.apiparam.CtSyncRouteArgs;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkDownRes;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkRes;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkUpRes;
import kd.bos.entity.ctbotp.apiresponse.CtEntryLkDownRes;
import kd.bos.entity.ctbotp.apiresponse.CtEntryLkUpRes;
import kd.bos.entity.ctbotp.apiresponse.CtGetEntityInfoRes;
import kd.bos.entity.ctbotp.apiresponse.CtQuerySyncResultRes;
import kd.bos.entity.ctbotp.link.CtAddLinkArgs;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtLkDownQueryArgs;
import kd.bos.entity.ctbotp.link.CtLkUpQueryArgs;
import kd.bos.entity.ctbotp.runtime.CtSaveArgs;
import kd.bos.entity.ctbotp.runtime.CtSaveOperationResult;
import kd.bos.entity.ctbotp.runtime.CtSyncArgs;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.service.ctbotp.entity.CtEntityServiceHelper;
import kd.bos.service.ctbotp.save.lk.CtBotpRouteManage;
import kd.bos.service.ctbotp.service.CtBillLkQueryService;
import kd.bos.service.ctbotp.service.CtBillLkServiceHelper;
import kd.bos.service.ctbotp.service.CtEntryLkQueryService;
import kd.bos.service.ctbotp.sync.CtSyncEngine;
import kd.bos.service.ctbotp.synclog.CtBotpQueryRstService;
import kd.bos.service.ctbotp.utils.BeanCopyUtils;
import kd.bos.servicehelper.CtSaveServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

@ApiController(value="bos", desc="\u8de8\u79df\u6237BOTP")
@ApiMapping(value="/ctbotp")
public class CtBotpSyncController {
    private Log log = LogFactory.getLog(CtBotpSyncController.class);

    @ApiPostMapping(value="/sync", desc="\u540c\u6b65\u670d\u52a1")
    public CustomApiResult<CtSaveOperationResult> sync(@Valid @ApiRequestBody(value="\u540c\u6b65\u670d\u52a1\u53c2\u6570\u4fe1\u606f", required=true) CtSyncArgs ctSyncArgs) {
        try {
            CtSaveOperationResult ctSyncResult = null;
            CtSyncEngine ctSyncEngine = new CtSyncEngine();
            ctSyncResult = ctSyncEngine.ctSync(ctSyncArgs);
            return CustomApiResult.success((Object)ctSyncResult);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            return CustomApiResult.fail((String)"500", (String)errorMsg);
        }
    }

    @ApiPostMapping(value="/ctSave", desc="\u4fdd\u5b58\u76ee\u6807\u5355")
    public CustomApiResult<CtSaveOperationResult> ctSave(@Valid @ApiRequestBody(value="\u4fdd\u5b58\u76ee\u6807\u5355\u53c2\u6570\u4fe1\u606f", required=true) CtSaveArgs ctSaveArgs) {
        try {
            CtSaveOperationResult ctSaveOperationResult = CtSaveServiceHelper.ctSave((CtSaveArgs)ctSaveArgs);
            return CustomApiResult.success((Object)ctSaveOperationResult);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            return CustomApiResult.fail((String)"500", (String)errorMsg);
        }
    }

    @ApiPostMapping(value="/getCtDirtBillLkDown", desc="\u4e0b\u67e5\u76f4\u63a5\u4e0b\u7ea7")
    public CustomApiResult<List<CtBillLkRes>> getCtDirtBillLkDown(@Valid @ApiRequestBody(value="\u4e0b\u67e5\u76f4\u63a5\u4e0b\u7ea7", required=true) CtLkDownQueryArgs ctLkDownQueryArgs) {
        try {
            List ctBillLks = CtBillLinkService.getCtDirtBillLkDown((CtLkDownQueryArgs)ctLkDownQueryArgs);
            ArrayList<CtBillLkRes> ctBillLkResList = new ArrayList<CtBillLkRes>(16);
            for (CtBillLk ctBillLk : ctBillLks) {
                CtBillLkRes ctBillLkRes = BeanCopyUtils.toCtBillLkRes(ctBillLk);
                ctBillLkResList.add(ctBillLkRes);
            }
            return CustomApiResult.success(ctBillLkResList);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            return CustomApiResult.fail((String)"500", (String)errorMsg);
        }
    }

    @ApiPostMapping(value="/getCtBillLkDown", desc="\u4e0b\u67e5")
    public CustomApiResult<CtBillLkDownRes> getCtBillLkDown(@Valid @ApiRequestBody(value="\u4e0b\u67e5", required=true) CtLkDownQueryReq ctLkDownQueryReq) {
        try {
            String sTenantCode = ctLkDownQueryReq.getsTenantCode();
            String sAccountId = ctLkDownQueryReq.getsAccountId();
            String sEntityKey = ctLkDownQueryReq.getsEntityKey();
            List sBillIds = ctLkDownQueryReq.getsBillIds();
            Boolean onlyDirtTarget = ctLkDownQueryReq.getOnlyDirtTarget();
            return CustomApiResult.success((Object)CtBillLkQueryService.loadBillLinkDownForApi(sTenantCode, sAccountId, sEntityKey, sBillIds.toArray(new Long[0]), onlyDirtTarget));
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            return CustomApiResult.fail((String)"500", (String)errorMsg);
        }
    }

    @ApiPostMapping(value="/getCtEntryLkDown", desc="\u4e0b\u67e5\u5206\u5f55")
    public CustomApiResult<CtEntryLkDownRes> getCtEntryLkDown(@Valid @ApiRequestBody(value="\u4e0b\u67e5\u5206\u5f55", required=true) CtEntryLkDownReq ctEntryLkDownReq) {
        try {
            return CustomApiResult.success((Object)CtEntryLkQueryService.loadEntryLinkDownRowsFullForApi(ctEntryLkDownReq));
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            return CustomApiResult.fail((String)"500", (String)errorMsg);
        }
    }

    @ApiPostMapping(value="/getCtEntryLkUp", desc="\u4e0a\u67e5\u5206\u5f55")
    public CustomApiResult<CtEntryLkUpRes> getCtEntryLkUp(@Valid @ApiRequestBody(value="\u4e0a\u67e5\u5206\u5f55", required=true) CtEntryLkUpReq ctEntryLkUpReq) {
        try {
            return CustomApiResult.success((Object)CtEntryLkQueryService.loadEntryLinkUpRowsFullForApi(ctEntryLkUpReq));
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            return CustomApiResult.fail((String)"500", (String)errorMsg);
        }
    }

    @ApiPostMapping(value="/getCtBillLkUp", desc="\u4e0a\u67e5")
    public CustomApiResult<CtBillLkUpRes> getCtBillLkUp(@Valid @ApiRequestBody(value="\u4e0a\u67e5", required=true) CtLkUpQueryArgs ctLkUpQueryArgs) {
        try {
            String tTenantCode = ctLkUpQueryArgs.gettTenantCode();
            String tAccountId = ctLkUpQueryArgs.gettAccountId();
            String tEntityKey = ctLkUpQueryArgs.gettEntityKey();
            List tBillIds = ctLkUpQueryArgs.gettBillIds();
            return CustomApiResult.success((Object)CtBillLkQueryService.loadBillLinkUpFullForApi(tTenantCode, tAccountId, tEntityKey, tBillIds.toArray(new Long[0])));
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            return CustomApiResult.fail((String)"500", (String)errorMsg);
        }
    }

    @ApiPostMapping(value="/deleteBills", desc="\u5220\u9664\u5355\u636e")
    public CustomApiResult<List<Long>> deleteBills(@Valid @ApiRequestBody(value="\u5220\u9664\u5355\u636e", required=true) CtDeleteBillsArgs ctDeleteBillsArgs) {
        try {
            OperateOption delOption = OperateOption.create();
            delOption.setVariableValue("ignorewarn", String.valueOf(true));
            delOption.setVariableValue("ignoreinteraction", String.valueOf(true));
            Operations operations = EntityMetadataCache.getDataEntityOperations((String)ctDeleteBillsArgs.getEntityKey());
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)(StringUtils.isBlank((CharSequence)operations.getDelete()) ? "delete" : operations.getDelete()), (String)ctDeleteBillsArgs.getEntityKey(), (Object[])ctDeleteBillsArgs.gettBillIds().toArray(new Object[0]), (OperateOption)delOption);
            List ids = operationResult.getSuccessPkIds().stream().map(a -> (Long)a).collect(Collectors.toList());
            return CustomApiResult.success(ids);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            return CustomApiResult.fail((String)"500", (String)errorMsg);
        }
    }

    @ApiPostMapping(value="/addLinks", desc="\u6dfb\u52a0\u5173\u8054\u5173\u7cfb")
    public CustomApiResult<String> addLinks(@Valid @ApiRequestBody(value="\u6dfb\u52a0\u5173\u8054\u5173\u7cfb", required=true) CtAddLinkArgs ctAddLinkArgs) {
        try {
            CtBillLkServiceHelper.addCtBillLinks(ctAddLinkArgs);
            return CustomApiResult.success(null);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            return CustomApiResult.fail((String)"500", (String)errorMsg);
        }
    }

    @ApiPostMapping(value="/addSyncRoute", desc="\u6dfb\u52a0\u540c\u6b65\u8def\u7ebf")
    public CustomApiResult<String> addSyncRoute(@Valid @ApiRequestBody(value="\u6dfb\u52a0\u540c\u6b65\u8def\u7ebf", required=true) CtSyncRouteArgs ctSyncRouteArgs) {
        try {
            CtBotpRouteManage.addAllRoute(ctSyncRouteArgs);
            return CustomApiResult.success(null);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            return CustomApiResult.fail((String)"500", (String)errorMsg);
        }
    }

    @ApiPostMapping(value="/getEntityInfos", desc="\u83b7\u53d6\u5b9e\u4f53\u4fe1\u606f")
    public CustomApiResult<CtGetEntityInfoRes> getEntityInfos(@Valid @ApiRequestBody(value="\u83b7\u53d6\u5b9e\u4f53\u4fe1\u606f", required=true) CtGetEntityInfoReq ctGetEntityInfoReq) {
        try {
            return CustomApiResult.success((Object)CtEntityServiceHelper.getEntityInfoRes(ctGetEntityInfoReq));
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            return CustomApiResult.fail((String)"500", (String)errorMsg);
        }
    }

    @ApiPostMapping(value="/querySyncResult", desc="\u67e5\u8be2\u540c\u6b65\u7ed3\u679c")
    public CustomApiResult<CtQuerySyncResultRes> querySyncResult(@Valid @ApiRequestBody(value="\u67e5\u8be2\u540c\u6b65\u7ed3\u679c", required=true) CtQuerySyncResultReq ctQuerySyncResultReq) {
        try {
            return CustomApiResult.success((Object)CtBotpQueryRstService.getCtSyncLogResult(ctQuerySyncResultReq));
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            return CustomApiResult.fail((String)"500", (String)errorMsg);
        }
    }
}

