/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.ctbotp.sync.SSyncLogService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtConvertRuleCache;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.constants.CtSyncLogConst;
import kd.bos.entity.ctbotp.constants.LkSyncStatusEnum;
import kd.bos.entity.ctbotp.constants.SyncStatusEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtLkUpQueryArgs;
import kd.bos.entity.ctbotp.runtime.CtConvertOperationResult;
import kd.bos.entity.ctbotp.runtime.CtPushArgs;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.ICtConvertEngineService;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.actions.CtAddBillRouteAction;
import kd.bos.service.ctbotp.convert.actions.CtAttachmentPanelPushAction;
import kd.bos.service.ctbotp.convert.actions.CtBuildQueryParameterAction;
import kd.bos.service.ctbotp.convert.actions.CtCompileRuleAction;
import kd.bos.service.ctbotp.convert.actions.CtConvertSaveAction;
import kd.bos.service.ctbotp.convert.actions.CtCreateConvertPlugAction;
import kd.bos.service.ctbotp.convert.actions.CtCreateDependEntityRowsAction;
import kd.bos.service.ctbotp.convert.actions.CtCreateLinkEntityRowsAction;
import kd.bos.service.ctbotp.convert.actions.CtCreateSyncLogAction;
import kd.bos.service.ctbotp.convert.actions.CtCreateTargetBillAction;
import kd.bos.service.ctbotp.convert.actions.CtCreateTargetBillIdAction;
import kd.bos.service.ctbotp.convert.actions.CtDataMutexAction;
import kd.bos.service.ctbotp.convert.actions.CtFillLinkInfoAction;
import kd.bos.service.ctbotp.convert.actions.CtFilterCoverBillAction;
import kd.bos.service.ctbotp.convert.actions.CtGroupSourceRowsAction;
import kd.bos.service.ctbotp.convert.actions.CtInitializeAction;
import kd.bos.service.ctbotp.convert.actions.CtLoadDependEntityRowsAction;
import kd.bos.service.ctbotp.convert.actions.CtLoadFunctionTypesAction;
import kd.bos.service.ctbotp.convert.actions.CtLoadSourceDataAction;
import kd.bos.service.ctbotp.convert.actions.CtMappingDependFieldAction;
import kd.bos.service.ctbotp.convert.actions.CtMappingFieldAction;
import kd.bos.service.ctbotp.convert.actions.CtMergePushResultAction;
import kd.bos.service.ctbotp.convert.actions.CtPushAgainCheckForCoverAction;
import kd.bos.service.ctbotp.convert.actions.CtRunRuleConditionAction;
import kd.bos.service.ctbotp.convert.actions.CtSortSourceRowsAction;
import kd.bos.service.ctbotp.utils.CtDescUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.collections.MapUtils;

public class CtConvertCoverEngineImpl
implements ICtConvertEngineService {
    private static final Log log = LogFactory.getLog(CtConvertCoverEngineImpl.class);
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-ctbotp";
    private static final String CONVERT_ENGINE = "CtConvertEngine";

    @Override
    public List<AbstractCtConvertAction> createActions(CtConvertContext context, CtConvertResultManager resultManager) {
        ArrayList<AbstractCtConvertAction> pushActions = new ArrayList<AbstractCtConvertAction>(16);
        pushActions.add(new CtCreateConvertPlugAction(context, resultManager));
        pushActions.add(new CtLoadFunctionTypesAction(context, resultManager));
        pushActions.add(new CtInitializeAction(context, resultManager));
        pushActions.add(new CtRunRuleConditionAction(context, resultManager));
        pushActions.add(new CtDataMutexAction(context, resultManager));
        pushActions.add(new CtPushAgainCheckForCoverAction(context, resultManager));
        pushActions.add(new CtFilterCoverBillAction(context, resultManager));
        pushActions.add(new CtCompileRuleAction(context, resultManager));
        pushActions.add(new CtBuildQueryParameterAction(context, resultManager));
        pushActions.add(new CtLoadSourceDataAction(context, resultManager));
        pushActions.add(new CtLoadDependEntityRowsAction(context, resultManager));
        pushActions.add(new CtSortSourceRowsAction(context, resultManager));
        pushActions.add(new CtGroupSourceRowsAction(context, resultManager));
        pushActions.add(new CtCreateTargetBillIdAction(context, resultManager));
        pushActions.add(new CtCreateSyncLogAction(context, resultManager));
        pushActions.add(new CtCreateTargetBillAction(context, resultManager));
        pushActions.add(new CtCreateLinkEntityRowsAction(context, resultManager));
        pushActions.add(new CtCreateDependEntityRowsAction(context, resultManager));
        pushActions.add(new CtMappingDependFieldAction(context, resultManager));
        pushActions.add(new CtMappingFieldAction(context, resultManager));
        pushActions.add(new CtFillLinkInfoAction(context, resultManager));
        pushActions.add(new CtAttachmentPanelPushAction(context, resultManager));
        pushActions.add(new CtMergePushResultAction(context, resultManager));
        pushActions.add(new CtAddBillRouteAction(context, resultManager));
        pushActions.add(new CtConvertSaveAction(context, resultManager));
        return pushActions;
    }

    @Override
    public void afterConvert(CtConvertResultManager resultManager, CtConvertOperationResult ctConvertOperationResult, CtPushArgs pushArgs) {
        if (resultManager != null) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    this.addSSyncLog(resultManager, ctConvertOperationResult, pushArgs);
                    this.updateSSyncLog(resultManager, ctConvertOperationResult);
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error(e);
                }
            }
        }
    }

    private void addSSyncLog(CtConvertResultManager resultManager, CtConvertOperationResult ctConvertOperationResult, CtPushArgs pushArgs) {
        Set<Object> sbillIdSet = resultManager.getSbillIdSet();
        ArrayList<SyncLog> sSyncLogs = new ArrayList<SyncLog>(sbillIdSet.size());
        ArrayList<Long> ids = new ArrayList<Long>(sbillIdSet.size());
        CtConvertRuleElement rule = CtConvertRuleCache.loadRule((String)pushArgs.getRuleId());
        for (Object billId : sbillIdSet) {
            if (!(billId instanceof Long)) continue;
            ids.add((Long)billId);
        }
        List<SyncLog> syncLogs = ctConvertOperationResult.getsSyncLogs();
        if (CollectionUtils.isEmpty((Collection)syncLogs)) {
            syncLogs = resultManager.getsSyncLogs();
        }
        if (syncLogs != null && syncLogs.size() > 0) {
            return;
        }
        if (SyncTypeEnum.REVERSE.getValue().equals(pushArgs.getSyncType())) {
            CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
            ctLkUpQueryArgs.settTenantCode(RequestContext.get().getTenantCode());
            ctLkUpQueryArgs.settAccountId(RequestContext.get().getAccountId());
            ctLkUpQueryArgs.settEntityKey(pushArgs.getSourceEntityNumber());
            ctLkUpQueryArgs.settBillIds(new ArrayList(ids));
            List ctBillLks = CtBillLinkService.getCtDirtBillLkUp((CtLkUpQueryArgs)ctLkUpQueryArgs);
            for (CtBillLk ctBillLk : ctBillLks) {
                SyncLog sSyncLog = new SyncLog();
                sSyncLog.setUniqueKey(ID.genStringId());
                sSyncLog.setStenantCode(ctBillLk.gettTenantCode());
                sSyncLog.setsAccountId(ctBillLk.gettAccountId());
                sSyncLog.setsEntityKey(ctBillLk.gettEntityKey());
                sSyncLog.setSbillId(ctBillLk.getTBillId());
                sSyncLog.setSbillNo(resultManager.getsBillNoMap().get(ctBillLk.getTBillId()));
                sSyncLog.setRulename(rule.getName().getLocaleValue());
                sSyncLog.setTtenantCode(ctBillLk.getsTenantCode());
                sSyncLog.settAccountId(ctBillLk.getsAccountId());
                sSyncLog.settEntityKey(ctBillLk.getsEntityKey());
                sSyncLog.setTbillId(ctBillLk.getSBillId());
                sSyncLog.setStatus(SyncStatusEnum.F.getStatus());
                sSyncLog.setRuleId(pushArgs.getRuleId());
                sSyncLog.setId(Long.valueOf(DBServiceHelper.genGlobalLongId()));
                sSyncLog.setCreateTime(new Date());
                sSyncLog.setSyncType(pushArgs.getSyncType());
                sSyncLog.setDesc(CtDescUtils.getDesc());
                sSyncLog.setLkSyncStatus(LkSyncStatusEnum.F.getStatus());
                if (pushArgs.getRootJobId() != null) {
                    sSyncLog.setRootJobId(pushArgs.getRootJobId());
                }
                sSyncLog.setSourceOperate(pushArgs.getSourceOperate());
                sSyncLogs.add(sSyncLog);
            }
        } else {
            if (ids.size() == 0) {
                ids.add(DBServiceHelper.genGlobalLongId());
            }
            for (Long sBillId : ids) {
                SyncLog sSyncLog = new SyncLog();
                sSyncLog.setUniqueKey(ID.genStringId());
                sSyncLog.setStenantCode(RequestContext.get().getTenantId());
                log.info("\u4e0a\u4e0b\u6587\u4e2d\u7684tenantId:" + RequestContext.get().getTenantId());
                log.info("\u4e0a\u4e0b\u6587\u4e2d\u7684tenantCode:" + RequestContext.get().getTenantCode());
                log.info("\u4e0b\u63a8\u53c2\u6570\u4e2d\u7684stenantcode:" + pushArgs.getsTenantCode());
                sSyncLog.setsAccountId(RequestContext.get().getAccountId());
                sSyncLog.setsEntityKey(pushArgs.getSourceEntityNumber());
                sSyncLog.setSbillId(sBillId);
                sSyncLog.setSbillNo(resultManager.getsBillNoMap().get(sBillId));
                sSyncLog.setTtenantCode(pushArgs.gettTenantCode());
                sSyncLog.settAccountId(pushArgs.gettAccountId());
                sSyncLog.settEntityKey(pushArgs.getTargetEntityNumber());
                sSyncLog.setStatus(SyncStatusEnum.F.getStatus());
                sSyncLog.setRuleId(pushArgs.getRuleId());
                sSyncLog.setId(Long.valueOf(ID.genLongId()));
                sSyncLog.setCreateTime(new Date());
                sSyncLog.setSyncType(pushArgs.getSyncType());
                sSyncLog.setRulename(rule.getName().getLocaleValue());
                sSyncLog.setDesc(CtDescUtils.getDesc());
                sSyncLog.setLkSyncStatus(LkSyncStatusEnum.F.getStatus());
                if (pushArgs.getRootJobId() != null) {
                    sSyncLog.setRootJobId(pushArgs.getRootJobId());
                }
                sSyncLog.setSourceOperate(pushArgs.getSourceOperate());
                sSyncLogs.add(sSyncLog);
            }
        }
        SSyncLogService.create().addSyncLogs(sSyncLogs);
        resultManager.setsSyncLogs(sSyncLogs);
        if (!ctConvertOperationResult.isSuccess() && resultManager.getReporter().getFailIds().isEmpty() && StringUtils.isNotEmpty((String)ctConvertOperationResult.getMessage())) {
            resultManager.getReporter().addFailId((Long)ids.get(0), ctConvertOperationResult.getMessage());
        }
    }

    private void updateSSyncLog(CtConvertResultManager resultManager, CtConvertOperationResult ctConvertOperationResult) {
        String errorMsg = null;
        if (ctConvertOperationResult.isException()) {
            errorMsg = ctConvertOperationResult.getMessage();
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)CtSyncLogConst.SYNC_FORMID_S);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        List<SyncLog> syncLogs = ctConvertOperationResult.getsSyncLogs();
        if (CollectionUtils.isEmpty((Collection)ctConvertOperationResult.getsSyncLogs())) {
            syncLogs = resultManager.getsSyncLogs();
        }
        for (SyncLog sSyncLog : syncLogs) {
            DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
            obj.set("id", (Object)sSyncLog.getId());
            obj.set("rulename", (Object)sSyncLog.getRulename());
            Long sbillId = sSyncLog.getSbillId();
            Long tbillId = sSyncLog.getTbillId();
            obj.set("updatetime", (Object)new Date());
            if (MapUtils.isNotEmpty(resultManager.gettBillNoMap())) {
                obj.set("tbillno", (Object)resultManager.gettBillNoMap().get(tbillId));
            }
            if (!ctConvertOperationResult.isException()) {
                Set successIds = ctConvertOperationResult.getReporter().getSuccessIds();
                Map errorIds = ctConvertOperationResult.getReporter().getFailIds();
                if (successIds.contains(tbillId)) {
                    obj.set("status", (Object)SyncStatusEnum.S.getStatus());
                    obj.set("lksyncstatus", (Object)LkSyncStatusEnum.S.getStatus());
                    dynamicObjects.add(obj);
                    continue;
                }
                String errMsg = (String)errorIds.get(sbillId);
                if (StringUtils.isEmpty((String)errMsg)) {
                    errMsg = ctConvertOperationResult.getMessage();
                }
                obj.set("desc_tag", (Object)errMsg);
                obj.set("status", (Object)SyncStatusEnum.F.getStatus());
                obj.set("lksyncstatus", (Object)LkSyncStatusEnum.F.getStatus());
                dynamicObjects.add(obj);
                continue;
            }
            obj.set("desc_tag", (Object)errorMsg);
            obj.set("status", (Object)SyncStatusEnum.F.getStatus());
            obj.set("lksyncstatus", (Object)LkSyncStatusEnum.F.getStatus());
            dynamicObjects.add(obj);
        }
        if (CollectionUtils.isNotEmpty(dynamicObjects)) {
            SSyncLogService.create().updateNoTx(dynamicObjects);
        }
    }
}

