/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.sync.CtSyncRouteService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtConvertRuleCache;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.apiparam.CtMainEntityTypeReq;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.entity.ctbotp.constants.SourceOperateEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.dto.MainEntityTypeDto;
import kd.bos.entity.ctbotp.runtime.AbstractCtConvertServiceArgs;
import kd.bos.entity.ctbotp.runtime.CtConvertOperationResult;
import kd.bos.entity.ctbotp.runtime.CtPushArgs;
import kd.bos.entity.ctbotp.runtime.CtReportManager;
import kd.bos.entity.ctbotp.runtime.CtSourceBillReport;
import kd.bos.entity.ctbotp.sync.SyncRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ctbotp.BillInfoManage;
import kd.bos.service.ctbotp.convert.CtBatchConvertEngineImpl;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertCoverEngineImpl;
import kd.bos.service.ctbotp.convert.CtConvertEngineImpl;
import kd.bos.service.ctbotp.convert.CtConvertReportManager;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.CtSingleRuleResultManager;
import kd.bos.service.ctbotp.convert.ICtConvertEngineService;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.sort.CtListSelectedRowComparator;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.service.ctbotp.utils.SyncRuleRecUtil;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtConvertEngine {
    private static final Log log = LogFactory.getLog(CtConvertEngine.class);
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-ctbotp";
    private static final String CONVERT_ENGINE = "CtConvertEngine";
    private String ERROR_NOSOURCE = ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u6e90\u5355\u7c7b\u578b", (String)"CtConvertEngine_0", (String)"bos-mservice-ctbotp", (Object[])new Object[0]);
    private String ERROR_NOTARGET = ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u76ee\u6807\u5355\u7c7b\u578b", (String)"CtConvertEngine_1", (String)"bos-mservice-ctbotp", (Object[])new Object[0]);
    private String ERROR_NODATA = ResManager.loadKDString((String)"\u672a\u9009\u62e9\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e", (String)"CtConvertEngine_2", (String)"bos-mservice-ctbotp", (Object[])new Object[0]);
    private static final String OP_NAME_PUSH = "ctpush";
    private long startTime = TimeServiceHelper.now().getTime();

    public CtConvertOperationResult ctEventPush(CtPushArgs args) {
        DLock lock = null;
        boolean isLock = false;
        try {
            CtConvertOperationResult ctConvertOperationResult;
            lock = DLock.create((String)this.getEventKey(args.getRootJobId()));
            isLock = lock.tryLock();
            if (!isLock) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4e8b\u4ef6\u6b63\u5728\u6267\u884c\u4e2d\u3002", (String)"CtConvertEngine_15", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
                log.info(msg);
            }
            CtConvertOperationResult ctConvertOperationResult2 = ctConvertOperationResult = this.ctPush(args);
            return ctConvertOperationResult2;
        }
        catch (Exception exception) {
            log.error("\u4e8b\u4ef6\u8ba2\u9605\u8de8\u79df\u6237\u4e0b\u63a8\u5f02\u5e38:", (Throwable)exception);
            throw exception;
        }
        finally {
            if (lock != null && isLock) {
                lock.unlock();
            }
        }
    }

    private String getEventKey(Long rootJobId) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(RequestContext.get().getTenantId());
        keyBuilder.append(RequestContext.get().getAccountId());
        keyBuilder.append(rootJobId);
        return keyBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtConvertOperationResult ctPush(CtPushArgs args) {
        boolean continueFlag = true;
        try (TraceSpan span = Tracer.create((String)CONVERT_ENGINE, (String)OP_NAME_PUSH);){
            CtConvertContext context;
            CtConvertOperationResult result = new CtConvertOperationResult();
            result.setSourceEntityNumber(args.getSourceEntityNumber());
            result.setTargetEntityNumber(args.getTargetEntityNumber());
            result.setStartTime(new Date());
            if (args.getSelectedRows() == null || args.getSelectedRows().isEmpty()) {
                result.setSuccess(false);
                continueFlag = false;
                result.setMessage(this.ERROR_NODATA);
                this.writeLog(OP_NAME_PUSH, (AbstractCtConvertServiceArgs)args, result);
            }
            if (StringUtils.isBlank((CharSequence)args.getSourceEntityNumber())) {
                result.setSuccess(false);
                continueFlag = false;
                result.setMessage(this.ERROR_NOSOURCE);
                this.writeLog(OP_NAME_PUSH, (AbstractCtConvertServiceArgs)args, result);
            }
            if (StringUtils.isBlank((CharSequence)args.getTargetEntityNumber())) {
                result.setSuccess(false);
                continueFlag = false;
                result.setMessage(this.ERROR_NOTARGET);
                this.writeLog(OP_NAME_PUSH, (AbstractCtConvertServiceArgs)args, result);
            }
            if ((context = this.createContext(args)) == null) {
                result.setSuccess(false);
                continueFlag = false;
                result.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u542f\u7528\u7684\u8f6c\u6362\u8def\u7ebf\u3002", (String)"Draw_0", (String)"bos-botp-business", (Object[])new Object[0]));
            }
            CtConvertResultManager resultManager = this.createResultManager();
            if (args.getSelectedRows() != null && context != null && StringUtils.isNotBlank((CharSequence)context.getSourceEntityNumber())) {
                this.initPushContext(result, context, resultManager, args);
            }
            resultManager.setCtPushProcessEnum(CtPushProcessEnum.Init);
            ICtConvertEngineService ctConvertEngineService = null;
            try {
                if (continueFlag) {
                    for (CtConvertRuleElement rule : context.getConvertRuleElements()) {
                        if (!SyncTypeEnum.REVERSE.getValue().equals(rule.getSyncType())) {
                            CtSyncRouteService.addSyncRoute((SyncRoute)CtConvertEngine.pushArgToSyncRoute(args));
                        }
                        this.updatePushArgs(rule, context);
                        CtSingleRuleContext ruleContext = this.createRuleContext(context, rule);
                        List<AbstractCtConvertAction> runAction = null;
                        ctConvertEngineService = this.getCtConvertEngineService(rule);
                        runAction = ctConvertEngineService.createActions(context, resultManager);
                        CtSingleRuleResultManager ruleResultManager = this.createRuleResultManager(resultManager);
                        for (AbstractCtConvertAction action : runAction) {
                            action.setRuleContext(ruleContext);
                            action.setRuleResultManager(ruleResultManager);
                            action.action();
                        }
                    }
                }
            }
            catch (KDBizException exp) {
                result.setException(true);
                result.setMessage(JSON.toJSONString((Object)((Object)exp)));
                log.warn((Throwable)exp);
            }
            catch (Throwable exp) {
                result.setException(true);
                result.setMessage(JSON.toJSONString((Object)exp));
                log.error(exp);
            }
            finally {
                StringBuilder errMsg = new StringBuilder();
                if (context != null && context.getSourceMainType() != null) {
                    this.releaseDataMutex(context.getSourceMainType().getName(), resultManager.getDataMutexSrcBillIds(), errMsg);
                }
                this.writeLog(OP_NAME_PUSH, (AbstractCtConvertServiceArgs)args, result);
            }
            result.setFinishedTime(new Date());
            if (ctConvertEngineService == null) {
                ctConvertEngineService = new CtConvertEngineImpl();
            }
            if (context != null) {
                args.setRootJobId(context.getTaskId());
            }
            this.exportPushResult(args, resultManager, result);
            if (ctConvertEngineService != null) {
                ctConvertEngineService.afterConvert(resultManager, result, args);
            }
            CtConvertOperationResult ctConvertOperationResult = result;
            return ctConvertOperationResult;
        }
    }

    private void updatePushArgs(CtConvertRuleElement rule, CtConvertContext ctConvertContext) {
        if (rule.getCtOptionPolicy().isBatchPush()) {
            ctConvertContext.getCtPushArgs().setBatchPush(true);
        }
        if (rule.getCtOptionPolicy().isPushOneTime()) {
            ctConvertContext.getCtPushArgs().setCheckPushAgain(true);
        }
        ctConvertContext.getCtPushArgs().setTargetBillOp(rule.getCtOptionPolicy().getTargetBillOp());
    }

    private ICtConvertEngineService getCtConvertEngineService(CtConvertRuleElement rule) {
        ICtConvertEngineService iCtConvertEngineService = null;
        iCtConvertEngineService = rule.getCtOptionPolicy().isBatchPush() ? new CtBatchConvertEngineImpl() : (rule.isMirrorSync() && rule.isMirrorUpdate() ? new CtConvertCoverEngineImpl() : new CtConvertEngineImpl());
        return iCtConvertEngineService;
    }

    public static SyncRoute pushArgToSyncRoute(CtPushArgs ctPushArgs) {
        SyncRoute syncRoute = new SyncRoute();
        syncRoute.setStenantCode(ctPushArgs.getsTenantCode());
        syncRoute.setsAccountId(ctPushArgs.getsAccountId());
        syncRoute.setsEntityKey(ctPushArgs.getSourceEntityNumber());
        syncRoute.setTtenantCode(ctPushArgs.gettTenantCode());
        syncRoute.settAccountId(ctPushArgs.gettAccountId());
        syncRoute.settEntityKey(ctPushArgs.getTargetEntityNumber());
        return syncRoute;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean releaseDataMutex(String srcEntityNumber, Set<String> srcBillIds, StringBuilder errMsg) {
        if (srcBillIds.isEmpty()) {
            return true;
        }
        ArrayList mutexRequireList = new ArrayList(10);
        for (String billId : srcBillIds) {
            HashMap<String, String> requireParam = new HashMap<String, String>(16);
            requireParam.put("dataObjId", billId);
            requireParam.put("groupId", "default_netctrl");
            requireParam.put("entityKey", srcEntityNumber);
            requireParam.put("operationKey", "ctbotp_convert");
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();){
            dataMutex.batchRelease(mutexRequireList);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            errMsg.append(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519: ", (String)"CtConvertEngine_7", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0])).append(e.getMessage());
            return false;
        }
    }

    private CtConvertContext createContext(CtPushArgs args) {
        CtConvertRuleElement rule;
        if (StringUtils.isBlank((CharSequence)args.getSourceOperate())) {
            args.setSourceOperate(SourceOperateEnum.OTHER.getValue());
        }
        CtConvertContext context = new CtConvertContext();
        context.setTaskId(ID.genLongId());
        context.setInputArgs((AbstractCtConvertServiceArgs)args);
        context.setCtPushArgs(args);
        if (StringUtils.isNotBlank((CharSequence)args.getSourceEntityNumber())) {
            BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)args.getSourceEntityNumber());
            context.setSourceMainType(srcMainType);
        }
        if (args.getCustomParams() != null) {
            for (Map.Entry entry : args.getCustomParams().entrySet()) {
                context.getOption().setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if ((rule = this.loadRule(args)) == null) {
            String string = String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8f6c\u6362\u89c4\u5219\uff1a%s", (String)"CtConvertEngine_8", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), args.getRuleId());
            log.error(string);
            throw new KDBizException(string);
        }
        if (!rule.isNormual()) {
            return null;
        }
        args.setsAccountId(rule.getSourceDataCenter());
        args.setsTenantCode(rule.getSourceTenant());
        args.settAccountId(rule.getTargetDataCenter());
        args.settTenantCode(rule.getTargetTenant());
        args.setRuleName(rule.getName().getLocaleValue());
        args.setRuleVerId(Long.valueOf(rule.getCurrentVerId()));
        args.setRuleExtVerId(Long.valueOf(rule.getExtVerId()));
        ArrayList<CtConvertRuleElement> arrayList = new ArrayList<CtConvertRuleElement>();
        arrayList.add(rule);
        context.setConvertRuleElements(arrayList);
        context.setSourceEntityNumber(args.getSourceEntityNumber());
        context.setTargetEntityNumber(args.getTargetEntityNumber());
        return context;
    }

    private void initPushContext(CtConvertOperationResult result, CtConvertContext context, CtConvertResultManager resultManager, CtPushArgs args) {
        this.initBillInfo(context, resultManager, args.getSelectedRows());
        resultManager.getCtReporter().initBillAndRules(args.getSelectedRows());
        result.getReporter().setsBillCounts(resultManager.getSbillIdSet().size());
    }

    public void initBillInfo(CtConvertContext context, CtConvertResultManager resultManager, List<ListSelectedRow> selectedRows) {
        ArrayList<ListSelectedRow> sortRows = new ArrayList<ListSelectedRow>(selectedRows.size());
        sortRows.addAll(selectedRows);
        CtListSelectedRowComparator comparator = new CtListSelectedRowComparator();
        sortRows.sort(comparator);
        boolean isHasBillNo = Boolean.FALSE;
        ArrayList<Long> sBillIds = new ArrayList<Long>(16);
        HashMap<Long, String> billIdNoMap = new HashMap<Long, String>(16);
        for (ListSelectedRow row : sortRows) {
            Long billId = (Long)row.getPrimaryKeyValue();
            String billNo = row.getBillNo();
            sBillIds.add(billId);
            if (StringUtils.isNotBlank((CharSequence)billNo)) {
                isHasBillNo = Boolean.TRUE;
                billIdNoMap.put(billId, billNo);
            }
            resultManager.getSbillIdSet().add(billId);
        }
        if (!isHasBillNo) {
            Map<Long, String> billNoMap = BillInfoManage.loadBillNoFromDB(context.getSourceEntityNumber(), sBillIds.toArray(new Object[0]));
            for (Long id : sBillIds) {
                billIdNoMap.put(id, billNoMap.get(id));
            }
        }
        resultManager.setsBillNoMap(billIdNoMap);
    }

    private CtSingleRuleContext createRuleContext(CtConvertContext context, CtConvertRuleElement rule) {
        CtSingleRuleContext ruleContext = new CtSingleRuleContext();
        ruleContext.setContext(context);
        ruleContext.setRule(rule);
        return ruleContext;
    }

    private CtConvertRuleElement loadRule(CtPushArgs context) {
        if (StringUtils.isNotBlank((CharSequence)context.getRuleId())) {
            CtConvertRuleElement rule = CtConvertRuleCache.loadRule((String)context.getRuleId());
            if (rule == null) {
                return null;
            }
            SyncRuleRecUtil.updateSyncRuleRec(rule);
            return rule;
        }
        return null;
    }

    private CtConvertResultManager createResultManager() {
        return new CtConvertResultManager();
    }

    private CtSingleRuleResultManager createRuleResultManager(CtConvertResultManager resultManager) {
        CtSingleRuleResultManager ruleResultManager = new CtSingleRuleResultManager();
        ruleResultManager.setConvertResultManager(resultManager);
        return ruleResultManager;
    }

    private void exportPushResult(CtPushArgs args, CtConvertResultManager resultManager, CtConvertOperationResult operationResult) {
        this.createConvertReport(args, resultManager.getReporter(), resultManager, operationResult);
        if (resultManager != null && resultManager.getReporter() != null) {
            if (CollectionUtils.isNotEmpty((Collection)resultManager.getReporter().getSuccessIds()) && resultManager.getReporter().getFailIds().isEmpty()) {
                operationResult.setSuccess(true);
            }
            if (resultManager.getReporter().isException()) {
                operationResult.setException(true);
                operationResult.setException(false);
                operationResult.setMessage(resultManager.getReporter().getErrorMsg());
            }
        }
        operationResult.setTargetCtDataObjects(resultManager.getTargetCtDataObjects());
        operationResult.setsSyncLogs(resultManager.getsSyncLogs());
        operationResult.setReporter(resultManager.getReporter());
        operationResult.setTargetTenantCode(args.gettTenantCode());
        operationResult.setTargetAccountId(args.gettAccountId());
        operationResult.setTargetEntityNumber(args.getTargetEntityNumber());
    }

    private void createConvertReport(CtPushArgs args, CtReportManager reportManager, CtConvertResultManager resultManager, CtConvertOperationResult operationResult) {
        ArrayList<CtSourceBillReport> ctSourceBillReports = new ArrayList<CtSourceBillReport>(16);
        if (reportManager != null && MapUtils.isNotEmpty((Map)reportManager.getFailIds())) {
            for (Map.Entry entry : reportManager.getFailIds().entrySet()) {
                CtSourceBillReport ctSourceBillReport = new CtSourceBillReport();
                ctSourceBillReport.setBillId(entry.getKey());
                ctSourceBillReport.addFailMessage((String)entry.getValue());
                if (resultManager != null && MapUtils.isNotEmpty(resultManager.getsBillNoMap())) {
                    ctSourceBillReport.setBillNo(resultManager.getsBillNoMap().get(entry.getKey()));
                }
                ctSourceBillReports.add(ctSourceBillReport);
            }
        } else if (!operationResult.isSuccess() && StringUtils.isNotBlank((CharSequence)operationResult.getMessage())) {
            Set<Object> sbillIdSet = resultManager.getSbillIdSet();
            if (sbillIdSet.size() == 0) {
                CtSourceBillReport ctSourceBillReport = new CtSourceBillReport();
                ctSourceBillReport.setBillId((Object)0);
                ctSourceBillReport.addFailMessage(operationResult.getMessage());
                ctSourceBillReports.add(ctSourceBillReport);
            } else {
                for (Object billId : sbillIdSet) {
                    CtSourceBillReport ctSourceBillReport = new CtSourceBillReport();
                    ctSourceBillReport.setBillId(billId);
                    ctSourceBillReport.addFailMessage(operationResult.getMessage());
                    if (MapUtils.isNotEmpty(resultManager.getsBillNoMap())) {
                        ctSourceBillReport.setBillNo(resultManager.getsBillNoMap().get(billId));
                    }
                    ctSourceBillReports.add(ctSourceBillReport);
                }
            }
        }
        if (resultManager != null) {
            resultManager.getReporter().setsBillCounts(resultManager.getSbillIdSet().size());
        }
        operationResult.setBillReports(ctSourceBillReports);
        if (reportManager != null && CollectionUtils.isNotEmpty((Collection)reportManager.getSuccessIds())) {
            operationResult.setTargetBillIds(reportManager.getSuccessIds());
        }
    }

    private void updateConvertReport(CtConvertReportManager reportManager, CtConvertOperationResult operationResult) {
        if (!reportManager.getBreakMessages().isEmpty()) {
            operationResult.setSuccess(false);
            operationResult.setMessage(reportManager.getBreakMessages().entrySet().iterator().next().getValue());
        }
        for (CtSourceBillReport billReport : reportManager.getBillReports()) {
            billReport.copyReportToList();
            operationResult.getBillReports().add(billReport);
        }
        if (operationResult.getBillReports().size() > 200) {
            int size = operationResult.getBillReports().size();
            for (int i = 200; i < size; ++i) {
                CtSourceBillReport billReport = (CtSourceBillReport)operationResult.getBillReports().get(i);
                billReport.getLinkEntityRowReports().clear();
                billReport.getDependEntityRowReports().clear();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeLog(String serviceName, AbstractCtConvertServiceArgs args, CtConvertOperationResult convertResult) {
        void var9_14;
        boolean success;
        if (StringUtils.isBlank((CharSequence)serviceName) || args == null || convertResult == null || StringUtils.isBlank((CharSequence)args.getSourceEntityNumber()) || StringUtils.isBlank((CharSequence)args.getTargetEntityNumber())) {
            return;
        }
        int count = 5;
        StringBuilder sb = new StringBuilder();
        sb.append("ConvertEngine.").append(serviceName).append("(");
        sb.append(args.getSourceEntityNumber()).append("->");
        sb.append(args.getTargetEntityNumber()).append(",");
        sb.append("ruleId:").append(args.getRuleId());
        if (args instanceof CtPushArgs && ((CtPushArgs)args).getSelectedRows() != null) {
            HashSet<Object> pkIds = new HashSet<Object>(((CtPushArgs)args).getSelectedRows().size());
            for (Object row : ((CtPushArgs)args).getSelectedRows()) {
                pkIds.add(row.getPrimaryKeyValue());
            }
            sb.append(",ids:[");
            int i = 0;
            for (Object e : pkIds) {
                if (i >= count) break;
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(String.valueOf(e));
                ++i;
            }
            if (pkIds.size() > count) {
                sb.append(", total ").append(String.valueOf(pkIds.size())).append(" bills");
            }
            sb.append("]");
        }
        sb.append(") \r\n");
        sb.append("Cost ").append(TimeServiceHelper.now().getTime() - this.startTime).append(" ms,");
        int successCount = convertResult.getTargetBillIds().size() + convertResult.getTargetBillIds().size();
        boolean bl = success = successCount > 0;
        if (success) {
            sb.append(" success = true, build ").append(successCount).append(" bills \r\n");
        } else {
            sb.append(" success = false, message : ").append(convertResult.getMessage()).append(" \r\n");
        }
        ArrayList<AppLogInfo> appLogInfoList = null;
        String string = "";
        String objectType = convertResult.getSourceEntityNumber();
        String opName = serviceName;
        if (StringUtils.equals((CharSequence)serviceName, (CharSequence)OP_NAME_PUSH)) {
            String string2 = this.getAppId(convertResult.getSourceEntityNumber());
            objectType = convertResult.getSourceEntityNumber();
            opName = String.format("%s-%s", ResManager.loadKDString((String)"\u6570\u636e\u534f\u540c", (String)"CtConvertEngine_6", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), convertResult.getTargetEntityNumber());
        }
        log.info("convertResult:" + SerializationUtils.toJsonString((Object)convertResult));
        if (convertResult.getBillReports().isEmpty()) {
            appLogInfoList = new ArrayList<AppLogInfo>(1);
            AppLogInfo logInfo = this.buildLogInfo((String)var9_14, objectType, opName, 0L, convertResult.getMessage());
            appLogInfoList.add(logInfo);
        } else {
            appLogInfoList = new ArrayList(convertResult.getBillReports().size());
            int i = 0;
            for (CtSourceBillReport billReport : convertResult.getBillReports()) {
                String opDesc = this.buildOpDescription(success, billReport);
                if (opDesc != null) {
                    AppLogInfo logInfo = this.buildLogInfo((String)var9_14, objectType, opName, 0L, opDesc);
                    appLogInfoList.add(logInfo);
                }
                if (i <= 30) {
                    sb.append(billReport.toString()).append("; ").append("ruleid:").append(billReport.getRuleId()).append(" \r\n");
                }
                ++i;
            }
            if (appLogInfoList.isEmpty()) {
                AppLogInfo logInfo = this.buildLogInfo((String)var9_14, objectType, opName, 0L, convertResult.getMessage());
                appLogInfoList.add(logInfo);
            }
        }
        if (!appLogInfoList.isEmpty()) {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            logService.addBatchLog(appLogInfoList);
        }
        log.info(sb.toString());
    }

    protected AppLogInfo buildLogInfo(String appId, String entityNumber, String opName, Long orgId, String msg) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(entityNumber);
        if (orgId != null && Long.compare(0L, orgId) != 0) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    protected AppLogInfo buildLogInfo(String appId, String entityNumber, Long orgId, String msg) {
        String opName = ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"ConvertEngine_6", (String)"bos-mservice-botp", (Object[])new Object[0]);
        return this.buildLogInfo(appId, entityNumber, opName, orgId, msg);
    }

    private String buildOpDescription(boolean success, CtSourceBillReport billReport) {
        if (!success && billReport.isFullSuccess()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)billReport.getRuleName())) {
            return billReport.toString();
        }
        return String.format("%s; %s(%s)", billReport.toString(), billReport.getRuleName(), billReport.getRuleId());
    }

    private String getAppId(String entityNumber) {
        String appNumber;
        String appId = "";
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String string = appNumber = mainType == null ? "" : mainType.getBizAppNumber();
        if (StringUtils.isNotBlank((CharSequence)appNumber)) {
            try {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
                if (null != appInfo) {
                    appId = appInfo.getId();
                }
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
        return appId;
    }

    public MainEntityTypeDto getMainEntityType(String tenant, String accountId, String entityNumber) {
        Map openApiResult;
        String localeId = RequestContext.get().getLang().toString();
        CtMainEntityTypeReq mainEntityTypeReq = new CtMainEntityTypeReq(entityNumber, Boolean.valueOf(false), Boolean.valueOf(false), localeId);
        String result = CtBotpApiUtils.post(tenant, accountId, CtApiUrlEnum.GETMAINENTITYINFO, SerializationUtils.toJsonString((Object)mainEntityTypeReq));
        if (StringUtils.isNotBlank((CharSequence)result) && Boolean.parseBoolean((openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class)).get("status").toString()) && openApiResult.get("errorCode").equals("0")) {
            return (MainEntityTypeDto)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(openApiResult.get("data")), MainEntityTypeDto.class);
        }
        return null;
    }
}

