/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntitySet;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class CtSingleRuleResultManager {
    private CtConvertResultManager convertResultManager;
    private CtExtendedDataEntitySet targetExtendedDataEntities;
    private boolean skipNextAction = false;
    private Set<Long> targetBillIds = new HashSet<Long>(0);
    private Set<Long> failBillIds = new HashSet<Long>(0);
    private Map<Long, String> targetBillHeads = new HashMap<Long, String>(0);
    private DataEntitySerializerOption serializerOption;
    private IRefrencedataProvider refrencedataProvider;
    private Map<String, SyncLog> existNextSyncLogs = new HashMap<String, SyncLog>(16);

    public Map<String, SyncLog> getExistNextSyncLogs() {
        return this.existNextSyncLogs;
    }

    public void setExistNextSyncLogs(Map<String, SyncLog> existNextSyncLogs) {
        this.existNextSyncLogs = existNextSyncLogs;
    }

    public CtConvertResultManager getConvertResultManager() {
        return this.convertResultManager;
    }

    public void setConvertResultManager(CtConvertResultManager convertResultManager) {
        this.convertResultManager = convertResultManager;
    }

    public CtExtendedDataEntitySet getTargetExtendedDataEntities() {
        return this.targetExtendedDataEntities;
    }

    public void setTargetExtendedDataEntities(CtExtendedDataEntitySet targetExtendedDataEntities) {
        this.targetExtendedDataEntities = targetExtendedDataEntities;
    }

    public boolean isSkipNextAction() {
        return this.skipNextAction;
    }

    public void setSkipNextAction(boolean skipNextAction) {
        this.skipNextAction = skipNextAction;
    }

    public Set<Long> getTargetBillIds() {
        return this.targetBillIds;
    }

    public void addTargetBillIds(Set<Long> billIds) {
        this.targetBillIds.addAll(billIds);
    }

    public synchronized Set<Long> getFailBillIds() {
        return this.failBillIds;
    }

    public synchronized boolean isFail(Long billId) {
        return this.failBillIds.contains(billId);
    }

    public synchronized void addFailBillIds(Set<Long> billIds) {
        this.failBillIds.addAll(billIds);
    }

    public synchronized void putTargetBillHeads(List<CtDataEntity> ctDataEntities) {
        for (CtDataEntity obj : ctDataEntities) {
            this.clearEntryPKSnapshot(obj);
            String objStr = SerializationUtils.toJsonString((Object)obj);
            this.targetBillHeads.put(obj.getId(), objStr);
        }
    }

    public boolean isTargetBillSaved(Object pkId) {
        return this.targetBillHeads.containsKey(pkId);
    }

    public synchronized CtDataEntity getTargetBillHead(Object billId) {
        String ctDataStr = this.targetBillHeads.get(billId);
        if (StringUtils.isBlank((CharSequence)ctDataStr)) {
            return null;
        }
        CtDataEntity ctDataEntity = (CtDataEntity)SerializationUtils.fromJsonString((String)ctDataStr, CtDataEntity.class);
        return ctDataEntity;
    }

    private void clearEntryPKSnapshot(CtDataEntity billObj) {
        if (billObj != null && MapUtils.isNotEmpty((Map)billObj.getChildEntitys())) {
            Iterator it = billObj.getChildEntitys().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                it.remove();
            }
        }
    }

    private String serDynamicObject(CtDataEntity obj) {
        return DataEntitySerializer.serializerToString((Object)obj, (DataEntitySerializerOption)this.getSerializerOption());
    }

    private DynamicObject deserDynamicObject(BillEntityType mainType, String str) {
        return (DynamicObject)DataEntitySerializer.deSerializerFromString((String)str, (IDataEntityType)mainType);
    }

    private DataEntitySerializerOption getSerializerOption() {
        if (this.serializerOption == null) {
            this.serializerOption = new DataEntitySerializerOption();
            this.serializerOption.setIncludeDataEntityState(true);
            this.serializerOption.setIncludeComplexProperty(false);
            this.serializerOption.setIncludeCollectionProperty(false);
            this.serializerOption.setIncludeType(false);
        }
        return this.serializerOption;
    }

    private IRefrencedataProvider getRefrencedataProvider() {
        if (this.refrencedataProvider == null) {
            this.refrencedataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                }
            };
        }
        return this.refrencedataProvider;
    }
}

