/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import kd.bos.entity.ctbotp.CtExtendedDataEntitySet;
import kd.bos.service.ctbotp.business.datamodel.CtDrawDataModel;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.CtSingleBatchContext;
import kd.bos.service.ctbotp.convert.CtSingleBatchResultManager;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.CtSingleRuleResultManager;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroup;

public abstract class AbstractCtConvertAction {
    protected CtConvertContext context;
    protected CtSingleRuleContext ruleContext;
    protected CtSingleBatchContext batchContext;
    protected CtConvertResultManager resultManager;
    protected CtSingleRuleResultManager ruleResultManager;
    protected CtSingleBatchResultManager batchResultManager;

    public AbstractCtConvertAction(CtConvertContext context, CtConvertResultManager resultManager) {
        this.context = context;
        this.resultManager = resultManager;
    }

    public CtConvertContext getContext() {
        return this.context;
    }

    public void setContext(CtConvertContext context) {
        this.context = context;
    }

    public CtSingleRuleContext getRuleContext() {
        return this.ruleContext;
    }

    public void setRuleContext(CtSingleRuleContext ruleContext) {
        this.ruleContext = ruleContext;
    }

    public CtSingleBatchContext getBatchContext() {
        return this.batchContext;
    }

    public void setBatchContext(CtSingleBatchContext batchContext) {
        this.batchContext = batchContext;
    }

    public CtConvertResultManager getResultManager() {
        return this.resultManager;
    }

    public void setResultManager(CtConvertResultManager resultManager) {
        this.resultManager = resultManager;
    }

    public CtSingleRuleResultManager getRuleResultManager() {
        return this.ruleResultManager;
    }

    public void setRuleResultManager(CtSingleRuleResultManager ruleResultManager) {
        this.ruleResultManager = ruleResultManager;
    }

    public CtSingleBatchResultManager getBatchResultManager() {
        return this.batchResultManager;
    }

    public void setBatchResultManager(CtSingleBatchResultManager batchResultManager) {
        this.batchResultManager = batchResultManager;
    }

    public CtDrawDataModel getModelProxy() {
        if (this.batchContext != null) {
            return this.batchContext.getModelProxy();
        }
        return this.ruleContext.getModelProxy();
    }

    public CtSourceRowsGroup getSourceRowsGroupRoot() {
        if (this.batchContext != null) {
            return this.batchContext.getSourceRowsGroupRoot();
        }
        return this.ruleContext.getRuleCompiler().getLinkEntityMap().getSourceRowsGroup();
    }

    public CtExtendedDataEntitySet getTargetExtendedDataEntities() {
        if (this.batchResultManager != null) {
            return this.batchResultManager.getTargetExtendedDataEntities();
        }
        return this.ruleResultManager.getTargetExtendedDataEntities();
    }

    public void setTargetExtendedDataEntities(CtExtendedDataEntitySet targetExtSet) {
        if (this.batchResultManager != null) {
            this.batchResultManager.setTargetExtendedDataEntities(targetExtSet);
        } else {
            this.ruleResultManager.setTargetExtendedDataEntities(targetExtSet);
        }
    }

    public boolean isSkipNextAction() {
        if (this.batchResultManager != null) {
            return this.batchResultManager.isSkipNextAction() && this.ruleResultManager.isSkipNextAction();
        }
        return this.ruleResultManager.isSkipNextAction();
    }

    public void setSkipNextAction(boolean skipNextAction) {
        if (this.batchResultManager != null) {
            this.batchResultManager.setSkipNextAction(skipNextAction);
        } else {
            this.ruleResultManager.setSkipNextAction(skipNextAction);
        }
    }

    public void action() {
        if (!this.isSkipNextAction()) {
            this.setProcess();
            this.doAction();
        }
    }

    protected void doAction() {
    }

    protected abstract void setProcess();
}

