/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ctbotp.BaseDataPropInfo;
import kd.bos.entity.ctbotp.CtExtendedDataEntity;
import kd.bos.entity.ctbotp.CtFieldConvertType;
import kd.bos.entity.ctbotp.CtFieldMapItem;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.batchrequest.CtBatchRequestManager;
import kd.bos.service.ctbotp.convert.compiler.CtDependEntityMap;
import kd.bos.service.ctbotp.convert.mapping.ICtMappingField;

public abstract class AbstractCtMappingdFieldValue {
    private static final Log log = LogFactory.getLog(AbstractCtMappingdFieldValue.class);
    protected CtExtendedDataEntity[] targetExtDataEntitys;
    protected ICtMappingField mappingField;
    protected Map<String, DynamicProperty> srcFldPropertys;
    protected CtBatchRequestManager batchRequestManager;
    protected CtConvertContext context;
    protected boolean isBatchPreCall;
    protected CtDependEntityMap entityMap;
    protected Map<String, BaseDataPropInfo> baseDataPropInfoMap;

    protected abstract boolean checkBeforeCalc();

    protected abstract void doException(Exception var1);

    public Map<String, BaseDataPropInfo> getBaseDataPropInfoMap() {
        return this.baseDataPropInfoMap;
    }

    public void setBaseDataPropInfoMap(Map<String, BaseDataPropInfo> baseDataPropInfoMap) {
        this.baseDataPropInfoMap = baseDataPropInfoMap;
    }

    protected abstract Object getSourceRows(CtExtendedDataEntity var1);

    protected void setArgs(CtExtendedDataEntity[] targetExtDataEntitys, ICtMappingField mappingField, Map<String, DynamicProperty> srcFldPropertys, CtBatchRequestManager batchRequestManager, CtConvertContext context, CtDependEntityMap entityMap, Map<String, BaseDataPropInfo> baseDataPropInfoMap) {
        this.targetExtDataEntitys = targetExtDataEntitys;
        this.mappingField = mappingField;
        this.srcFldPropertys = srcFldPropertys;
        this.batchRequestManager = batchRequestManager;
        this.context = context;
        this.entityMap = entityMap;
        this.baseDataPropInfoMap = baseDataPropInfoMap;
    }

    protected AbstractCtMappingdFieldValue setBatchPreCall(boolean batchPreCall) {
        this.isBatchPreCall = batchPreCall;
        return this;
    }

    protected void prepBillAndCalc() {
        for (CtExtendedDataEntity extDataEntity : this.targetExtDataEntitys) {
            Object sourceRows;
            boolean checkResult = this.checkBeforeCalc();
            if (!checkResult || (sourceRows = this.getSourceRows(extDataEntity)) == null) continue;
            try {
                if (this.isBatchPreCall) {
                    boolean isPre = this.batchPreCall(this.srcFldPropertys, sourceRows, extDataEntity);
                    if (isPre) continue;
                    break;
                }
                this.calcAndMaping(this.baseDataPropInfoMap, this.srcFldPropertys, sourceRows, extDataEntity);
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Exception e) {
                this.doException(e);
            }
        }
    }

    private boolean batchPreCall(Map<String, DynamicProperty> srcFldPropertys, Object sourceRows, CtExtendedDataEntity extDataEntity) {
        try {
            CtFieldMapItem fieldMapItem = this.mappingField.getFieldMap();
            if (fieldMapItem.getCtFieldConvertType() != CtFieldConvertType.ByCondition && fieldMapItem.getCtFieldConvertType() != CtFieldConvertType.Formula) {
                return false;
            }
            return this.mappingField.batchPreCall(srcFldPropertys, (List)sourceRows, extDataEntity.getDataEntity(), this.batchRequestManager);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return false;
        }
    }

    private void calcAndMaping(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, DynamicProperty> srcFldPropertys, Object sourceRows, CtExtendedDataEntity extDataEntity) {
        this.mappingField.calcAndMappingValue(baseDataPropInfoMap, srcFldPropertys, (List)sourceRows, extDataEntity.getCtDataEntity(), this.batchRequestManager);
    }
}

