/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntitySet;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroup;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroupKey;
import kd.bos.service.ctbotp.convert.mapping.ICtMappingField;

public class CtCreateLinkEntityRowsAction
extends AbstractCtConvertAction {
    private CtLinkEntityMap linkEntityMap = null;
    private String targetEntryEntity = null;
    private String targetSubEntryEntity = null;

    public CtCreateLinkEntityRowsAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtCreateLinkEntityRowsAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        CtExtendedDataEntitySet targetExtSet = this.getTargetExtendedDataEntities();
        this.targetEntryEntity = this.linkEntityMap.getTargetEntryKey();
        this.targetSubEntryEntity = this.linkEntityMap.getTargetSubEntryKey();
        CtExtendedDataEntity[] headExtEntitys = targetExtSet.FindByEntityKey(this.ruleContext.getContext().getCtPushArgs().getTargetEntityNumber());
        HashMap<CtSourceRowsGroupKey, CtExtendedDataEntity> headGroup = new HashMap<CtSourceRowsGroupKey, CtExtendedDataEntity>();
        for (CtExtendedDataEntity headExtEntity : headExtEntitys) {
            Object sourceRows = headExtEntity.getValue("ConvertSource");
            if (sourceRows == null) continue;
            CtSourceRowsGroupKey groupKey = (CtSourceRowsGroupKey)headExtEntity.getValue("SourceRowsGroupKey");
            headGroup.put(groupKey, headExtEntity);
        }
        CtSourceRowsGroup group = this.getSourceRowsGroupRoot();
        for (CtSourceRowsGroup srcBillGroup : group.getChildGroupList()) {
            CtSourceRowsGroupKey srcBillGroupKey = srcBillGroup.getGroupKey();
            CtExtendedDataEntity headExtEntity = (CtExtendedDataEntity)headGroup.get(srcBillGroupKey);
            if (headExtEntity == null) continue;
            boolean isNewBill = false;
            Object extNewEntityValue = headExtEntity.getValue("isNewEntity");
            if (extNewEntityValue != null) {
                isNewBill = (Boolean)extNewEntityValue;
            }
            this.createEntryEntity(targetExtSet, headExtEntity, srcBillGroup, isNewBill);
        }
        this.setTargetExtendedDataEntities(targetExtSet);
    }

    private void setDefValueCalculatorBillType(DynamicObject sourceRow) {
        BillEntityType tgtMainType = this.context.getTargetMainType();
        BillTypeProp billTypeField = null;
        for (IDataEntityProperty property : tgtMainType.getAllFields().values()) {
            if (!(property instanceof BillTypeProp)) continue;
            billTypeField = (BillTypeProp)property;
            break;
        }
        String billTypeId = "";
    }

    private void createEntryEntity(CtExtendedDataEntitySet targetExtSet, CtExtendedDataEntity headExtEntity, CtSourceRowsGroup srcBillRowsGroup, boolean isNewBill) {
        if (this.targetEntryEntity == null) {
            return;
        }
        ICtGetValueMode srcEntryIdReader = this.getSrcEntryIdReader(this.linkEntityMap.getTargetFields().get(this.targetEntryEntity));
        List<CtSourceRowsGroup> srcEntryRowsGroups = this.getNotEmptyRows(srcBillRowsGroup.getChildGroupList(), srcEntryIdReader);
        if (srcEntryRowsGroups.isEmpty()) {
            return;
        }
        String entryKey = this.targetEntryEntity;
        int groupRowCount = srcEntryRowsGroups.size();
        int startRowIndex = srcBillRowsGroup.getStartEntrySeq();
        int rowIndex = 0;
        ArrayList<CtExtendedDataEntity> entryExtEntitys = new ArrayList<CtExtendedDataEntity>(srcEntryRowsGroups.size());
        for (CtSourceRowsGroup srcEntryRowGroup : srcEntryRowsGroups) {
            CtDataEntity ctDataEntity = new CtDataEntity();
            ctDataEntity.setSeq(Integer.valueOf(rowIndex + startRowIndex));
            headExtEntity.getCtDataEntity().addChildEntitys(entryKey, "", ctDataEntity);
            CtExtendedDataEntity entryExtEntity = new CtExtendedDataEntity(ctDataEntity, 0, rowIndex);
            entryExtEntity.setValueExt("ConvertSource", srcEntryRowGroup.getSourceRows());
            entryExtEntity.setValueExt("isNewEntity", (Object)Boolean.TRUE);
            entryExtEntitys.add(entryExtEntity);
            this.createSubEntryEntity(targetExtSet, headExtEntity, rowIndex, srcEntryRowGroup);
            ++rowIndex;
        }
        targetExtSet.AddExtendedDataEntities(entryKey, entryExtEntitys);
    }

    private void createSubEntryEntity(CtExtendedDataEntitySet targetExtSet, CtExtendedDataEntity headExtEntity, int rowIndex, CtSourceRowsGroup srcEntryRowsGroup) {
        if (this.targetSubEntryEntity == null) {
            return;
        }
        String subEntryKey = this.targetSubEntryEntity;
        ICtGetValueMode srcSubEntryIdReader = this.getSrcEntryIdReader(this.linkEntityMap.getTargetFields().get(this.targetSubEntryEntity));
        List<CtSourceRowsGroup> srcSubEntryRowsGroups = this.getNotEmptyRows(srcEntryRowsGroup.getChildGroupList(), srcSubEntryIdReader);
        if (srcSubEntryRowsGroups.isEmpty()) {
            return;
        }
        int groupRowCount = srcSubEntryRowsGroups.size();
        int subRowIndex = 0;
        ArrayList<CtExtendedDataEntity> subEntryExtEntitys = new ArrayList<CtExtendedDataEntity>(groupRowCount);
        for (CtSourceRowsGroup srcSubEntryRowsGroup : srcSubEntryRowsGroups) {
            CtDataEntity ctDataEntity = new CtDataEntity();
            ctDataEntity.setSeq(Integer.valueOf(subRowIndex));
            ((CtDataEntity)((List)headExtEntity.getCtDataEntity().getChildEntitys().get(this.targetEntryEntity)).get(rowIndex)).addChildEntitys(this.targetSubEntryEntity, "", ctDataEntity);
            CtExtendedDataEntity subEntryExtEntity = new CtExtendedDataEntity(ctDataEntity, headExtEntity.getDataEntityIndex(), rowIndex, subRowIndex, "");
            subEntryExtEntity.setValueExt("ConvertSource", srcSubEntryRowsGroup.getSourceRows());
            subEntryExtEntity.setValueExt("isNewEntity", (Object)Boolean.TRUE);
            subEntryExtEntitys.add(subEntryExtEntity);
            ++subRowIndex;
        }
        targetExtSet.AddExtendedDataEntities(subEntryKey, subEntryExtEntitys);
    }

    private List<CtSourceRowsGroup> getNotEmptyRows(List<CtSourceRowsGroup> rowsGroups, ICtGetValueMode srcEntryIdReader) {
        ArrayList<CtSourceRowsGroup> notEmptyRowsGroups = new ArrayList<CtSourceRowsGroup>();
        block0: for (CtSourceRowsGroup rowsGroup : rowsGroups) {
            for (DynamicObject sourceRow : rowsGroup.getSourceRows()) {
                Long entryId = (Long)srcEntryIdReader.getValue(this.linkEntityMap.getBaseDataPropInfoMap(), this.linkEntityMap.getSrcFldPropertys(), sourceRow);
                if (entryId == null || Long.compare(entryId, 0L) == 0) continue;
                notEmptyRowsGroups.add(rowsGroup);
                continue block0;
            }
        }
        return notEmptyRowsGroups;
    }

    private ICtGetValueMode getSrcEntryIdReader(List<ICtMappingField> mappingFields) {
        boolean isLinkSubEntry = false;
        boolean isLinkEntry = false;
        if (mappingFields != null) {
            for (ICtMappingField mappingField : mappingFields) {
                if (StringUtils.isNotBlank((CharSequence)mappingField.getSourceSubEntryKey())) {
                    isLinkSubEntry = true;
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)mappingField.getSourceEntryKey())) continue;
                isLinkEntry = true;
            }
        }
        if (isLinkSubEntry) {
            return this.linkEntityMap.getSrcSubEntryIdReader();
        }
        if (isLinkEntry) {
            return this.linkEntityMap.getSrcEntryIdReader();
        }
        return this.linkEntityMap.getSrcBillIdReader();
    }
}

