/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntitySet;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroup;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroupKey;
import kd.bos.service.ctbotp.convert.mapping.ICtMappingField;
import kd.bos.util.CollectionUtils;

public class CtCreateTargetBillAction
extends AbstractCtConvertAction {
    private CtLinkEntityMap linkEntityMap;
    private ICtMappingField mappingBillType = null;
    private ICtGetValueMode srcBillTypeReader = null;
    private String entityKey;

    public String getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    private void initVar() {
        this.linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        this.entityKey = this.context.getCtPushArgs().getTargetEntityNumber();
        this.mappingBillType = this.linkEntityMap.getMappingBillType();
        this.srcBillTypeReader = this.linkEntityMap.getSrcBillTypeReader();
    }

    public CtCreateTargetBillAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtCreateTargetBillAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.initVar();
        CtSourceRowsGroup group = this.getSourceRowsGroupRoot();
        CtExtendedDataEntitySet targetExtSet = new CtExtendedDataEntitySet();
        int dataEntityIndex = 0;
        ArrayList<CtExtendedDataEntity> headExtEntitys = new ArrayList<CtExtendedDataEntity>(group.getSourceRows().size());
        for (CtSourceRowsGroup srcBillGroup : group.getChildGroupList()) {
            CtSourceRowsGroupKey srcBillGroupKey = srcBillGroup.getGroupKey();
            StringBuilder errMessage = new StringBuilder();
            CtDataEntity ctDataEntity = this.createNewData(srcBillGroup, errMessage);
            ctDataEntity.initProp(this.entityKey, "billhead|");
            this.setBillType(srcBillGroup.getSourceRows(), ctDataEntity);
            CtExtendedDataEntity headExtEntity = new CtExtendedDataEntity(ctDataEntity, dataEntityIndex, 0);
            headExtEntity.setId(ctDataEntity.getId());
            ArrayList<DynamicObject> sourceRows = new ArrayList<DynamicObject>(8);
            sourceRows.addAll(srcBillGroup.getSourceRows());
            headExtEntity.setValueExt("ConvertSource", sourceRows);
            headExtEntity.setValueExt("isNewEntity", (Object)Boolean.TRUE);
            headExtEntity.setValue("SourceRowsGroupKey", (Object)srcBillGroupKey);
            headExtEntitys.add(headExtEntity);
            ++dataEntityIndex;
        }
        if (CollectionUtils.isEmpty(headExtEntitys)) {
            this.ruleResultManager.setSkipNextAction(Boolean.TRUE);
            return;
        }
        targetExtSet.AddExtendedDataEntities(this.entityKey, headExtEntitys);
        this.setTargetExtendedDataEntities(targetExtSet);
    }

    protected CtDataEntity createNewData(CtSourceRowsGroup srcBillGroup, StringBuilder errMessage) {
        CtDataEntity ctDataEntity = new CtDataEntity();
        ctDataEntity.setId((Long)srcBillGroup.getTargetBillId());
        ctDataEntity.setExistNextBatch(srcBillGroup.isExistNextBatch());
        ctDataEntity.setFirstBatch(srcBillGroup.isFirstBatch());
        ctDataEntity.setConver(srcBillGroup.isConver());
        return ctDataEntity;
    }

    private void setBillType(List<DynamicObject> sourceRows, CtDataEntity ctDataEntity) {
        if (CollectionUtils.isEmpty((Collection)this.ruleContext.getRule().getCtBillTypeMapPolicy().getItems())) {
            return;
        }
        Long billTypeId = null;
        if (this.mappingBillType != null) {
            billTypeId = (Long)this.mappingBillType.calcMapValue(this.linkEntityMap.getBaseDataPropInfoMap(), this.linkEntityMap.getSrcFldPropertys(), sourceRows);
        }
        Object srcBillTypeIdObj = this.srcBillTypeReader.getValue(this.linkEntityMap.getBaseDataPropInfoMap(), this.linkEntityMap.getSrcFldPropertys(), sourceRows.get(0));
        Long srcBillTypeId = Long.parseLong(srcBillTypeIdObj.toString());
        ctDataEntity.setBillTypeInfo(ctDataEntity, srcBillTypeId, billTypeId);
    }
}

