/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.id.ID;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroup;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtCreateTargetBillIdAction
extends AbstractCtConvertAction {
    public CtCreateTargetBillIdAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtGroupSourceRowsAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        CtSourceRowsGroup group = this.getSourceRowsGroupRoot();
        if (group == null || CollectionUtils.isEmpty(group.getChildGroupList())) {
            return;
        }
        long[] ids = ID.genLongIds((int)group.getChildGroupList().size());
        int i = 0;
        for (CtSourceRowsGroup srcBillGroup : group.getChildGroupList()) {
            Long sbillId = (Long)srcBillGroup.getSourceRows().get(0).getPkValue();
            long tbillId = ids[i];
            if (MapUtils.isNotEmpty(this.resultManager.getSourceTargetIdMap()) && this.resultManager.getSourceTargetIdMap().containsKey(sbillId)) {
                tbillId = this.resultManager.getSourceTargetIdMap().get(sbillId);
                srcBillGroup.setConver(true);
            }
            srcBillGroup.setTargetBillId(tbillId);
            srcBillGroup.setFirstBatch(true);
            srcBillGroup.setExistNextBatch(false);
            ++i;
        }
    }
}

