/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkRes;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.link.CtLkDownQueryArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.service.CtBillLkServiceHelper;

public class CtFilterCoverBillAction
extends AbstractCtConvertAction {
    public CtFilterCoverBillAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtFilterCoverBillAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        if (!SyncTypeEnum.FORWARD.getValue().equals(this.getContext().getCtPushArgs().getSyncType())) {
            return;
        }
        Set<Long> sBillIds = this.getSrcBillIds();
        Map<Long, Long> idMap = this.collectIds(sBillIds);
        this.resultManager.setSourceTargetIdMap(idMap);
    }

    private Set<Long> getSrcBillIds() {
        HashSet<Long> srcBillIds = new HashSet<Long>(this.getRuleContext().getSelectedRows().size());
        for (ListSelectedRow selectedRow : this.getRuleContext().getSelectedRows()) {
            Long srcBillId = (Long)selectedRow.getPrimaryKeyValue();
            srcBillIds.add(srcBillId);
        }
        return srcBillIds;
    }

    private Map<Long, Long> collectIds(Set<Long> srcBillIds) {
        if (srcBillIds == null || srcBillIds.size() == 0) {
            return null;
        }
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        CtLkDownQueryArgs ctLkDownQueryArgs = new CtLkDownQueryArgs();
        ctLkDownQueryArgs.setsTenantCode(RequestContext.get().getTenantId());
        ctLkDownQueryArgs.setsAccountId(RequestContext.get().getAccountId());
        ctLkDownQueryArgs.setsEntityKey(this.getContext().getCtPushArgs().getSourceEntityNumber());
        ctLkDownQueryArgs.setsBillIds(new ArrayList<Long>(srcBillIds));
        List<CtBillLkRes> ctBillLks = CtBillLkServiceHelper.getDirtBillLkDown(ctLkDownQueryArgs);
        for (CtBillLkRes ctBillLk : ctBillLks) {
            if (!ctBillLk.gettTenantCode().equals(this.ruleContext.getRule().getTargetTenant()) || !ctBillLk.gettAccountId().equals(this.ruleContext.getRule().getTargetDataCenter()) || !ctBillLk.gettEntityKey().equals(this.ruleContext.getRule().getTargetEntityNumber())) continue;
            idMap.put(ctBillLk.getsBillId(), ctBillLk.gettBillId());
        }
        return idMap;
    }

    private void filterSelectedRows(Set<Long> noPushBillIds) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(this.ruleContext.getSelectedRows());
        this.ruleContext.getSelectedRows().clear();
        for (ListSelectedRow selectedRow : selectedRows) {
            Object billId = selectedRow.getPrimaryKeyValue();
            if (!noPushBillIds.contains(billId)) continue;
            this.ruleContext.getSelectedRows().add(selectedRow);
        }
    }
}

