/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.compiler.CtDependEntityMap;
import kd.bos.service.ctbotp.convert.query.CtBotpQueryImpl;

public class CtLoadDependEntityRowsAction
extends AbstractCtConvertAction {
    public CtLoadDependEntityRowsAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtLoadDependEntityRowsAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.loadDependEntityRows();
    }

    private void loadDependEntityRows() {
        ArrayList<CtDependEntityMap> headEntityMap = new ArrayList<CtDependEntityMap>();
        ArrayList<CtDependEntityMap> entryEntityMap = new ArrayList<CtDependEntityMap>();
        ArrayList<CtDependEntityMap> subEntryEntityMap = new ArrayList<CtDependEntityMap>();
        for (CtDependEntityMap entityMap : this.ruleContext.getRuleCompiler().getDependEntityMaps().values()) {
            String[] targetEntityArr = entityMap.getTargetEntity().split("\\|");
            if (targetEntityArr.length == 3) {
                subEntryEntityMap.add(entityMap);
                continue;
            }
            if (targetEntityArr.length == 2) {
                entryEntityMap.add(entityMap);
                continue;
            }
            headEntityMap.add(entityMap);
        }
        for (CtDependEntityMap entityMap : headEntityMap) {
            this.loadDependEntityRows(entityMap);
        }
        for (CtDependEntityMap entityMap : entryEntityMap) {
            this.loadDependEntityRows(entityMap);
        }
        for (CtDependEntityMap entityMap : subEntryEntityMap) {
            this.loadDependEntityRows(entityMap);
        }
    }

    private void loadDependEntityRows(CtDependEntityMap entityMap) {
        QFilter[] qFilters = this.compileQFilter(entityMap);
        if (qFilters == null || qFilters.length == 0) {
            return;
        }
        DynamicObjectCollection rows = this.queryData(entityMap, qFilters);
        this.setSourceRows(entityMap, (List<DynamicObject>)rows);
        if (entityMap.getSrcFldPropertys().isEmpty()) {
            DynamicObjectType dType = rows.getDynamicObjectType();
            Map<String, DynamicProperty> fldPropertys = this.buildSourceRowPropsDictory(dType, entityMap.getSrcFldAlias());
            entityMap.setSrcFldPropertys(fldPropertys);
        }
    }

    private DynamicObjectCollection queryData(CtDependEntityMap ctDependEntityMap, QFilter[] qFilters) {
        CtBotpQueryImpl botpQueryExecuter = new CtBotpQueryImpl();
        DynamicObjectCollection rows = botpQueryExecuter.query(ctDependEntityMap.getQueryParameter(), qFilters);
        return rows;
    }

    private Map<String, DynamicProperty> buildSourceRowPropsDictory(DynamicObjectType dType, Map<String, String> fldAlias) {
        HashMap<String, DynamicProperty> fldPropertys = new HashMap<String, DynamicProperty>(fldAlias.size());
        for (Map.Entry<String, String> fldAliasItem : fldAlias.entrySet()) {
            String var = fldAliasItem.getKey();
            String alias = fldAliasItem.getValue();
            DynamicProperty property = dType.getProperty(alias);
            fldPropertys.put(var, property);
        }
        return fldPropertys;
    }

    protected QFilter[] compileQFilter(CtDependEntityMap entityMap) {
        entityMap.compileQFilter();
        return entityMap.getQFilters().toArray(new QFilter[entityMap.getQFilters().size()]);
    }

    protected List<DynamicObject> getTargetAnchorSourceRows(CtDependEntityMap entityMap) {
        return entityMap.getTargetAnchorEntityMap().getSourceRows();
    }

    protected void setSourceRows(CtDependEntityMap entityMap, List<DynamicObject> sourceRows) {
        entityMap.getSourceRows().clear();
        entityMap.getSourceRows().addAll(sourceRows);
    }
}

