/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.query.CtBotpQueryImpl;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.xdb.hint.ShardingHintContext;

public class CtLoadSourceDataAction
extends AbstractCtConvertAction {
    private static final Log logger = LogFactory.getLog(CtLoadSourceDataAction.class);
    private static final int MAX_PUSH_ROWS = 20000;
    private static final String OP_NAME_MAX_PUSH_ROWS = "bos_max_push_rows";
    private static final String OP_NAME_LIMIT_MAX_ROWS = "bos_push_limit_max_rows";
    private static final String QUERY_HAS_BASEDATA_ENABLE = "query_has_basedata_enable";

    public int getMaxPushRows() {
        String rows = this.getContext().getOption().getVariableValue(OP_NAME_MAX_PUSH_ROWS, String.valueOf(20000));
        return Integer.parseInt(rows);
    }

    public boolean isLimitMaxRows() {
        String tenantCode = RequestContext.get().getTenantCode();
        String paramValue = System.getProperty(String.format("%s_%s", tenantCode, OP_NAME_LIMIT_MAX_ROWS));
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return true;
        }
        return Boolean.parseBoolean(paramValue);
    }

    public boolean isOnlyReadBillTable() {
        return StringUtils.equals((CharSequence)"true", (CharSequence)"false");
    }

    public CtLoadSourceDataAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtLoadSourceDataAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.loadSourceRows();
    }

    private void loadSourceRows() {
        CtLinkEntityMap linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        String entityNumber = this.ruleContext.getContext().getInputArgs().getSourceEntityNumber();
        String selectSQLString = linkEntityMap.getSrcSelectString();
        QFilter[] qFilters = linkEntityMap.getQFilters().toArray(new QFilter[linkEntityMap.getQFilters().size()]);
        int count = this.queryCount(qFilters, entityNumber, linkEntityMap.getSrcRowIdSelectString());
        if (this.isLimitMaxRows() && count > this.getMaxPushRows()) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append(String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u4e00\u6b21\u8f6c\u6362\u7684\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8d85\u8fc7\uff08%s\u884c\uff09\uff0c\u8d85\u51fa\u7cfb\u7edf\u5904\u7406\u80fd\u529b\uff0c\u5efa\u8bae\u6309\u5982\u4e0b\u65b9\u5f0f\u8c03\u6574\uff1a", (String)"LoadSourceDataAction_1", (String)"bos-mservice-botp", (Object[])new Object[0]), count));
            sBuilder.append("\r\n").append(String.format(ResManager.loadKDString((String)"1.\u5206\u591a\u6b21\u8f6c\u6362\uff0c\u6bcf\u6b21%s\u884c\u4ee5\u5185\uff1b", (String)"LoadSourceDataAction_2", (String)"bos-mservice-botp", (Object[])new Object[0]), this.getMaxPushRows()));
            sBuilder.append("\r\n").append(ResManager.loadKDString((String)"2.\u4fee\u6539\u8f6c\u6362\u89c4\u5219\uff0c\u52fe\u9009\u3010\u81ea\u52a8\u4fdd\u5b58\u3011\u9009\u9879\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u5206\u6279\u5904\u7406\uff1b", (String)"LoadSourceDataAction_3", (String)"bos-mservice-botp", (Object[])new Object[0]));
            sBuilder.append("\r\n").append(ResManager.loadKDString((String)"3.\u6539\u7528\u4e0b\u63a8\u5e76\u4fdd\u5b58(pushandsave)\u64cd\u4f5c\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u5206\u6279\u5904\u7406\uff1b", (String)"LoadSourceDataAction_4", (String)"bos-mservice-botp", (Object[])new Object[0]));
            throw new KDBizException(sBuilder.toString());
        }
        DynamicObjectCollection rows = this.queryData(linkEntityMap, qFilters, entityNumber, selectSQLString);
        linkEntityMap.getSourceRows().clear();
        linkEntityMap.getSourceRows().addAll((Collection<DynamicObject>)rows);
        DynamicObjectType dType = rows.getDynamicObjectType();
        Map<String, DynamicProperty> fldPropertys = this.buildSourceRowPropsDictory(dType, linkEntityMap.getSrcFldAlias());
        linkEntityMap.getSrcFldPropertys().clear();
        linkEntityMap.getSrcFldPropertys().putAll(fldPropertys);
        this.ruleContext.getMulbasedataParaManager().collectMulbasedataNumberForLoadSource(linkEntityMap, fldPropertys, rows);
    }

    private int queryCount(QFilter[] qFilters, String entityNumber, String selectSQLString) {
        int count = 0;
        ORM orm = ORM.create();
        try {
            count = orm.count(this.getClass().getName(), entityNumber, selectSQLString, qFilters, null, this.getMaxPushRows() + 1);
        }
        catch (RuntimeException e) {
            logger.error(String.format("[BOTP-LoadSourceDataAciton]\u4e0b\u63a8\u68c0\u7d22\u6e90\u5355count\u51fa\u9519,[entityNumber:%s],[selectSQLString:%s],[qFilters:%s]", entityNumber, selectSQLString, Arrays.toString(qFilters)));
            throw new RuntimeException(e);
        }
        return count;
    }

    private DynamicObjectCollection queryData(CtLinkEntityMap linkEntityMap, QFilter[] qFilters, String entityNumber, String selectSQLString) {
        CtBotpQueryImpl botpQueryExecuter = new CtBotpQueryImpl();
        DynamicObjectCollection rows = botpQueryExecuter.query(linkEntityMap.getQueryParameter(), qFilters);
        return rows;
    }

    private DynamicObjectCollection queryHasBasedata(CtLinkEntityMap linkEntityMap, QFilter[] qFilters, String entityNumber, String selectSQLString, DynamicObjectCollection rows) {
        logger.info("\u6267\u884c\u57fa\u7840\u8d44\u6599\u5206\u8868\u65f6\u53d6\u6570\u7684\u4f18\u5316\u903b\u8f91\u3002");
        ShardingHintContext hintContext = null;
        if (!linkEntityMap.getQueryParameter().getQueryRefIdProps().isEmpty()) {
            logger.info("\u6267\u884c\u57fa\u7840\u8d44\u6599\u5206\u8868\u65f6\u53d6\u6570\u7684\u4f18\u5316\u903b\u8f91\uff0c\u7edf\u8ba1\u57fa\u7840\u8d44\u6599\u4e0d\u4e3a\u7a7a");
            CtBotpQueryImpl botpQuery = new CtBotpQueryImpl();
            Map<String, Set<Object>> queryBaseIds = botpQuery.queryBaseIds(linkEntityMap.getQueryParameter(), qFilters);
            for (Map.Entry<String, Set<Object>> entry : queryBaseIds.entrySet()) {
                String keyTable;
                String keyEntityNumber = entry.getKey();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)keyEntityNumber);
                if (dataEntityType == null || !ShardingHinter.isSharding((String)(keyTable = dataEntityType.getAlias()))) continue;
                hintContext = ShardingHinter.tryHint((IDataEntityType)dataEntityType, (Object[])entry.getValue().toArray());
                break;
            }
        }
        if (hintContext != null) {
            hintContext.set();
        }
        ORM orm = ORM.create();
        try {
            DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectSQLString, qFilters);
            Object object = null;
            try {
                rows = orm.toPlainDynamicObjectCollection(ds);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (RuntimeException e) {
            logger.error(String.format("[BOTP-LoadSourceDataAciton]\u4e0b\u63a8\u68c0\u7d22\u6e90\u5355\u6570\u636e\u51fa\u9519,[entityNumber:%s],[selectSQLString:%s],[qFilters:%s]", entityNumber, selectSQLString, Arrays.toString(qFilters)));
            throw new RuntimeException(e);
        }
        finally {
            if (hintContext != null) {
                hintContext.close();
            }
        }
        return rows;
    }

    private boolean isQueryHasBasedata() {
        String tenantId = RequestContext.get().getTenantId();
        return SystemPropertyUtils.getBoolean((String)tenantId, (String)QUERY_HAS_BASEDATA_ENABLE);
    }

    private Map<String, DynamicProperty> buildSourceRowPropsDictory(DynamicObjectType dType, Map<String, String> fldAlias) {
        HashMap<String, DynamicProperty> fldPropertys = new HashMap<String, DynamicProperty>(fldAlias.size());
        for (Map.Entry<String, String> fldAliasItem : fldAlias.entrySet()) {
            String var = fldAliasItem.getKey();
            String alias = fldAliasItem.getValue();
            DynamicProperty property = dType.getProperty(alias);
            fldPropertys.put(var, property);
        }
        return fldPropertys;
    }
}

