/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ctbotp.CtExtendedDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntitySet;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.actions.CtMappingDependFieldValue;
import kd.bos.service.ctbotp.convert.batchrequest.CtBatchRequestManager;
import kd.bos.service.ctbotp.convert.compiler.CtDependEntityMap;
import kd.bos.service.ctbotp.convert.mapping.ICtMappingField;

public class CtMappingDependFieldAction
extends AbstractCtConvertAction {
    private static final Log log = LogFactory.getLog(CtMappingDependFieldAction.class);
    private CtBatchRequestManager batchRequestManager;

    public CtMappingDependFieldAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtMappingDependFieldAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        CtExtendedDataEntitySet targetExtDataSet = this.getTargetExtendedDataEntities();
        for (CtDependEntityMap entityMap : this.ruleContext.getRuleCompiler().getDependEntityMaps().values()) {
            this.createBatchRequestHandlers(entityMap);
            Map<String, DynamicProperty> srcFldPropertys = entityMap.getSrcFldPropertys();
            for (Map.Entry<String, List<ICtMappingField>> entityItem : entityMap.getTargetFields().entrySet()) {
                String entityType = entityItem.getKey();
                List<ICtMappingField> mappingFields = entityItem.getValue();
                String[] targetEntityArr = entityType.split("\\|");
                String entryTypeKey = targetEntityArr[targetEntityArr.length - 1];
                if ("billhead".equals(entryTypeKey)) {
                    entryTypeKey = this.context.getTargetEntityNumber();
                }
                CtExtendedDataEntity[] targetExtDataEntitys = targetExtDataSet.FindByEntityKey(entryTypeKey);
                for (ICtMappingField mappingField : mappingFields) {
                    CtMappingDependFieldValue mappingDependFieldValue = new CtMappingDependFieldValue(targetExtDataEntitys, mappingField, srcFldPropertys, this.batchRequestManager, this.getContext(), entityMap, entityMap.getBaseDataPropInfoMap());
                    mappingDependFieldValue.setBatchPreCall(true).prepBillAndCalc();
                    mappingDependFieldValue.setBatchPreCall(false).prepBillAndCalc();
                }
            }
            this.doBatchRequests();
        }
    }

    private void createBatchRequestHandlers(CtDependEntityMap entityMap) {
        this.batchRequestManager = new CtBatchRequestManager();
        this.batchRequestManager.initialize(this.ruleContext, this.ruleResultManager, entityMap);
    }

    private void doBatchRequests() {
        this.batchRequestManager.batchSetBasedataValue();
        if (this.batchRequestManager.getBatchOrgSepr().isFail()) {
            this.setSkipNextAction(true);
        }
        this.batchRequestManager.batchAfterSetBasedataValue();
        this.batchRequestManager.batchSetRefBillValue();
        this.batchRequestManager.batchSetFlexValue();
        this.batchRequestManager.batchSetItemClassValue();
        this.batchRequestManager.batchSetBaseDataValue();
        this.batchRequestManager.batchSetAttachmentValue();
    }
}

