/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ctbotp.BaseDataPropInfo;
import kd.bos.entity.ctbotp.CtExtendedDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntitySet;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.actions.CtMappingFieldValue;
import kd.bos.service.ctbotp.convert.batchrequest.CtBatchRequestManager;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.mapping.ICtMappingField;

public class CtMappingFieldAction
extends AbstractCtConvertAction {
    private static final Log log = LogFactory.getLog(CtMappingFieldAction.class);
    private CtLinkEntityMap linkEntityMap = null;
    private CtBatchRequestManager batchRequestManager;

    public CtMappingFieldAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtMappingFieldAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        Map<String, DynamicProperty> srcFldPropertys = this.linkEntityMap.getSrcFldPropertys();
        Map<String, BaseDataPropInfo> baseDataPropInfoMap = this.linkEntityMap.getBaseDataPropInfoMap();
        CtExtendedDataEntitySet targetExtDataSet = this.getTargetExtendedDataEntities();
        this.createBatchRequestHandlers();
        for (Map.Entry<String, List<ICtMappingField>> entityItem : this.linkEntityMap.getTargetFields().entrySet()) {
            String entityType = entityItem.getKey();
            String[] entityArr = entityType.split("\\|");
            String entityKey = entityArr[entityArr.length - 1];
            if (entityKey.contains("billhead")) {
                entityKey = this.context.getCtPushArgs().getTargetEntityNumber();
            }
            List<ICtMappingField> mappingFields = entityItem.getValue();
            CtExtendedDataEntity[] targetExtDataEntitys = targetExtDataSet.FindByEntityKey(entityKey);
            for (ICtMappingField mappingField : mappingFields) {
                CtMappingFieldValue mappingFieldValue = new CtMappingFieldValue(targetExtDataEntitys, mappingField, srcFldPropertys, this.batchRequestManager, this.getContext(), null, baseDataPropInfoMap);
                mappingFieldValue.setBatchPreCall(true).prepBillAndCalc();
                mappingFieldValue.setBatchPreCall(false).prepBillAndCalc();
            }
        }
        this.doBatchRequest();
    }

    private void createBatchRequestHandlers() {
        this.batchRequestManager = new CtBatchRequestManager();
        this.batchRequestManager.initialize(this.ruleContext, this.ruleResultManager, this.linkEntityMap);
    }

    private void doBatchRequest() {
        this.batchRequestManager.batchSetBasedataValue();
        if (this.batchRequestManager.getBatchOrgSepr().isFail()) {
            this.setSkipNextAction(true);
        }
        this.batchRequestManager.batchSetRefBillValue();
        if (this.batchRequestManager.getBatchRefBill().isFail()) {
            this.setSkipNextAction(true);
        }
        this.batchRequestManager.batchAfterSetBasedataValue();
        this.batchRequestManager.batchSetFlexValue();
        this.batchRequestManager.batchSetItemClassValue();
        this.batchRequestManager.batchSetBaseDataValue();
        this.batchRequestManager.batchSetAttachmentValue();
    }

    private void loadReferenceObject() {
        CtExtendedDataEntitySet targetExtDataSet = this.getTargetExtendedDataEntities();
        CtExtendedDataEntity[] headObjs = targetExtDataSet.FindByEntityKey(this.context.getInputArgs().getTargetEntityNumber());
        Object[] objs = new DynamicObject[headObjs.length];
        for (int i = 0; i < headObjs.length; ++i) {
            objs[i] = headObjs[i].getDataEntity();
        }
        BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)this.context.getTargetMainType());
    }
}

