/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtLkUpQueryArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;

public class CtReversePushUpLKCheckAction
extends AbstractCtConvertAction {
    public CtReversePushUpLKCheckAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtPushAgainCheckAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        if (!SyncTypeEnum.REVERSE.getValue().equals(this.getContext().getCtPushArgs().getSyncType())) {
            return;
        }
        Set<Long> tarBillIds = this.getTarBillIds();
        Set<Long> noExsitUpLkBillIds = this.findNoExsitUpLkBills(tarBillIds);
        this.filterSelectedRows(noExsitUpLkBillIds);
        if (this.ruleContext.getSelectedRows().isEmpty()) {
            this.setSkipNextAction(true);
        }
    }

    private Set<Long> getTarBillIds() {
        HashSet<Long> srcBillIds = new HashSet<Long>(this.getRuleContext().getSelectedRows().size());
        for (ListSelectedRow selectedRow : this.getRuleContext().getSelectedRows()) {
            Long srcBillId = (Long)selectedRow.getPrimaryKeyValue();
            srcBillIds.add(srcBillId);
        }
        return srcBillIds;
    }

    private Set<Long> findNoExsitUpLkBills(Set<Long> tarBillIds) {
        if (tarBillIds == null || tarBillIds.isEmpty()) {
            return Collections.emptySet();
        }
        CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
        ctLkUpQueryArgs.settTenantCode(RequestContext.get().getTenantId());
        ctLkUpQueryArgs.settAccountId(RequestContext.get().getAccountId());
        ctLkUpQueryArgs.settEntityKey(this.getContext().getCtPushArgs().getSourceEntityNumber());
        ctLkUpQueryArgs.settBillIds(new ArrayList<Long>(tarBillIds));
        List ctBillLks = CtBillLinkService.getCtDirtBillLkUp((CtLkUpQueryArgs)ctLkUpQueryArgs);
        HashMap<Long, CtBillLk> ctBillLkMap = new HashMap<Long, CtBillLk>(ctBillLks.size());
        for (CtBillLk ctBillLk : ctBillLks) {
            ctBillLkMap.put(ctBillLk.getTBillId(), ctBillLk);
        }
        String failMessage = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\u5173\u8054\u7684\u6e90\u5355\uff0c\u65e0\u6cd5\u53cd\u5411\u540c\u6b65\u3002", (String)"CtPushAgainCheckAction_2", (String)"bos-mservice-ctbotp", (Object[])new Object[0]);
        HashSet<Long> noExsitUpLkBillIds = new HashSet<Long>(16);
        for (Long tarBillId : tarBillIds) {
            if (ctBillLkMap.containsKey(tarBillId)) continue;
            noExsitUpLkBillIds.add(tarBillId);
            this.getResultManager().getReporter().addFailId(tarBillId, failMessage);
        }
        return noExsitUpLkBillIds;
    }

    private void filterSelectedRows(Set<Long> noExsitUpLkBillIds) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(this.ruleContext.getSelectedRows());
        this.ruleContext.getSelectedRows().clear();
        if (noExsitUpLkBillIds == null) {
            return;
        }
        for (ListSelectedRow selectedRow : selectedRows) {
            Object billId = selectedRow.getPrimaryKeyValue();
            if (noExsitUpLkBillIds.contains(billId)) continue;
            this.ruleContext.getSelectedRows().add(selectedRow);
        }
    }
}

