/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ctbotp.runtime.CtSourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertReportManager;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.compiler.CtCRConditionCompiler;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.report.ICtBuildDetailReport;
import kd.bos.service.ctbotp.convert.var.CtSourceFieldVariable;

public class CtRunDataConditionAction
extends AbstractCtConvertAction {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-ctbotp";
    private Boolean outFormula = null;

    private boolean isOutFormula() {
        if (this.outFormula == null) {
            String paramValue = (String)this.getContext().getInputArgs().getCustomParams().get("botp_outformula");
            this.outFormula = paramValue == null ? Boolean.FALSE : Boolean.valueOf(paramValue);
        }
        return this.outFormula;
    }

    public CtRunDataConditionAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        String failMessage;
        super.doAction();
        CtConvertReportManager reportManager = this.resultManager.getCtReporter();
        CtLinkEntityMap linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        Map<String, DynamicProperty> fldProperties = linkEntityMap.getSrcFldPropertys();
        EntityType linkEntity = (EntityType)this.context.getSourceMainType().getAllEntities().get(linkEntityMap.getSourceLinkEntityKey());
        ICtBuildDetailReport reportBuilder = this.ruleContext.getSrcRowReportBuilder(linkEntity);
        if (linkEntityMap.getSourceRows().isEmpty()) {
            this.setSkipNextAction(true);
            String failMessage2 = null;
            failMessage2 = linkEntity instanceof EntryType && ((EntryType)linkEntity).isMustIuput() ? String.format(ResManager.loadKDString((String)"\u6839\u636e\u4f20\u5165\u7684\u6e90\u5355\u5185\u7801\uff0c\u6ca1\u6709\u53d6\u5230\u6e90\u5355\u6570\u636e\uff0c\u53ef\u80fd\u662f%s\u6ca1\u6709\u8bb0\u5f55", (String)"CtRunDataConditionAction_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), linkEntity.getDisplayName().toString()) : ResManager.loadKDString((String)"\u6839\u636e\u4f20\u5165\u7684\u6e90\u5355\u5185\u7801\uff0c\u6ca1\u6709\u53d6\u5230\u6e90\u5355\u6570\u636e", (String)"CtRunDataConditionAction_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
            this.resultManager.getReporter().addFailId((Long)((ListSelectedRow)this.context.getCtPushArgs().getSelectedRows().get(0)).getPrimaryKeyValue(), failMessage2);
            return;
        }
        HashSet<DynamicObject> sourceRows = new HashSet<DynamicObject>();
        List<CtCRConditionCompiler> crConditionCompilers = this.ruleContext.getRuleCompiler().getDataFilterCompilers();
        HashSet<Long> removeBillId = new HashSet<Long>();
        String dataRangeMode = this.ruleContext.getRule().getCtFilterPolicy().getDataRangeMode();
        if (StringUtils.isBlank((CharSequence)dataRangeMode)) {
            dataRangeMode = "0";
        }
        for (CtCRConditionCompiler ctCRConditionCompiler : crConditionCompilers) {
            this.runCondition(sourceRows, fldProperties, ctCRConditionCompiler, linkEntityMap, reportManager, reportBuilder, dataRangeMode, removeBillId);
        }
        if (sourceRows.isEmpty()) {
            this.setSkipNextAction(true);
            failMessage = null;
            failMessage = dataRangeMode.equals("1") ? ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u8f6c\u6362\u89c4\u5219\u7684\u6570\u636e\u7b5b\u9009\u6761\u4ef6\uff0c\u4efb\u4e00\u5206\u5f55\u4e0d\u7b26\u5408\u6761\u4ef6\u5219\u6574\u5355\u4e0d\u7b26\u5408", (String)"CtRunDataConditionAction_7", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]) : (dataRangeMode.equals("2") ? ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u8f6c\u6362\u89c4\u5219\u7684\u6570\u636e\u7b5b\u9009\u6761\u4ef6\uff0c\u4efb\u4e00\u5206\u5f55\u7b26\u5408\u6761\u4ef6\u5219\u6574\u5355\u7b26\u5408", (String)"CtRunDataConditionAction_6", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u8f6c\u6362\u89c4\u5219\u7684\u6570\u636e\u7b5b\u9009\u6761\u4ef6\uff0c\u4ec5\u5141\u8bb8\u7b26\u5408\u6761\u4ef6\u7684\u5206\u5f55\u884c\u6267\u884c\u4e0b\u63a8", (String)"CtRunDataConditionAction_5", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            for (ListSelectedRow listSelectedRow : this.context.getCtPushArgs().getSelectedRows()) {
                this.resultManager.getReporter().addFailId((Long)listSelectedRow.getPrimaryKeyValue(), failMessage);
            }
            this.resultManager.getCtReporter().addBreakMessage(this.ruleContext.getRule(), failMessage);
        } else {
            failMessage = null;
            failMessage = dataRangeMode.equals("1") ? ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u8f6c\u6362\u89c4\u5219\u7684\u6570\u636e\u7b5b\u9009\u6761\u4ef6\uff0c\u4efb\u4e00\u5206\u5f55\u4e0d\u7b26\u5408\u6761\u4ef6\u5219\u6574\u5355\u4e0d\u7b26\u5408", (String)"CtRunDataConditionAction_7", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]) : (dataRangeMode.equals("2") ? ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u8f6c\u6362\u89c4\u5219\u7684\u6570\u636e\u7b5b\u9009\u6761\u4ef6\uff0c\u4efb\u4e00\u5206\u5f55\u7b26\u5408\u6761\u4ef6\u5219\u6574\u5355\u7b26\u5408", (String)"CtRunDataConditionAction_6", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u8f6c\u6362\u89c4\u5219\u7684\u6570\u636e\u7b5b\u9009\u6761\u4ef6\uff0c\u4ec5\u5141\u8bb8\u7b26\u5408\u6761\u4ef6\u7684\u5206\u5f55\u884c\u6267\u884c\u4e0b\u63a8", (String)"CtRunDataConditionAction_5", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            Set set = sourceRows.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            for (ListSelectedRow listSelectedRow : this.context.getCtPushArgs().getSelectedRows()) {
                if (set.contains(listSelectedRow.getPrimaryKeyValue()) && !removeBillId.contains(listSelectedRow.getPrimaryKeyValue())) continue;
                this.resultManager.getReporter().addFailId((Long)listSelectedRow.getPrimaryKeyValue(), failMessage);
                Iterator<DynamicObject> it = linkEntityMap.getSourceRows().iterator();
                while (it.hasNext()) {
                    DynamicObject sourceRow = it.next();
                    if (dataRangeMode.equals("2")) {
                        if (!sourceRow.getPkValue().equals(listSelectedRow.getPrimaryKeyValue())) continue;
                        it.remove();
                        continue;
                    }
                    if (!dataRangeMode.equals("1") || !removeBillId.contains((Long)sourceRow.getPkValue())) continue;
                    it.remove();
                }
            }
        }
    }

    @Override
    protected void setProcess() {
    }

    private void runCondition(Set<DynamicObject> sourceRows, Map<String, DynamicProperty> fldProperties, CtCRConditionCompiler rowCondCompiler, CtLinkEntityMap linkEntityMap, CtConvertReportManager reportManager, ICtBuildDetailReport reportBuilder, String dataRangeMode, Set<Long> removeBillId) {
        Iterator<DynamicObject> it = linkEntityMap.getSourceRows().iterator();
        while (it.hasNext()) {
            List list;
            DynamicObject sourceRow = it.next();
            reportBuilder.addLinkRow(reportManager, fldProperties, sourceRow);
            if (dataRangeMode.equals("1") && removeBillId.contains(sourceRow.getPkValue())) {
                it.remove();
                continue;
            }
            if (rowCondCompiler.executeCondition(null, fldProperties, sourceRow)) {
                sourceRows.add(sourceRow);
                continue;
            }
            String failMessage = rowCondCompiler.buildFailMessage(null, fldProperties, sourceRow, this.isOutFormula());
            reportBuilder.addErrorReport(reportManager, fldProperties, sourceRow, failMessage);
            sourceRows.remove(sourceRow);
            if (dataRangeMode.equals("0")) {
                it.remove();
                continue;
            }
            if (dataRangeMode.equals("1")) {
                String billFailMessage = ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u8f6c\u6362\u89c4\u5219\u7684\u6570\u636e\u7b5b\u9009\u6761\u4ef6\uff0c\u4efb\u4e00\u5206\u5f55\u4e0d\u7b26\u5408\u6761\u4ef6\u5219\u6574\u5355\u4e0d\u7b26\u5408", (String)"CtRunDataConditionAction_7", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
                Long pkId = (Long)sourceRow.getPkValue();
                CtSourceBillReport billReport = reportManager.getBillReports(pkId);
                billReport.getFailMessages().add(billFailMessage);
                removeBillId.add((Long)sourceRow.getPkValue());
                it.remove();
                continue;
            }
            if (!dataRangeMode.equals("2")) continue;
            CtSourceFieldVariable ctSourceFieldVariable = (CtSourceFieldVariable)rowCondCompiler.getVars().get(0);
            if (ctSourceFieldVariable.getSourceField().getParent().getName().equals(this.context.getSourceMainType().getName())) {
                removeBillId.add((Long)sourceRow.getPkValue());
            }
            if ((list = linkEntityMap.getSourceRows().stream().filter(row -> row.getPkValue().equals(sourceRow.getPkValue())).collect(Collectors.toList())).size() != 1) continue;
            it.remove();
        }
    }
}

