/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ctbotp.runtime.CtPushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertReportManager;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.baseversion.CtBasedataVersionManager;
import kd.bos.service.ctbotp.convert.compiler.CtCRConditionCompiler;
import kd.bos.service.ctbotp.convert.compiler.CtConvertRuleCompiler;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetConstValue;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.var.CtSourceFieldVariable;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;

public class CtRunRuleConditionAction
extends AbstractCtConvertAction {
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-ctbotp";

    public CtRunRuleConditionAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
    }

    @Override
    protected void doAction() {
        super.doAction();
        Set<Object> srcBillIds = this.getSrcBillIds();
        if (srcBillIds.isEmpty()) {
            this.resultManager.setSkipNextRule(true);
            this.setSkipNextAction(true);
            return;
        }
        Set<Object> myBillIds = this.runCondition(srcBillIds);
        this.filterSelectedRows(myBillIds);
        if (this.ruleContext.getSelectedRows().isEmpty()) {
            this.setSkipNextAction(true);
        }
        srcBillIds.removeAll(myBillIds);
        for (Object srcBillId : srcBillIds) {
            this.resultManager.getReporter().addFailId((Long)srcBillId, ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u6570\u636e\u534f\u540c\u89c4\u5219\u542f\u7528\u6761\u4ef6\u3002", (String)"CtRunRuleConditionAction_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
        }
        this.updateRuleId(myBillIds);
    }

    private Set<Object> getSrcBillIds() {
        return new HashSet<Object>(this.resultManager.getSbillIdSet());
    }

    private Set<Object> runCondition(Set<Object> srcBillIds) {
        CtCRConditionCompiler runCondCompiler;
        CtBasedataVersionManager basedataVersionManagerForRunRule;
        block18: {
            basedataVersionManagerForRunRule = new CtBasedataVersionManager();
            runCondCompiler = null;
            CtConvertRuleCompiler ruleCompiler = this.ruleContext.getRuleCompiler();
            try {
                runCondCompiler = ruleCompiler.compileRunCondition();
            }
            catch (KDBizException exp) {
                if (!exp.getErrorCode().getCode().equals("bos.fieldNotExist")) break block18;
                KDBizException e = new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53[%1$s]\u8f6c\u6362\u89c4\u5219[%2$s]\u914d\u7f6e\u6709\u8bef\uff1a\u89c4\u5219\u542f\u7528\u6761\u4ef6\u4e2d\u7684\u5b57\u6bb5[%3$s]\uff0c\u5728\u6e90\u5355\u4e0a\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u8f6c\u6362\u89c4\u5219", (String)"CtRunRuleConditionAction_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.ruleContext.getRule().getSourceEntityNumber(), this.ruleContext.getRule().getName(), exp.getArgs().length > 1 ? exp.getArgs()[1].toString().split("\uff0c")[0] : ""));
                throw e;
            }
        }
        if (runCondCompiler == null || runCondCompiler.getGridQFilters().isEmpty() && runCondCompiler.getExpressionExecuter() instanceof CtGetConstValue && ((Boolean)((CtGetConstValue)runCondCompiler.getExpressionExecuter()).getConstValue()).booleanValue()) {
            return srcBillIds;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        BillEntityType srcMainType = this.context.getSourceMainType();
        String entityNumber = srcMainType.getName();
        String pkFieldName = srcMainType.getPrimaryKey().getName();
        HashMap<String, String> fieldAlias = new HashMap<String, String>();
        ArrayList<String> selectFields = new ArrayList<String>();
        fieldAlias.put(pkFieldName, pkFieldName);
        selectFields.add(pkFieldName);
        ICtGetValueMode expressExecutor = runCondCompiler.getExpressionExecuter();
        ICtGetValueMode gridFilterExecutor = this.ruleContext.getRuleCompiler().getRuleCondCompiler().getGridFilterExecuter();
        this.addSourceFields(expressExecutor.getVars(), selectFields, fieldAlias);
        this.addSourceFields(gridFilterExecutor.getVars(), selectFields, fieldAlias);
        Map<String, CtSourceFieldVariable> fields = this.buildVarSourceFieldMap(expressExecutor, gridFilterExecutor);
        basedataVersionManagerForRunRule.prepareBasedataPropForVersion(srcMainType, fields, fieldAlias, selectFields);
        String selectString = StringUtils.join((Object[])selectFields.toArray(), (String)",");
        QFilter idFilter = new QFilter("id", "in", (Object)srcBillIds.toArray());
        qFilters.add(idFilter);
        QFilter[] arrQFilters = new QFilter[qFilters.size()];
        arrQFilters = qFilters.toArray(arrQFilters);
        ORM orm = ORM.create();
        DynamicObjectCollection rows = null;
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectString, arrQFilters);){
            rows = orm.toPlainDynamicObjectCollection(ds);
        }
        HashMap<String, DynamicProperty> fieldPropertys = new HashMap<String, DynamicProperty>(fieldAlias.size());
        DynamicObjectType dType = rows.getDynamicObjectType();
        for (Map.Entry entry : fieldAlias.entrySet()) {
            String string = (String)entry.getKey();
            String fldAlias = (String)entry.getValue();
            DynamicProperty property = (DynamicProperty)dType.getProperties().get((Object)fldAlias);
            fieldPropertys.put(string, property);
        }
        this.ruleContext.getMulbasedataParaManager().collectMulbasedataNumberForRunRule(runCondCompiler, expressExecutor.getVars(), fieldPropertys, rows);
        basedataVersionManagerForRunRule.setGetValueFuncToValueModel(fieldPropertys, expressExecutor);
        basedataVersionManagerForRunRule.setGetValueFuncToValueModel(fieldPropertys, gridFilterExecutor);
        HashMap<String, Object> memIdSet = new HashMap<String, Object>(srcBillIds.size());
        for (Object object : srcBillIds) {
            String idString = String.valueOf(object);
            memIdSet.put(idString, object);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (DynamicObject row : rows) {
            if (!((Boolean)expressExecutor.getValue(null, fieldPropertys, row)).booleanValue() || !((Boolean)gridFilterExecutor.getValue(null, fieldPropertys, row)).booleanValue()) continue;
            Object billId = row.get(pkFieldName);
            String idString = String.valueOf(billId);
            Object memBillId = memIdSet.get(idString);
            hashSet.add(memBillId);
        }
        return hashSet;
    }

    private Map<String, CtSourceFieldVariable> buildVarSourceFieldMap(ICtGetValueMode expressExecutor, ICtGetValueMode gridFilterExecutor) {
        HashMap<String, CtSourceFieldVariable> fields = new HashMap<String, CtSourceFieldVariable>();
        if (expressExecutor != null) {
            for (ICtVariableMode var : expressExecutor.getVars()) {
                if (!(var instanceof CtSourceFieldVariable) || fields.containsKey(var.getVar())) continue;
                fields.put(var.getVar(), (CtSourceFieldVariable)var);
            }
        }
        if (gridFilterExecutor != null) {
            for (ICtVariableMode var : gridFilterExecutor.getVars()) {
                if (!(var instanceof CtSourceFieldVariable) || fields.containsKey(var.getVar())) continue;
                fields.put(var.getVar(), (CtSourceFieldVariable)var);
            }
        }
        return fields;
    }

    private void filterSelectedRows(Set<Object> myBillIds) {
        List selectedRows = null;
        selectedRows = ((CtPushArgs)this.context.getInputArgs()).getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            Object billId = selectedRow.getPrimaryKeyValue();
            if (!myBillIds.contains(billId)) continue;
            this.ruleContext.getSelectedRows().add(selectedRow);
        }
    }

    private void updateRuleId(Set<Object> myBillIds) {
        String ruleId = this.ruleContext.getRule().getId();
        String ruleName = this.ruleContext.getRule().getName().toString();
        CtConvertReportManager reportManager = this.resultManager.getCtReporter();
        for (Object billId : myBillIds) {
            reportManager.updateRuleId(billId, ruleId, ruleName);
        }
    }

    private void addSourceFields(List<ICtVariableMode> vars, List<String> selectFldStrings, Map<String, String> fieldAlias) {
        int fieldIndex = fieldAlias.size();
        for (ICtVariableMode var : vars) {
            if (!(var instanceof CtSourceFieldVariable) || fieldAlias.containsKey(var.getVar())) continue;
            CtSourceFieldVariable srcField = (CtSourceFieldVariable)var;
            String fldAlias = "f" + Integer.toString(fieldIndex);
            String selectFldString = srcField.getFullPropName() + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            fieldAlias.put(var.getVar(), fldAlias);
            ++fieldIndex;
        }
    }
}

