/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.sort.CtListSelectedRowComparator;
import kd.bos.service.ctbotp.convert.sort.CtSourceRowComparator;
import kd.bos.service.ctbotp.convert.sort.CtSourceRowSortKey;
import kd.bos.service.ctbotp.convert.sort.ICtSortKeyBuilder;

public class CtSortSourceRowsAction
extends AbstractCtConvertAction {
    public CtSortSourceRowsAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtSortSourceRowsAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        CtLinkEntityMap linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        if (linkEntityMap.getSourceRows().size() <= 1) {
            return;
        }
        if (linkEntityMap.getSourceRows().size() > 10000) {
            return;
        }
        ICtSortKeyBuilder sortKeyBuilder = ICtSortKeyBuilder.create(this.ruleContext, linkEntityMap, this.ruleContext.getSelectedRows().get(0));
        CtSourceRowComparator sortByRowIndex = new CtSourceRowComparator(this.ruleContext, linkEntityMap);
        List<ListSelectedRow> sortListSelectedRows = this.sortListSelectedRows();
        List<CtSourceRowSortKey> sortKeys = this.buildSortKeys(sortListSelectedRows, sortKeyBuilder);
        Map<CtSourceRowSortKey, List<DynamicObject>> mapSourceRows = this.buildSourceRowsMap(linkEntityMap.getSrcFldPropertys(), linkEntityMap.getSourceRows(), sortKeyBuilder);
        ArrayList<DynamicObject> sortSourceRows = new ArrayList<DynamicObject>();
        for (CtSourceRowSortKey ctSourceRowSortKey : sortKeys) {
            List<DynamicObject> list = mapSourceRows.get(ctSourceRowSortKey);
            if (list == null) continue;
            list.sort(sortByRowIndex);
            sortSourceRows.addAll(list);
            mapSourceRows.remove(ctSourceRowSortKey);
        }
        for (Map.Entry entry : mapSourceRows.entrySet()) {
            sortSourceRows.addAll((Collection)entry.getValue());
        }
        linkEntityMap.getSourceRows().clear();
        linkEntityMap.getSourceRows().addAll(sortSourceRows);
    }

    private List<ListSelectedRow> sortListSelectedRows() {
        ArrayList<ListSelectedRow> sortRows = new ArrayList<ListSelectedRow>(this.ruleContext.getSelectedRows().size());
        sortRows.addAll(this.ruleContext.getSelectedRows());
        CtListSelectedRowComparator comparator = new CtListSelectedRowComparator();
        sortRows.sort(comparator);
        return sortRows;
    }

    private List<CtSourceRowSortKey> buildSortKeys(List<ListSelectedRow> selectedRows, ICtSortKeyBuilder sortKeyBuilder) {
        ArrayList<CtSourceRowSortKey> sortKeys = new ArrayList<CtSourceRowSortKey>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            CtSourceRowSortKey sortKey = sortKeyBuilder.buildSortKey(selectedRow);
            sortKeys.add(sortKey);
        }
        return sortKeys;
    }

    private Map<CtSourceRowSortKey, List<DynamicObject>> buildSourceRowsMap(Map<String, DynamicProperty> fldProperties, List<DynamicObject> sourceRows, ICtSortKeyBuilder sortKeyBuilder) {
        HashMap<CtSourceRowSortKey, List<DynamicObject>> mapSourceRows = new HashMap<CtSourceRowSortKey, List<DynamicObject>>();
        for (DynamicObject sourceRow : sourceRows) {
            CtSourceRowSortKey sortKey = sortKeyBuilder.buildSortKey(fldProperties, sourceRow);
            if (!mapSourceRows.containsKey(sortKey)) {
                mapSourceRows.put(sortKey, new ArrayList());
            }
            ((List)mapSourceRows.get(sortKey)).add(sourceRow);
        }
        return mapSourceRows;
    }
}

