/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.runtime.CtPushArgs;
import kd.bos.entity.ctbotp.runtime.CtSaveOperationResult;
import kd.bos.entity.ctbotp.runtime.CtSyncArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.service.ctbotp.utils.CtBotpTenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtSyncAction
extends AbstractCtConvertAction {
    private static final Log log = LogFactory.getLog(CtSyncAction.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-botp";

    public CtSyncAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.ctSync(this.resultManager, this.context.getCtPushArgs());
    }

    private void ctSync(CtConvertResultManager resultManager, CtPushArgs args) {
        CtSyncArgs ctSyncArgs = new CtSyncArgs();
        ctSyncArgs.setSyncType(args.getSyncType());
        ctSyncArgs.setData(resultManager.getTargetCtDataObjects());
        ctSyncArgs.setsEntityKey(args.getSourceEntityNumber());
        ctSyncArgs.settEntityKey(args.getTargetEntityNumber());
        ctSyncArgs.setRuleId(args.getRuleId());
        ctSyncArgs.setRuleVerId(args.getRuleVerId());
        ctSyncArgs.setRuleExtVerId(args.getRuleExtVerId());
        ctSyncArgs.setsAccountId(args.getsAccountId());
        ctSyncArgs.setsTenantCode(args.getsTenantCode());
        ctSyncArgs.settAccountId(args.gettAccountId());
        ctSyncArgs.settTenantCode(args.gettTenantCode());
        ctSyncArgs.setsSyncLogs(resultManager.getsSyncLogs());
        ctSyncArgs.setCheckPushAgain(args.isCheckPushAgain());
        ctSyncArgs.setTargetBillOp(args.getTargetBillOp());
        String result = null;
        String errorMsg = "";
        try {
            result = CtBotpApiUtils.post(CtBotpTenantUtils.getGroupTenantInfo().getTenantId(), CtBotpTenantUtils.getGroupTenantInfo().getAccountId(), CtApiUrlEnum.CTSYNC, SerializationUtils.toJsonString((Object)ctSyncArgs));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (result == null) {
            errorMsg = ResManager.loadKDString((String)"\u8c03\u7528\u4fdd\u5b58\u76ee\u6807\u5355\u63a5\u53e3\u5f02\u5e38\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"CtBatchSyncAction_0", (String)"bos-mservice-ctbotp", (Object[])new Object[0]);
            resultManager.getReporter().setException(Boolean.TRUE.booleanValue());
            resultManager.getReporter().setErrorMsg(errorMsg);
            return;
        }
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        if (openApiResult != null && !openApiResult.get("errorCode").equals("0")) {
            resultManager.getReporter().setException(Boolean.TRUE.booleanValue());
            Object message = openApiResult.get("message");
            errorMsg = StringUtils.isNotBlank(message) ? message.toString() : String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4fdd\u5b58\u76ee\u6807\u5355\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002\u9519\u8bef\u7801\uff1a%s", (String)"CtBatchSyncAction_1", (String)"bos-mservice-ctbotp", (Object[])new Object[0]), openApiResult.get("errorCode"));
            resultManager.getReporter().setErrorMsg(errorMsg);
            return;
        }
        CtSaveOperationResult ctSyncResult = null;
        if (openApiResult != null && openApiResult.get("data") != null) {
            ctSyncResult = (CtSaveOperationResult)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(openApiResult.get("data")), CtSaveOperationResult.class);
        }
        if (ctSyncResult == null) {
            return;
        }
        this.outMessage(ctSyncResult);
        resultManager.getReporter().setException(ctSyncResult.isException());
        resultManager.getReporter().setErrorMsg(ctSyncResult.getMessage());
        resultManager.settBillNoMap(ctSyncResult.gettBillNoMap());
        resultManager.setCtBillLks(ctSyncResult.getCtBillLks());
    }

    private void outMessage(CtSaveOperationResult saveResult) {
        if (saveResult == null || saveResult.getReporter() == null) {
            return;
        }
        if (saveResult.isException()) {
            this.resultManager.getReporter().setException(true);
            this.resultManager.getReporter().setErrorMsg(saveResult.getMessage());
        }
        if (MapUtils.isNotEmpty((Map)saveResult.getReporter().getFailIds())) {
            Map errorMap = saveResult.getReporter().getFailIds();
            for (Map.Entry entry : errorMap.entrySet()) {
                this.resultManager.getReporter().addFailId((Long)entry.getKey(), (String)entry.getValue());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)saveResult.getReporter().getSuccessIds())) {
            ArrayList successPkIds = new ArrayList(saveResult.getReporter().getSuccessIds());
            this.resultManager.getReporter().getSuccessIds().addAll(successPkIds);
        }
    }
}

