/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.batchactions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.sync.SSyncLogService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.apiparam.CtDeleteBillsArgs;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.constants.CtSyncLogConst;
import kd.bos.entity.ctbotp.constants.LkSyncStatusEnum;
import kd.bos.entity.ctbotp.constants.SyncStatusEnum;
import kd.bos.entity.ctbotp.runtime.CtReportManager;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.CtSingleBatchResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.batchactions.CtBatchSingleExecute;
import kd.bos.service.ctbotp.convert.compiler.AbstractCtEntityMap;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.group.CtSourceRowId;
import kd.bos.service.ctbotp.convert.group.CtSourceRowIdAndGroupKey;
import kd.bos.service.ctbotp.convert.group.CtSourceRowIdAndGroupKeyComparator;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroup;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroupKey;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroupKeyBuilder;
import kd.bos.service.ctbotp.convert.report.ICtBuildDetailReport;
import kd.bos.service.ctbotp.convert.sort.CtListSelectedRowComparator;
import kd.bos.service.ctbotp.convert.sort.CtSourceRowSortKey;
import kd.bos.service.ctbotp.convert.sort.ICtSortKeyBuilder;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtBatchPushAction
extends AbstractCtConvertAction {
    private static final Log LOG = LogFactory.getLog(CtBatchPushAction.class);
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private CtLinkEntityMap linkEntityMap = null;
    private EntityType srcLinkEntity = null;
    private CtReportManager reportManager = null;
    private ICtBuildDetailReport reportBuilder = null;
    private Boolean outFormula = null;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"BigDataPushAction", (int)32);
    private int rowCountOneBatch = 2000;
    private int finishBatchCount = 0;
    private int batchCount = 1;
    private BigDecimal percentage;
    private int billPushCount = 20000;

    public CtBatchPushAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.initVar();
        CtSourceRowsGroup billGroupRoot = this.readSourceRowIds();
        if (billGroupRoot.getChildGroupList().isEmpty()) {
            this.setSkipNextAction(true);
            return;
        }
        this.genTargetBillPKIds(billGroupRoot);
        List<CtSourceRowsGroup> batchGroupRoots1 = this.split1(billGroupRoot);
        List<CtSourceRowsGroup> batchGroupRoots2 = this.split2(billGroupRoot);
        this.batchCount = batchGroupRoots1.size() + batchGroupRoots2.size();
        this.percentage = new BigDecimal("90").divide(new BigDecimal(this.batchCount), 4, RoundingMode.HALF_UP);
        this.doBatchExecuteSync(batchGroupRoots1);
        this.doBatchExecuteSync(batchGroupRoots2);
        HashSet<Long> successIds = new HashSet<Long>(this.ruleResultManager.getTargetBillIds());
        successIds.removeAll(this.ruleResultManager.getFailBillIds());
        this.resultManager.getTargetBillIds().addAll(successIds);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(successIds)) {
            this.resultManager.getReporter().addSuccessIds((Collection)successIds.stream().map(a -> (Long)a).collect(Collectors.toList()));
        }
        this.doDelete(this.ruleResultManager.getFailBillIds());
    }

    private void initVar() {
        this.reportManager = this.resultManager.getReporter();
        this.linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        this.srcLinkEntity = (EntityType)this.context.getSourceMainType().getAllEntities().get(this.linkEntityMap.getSourceLinkEntityKey());
        this.reportBuilder = this.ruleContext.getSrcRowReportBuilder(this.srcLinkEntity);
    }

    private CtSourceRowsGroup readSourceRowIds() {
        String entityNumber = this.ruleContext.getContext().getInputArgs().getSourceEntityNumber();
        String selectSQLString = this.linkEntityMap.getSrcRowIdSelectString();
        QFilter[] qFilters = new QFilter[1];
        Set idSets = this.ruleContext.getSelectedRows().stream().map(a -> a.getPrimaryKeyValue()).collect(Collectors.toSet());
        qFilters[0] = new QFilter(this.context.getSourceMainType().getPrimaryKey().getName(), "in", idSets);
        Map<String, String> fldAlias = this.linkEntityMap.getSrcFldAlias();
        int groupKeyCount = this.linkEntityMap.getSourceRowsGroupKeyBuilders().size();
        List<CtSourceRowIdAndGroupKey> srcRowIdAndGroupKeys = new ArrayList<CtSourceRowIdAndGroupKey>();
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectSQLString, qFilters);
        Object object = null;
        try {
            if (!ds.hasNext()) {
                this.buildNoDataErrorReport();
            }
            while (ds.hasNext()) {
                Row row = ds.next();
                CtSourceRowId sourceRowId = CtSourceRowId.create((AbstractCtEntityMap)this.linkEntityMap, row);
                ArrayList<CtSourceRowsGroupKey> groupKeys = new ArrayList<CtSourceRowsGroupKey>(3);
                for (int i = 0; i < groupKeyCount; ++i) {
                    CtSourceRowsGroupKeyBuilder groupKeyBuilder = this.linkEntityMap.getSourceRowsGroupKeyBuilders().get(i);
                    groupKeys.add(groupKeyBuilder.getFldValues(fldAlias, row));
                }
                CtSourceRowIdAndGroupKey srcRowIdAndGroupKey = new CtSourceRowIdAndGroupKey(sourceRowId, groupKeys);
                srcRowIdAndGroupKeys.add(srcRowIdAndGroupKey);
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        srcRowIdAndGroupKeys = this.sort(srcRowIdAndGroupKeys);
        CtSourceRowsGroup billGroupRoot = new CtSourceRowsGroup(null);
        for (CtSourceRowIdAndGroupKey srcRowIdAndGroupKey : srcRowIdAndGroupKeys) {
            billGroupRoot.addSourceRow(srcRowIdAndGroupKey.getSourceRowId(), srcRowIdAndGroupKey.getGroupKeys());
        }
        return billGroupRoot;
    }

    private List<CtSourceRowIdAndGroupKey> sort(List<CtSourceRowIdAndGroupKey> srcRowIdAndGroupKeys) {
        List list;
        if (srcRowIdAndGroupKeys.size() <= 1) {
            return srcRowIdAndGroupKeys;
        }
        if (srcRowIdAndGroupKeys.size() > 10000) {
            return srcRowIdAndGroupKeys;
        }
        ICtSortKeyBuilder sortKeyBuilder = ICtSortKeyBuilder.create(this.ruleContext, this.linkEntityMap, this.ruleContext.getSelectedRows().get(0));
        CtSourceRowIdAndGroupKeyComparator sortByRowIndex = new CtSourceRowIdAndGroupKeyComparator();
        List<ListSelectedRow> sortListSelectedRows = this.sortListSelectedRows();
        ArrayList<CtSourceRowSortKey> sortKeys = new ArrayList<CtSourceRowSortKey>(sortListSelectedRows.size());
        for (ListSelectedRow listSelectedRow : sortListSelectedRows) {
            CtSourceRowSortKey sortKey = sortKeyBuilder.buildSortKey(listSelectedRow);
            sortKeys.add(sortKey);
        }
        HashMap<CtSourceRowSortKey, List> mapSourceRows = new HashMap<CtSourceRowSortKey, List>(sortKeys.size());
        for (CtSourceRowIdAndGroupKey sAndSortKey : srcRowIdAndGroupKeys) {
            CtSourceRowSortKey ctSourceRowSortKey = sortKeyBuilder.buildSortKey(sAndSortKey.getSourceRowId());
            list = mapSourceRows.computeIfAbsent(ctSourceRowSortKey, s -> new ArrayList());
            list.add(sAndSortKey);
        }
        ArrayList<CtSourceRowIdAndGroupKey> arrayList = new ArrayList<CtSourceRowIdAndGroupKey>();
        for (CtSourceRowSortKey ctSourceRowSortKey : sortKeys) {
            list = (List)mapSourceRows.get(ctSourceRowSortKey);
            if (list == null) continue;
            list.sort(sortByRowIndex);
            arrayList.addAll(list);
            mapSourceRows.remove(ctSourceRowSortKey);
        }
        for (Map.Entry entry : mapSourceRows.entrySet()) {
            arrayList.addAll((Collection)entry.getValue());
        }
        return arrayList;
    }

    private List<ListSelectedRow> sortListSelectedRows() {
        ArrayList<ListSelectedRow> sortRows = new ArrayList<ListSelectedRow>(this.ruleContext.getSelectedRows().size());
        sortRows.addAll(this.ruleContext.getSelectedRows());
        CtListSelectedRowComparator comparator = new CtListSelectedRowComparator();
        sortRows.sort(comparator);
        return sortRows;
    }

    private List<CtSourceRowsGroup> split1(CtSourceRowsGroup groupRootAll) {
        ArrayList<CtSourceRowsGroup> batchGroupRoots = new ArrayList<CtSourceRowsGroup>();
        CtSourceRowsGroup currGroupRoot = new CtSourceRowsGroup(null);
        for (CtSourceRowsGroup billGroup : groupRootAll.getChildGroupList()) {
            billGroup.setStartEntrySeq(1);
            int currEntryRowCount = currGroupRoot.getEntryRowCount();
            if (currEntryRowCount != 0 && currEntryRowCount + billGroup.getEntryRowCount() > this.rowCountOneBatch) {
                batchGroupRoots.add(currGroupRoot);
                currGroupRoot = new CtSourceRowsGroup(null);
            }
            CtSourceRowsGroup billFirstGroup = null;
            billFirstGroup = billGroup.getChildGroupList().isEmpty() ? billGroup : billGroup.splitSubList(this.rowCountOneBatch);
            if (billFirstGroup == null) continue;
            billFirstGroup.setFirstBatch(Boolean.TRUE);
            currGroupRoot.getChildGroupList().add(billFirstGroup);
            currGroupRoot.getChildGroupMap().put(billFirstGroup.getGroupKey(), billFirstGroup);
            currGroupRoot.getSourceRowIds().addAll(billFirstGroup.getSourceRowIds());
        }
        if (!currGroupRoot.getChildGroupList().isEmpty()) {
            batchGroupRoots.add(currGroupRoot);
        }
        return batchGroupRoots;
    }

    private List<CtSourceRowsGroup> split2(CtSourceRowsGroup groupRootAll) {
        ArrayList<CtSourceRowsGroup> batchGroupRoots = new ArrayList<CtSourceRowsGroup>();
        CtSourceRowsGroup currGroupRoot = new CtSourceRowsGroup(null);
        for (CtSourceRowsGroup billGroup : groupRootAll.getChildGroupList()) {
            while (billGroup.getStartEntrySeq() <= billGroup.getChildGroupList().size()) {
                CtSourceRowsGroup newBillGroup;
                int currEntryRowCount = currGroupRoot.getEntryRowCount();
                if (currEntryRowCount != 0 && currEntryRowCount + (billGroup.getEntryRowCount() - billGroup.getStartEntrySeq() + 1) > this.rowCountOneBatch) {
                    batchGroupRoots.add(currGroupRoot);
                    currGroupRoot = new CtSourceRowsGroup(null);
                }
                if ((newBillGroup = billGroup.splitSubList(this.rowCountOneBatch)) == null) continue;
                currGroupRoot.getChildGroupList().add(newBillGroup);
                currGroupRoot.getChildGroupMap().put(newBillGroup.getGroupKey(), newBillGroup);
                currGroupRoot.getSourceRowIds().addAll(newBillGroup.getSourceRowIds());
            }
        }
        if (!currGroupRoot.getChildGroupList().isEmpty()) {
            batchGroupRoots.add(currGroupRoot);
        }
        return batchGroupRoots;
    }

    private void genTargetBillPKIds(CtSourceRowsGroup billGroupRoot) {
        if (billGroupRoot.getChildGroupList().isEmpty()) {
            return;
        }
        long[] ids = ID.genLongIds((int)billGroupRoot.getChildGroupList().size());
        HashSet<Long> idSet = new HashSet<Long>(ids.length);
        for (long id : ids) {
            idSet.add(id);
        }
        this.ruleResultManager.addTargetBillIds(idSet);
        int i = 0;
        for (CtSourceRowsGroup billGroup : billGroupRoot.getChildGroupList()) {
            billGroup.setTargetBillId(ids[i]);
            ++i;
        }
    }

    private void doBatchExecuteSync(List<CtSourceRowsGroup> batchGroupRoots) {
        LinkedList<CtBatchSingleExecute> batchExecutes = new LinkedList<CtBatchSingleExecute>();
        for (CtSourceRowsGroup billGroup : batchGroupRoots) {
            CtBatchSingleExecute batchExecute = new CtBatchSingleExecute(RequestContext.get(), this.context, this.ruleContext, this.resultManager, this.ruleResultManager, billGroup);
            batchExecute.setSyncExecute(true);
            batchExecutes.offer(batchExecute);
        }
        while (!batchExecutes.isEmpty()) {
            CtBatchSingleExecute batchExecute = (CtBatchSingleExecute)batchExecutes.poll();
            CtSingleBatchResultManager batchResult = new CtSingleBatchResultManager();
            try {
                batchResult = batchExecute.call();
            }
            catch (InterruptedException ex) {
                batchResult.setException(ex);
                batchResult.getReporter().setException(Boolean.TRUE.booleanValue());
                batchResult.getReporter().setErrorMsg(ex.getMessage());
                LOG.error((Throwable)ex);
            }
            catch (KDBizException ex) {
                batchResult.setException(ex);
                LOG.warn((Throwable)ex);
                batchResult.getReporter().setException(Boolean.TRUE.booleanValue());
                batchResult.getReporter().setErrorMsg(ex.getMessage());
            }
            catch (Throwable ex) {
                batchResult.setException(ex);
                LOG.error(ex);
                batchResult.getReporter().setException(Boolean.TRUE.booleanValue());
                batchResult.getReporter().setErrorMsg(ex.getMessage());
            }
            this.collectExistNextSyncLogs(batchExecute, batchResult);
            this.outBatchExecuteResult(batchResult);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(batchResult.getCtBillLks())) {
                this.resultManager.getCtBillLks().addAll(batchResult.getCtBillLks());
            }
            ++this.finishBatchCount;
            this.updateSSyncLog(batchResult);
        }
        batchGroupRoots.clear();
    }

    private void collectExistNextSyncLogs(CtBatchSingleExecute batchExecute, CtSingleBatchResultManager batchResult) {
        if (batchExecute == null || batchExecute.getCurrGroupRoot() == null || org.apache.commons.collections.CollectionUtils.isEmpty(batchExecute.getCurrGroupRoot().getChildGroupList())) {
            return;
        }
        if (batchResult == null || org.apache.commons.collections.CollectionUtils.isEmpty(batchResult.getsSyncLogs())) {
            return;
        }
        HashSet<String> existNextKeys = new HashSet<String>(16);
        CtSourceRowsGroup ctSourceRowsGroup = batchExecute.getCurrGroupRoot();
        for (CtSourceRowsGroup group : ctSourceRowsGroup.getChildGroupList()) {
            if (group == null || !org.apache.commons.collections.CollectionUtils.isNotEmpty(group.getSourceRowIds())) continue;
            Long tBillId = (Long)group.getTargetBillId();
            for (CtSourceRowId ctSourceRowId : group.getSourceRowIds()) {
                Long sBillId = (Long)ctSourceRowId.getBillId();
                String key = String.valueOf(sBillId) + tBillId;
                if (!group.isExistNextBatch()) {
                    this.ruleResultManager.getExistNextSyncLogs().remove(key);
                    continue;
                }
                existNextKeys.add(key);
            }
        }
        List<SyncLog> syncLogs = batchResult.getsSyncLogs();
        for (SyncLog syncLog : syncLogs) {
            String key = String.valueOf(syncLog.getSbillId()) + syncLog.getTbillId();
            if (!existNextKeys.contains(key)) continue;
            this.ruleResultManager.getExistNextSyncLogs().put(key, syncLog);
        }
    }

    private void updateSSyncLog(CtSingleBatchResultManager batchResult) {
        String errorMsg = null;
        if (batchResult.getReporter().isException()) {
            errorMsg = batchResult.getReporter().getErrorMsg();
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)CtSyncLogConst.SYNC_FORMID_S);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        List<SyncLog> syncLogs = batchResult.getsSyncLogs();
        if (CollectionUtils.isEmpty(batchResult.getsSyncLogs())) {
            syncLogs = batchResult.getsSyncLogs();
        }
        for (SyncLog sSyncLog : syncLogs) {
            DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
            Long tbillId = sSyncLog.getTbillId();
            obj.set("id", (Object)sSyncLog.getId());
            obj.set("rulename", (Object)sSyncLog.getRulename());
            Long sbillId = sSyncLog.getSbillId();
            obj.set("updatetime", (Object)new Date());
            if (MapUtils.isNotEmpty(batchResult.gettBillNoMap())) {
                obj.set("tbillno", (Object)batchResult.gettBillNoMap().get(tbillId));
            }
            if (!batchResult.getReporter().isException()) {
                Set successIds = batchResult.getReporter().getSuccessIds();
                Map errorIds = batchResult.getReporter().getFailIds();
                if (successIds.contains(tbillId)) {
                    obj.set("status", (Object)SyncStatusEnum.S.getStatus());
                    obj.set("lksyncstatus", (Object)LkSyncStatusEnum.S.getStatus());
                    dynamicObjects.add(obj);
                    continue;
                }
                obj.set("desc_tag", errorIds.get(sbillId));
                obj.set("status", (Object)SyncStatusEnum.F.getStatus());
                obj.set("lksyncstatus", (Object)LkSyncStatusEnum.F.getStatus());
                dynamicObjects.add(obj);
                continue;
            }
            obj.set("desc_tag", (Object)errorMsg);
            obj.set("status", (Object)SyncStatusEnum.F.getStatus());
            obj.set("lksyncstatus", (Object)LkSyncStatusEnum.F.getStatus());
            dynamicObjects.add(obj);
        }
        if (CollectionUtils.isNotEmpty(dynamicObjects)) {
            SSyncLogService.create().updateNoTx(dynamicObjects);
        }
    }

    private void doBatchExecuteAnsy(List<CtSourceRowsGroup> batchGroupRoots) {
        ArrayList<Future> results = new ArrayList<Future>(batchGroupRoots.size());
        for (CtSourceRowsGroup billGroup : batchGroupRoots) {
            CtBatchSingleExecute batchExecute = new CtBatchSingleExecute(RequestContext.get(), this.context, this.ruleContext, this.resultManager, this.ruleResultManager, billGroup);
            Future ret = threadPool.submit((Callable)batchExecute);
            results.add(ret);
        }
        for (Future result : results) {
            CtSingleBatchResultManager batchResult = null;
            try {
                batchResult = (CtSingleBatchResultManager)result.get();
            }
            catch (InterruptedException ex) {
                batchResult = new CtSingleBatchResultManager();
                batchResult.setException(ex);
                LOG.error((Throwable)ex);
            }
            catch (KDBizException ex) {
                batchResult = new CtSingleBatchResultManager();
                batchResult.setException(ex);
                LOG.warn((Throwable)ex);
            }
            catch (Throwable ex) {
                batchResult = new CtSingleBatchResultManager();
                batchResult.setException(ex);
                LOG.error(ex);
            }
            this.outBatchExecuteResult(batchResult);
            ++this.finishBatchCount;
            String processTip = String.format(ResManager.loadKDString((String)"\u5206\u6279\u751f\u6210\u76ee\u6807\u5355\uff0c\u5df2\u5b8c\u6210\u7b2c %1$s/%2$s \u6279", (String)"BigDataPushAction_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.finishBatchCount, this.batchCount);
            int n = 5 + this.percentage.multiply(new BigDecimal(this.finishBatchCount - 1)).intValue();
        }
        batchGroupRoots.clear();
        batchGroupRoots = null;
    }

    private void outBatchExecuteResult(CtSingleBatchResultManager batchResult) {
        HashSet<Long> failIds = new HashSet<Long>(0);
        for (CtSourceRowsGroup billGroup : batchResult.getSourceRowsGroupRoot().getChildGroupList()) {
            if (batchResult.getSuccessIds().contains(billGroup.getTargetBillId())) continue;
            for (CtSourceRowId sourceRowId : billGroup.getSourceRowIds()) {
                Long billId = (Long)sourceRowId.getBillId();
                failIds.add(billId);
                String failMessage = batchResult.getFailIds().get(billId);
                if (failMessage == null) {
                    if (batchResult.getException() != null) {
                        failMessage = batchResult.getException().getMessage();
                    }
                    if (StringUtils.isBlank((CharSequence)failMessage)) {
                        failMessage = ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u8f6c\u6362\u5931\u8d25", (String)"BigDataPushAction_4", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
                    }
                }
                if (!MapUtils.isNotEmpty(batchResult.getFailIds())) continue;
                this.resultManager.getReporter().getFailIds().put(billId, failMessage);
            }
        }
        this.ruleResultManager.addFailBillIds(failIds);
        batchResult.getSourceRowsGroupRoot().clearMemory();
        batchResult.setSourceRowsGroupRoot(null);
    }

    private void doDelete(Set<Long> failIds) {
        if (failIds.isEmpty()) {
            return;
        }
        ArrayList ids = new ArrayList(failIds.size());
        CtDeleteBillsArgs ctDeleteBillsArgs = new CtDeleteBillsArgs();
        ctDeleteBillsArgs.setEntityKey(this.context.getTargetEntityNumber());
        ctDeleteBillsArgs.settBillIds(ids);
        String result = CtBotpApiUtils.post(this.context.getCtPushArgs().gettTenantCode(), this.context.getCtPushArgs().gettAccountId(), CtApiUrlEnum.DELETEBILLS, SerializationUtils.toJsonString((Object)ctDeleteBillsArgs));
    }

    private boolean isOutFormula() {
        if (this.outFormula == null) {
            String paramValue = (String)this.getContext().getInputArgs().getCustomParams().get("botp_outformula");
            this.outFormula = paramValue == null ? Boolean.FALSE : Boolean.valueOf(paramValue);
        }
        return this.outFormula;
    }

    private void buildNoDataErrorReport() {
        String failMessage = null;
        failMessage = this.srcLinkEntity instanceof EntryType && ((EntryType)this.srcLinkEntity).isMustIuput() ? String.format(ResManager.loadKDString((String)"\u6839\u636e\u4f20\u5165\u7684\u6e90\u5355\u5185\u7801\uff0c\u6ca1\u6709\u53d6\u5230\u6e90\u5355\u6570\u636e\uff0c\u53ef\u80fd\u662f%s\u6ca1\u6709\u8bb0\u5f55", (String)"BigDataPushAction_5", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.srcLinkEntity.getDisplayName().toString()) : (this.isOutFormula() ? String.format(ResManager.loadKDString((String)"\u6839\u636e\u4f20\u5165\u7684\u6e90\u5355\u5185\u7801\uff0c\u6ca1\u6709\u53d6\u5230\u6e90\u5355\u6570\u636e: %s", (String)"BigDataPushAction_6", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.linkEntityMap.getQFilters()) : ResManager.loadKDString((String)"\u6839\u636e\u4f20\u5165\u7684\u6e90\u5355\u5185\u7801\uff0c\u6ca1\u6709\u53d6\u5230\u6e90\u5355\u6570\u636e", (String)"BigDataPushAction_7", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
    }

    private void buildValidateErrorReport(Map<String, String> fldAlias, Row row, CtSourceRowId sourceRowId) {
    }
}

