/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.batchrequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ctbotp.CtDataEntityFieldValue;
import kd.bos.entity.ctbotp.CtDataFlexValue;
import kd.bos.entity.ctbotp.CtFlexItem;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.batchrequest.CtFlexFieldSetValueRequest;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CtBatchFlexFieldSetValue {
    private BillEntityType sourceMainType;
    private List<CtFlexFieldSetValueRequest> requests = new ArrayList<CtFlexFieldSetValueRequest>();

    public List<CtFlexFieldSetValueRequest> getRequests() {
        return this.requests;
    }

    public CtBatchFlexFieldSetValue(CtSingleRuleContext ruleContext) {
        this.sourceMainType = ruleContext.getContext().getSourceMainType();
    }

    public void batchDo() {
        for (CtFlexFieldSetValueRequest request : this.requests) {
            Map<String, CtFlexItem> flexItemMap;
            String flexItemMapJson;
            DynamicObject flexAuxProValueCol;
            if (request.getFlexId() == null || "0".equals(String.valueOf(request.getFlexId()))) continue;
            int flexTypeId = request.getSrcFlexProp().getFlexTypeId();
            boolean assistantValueType = "2".equals(String.valueOf(flexTypeId)) || "21".equals(String.valueOf(flexTypeId));
            boolean baseValueType = "1".equals(String.valueOf(flexTypeId));
            if (!assistantValueType && !baseValueType) continue;
            if (baseValueType) {
                flexAuxProValueCol = BusinessDataServiceHelper.loadSingleFromCache((Object)request.getFlexId(), (String)"bd_flexauxprop", (String)"value");
                flexItemMapJson = flexAuxProValueCol.getString("value");
                flexItemMap = this.parseFlexItem(flexItemMapJson);
            } else {
                flexAuxProValueCol = BusinessDataServiceHelper.loadSingleFromCache((Object)request.getFlexId(), (String)"gl_assist", (String)"assvals");
                flexItemMapJson = flexAuxProValueCol.getString("assvals");
                flexItemMap = this.parseFlexItem(flexItemMapJson);
            }
            CtDataEntityFieldValue ctDataEntityFieldValue = new CtDataEntityFieldValue();
            ctDataEntityFieldValue.setFlexValue(new CtDataFlexValue((Long)request.getFlexId(), flexItemMap));
            request.setNewValue(ctDataEntityFieldValue);
            request.setValue();
        }
    }

    private Map<String, CtFlexItem> parseFlexItem(String flexItemMapJson) {
        Map flexItemMap = (Map)SerializationUtils.fromJsonString((String)flexItemMapJson, Map.class);
        LinkedHashMap<String, CtFlexItem> ctFlexItemMap = new LinkedHashMap<String, CtFlexItem>(flexItemMap.size());
        for (Map.Entry flexItem : flexItemMap.entrySet()) {
            String flexItemId = (String)flexItem.getKey();
            Object flexItemValue = flexItem.getValue();
            QFilter filter = new QFilter("flexfield", "=", (Object)flexItemId);
            DynamicObject flexPropertyValue = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_flex_property", (QFilter[])filter.toArray());
            int flexItemValueType = flexPropertyValue.getInt("valuetype");
            String flexItemEntityNumber = null;
            String flexItemPkProp = null;
            String flexItemNumberVal = null;
            String flexItemNumberProp = null;
            if (!"3".equals(String.valueOf(flexItemValueType))) {
                flexItemEntityNumber = flexPropertyValue.getString("valuesource_id");
                DynamicObject flexItemEntity = BusinessDataServiceHelper.loadSingle(flexItemValue, (String)flexItemEntityNumber);
                BasedataEntityType basedataEntityType = (BasedataEntityType)flexItemEntity.getDataEntityType();
                flexItemNumberProp = basedataEntityType.getNumberProperty();
                flexItemPkProp = basedataEntityType.getPrimaryKey().getName();
                flexItemNumberVal = flexItemEntity.getString(flexItemNumberProp);
            }
            CtFlexItem ctFlexItem = new CtFlexItem(flexItemId, flexItemEntityNumber, flexItemValue, flexItemPkProp, flexItemNumberVal, flexItemNumberProp, flexItemValueType);
            String ctFlexItemMapKey = "3".equals(String.valueOf(flexItemValueType)) ? flexPropertyValue.getString("name") : flexItemEntityNumber;
            ctFlexItemMap.put(ctFlexItemMapKey, ctFlexItem);
        }
        return ctFlexItemMap;
    }

    private Map<String, Map<Object, DynamicObject>> loadSourceEntityRows() {
        HashSet<String> allPropNames = new HashSet<String>(4);
        HashMap<String, HashSet<String>> srcFlexPropNames = new HashMap<String, HashSet<String>>(4);
        HashMap<String, HashSet<Object>> srcRowIds = new HashMap<String, HashSet<Object>>(4);
        for (CtFlexFieldSetValueRequest request : this.requests) {
            String entityKey = request.getSrcFlexProp().getParent().getName();
            allPropNames.add(request.getSrcFlexProp().getName());
            allPropNames.add(request.getBasedataProp().getName());
            HashSet<String> propNames = (HashSet<String>)srcFlexPropNames.get(entityKey);
            if (propNames == null) {
                propNames = new HashSet<String>(4);
                srcFlexPropNames.put(entityKey, propNames);
            }
            propNames.add(request.getSrcFlexProp().getName());
            HashSet<Object> rowIds = (HashSet<Object>)srcRowIds.get(entityKey);
            if (rowIds == null) {
                rowIds = new HashSet<Object>(this.requests.size());
                srcRowIds.put(entityKey, rowIds);
            }
            rowIds.addAll(request.getSrcRowIds());
        }
        HashMap<String, Map<Object, DynamicObject>> srcAllDataEntities = new HashMap<String, Map<Object, DynamicObject>>(4);
        BillEntityType subMainType = (BillEntityType)EntityMetadataCache.getSubDataEntityType((String)this.sourceMainType.getName(), allPropNames);
        Map<String, EntityType> localEntityTypes = this.buildSingleSubMainType(subMainType, allPropNames);
        for (Map.Entry entry : srcFlexPropNames.entrySet()) {
            Object[] rowObjs;
            EntityType entityType = localEntityTypes.get(entry.getKey());
            Set rowIds = (Set)srcRowIds.get(entry.getKey());
            if (rowIds == null || entityType == null) continue;
            HashMap<Object, DynamicObject> srcRows = new HashMap<Object, DynamicObject>(rowIds.size());
            srcAllDataEntities.put((String)entry.getKey(), (Map<Object, DynamicObject>)srcRows);
            for (Object rowObj : rowObjs = BusinessDataReader.load((Object[])rowIds.toArray(), (IDataEntityType)entityType)) {
                Object rowId = ((DynamicObject)rowObj).getPkValue();
                srcRows.put(rowId, (DynamicObject)rowObj);
            }
        }
        return srcAllDataEntities;
    }

    private Map<String, EntityType> buildSingleSubMainType(BillEntityType subMainType, Set<String> allPropNames) {
        BillEntityType localSubMainType = null;
        try {
            localSubMainType = (BillEntityType)subMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("", exp.getMessage()), new Object[0]);
        }
        HashMap<String, EntityType> entityTypes = new HashMap<String, EntityType>(4);
        for (EntityType entityType : localSubMainType.getAllEntities().values()) {
            HashSet<String> propNames = new HashSet<String>(entityType.getProperties().size());
            ArrayList<IDataEntityProperty> subEntryProps = new ArrayList<IDataEntityProperty>(1);
            for (IDataEntityProperty prop : entityType.getProperties()) {
                if (prop instanceof EntryProp) {
                    subEntryProps.add(prop);
                    continue;
                }
                if (!allPropNames.contains(prop.getName())) continue;
                propNames.add(prop.getName());
            }
            if (propNames.isEmpty()) continue;
            if (!subEntryProps.isEmpty()) {
                EntityType subEntityType = entityType.getSubEntityType(propNames);
                entityTypes.put(entityType.getName(), subEntityType);
                continue;
            }
            entityTypes.put(entityType.getName(), entityType);
        }
        return entityTypes;
    }
}

