/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ctbotp.BaseDataPropInfo;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetConstValue;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetSourceFieldValue;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroup;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroupKeyBuilder;
import kd.bos.service.ctbotp.convert.mapping.ICtMappingField;
import kd.bos.service.ctbotp.convert.query.CtBotpQueryParameter;
import kd.bos.service.ctbotp.convert.var.CtSourceFieldVariable;
import kd.bos.service.ctbotp.convert.var.CtUnknowVariable;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;

public abstract class AbstractCtEntityMap {
    protected String sourceEntryKey;
    protected String sourceSubEntryKey;
    protected Map<EntityType, List<CtSourceFieldVariable>> sourceFields = new HashMap<EntityType, List<CtSourceFieldVariable>>();
    protected String sourceEntityKeys;
    private ICtGetValueMode srcBillIdReader;
    private ICtGetValueMode srcEntryIdReader;
    private ICtGetValueMode srcEntrySeqReader;
    private ICtGetValueMode srcSubEntryIdReader;
    private ICtGetValueMode srcSubEntrySeqReader;
    protected String targetEntryKey;
    protected String targetSubEntryKey;
    protected Map<String, List<ICtMappingField>> targetFields = new HashMap<String, List<ICtMappingField>>();
    protected String targetEntityKeys;
    protected String srcSelectString;
    protected Map<String, String> srcFldAlias = new HashMap<String, String>();
    protected Map<String, BaseDataPropInfo> baseDataPropInfoMap = new HashMap<String, BaseDataPropInfo>();
    protected List<QFilter> qFilters = new ArrayList<QFilter>();
    protected Map<String, DynamicProperty> srcFldPropertys = new HashMap<String, DynamicProperty>();
    protected CtBotpQueryParameter queryParameter;
    protected List<DynamicObject> sourceRows = new ArrayList<DynamicObject>();
    protected List<CtSourceRowsGroupKeyBuilder> sourceRowsGroupKeyBuilders = new ArrayList<CtSourceRowsGroupKeyBuilder>();
    protected CtSourceRowsGroup sourceRowsGroup;

    public String getSourceEntryKey() {
        return this.sourceEntryKey;
    }

    public void setSourceEntryKey(String sourceEntryKey) {
        this.sourceEntryKey = sourceEntryKey;
    }

    public String getSourceEntryPKFullName() {
        return this.sourceEntryKey + ".id";
    }

    public String getSourceEntrySeqFullName() {
        return this.sourceEntryKey + ".seq";
    }

    public String getSourceSubEntryKey() {
        return this.sourceSubEntryKey;
    }

    public void setSourceSubEntryKey(String sourceSubEntryKey) {
        this.sourceSubEntryKey = sourceSubEntryKey;
    }

    public String getSourceSubEntryPKFullName() {
        return this.sourceEntryKey + "." + this.sourceSubEntryKey + ".id";
    }

    public String getSourceSubEntrySeqFullName() {
        return this.sourceEntryKey + "." + this.sourceSubEntryKey + ".seq";
    }

    public Map<EntityType, List<CtSourceFieldVariable>> getSourceFields() {
        return this.sourceFields;
    }

    public ICtGetValueMode getSrcBillIdReader() {
        return this.srcBillIdReader;
    }

    public ICtGetValueMode getSrcEntryIdReader() {
        return this.srcEntryIdReader;
    }

    public ICtGetValueMode getSrcEntrySeqReader() {
        return this.srcEntrySeqReader;
    }

    public ICtGetValueMode getSrcSubEntryIdReader() {
        return this.srcSubEntryIdReader;
    }

    public ICtGetValueMode getSrcSubEntrySeqReader() {
        return this.srcSubEntrySeqReader;
    }

    public Map<String, BaseDataPropInfo> getBaseDataPropInfoMap() {
        return this.baseDataPropInfoMap;
    }

    public void setBaseDataPropInfoMap(Map<String, BaseDataPropInfo> baseDataPropInfoMap) {
        this.baseDataPropInfoMap = baseDataPropInfoMap;
    }

    public Map<String, CtSourceFieldVariable> getAllSourceFields() {
        HashMap<String, CtSourceFieldVariable> fields = new HashMap<String, CtSourceFieldVariable>();
        for (Map.Entry<EntityType, List<CtSourceFieldVariable>> entityItem : this.sourceFields.entrySet()) {
            for (CtSourceFieldVariable srcFldVar : entityItem.getValue()) {
                String var = srcFldVar.getVar();
                if (fields.containsKey(var)) continue;
                fields.put(var, srcFldVar);
            }
        }
        return fields;
    }

    public String getTargetEntryKey() {
        return this.targetEntryKey;
    }

    public void setTargetEntryKey(String targetEntryKey) {
        this.targetEntryKey = targetEntryKey;
    }

    public String getTargetSubEntryKey() {
        return this.targetSubEntryKey;
    }

    public void setTargetSubEntryKey(String targetSubEntryKey) {
        this.targetSubEntryKey = targetSubEntryKey;
    }

    public Map<String, List<ICtMappingField>> getTargetFields() {
        return this.targetFields;
    }

    public String getSrcSelectString() {
        return this.srcSelectString;
    }

    public void setSrcSelectString(String srcSelectString) {
        this.srcSelectString = srcSelectString;
    }

    public List<QFilter> getQFilters() {
        return this.qFilters;
    }

    public Map<String, String> getSrcFldAlias() {
        return this.srcFldAlias;
    }

    public synchronized Map<String, DynamicProperty> getSrcFldPropertys() {
        return this.srcFldPropertys;
    }

    public synchronized void setSrcFldPropertys(Map<String, DynamicProperty> map) {
        if (this.srcFldPropertys.isEmpty()) {
            this.srcFldPropertys.putAll(map);
        }
    }

    public synchronized CtBotpQueryParameter getQueryParameter() {
        return this.queryParameter;
    }

    public List<DynamicObject> getSourceRows() {
        return this.sourceRows;
    }

    public CtSourceRowsGroup getSourceRowsGroup() {
        return this.sourceRowsGroup;
    }

    public void setSourceRowsGroup(CtSourceRowsGroup sourceRowsGroup) {
        this.sourceRowsGroup = sourceRowsGroup;
    }

    public List<CtSourceRowsGroupKeyBuilder> getSourceRowsGroupKeyBuilders() {
        return this.sourceRowsGroupKeyBuilders;
    }

    public void addMappingField(ICtMappingField mappingField) {
        if (!this.targetFields.containsKey(mappingField.getJoinTargetEntityKeys())) {
            this.targetFields.put(mappingField.getJoinTargetEntityKeys(), new ArrayList());
        }
        this.targetFields.get(mappingField.getJoinTargetEntityKeys()).add(mappingField);
        for (CtSourceFieldVariable srcFieldVar : mappingField.getSrcFieldVars()) {
            this.addSourceField(srcFieldVar);
        }
    }

    public void addMappingFields(List<ICtMappingField> mappingFields) {
        for (ICtMappingField mappingField : mappingFields) {
            this.addMappingField(mappingField);
        }
    }

    public void addSourceField(CtSourceFieldVariable srcFldVar) {
        if (srcFldVar == null) {
            return;
        }
        EntityType srcEntityType = (EntityType)srcFldVar.getSourceField().getParent();
        if (!this.sourceFields.containsKey(srcEntityType)) {
            this.sourceFields.put(srcEntityType, new ArrayList());
        }
        this.sourceFields.get(srcEntityType).add(srcFldVar);
        this.sourceEntityKeys = null;
    }

    public void addSourceRowsGroupKeyBuilders(CtSourceRowsGroupKeyBuilder groupKeyBuilder) {
        this.sourceRowsGroupKeyBuilders.add(groupKeyBuilder);
        for (ICtVariableMode var : groupKeyBuilder.getVars()) {
            if (var instanceof CtUnknowVariable) {
                String srcEntityNumber = groupKeyBuilder.getRuleContext() == null ? "" : groupKeyBuilder.getRuleContext().getRule().getSourceEntityNumber();
                KDBizException e = new KDBizException(BosErrorCode.fieldNotExist, new Object[]{srcEntityNumber, var.getVar()});
                throw e;
            }
            this.addSourceField((CtSourceFieldVariable)var);
        }
    }

    public String getJoinSourceEntityKeys() {
        if (StringUtils.isBlank((CharSequence)this.sourceEntityKeys)) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("billhead").append('|');
            if (StringUtils.isNotBlank((CharSequence)this.sourceEntryKey)) {
                sBuilder.append(this.sourceEntryKey).append('|');
                if (StringUtils.isNotBlank((CharSequence)this.sourceSubEntryKey)) {
                    sBuilder.append(this.sourceSubEntryKey).append('|');
                }
            }
            this.sourceEntityKeys = sBuilder.toString();
        }
        return this.sourceEntityKeys;
    }

    public String getJoinTargetEntityKeys() {
        if (StringUtils.isBlank((CharSequence)this.targetEntityKeys)) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("billhead").append('|');
            if (StringUtils.isNotBlank((CharSequence)this.targetEntryKey)) {
                sBuilder.append(this.targetEntryKey).append('|');
                if (StringUtils.isNotBlank((CharSequence)this.targetSubEntryKey)) {
                    sBuilder.append(this.targetSubEntryKey).append('|');
                }
            }
            this.targetEntityKeys = sBuilder.toString();
        }
        return this.targetEntityKeys;
    }

    public boolean includeOther(String a, String b) {
        return StringUtils.isBlank((CharSequence)a) || StringUtils.isBlank((CharSequence)b) || a.startsWith(b) || b.startsWith(a);
    }

    public void compileSelectString(CtSingleRuleContext ruleContext) {
        String alias;
        this.compileSourceRowIdReader(ruleContext);
        ArrayList<String> selectFldStrings = new ArrayList<String>(10);
        int fldIndex = 0;
        BillEntityType srcMainType = ruleContext.getContext().getSourceMainType();
        this.queryParameter = new CtBotpQueryParameter(srcMainType.getName());
        String pkPropName = srcMainType.getPrimaryKey().getName();
        this.srcFldAlias.put(pkPropName, pkPropName);
        selectFldStrings.add(pkPropName);
        fldIndex = this.queryParameter.addSelectField(this.baseDataPropInfoMap, this.srcFldAlias, (IDataEntityProperty)srcMainType.getPrimaryKey(), null, pkPropName, fldIndex);
        ++fldIndex;
        if (StringUtils.isNotBlank((CharSequence)srcMainType.getBillNo()) && StringUtils.isNotBlank((CharSequence)((TextProp)srcMainType.findProperty(srcMainType.getBillNo())).getAlias())) {
            this.srcFldAlias.put(srcMainType.getBillNo(), srcMainType.getBillNo());
            selectFldStrings.add(srcMainType.getBillNo());
            fldIndex = this.queryParameter.addSelectField(this.baseDataPropInfoMap, this.srcFldAlias, (IDataEntityProperty)srcMainType.getProperty(srcMainType.getBillNo()), null, srcMainType.getBillNo(), fldIndex);
            ++fldIndex;
        }
        if (StringUtils.isNotBlank((CharSequence)this.sourceEntryKey)) {
            String entryPKPropName = this.getSourceEntryPKFullName();
            alias = "f" + Integer.toString(fldIndex);
            this.srcFldAlias.put(entryPKPropName, alias);
            selectFldStrings.add(entryPKPropName + " " + alias);
            fldIndex = this.queryParameter.addSelectField(this.baseDataPropInfoMap, this.srcFldAlias, srcMainType.findProperty(entryPKPropName), null, alias, fldIndex);
            ++fldIndex;
            String entrySeqPropName = this.getSourceEntrySeqFullName();
            if (srcMainType.findProperty(entrySeqPropName) != null) {
                String seqAlias = "f" + Integer.toString(fldIndex);
                this.srcFldAlias.put(entrySeqPropName, seqAlias);
                selectFldStrings.add(entrySeqPropName + " " + seqAlias);
                fldIndex = this.queryParameter.addSelectField(this.baseDataPropInfoMap, this.srcFldAlias, srcMainType.findProperty(entrySeqPropName), null, seqAlias, fldIndex);
                ++fldIndex;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.sourceSubEntryKey)) {
            String subEntryPKPropName = this.getSourceSubEntryPKFullName();
            alias = "f" + Integer.toString(fldIndex);
            String subEntryIdProp = this.sourceSubEntryKey + ".id";
            this.srcFldAlias.put(subEntryPKPropName, alias);
            this.srcFldAlias.put(subEntryIdProp, alias);
            selectFldStrings.add(subEntryPKPropName + " " + alias);
            fldIndex = this.queryParameter.addSelectField(this.baseDataPropInfoMap, this.srcFldAlias, srcMainType.findProperty(subEntryIdProp), null, alias, fldIndex);
            ++fldIndex;
            String subEntrySeqPropName = this.sourceSubEntryKey + ".seq";
            String subEntrySeqProp = this.sourceSubEntryKey + ".seq";
            if (srcMainType.findProperty(subEntrySeqPropName) != null) {
                subEntrySeqPropName = this.getSourceSubEntrySeqFullName();
                String seqAlias = "f" + Integer.toString(fldIndex);
                this.srcFldAlias.put(subEntrySeqPropName, seqAlias);
                this.srcFldAlias.put(this.sourceSubEntryKey + ".seq", seqAlias);
                selectFldStrings.add(subEntrySeqPropName + " " + seqAlias);
                fldIndex = this.queryParameter.addSelectField(this.baseDataPropInfoMap, this.srcFldAlias, srcMainType.findProperty(subEntrySeqProp), null, seqAlias, fldIndex);
                ++fldIndex;
            }
        }
        Map<String, CtSourceFieldVariable> srcFields = this.getAllSourceFields();
        for (CtSourceFieldVariable srcField : srcFields.values()) {
            String var = srcField.getVar();
            if (this.srcFldAlias.containsKey(var)) continue;
            String fldAlias = "f" + fldIndex;
            String selectFldString = srcField.getFullPropName() + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            this.srcFldAlias.put(var, fldAlias);
            fldIndex = this.queryParameter.addSelectField(this.baseDataPropInfoMap, this.srcFldAlias, srcField.getSourceField(), StringUtils.join((Object[])srcField.getRefProps(), (String)"."), fldAlias, fldIndex);
            ++fldIndex;
        }
        ruleContext.getBasedataVersionManager().prepareBasedataPropForVersion(srcMainType, srcFields, this.srcFldAlias, selectFldStrings);
        this.srcSelectString = StringUtils.join((Object[])selectFldStrings.toArray(new Object[selectFldStrings.size()]), (String)",");
    }

    private void compileSourceRowIdReader(CtSingleRuleContext ruleContext) {
        BillEntityType srcMainType = ruleContext.getContext().getSourceMainType();
        this.srcBillIdReader = new CtGetSourceFieldValue(ruleContext, "id");
        if (StringUtils.isBlank((CharSequence)this.sourceEntryKey)) {
            this.srcEntryIdReader = new CtGetConstValue(null);
            this.srcEntrySeqReader = new CtGetConstValue(0);
        } else {
            this.srcEntryIdReader = new CtGetSourceFieldValue(ruleContext, this.getSourceEntryPKFullName());
            String entrySeqPropName = this.getSourceEntrySeqFullName();
            this.srcEntrySeqReader = srcMainType.findProperty(entrySeqPropName) == null ? new CtGetConstValue(0) : new CtGetSourceFieldValue(ruleContext, this.getSourceEntrySeqFullName());
        }
        if (StringUtils.isBlank((CharSequence)this.sourceSubEntryKey)) {
            this.srcSubEntryIdReader = new CtGetConstValue(null);
            this.srcSubEntrySeqReader = new CtGetConstValue(0);
        } else {
            this.srcSubEntryIdReader = new CtGetSourceFieldValue(ruleContext, this.getSourceSubEntryPKFullName());
            String subEntrySeqPropName = this.sourceSubEntryKey + ".seq";
            this.srcSubEntrySeqReader = srcMainType.findProperty(subEntrySeqPropName) == null ? new CtGetConstValue(0) : new CtGetSourceFieldValue(ruleContext, this.getSourceSubEntrySeqFullName());
        }
    }
}

