/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ctbotp.constants.CtValueTypeEnum;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.compiler.AbstractCtEntityMap;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.group.CtSourceRowId;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroup;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroupKeyBuilder;
import kd.bos.service.ctbotp.convert.mapping.CtMappingCtrlField;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSAccountId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSBillId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSEntityKey;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSLinkEntityKey;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSLinkTableId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSTableId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSTenantCode;
import kd.bos.service.ctbotp.convert.mapping.CtMappingTAccountId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingTEntityKey;
import kd.bos.service.ctbotp.convert.mapping.CtMappingTLinkEntityKey;
import kd.bos.service.ctbotp.convert.mapping.CtMappingTTenantCode;
import kd.bos.service.ctbotp.convert.mapping.ICtMappingField;
import kd.bos.service.ctbotp.convert.mapping.ICtMappingLinkField;
import kd.bos.service.ctbotp.convert.var.CtSourceFieldVariable;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;

public class CtLinkEntityMap
extends AbstractCtEntityMap {
    private String sourceLinkEntityKey;
    private String targetLinkEntityKey;
    private ICtGetValueMode srcMainOrgReader;
    private ICtGetValueMode srcBillTypeReader;
    private ICtMappingField mappingMainOrg;
    private ICtMappingField mappingBillType;
    private LinkEntryProp linkEntryProp;
    private CtMappingSTenantCode mappingSTenantCode;
    private CtMappingTTenantCode mappingTTenantCode;
    private CtMappingSAccountId mappingSAccountId;
    private CtMappingTAccountId mappingTAccountId;
    private CtMappingSTableId mappingSTableId;
    private CtMappingSBillId mappingSBillId;
    private CtMappingSEntityKey mappingSEntityKey;
    private CtMappingTEntityKey mappingTEntityKey;
    private CtMappingSLinkEntityKey mappingSLinkEntityKey;
    private CtMappingSLinkTableId mappingSLinkTableId;
    private CtMappingTLinkEntityKey mappingTLinkEntityKey;
    private CtMappingSId mappingSId;
    List<CtMappingCtrlField> mappingCtrlFields = new ArrayList<CtMappingCtrlField>();
    private String srcRowIdSelectString;

    public String getSourceLinkEntityKey() {
        return this.sourceLinkEntityKey;
    }

    public void setSourceLinkEntityKey(String sourceLinkEntityKey) {
        this.sourceLinkEntityKey = sourceLinkEntityKey;
    }

    public String getTargetLinkEntityKey() {
        return this.targetLinkEntityKey;
    }

    public void setTargetLinkEntityKey(String targetLinkEntityKey) {
        this.targetLinkEntityKey = targetLinkEntityKey;
    }

    public ICtGetValueMode getSrcMainOrgReader() {
        return this.srcMainOrgReader;
    }

    public void setSrcMainOrgReader(ICtGetValueMode srcMainOrgReader) {
        this.srcMainOrgReader = srcMainOrgReader;
    }

    public CtMappingSEntityKey getMappingSEntityKey() {
        return this.mappingSEntityKey;
    }

    public void setMappingSEntityKey(CtMappingSEntityKey mappingSEntityKey) {
        this.mappingSEntityKey = mappingSEntityKey;
    }

    public CtMappingTEntityKey getMappingTEntityKey() {
        return this.mappingTEntityKey;
    }

    public void setMappingTEntityKey(CtMappingTEntityKey mappingTEntityKey) {
        this.mappingTEntityKey = mappingTEntityKey;
    }

    public ICtGetValueMode getSrcBillTypeReader() {
        return this.srcBillTypeReader;
    }

    public void setSrcBillTypeReader(ICtGetValueMode srcBillTypeReader) {
        this.srcBillTypeReader = srcBillTypeReader;
    }

    public String getSrcRowIdSelectString() {
        return this.srcRowIdSelectString;
    }

    public ICtMappingField getMappingMainOrg() {
        return this.mappingMainOrg;
    }

    public ICtMappingField getMappingBillType() {
        return this.mappingBillType;
    }

    public LinkEntryProp getLinkEntryProp() {
        return this.linkEntryProp;
    }

    public void setLinkEntryProp(LinkEntryProp linkEntryProp) {
        this.linkEntryProp = linkEntryProp;
    }

    public CtMappingSTableId getMappingSTableId() {
        return this.mappingSTableId;
    }

    public void setMappingSTableId(CtMappingSTableId mappingSTableId) {
        this.mappingSTableId = mappingSTableId;
    }

    public CtMappingSBillId getMappingSBillId() {
        return this.mappingSBillId;
    }

    public void setMappingSBillId(CtMappingSBillId mappingSBillId) {
        this.mappingSBillId = mappingSBillId;
    }

    public CtMappingSId getMappingSId() {
        return this.mappingSId;
    }

    public void setMappingSId(CtMappingSId mappingSId) {
        this.mappingSId = mappingSId;
    }

    public List<CtMappingCtrlField> getMappingCtrlFields() {
        return this.mappingCtrlFields;
    }

    public CtMappingSTenantCode getMappingSTenantCode() {
        return this.mappingSTenantCode;
    }

    public void setMappingSTenantCode(CtMappingSTenantCode mappingSTenantCode) {
        this.mappingSTenantCode = mappingSTenantCode;
    }

    public CtMappingTTenantCode getMappingTTenantCode() {
        return this.mappingTTenantCode;
    }

    public void setMappingTTenantCode(CtMappingTTenantCode mappingTTenantCode) {
        this.mappingTTenantCode = mappingTTenantCode;
    }

    public CtMappingSAccountId getMappingSAccountId() {
        return this.mappingSAccountId;
    }

    public void setMappingSAccountId(CtMappingSAccountId mappingSAccountId) {
        this.mappingSAccountId = mappingSAccountId;
    }

    public CtMappingTAccountId getMappingTAccountId() {
        return this.mappingTAccountId;
    }

    public void setMappingTAccountId(CtMappingTAccountId mappingTAccountId) {
        this.mappingTAccountId = mappingTAccountId;
    }

    public CtMappingSLinkEntityKey getMappingSLinkEntityKey() {
        return this.mappingSLinkEntityKey;
    }

    public void setMappingSLinkEntityKey(CtMappingSLinkEntityKey mappingSLinkEntityKey) {
        this.mappingSLinkEntityKey = mappingSLinkEntityKey;
    }

    public CtMappingSLinkTableId getMappingSLinkTableId() {
        return this.mappingSLinkTableId;
    }

    public void setMappingSLinkTableId(CtMappingSLinkTableId mappingSLinkTableId) {
        this.mappingSLinkTableId = mappingSLinkTableId;
    }

    public CtMappingTLinkEntityKey getMappingTLinkEntityKey() {
        return this.mappingTLinkEntityKey;
    }

    public void setMappingTLinkEntityKey(CtMappingTLinkEntityKey mappingTLinkEntityKey) {
        this.mappingTLinkEntityKey = mappingTLinkEntityKey;
    }

    @Override
    public void addMappingField(ICtMappingField mappingField) {
        if (mappingField instanceof ICtMappingLinkField) {
            if (mappingField instanceof CtMappingSTableId) {
                this.mappingSTableId = (CtMappingSTableId)mappingField;
            } else if (mappingField instanceof CtMappingSBillId) {
                this.mappingSBillId = (CtMappingSBillId)mappingField;
            } else if (mappingField instanceof CtMappingSId) {
                this.mappingSId = (CtMappingSId)mappingField;
            } else if (mappingField instanceof CtMappingSEntityKey) {
                this.mappingSEntityKey = (CtMappingSEntityKey)mappingField;
            } else if (mappingField instanceof CtMappingTEntityKey) {
                this.mappingTEntityKey = (CtMappingTEntityKey)mappingField;
            } else if (mappingField instanceof CtMappingSTenantCode) {
                this.mappingSTenantCode = (CtMappingSTenantCode)mappingField;
            } else if (mappingField instanceof CtMappingSAccountId) {
                this.mappingSAccountId = (CtMappingSAccountId)mappingField;
            } else if (mappingField instanceof CtMappingTTenantCode) {
                this.mappingTTenantCode = (CtMappingTTenantCode)mappingField;
            } else if (mappingField instanceof CtMappingTAccountId) {
                this.mappingTAccountId = (CtMappingTAccountId)mappingField;
            } else if (mappingField instanceof CtMappingSLinkEntityKey) {
                this.mappingSLinkEntityKey = (CtMappingSLinkEntityKey)mappingField;
            } else if (mappingField instanceof CtMappingSLinkTableId) {
                this.mappingSLinkTableId = (CtMappingSLinkTableId)mappingField;
            } else if (mappingField instanceof CtMappingTLinkEntityKey) {
                this.mappingTLinkEntityKey = (CtMappingTLinkEntityKey)mappingField;
            } else {
                this.mappingCtrlFields.add((CtMappingCtrlField)mappingField);
            }
            mappingField.getTargetFieldProp().setValueType(CtValueTypeEnum.SIMPLE.name());
            for (CtSourceFieldVariable srcFieldVar : mappingField.getSrcFieldVars()) {
                this.addSourceField(srcFieldVar);
            }
        } else {
            String jsClassName = mappingField.getTargetFieldProp().getType();
            Object fieldClassType = TypesContainer.createInstance((String)jsClassName);
            if (fieldClassType == null) {
                return;
            }
            if (fieldClassType instanceof MainOrgProp) {
                this.mappingMainOrg = mappingField;
            } else if (fieldClassType instanceof BillTypeProp) {
                this.mappingBillType = mappingField;
            }
            super.addMappingField(mappingField);
        }
    }

    @Override
    public void compileSelectString(CtSingleRuleContext ruleContext) {
        super.compileSelectString(ruleContext);
        this.compileRowIdSelectString(ruleContext);
    }

    private void compileRowIdSelectString(CtSingleRuleContext ruleContext) {
        String seqAlias;
        String alias;
        BillEntityType srcMainType = ruleContext.getContext().getSourceMainType();
        ArrayList<String> selectFldStrings = new ArrayList<String>(20);
        HashSet<String> selectFldAlias = new HashSet<String>(20);
        String pkPropName = srcMainType.getPrimaryKey().getName();
        selectFldStrings.add(pkPropName);
        selectFldAlias.add(pkPropName);
        if (StringUtils.isNotBlank((CharSequence)srcMainType.getBillNo()) && !selectFldAlias.contains(srcMainType.getBillNo()) && StringUtils.isNotBlank((CharSequence)((TextProp)srcMainType.findProperty(srcMainType.getBillNo())).getAlias())) {
            selectFldStrings.add(srcMainType.getBillNo());
            selectFldAlias.add(srcMainType.getBillNo());
        }
        if (StringUtils.isNotBlank((CharSequence)this.sourceEntryKey)) {
            String entryPKPropName = this.getSourceEntryPKFullName();
            alias = (String)this.srcFldAlias.get(entryPKPropName);
            selectFldStrings.add(entryPKPropName + " " + alias);
            selectFldAlias.add(alias);
            String entrySeqPropName = this.getSourceEntrySeqFullName();
            if (srcMainType.findProperty(entrySeqPropName) != null) {
                seqAlias = (String)this.srcFldAlias.get(entrySeqPropName);
                selectFldStrings.add(entrySeqPropName + " " + seqAlias);
                selectFldAlias.add(seqAlias);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.sourceSubEntryKey)) {
            String subEntryPKPropName = this.getSourceSubEntryPKFullName();
            alias = (String)this.srcFldAlias.get(subEntryPKPropName);
            selectFldStrings.add(subEntryPKPropName + " " + alias);
            selectFldAlias.add(alias);
            String subEntrySeqPropName = this.sourceSubEntryKey + ".seq";
            if (srcMainType.findProperty(subEntrySeqPropName) != null) {
                subEntrySeqPropName = this.getSourceSubEntrySeqFullName();
                seqAlias = (String)this.srcFldAlias.get(subEntrySeqPropName);
                selectFldStrings.add(subEntrySeqPropName + " " + seqAlias);
                selectFldAlias.add(seqAlias);
            }
        }
        for (CtSourceRowsGroupKeyBuilder builder : this.getSourceRowsGroupKeyBuilders()) {
            for (ICtVariableMode var : builder.getVars()) {
                CtSourceFieldVariable srcField;
                String fldAlias;
                if (!(var instanceof CtSourceFieldVariable) || selectFldAlias.contains(fldAlias = (String)this.srcFldAlias.get((srcField = (CtSourceFieldVariable)var).getVar()))) continue;
                String selectFldString = srcField.getFullPropName() + " " + fldAlias;
                selectFldStrings.add(selectFldString);
                selectFldAlias.add(fldAlias);
            }
        }
        this.srcRowIdSelectString = StringUtils.join((Object[])selectFldStrings.toArray(new Object[selectFldStrings.size()]), (String)",");
    }

    public void compileQFilter(CtSingleRuleContext ruleContext, List<ListSelectedRow> selectedRows) {
        boolean pushByBill = true;
        Set<Object> pkValues = null;
        String pkPropName = "id";
        ListSelectedRow firstSelectedRow = selectedRows.get(0);
        if (!pushByBill && this.isGetRowBySubEntryId(firstSelectedRow)) {
            pkPropName = this.getSourceSubEntryPKFullName();
            pkValues = this.getSourceSubEntryPKValues(selectedRows);
        } else if (!pushByBill && this.isGetRowByEntryId(firstSelectedRow)) {
            pkPropName = this.getSourceEntryPKFullName();
            pkValues = this.getSourceEntryPKValues(selectedRows);
        } else {
            pkValues = this.getSourcePKValues(selectedRows);
        }
        if (!"id".equals(pkPropName)) {
            HashSet<Object> idSet = new HashSet<Object>(16);
            for (ListSelectedRow row : selectedRows) {
                idSet.add(row.getPrimaryKeyValue());
            }
            this.qFilters.add(new QFilter("id", "in", idSet));
        }
        this.qFilters.add(new QFilter(pkPropName, "in", pkValues));
    }

    public QFilter comileQFilter(CtSingleRuleContext ruleContext, CtSourceRowsGroup groupRoot) {
        String pkPropName = "id";
        HashSet<Object> pkValues = new HashSet<Object>();
        EntityType srcLinkEntity = (EntityType)ruleContext.getContext().getSourceMainType().getAllEntities().get(this.getSourceLinkEntityKey());
        if (srcLinkEntity instanceof SubEntryType) {
            pkPropName = this.getSourceSubEntryPKFullName();
            for (CtSourceRowId sourceRowId : groupRoot.getSourceRowIds()) {
                if (Long.compare((Long)sourceRowId.getSubEntryId(), 0L) == 0) continue;
                pkValues.add(sourceRowId.getSubEntryId());
            }
        } else if (srcLinkEntity instanceof EntryType) {
            pkPropName = this.getSourceEntryPKFullName();
            for (CtSourceRowId sourceRowId : groupRoot.getSourceRowIds()) {
                if (Long.compare((Long)sourceRowId.getEntryId(), 0L) == 0) continue;
                pkValues.add(sourceRowId.getEntryId());
            }
        }
        if (pkValues.isEmpty()) {
            pkPropName = "id";
            for (CtSourceRowId sourceRowId : groupRoot.getSourceRowIds()) {
                pkValues.add(sourceRowId.getBillId());
            }
        }
        QFilter ret = new QFilter(pkPropName, "in", pkValues);
        if (!"id".equals(pkPropName)) {
            HashSet<Object> idSet = new HashSet<Object>(16);
            for (CtSourceRowId sourceRowId : groupRoot.getSourceRowIds()) {
                idSet.add(sourceRowId.getBillId());
            }
            ret = new QFilter("id", "in", idSet).and(ret);
        }
        return ret;
    }

    public boolean isGetRowByEntryId(ListSelectedRow firstSelectedRow) {
        if (StringUtils.isBlank((CharSequence)this.sourceEntryKey)) {
            return false;
        }
        if (firstSelectedRow.getEntryPrimaryKeyValue() == null) {
            return false;
        }
        return this.sourceEntryKey.equals(firstSelectedRow.getEntryEntityKey());
    }

    public boolean isGetRowBySubEntryId(ListSelectedRow firstSelectedRow) {
        if (StringUtils.isBlank((CharSequence)this.sourceSubEntryKey)) {
            return false;
        }
        if (firstSelectedRow.getSubEntryPrimaryKeyValue() == null) {
            return false;
        }
        return this.sourceSubEntryKey.equals(firstSelectedRow.getSubEntryEntityKey());
    }

    private Set<Object> getSourcePKValues(List<ListSelectedRow> selectedRows) {
        HashSet<Object> pkValues = new HashSet<Object>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            Object pkValue = selectedRow.getPrimaryKeyValue();
            pkValues.add(pkValue);
        }
        return pkValues;
    }

    private Set<Object> getSourceEntryPKValues(List<ListSelectedRow> selectedRows) {
        HashSet<Object> pkValues = new HashSet<Object>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            Object pkValue = selectedRow.getEntryPrimaryKeyValue();
            pkValues.add(pkValue);
        }
        return pkValues;
    }

    private Set<Object> getSourceSubEntryPKValues(List<ListSelectedRow> selectedRows) {
        HashSet<Object> pkValues = new HashSet<Object>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            Object pkValue = selectedRow.getSubEntryPrimaryKeyValue();
            pkValues.add(pkValue);
        }
        return pkValues;
    }
}

