/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.group;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.BaseDataPropInfo;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.getvaluemode.AbstractCtGetValueMode;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetConstValue;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetSourceFieldValue;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroupKey;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;

public class CtSourceRowsGroupKeyBuilder {
    private String groupFieldKey;
    private CtSingleRuleContext ruleContext;
    private List<ICtGetValueMode> fldValueGetHandlers = new ArrayList<ICtGetValueMode>();
    private List<ICtVariableMode> vars = new ArrayList<ICtVariableMode>();
    public static final String ALLINONE = "@all";

    public CtSourceRowsGroupKeyBuilder(CtSingleRuleContext ruleContext, String groupFieldKey) {
        this.ruleContext = ruleContext;
        this.groupFieldKey = groupFieldKey;
        this.compile();
    }

    public List<ICtGetValueMode> getFldValueGetHandlers() {
        return this.fldValueGetHandlers;
    }

    public List<ICtVariableMode> getVars() {
        return this.vars;
    }

    public CtSourceRowsGroupKey getFldValues(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        Object[] fldValues = new Object[this.fldValueGetHandlers.size()];
        for (int i = 0; i < this.fldValueGetHandlers.size(); ++i) {
            ICtGetValueMode fldValueGetHandler = this.fldValueGetHandlers.get(i);
            fldValues[i] = fldValueGetHandler.getValue(baseDataPropInfoMap, fldProperties, sourceRow);
        }
        return new CtSourceRowsGroupKey(fldValues);
    }

    public CtSourceRowsGroupKey getFldValues(Map<String, String> fldAlias, Row row) {
        Object[] fldValues = new Object[this.fldValueGetHandlers.size()];
        for (int i = 0; i < this.fldValueGetHandlers.size(); ++i) {
            ICtGetValueMode fldValueGetHandler = this.fldValueGetHandlers.get(i);
            fldValues[i] = fldValueGetHandler.getValue(fldAlias, row);
        }
        return new CtSourceRowsGroupKey(fldValues);
    }

    private void compile() {
        String[] fldKeys = StringUtils.split((String)this.groupFieldKey, (String)",");
        this.fldValueGetHandlers = new ArrayList<ICtGetValueMode>(10);
        for (String fldKey : fldKeys) {
            AbstractCtGetValueMode fldValueGetHandler = null;
            fldValueGetHandler = ALLINONE.equals(fldKey) ? new CtGetConstValue(ALLINONE) : new CtGetSourceFieldValue(this.ruleContext, fldKey);
            this.fldValueGetHandlers.add(fldValueGetHandler);
            this.vars.addAll(fldValueGetHandler.getVars());
        }
    }

    public CtSingleRuleContext getRuleContext() {
        return this.ruleContext;
    }
}

