/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.log;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class CtConvertLogAsyncCleanTask
extends AbstractTask {
    private static final String BOTP_CONVERTLOG = "botp_convertlog";
    private static final String SYS_PARAM_KEY_MX_CONVERTLOG_KEEP_MONTH = "max_convertlog_keep_month";
    private static final String FIELD_STARTTIME = "opdate";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LogORM logORM = LogORM.create();
        Integer maxMonth = (Integer)SystemParamServiceHelper.getPublicParameter((String)SYS_PARAM_KEY_MX_CONVERTLOG_KEEP_MONTH);
        if (maxMonth == null) {
            maxMonth = 12;
        }
        LocalDateTime lastDate = LocalDateTime.now().minus(maxMonth.intValue(), ChronoUnit.MONTHS);
        QFilter filter = new QFilter(FIELD_STARTTIME, "<", (Object)Date.from(Timestamp.valueOf(lastDate).toInstant()));
        logORM.delete(BOTP_CONVERTLOG, new QFilter[]{filter});
    }
}

