/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.convert.log.CtConvertLink;
import kd.bos.service.ctbotp.convert.log.CtConvertLog;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CtUpdateTargetLog
extends CtConvertLog {
    private Set<CtConvertLink> convertLinks = new HashSet<CtConvertLink>();
    private String snapshotFileUrl;

    public Set<CtConvertLink> getConvertLinks() {
        return this.convertLinks;
    }

    public void setConvertLinks(Set<CtConvertLink> convertLinks) {
        this.convertLinks = convertLinks;
    }

    public String getSnapshotFileUrl() {
        return this.snapshotFileUrl;
    }

    public void setSnapshotFileUrl(String snapshotFileUrl) {
        this.snapshotFileUrl = snapshotFileUrl;
    }

    public void updateConvertTargetInfo(LogORM logORM, MainEntityType logType) {
        ArrayList<DynamicObject> updateLogs = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> addNewLogs = new ArrayList<DynamicObject>();
        MainEntityType updateMainType = (MainEntityType)logType.getSubEntityType(Arrays.asList("id", "opdate", "tbillno", "tbillid"));
        HashSet<Long> sourceIds = new HashSet<Long>(this.convertLinks.size());
        HashSet<Long> splitSourceIds = new HashSet<Long>();
        for (CtConvertLink link : this.getConvertLinks()) {
            if (sourceIds.contains(link.getSbillid())) {
                splitSourceIds.add(link.getSbillid());
                continue;
            }
            sourceIds.add(link.getSbillid());
        }
        Map<Long, Long> sourceLogIdMap = this.querySourceLogIdMap(logORM, logType, sourceIds);
        Map<Long, Long> splitLogIdMap = this.getSubSourceLogIdMap(sourceLogIdMap, splitSourceIds);
        Map splitLogObjs = BusinessDataServiceHelper.loadFromCache((Object[])splitLogIdMap.values().toArray(), (DynamicObjectType)logType);
        for (CtConvertLink link : this.getConvertLinks()) {
            if (sourceIds.remove(link.getSbillid())) {
                updateLogs.add(this.buildUpdateLogObj(link, updateMainType, sourceLogIdMap.get(link.getSbillid())));
                continue;
            }
            Long logId = splitLogIdMap.get(link.getSbillid());
            if (logId == null) continue;
            addNewLogs.add(this.cloneAddNewLogObj(link, (DynamicObject)splitLogObjs.get(logId), logType));
        }
        if (!updateLogs.isEmpty()) {
            logORM.update(updateLogs);
        }
        if (!addNewLogs.isEmpty()) {
            logORM.insert(addNewLogs);
        }
    }

    private DynamicObject cloneAddNewLogObj(CtConvertLink link, DynamicObject logObj, MainEntityType mainEntityType) {
        DynamicObject convertLogObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)logObj, (boolean)false, (boolean)true);
        mainEntityType.getPrimaryKey().setValueFast((Object)convertLogObj, (Object)ID.genLongId());
        convertLogObj.set("tbillno", (Object)link.getTbillno());
        convertLogObj.set("tbillid", (Object)link.getTbillid());
        return convertLogObj;
    }

    private Map<Long, Long> getSubSourceLogIdMap(Map<Long, Long> sourceLogIdMap, Set<Long> sbillids) {
        HashMap<Long, Long> subMap = new HashMap<Long, Long>(sourceLogIdMap.size());
        for (Map.Entry<Long, Long> entry : sourceLogIdMap.entrySet()) {
            if (!sbillids.contains(entry.getKey())) continue;
            subMap.put(entry.getKey(), entry.getValue());
        }
        return subMap;
    }

    private DynamicObject buildUpdateLogObj(CtConvertLink link, MainEntityType subMainType, Long logId) {
        DynamicObject convertLogObj = new DynamicObject((DynamicObjectType)subMainType);
        subMainType.getPrimaryKey().setValueFast((Object)convertLogObj, (Object)logId);
        convertLogObj.set("tbillno", (Object)link.getTbillno());
        convertLogObj.set("tbillid", (Object)link.getTbillid());
        return convertLogObj;
    }

    private Map<Long, Long> querySourceLogIdMap(LogORM logORM, MainEntityType logType, Set<Long> sourceIds) {
        HashMap<Long, Long> sourceLogIdMap = new HashMap<Long, Long>();
        QFilter filter = new QFilter("taskid", "=", (Object)this.getTaskId()).and(new QFilter("sbillid", "in", sourceIds));
        try (DataSet ds = logORM.queryDataSet(logType.getName(), "id, sbillid", new QFilter[]{filter}, 0, 100000);){
            while (ds.hasNext()) {
                Row row = ds.next();
                sourceLogIdMap.put(row.getLong("sbillid"), row.getLong("id"));
            }
            HashMap<Long, Long> hashMap = sourceLogIdMap;
            return hashMap;
        }
    }
}

