/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.facade;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.sync.CtSyncRouteService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.CtLinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.IEntityOperateService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.track.BFTrackerOpType;
import kd.bos.service.ctbotp.facade.CtTcSevice;
import kd.bos.service.ctbotp.facade.ICtBotpOperateService;
import kd.bos.service.ctbotp.facade.OperateSyncContext;
import kd.bos.service.ctbotp.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.helper.CtTrackerTypes;
import kd.bos.service.operation.Audit;
import kd.bos.service.operation.Delete;
import kd.bos.service.operation.Draft;
import kd.bos.service.operation.Invalid;
import kd.bos.service.operation.Save;
import kd.bos.service.operation.Submit;
import kd.bos.service.operation.UnAudit;
import kd.bos.service.operation.UnSubmit;
import kd.bos.service.operation.Valid;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;
import kd.bos.util.CollectionUtils;

public class CtBotpOperateSevice
implements ICtBotpOperateService {
    private Log log = LogFactory.getLog(CtBotpOperateSevice.class);
    protected OperateSyncContext context = new OperateSyncContext();
    public Map<String, Object> operateMetaMap;
    protected static final String FORMID_CTBOTP_LINK = "bos_ctbotp_billlk";

    @Override
    public void init(OperateOption operateOption, int bfTrackerOpType, MainEntityType mainEntityType) {
        if (BFTrackerOpType.Unknown.getValue() != bfTrackerOpType) {
            this.context.setOpType(bfTrackerOpType);
            this.context.setOperateOption(operateOption);
            this.context.setEntityKey(mainEntityType.getName());
            this.context.setMainEntityType(mainEntityType);
            this.context.setContinueExecution(this.isCTSyncService(mainEntityType));
        }
    }

    private int getOperationType(IEntityOperateService owner) {
        int operationType = BFTrackerOpType.Unknown.getValue();
        if (owner instanceof Save) {
            operationType = BFTrackerOpType.Save.getValue();
        } else if (owner instanceof Draft) {
            operationType = BFTrackerOpType.Draft.getValue();
        } else if (owner instanceof Audit) {
            operationType = BFTrackerOpType.Audit.getValue();
        } else if (owner instanceof UnAudit) {
            operationType = BFTrackerOpType.UnAudit.getValue();
        } else if (owner instanceof Valid) {
            operationType = BFTrackerOpType.UnCancel.getValue();
        } else if (owner instanceof Submit) {
            operationType = BFTrackerOpType.Save.getValue();
        } else if (owner instanceof UnSubmit) {
            operationType = BFTrackerOpType.Save.getValue();
        } else if (owner instanceof Delete) {
            operationType = BFTrackerOpType.Delete.getValue();
        } else if (owner instanceof Invalid) {
            Object link;
            boolean keepLink = false;
            operationType = BFTrackerOpType.Delete.getValue();
            Map parametar = (Map)this.operateMetaMap.get("parameter");
            if (parametar != null && (link = parametar.get("KeepLink")) != null) {
                keepLink = Boolean.parseBoolean(link.toString());
                operationType = keepLink ? BFTrackerOpType.Cancel.getValue() : BFTrackerOpType.Delete.getValue();
            }
        }
        if (BFTrackerOpType.Unknown.getValue() == operationType) {
            this.log.info("\u672a\u77e5\u64cd\u4f5c\u7c7b\u578b\u3002");
        }
        return operationType;
    }

    private CtBFTrackerDbService createDbService() {
        CtBFTrackerDbService db = new CtBFTrackerDbService();
        db.setTrackerTypes(this.context.getTrackerTypes());
        db.setTargetSubMainType((BillEntityType)this.context.getMainEntityType());
        return db;
    }

    @Override
    public void afterInitialize(MainEntityType mainEntityType, OperateOption operateOption, int opType) {
        this.log.info("OperateSyncFacade.afterInitialize");
        this.init(operateOption, opType, mainEntityType);
    }

    @Override
    public void beforeCallOperationTransaction(Map<String, Object> params) {
    }

    @Override
    public void beforeExecuteOperate(Map<String, Object> params) {
    }

    @Override
    public void afterExecuteOperate(Map<String, Object> params) {
    }

    @Override
    public void callOperation(Map<String, Object> params) {
        if (this.context.isContinueExecution() && this.hasCttcTable()) {
            CtTcSevice.deleteTc(params, this.context);
        }
    }

    protected boolean hasCttcTable() {
        CtLinkSetElement ctLinkSetElement = CtConvertMetaServiceHelper.loadCtLinkSet((String)this.context.getMainEntityType().getName());
        if (ctLinkSetElement == null || StringUtils.isEmpty((CharSequence)ctLinkSetElement.getCtTrackerTable())) {
            return false;
        }
        CtTrackerTypes trackerTypes = CtTrackerTypes.buildTrackerTypes((BillEntityType)this.context.getMainEntityType());
        this.context.setTrackerTypes(trackerTypes);
        this.context.setDbService(this.createDbService());
        TableDefine tableDefine = this.context.getDbService().loadTableDefine(this.context.getMainEntityType().getName());
        this.context.setMainTableId(tableDefine.getTableId());
        return true;
    }

    @Override
    public void afterCommit(Map<String, Object> params) {
    }

    @Override
    public void afterRollback(Map<String, Object> params) {
    }

    @Override
    public void afterRelease() {
    }

    protected boolean isCTSyncService(MainEntityType mainEntityType) {
        if (mainEntityType == null) {
            return false;
        }
        String entityNumber = mainEntityType.getName();
        List syncRoutes = CtSyncRouteService.getSyncRouteUp((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)entityNumber);
        return !CollectionUtils.isEmpty((Collection)syncRoutes);
    }
}

