/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.facade;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.IEntityOperateService;
import kd.bos.facade.FacadeResult;
import kd.bos.facade.entity.IEntityLifecycleFacade;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.BOTPServiceFactory;
import kd.bos.service.botp.track.BFTrackerOpType;
import kd.bos.service.ctbotp.ICtBFTrackerEngineProxy;
import kd.bos.service.operation.Audit;
import kd.bos.service.operation.Delete;
import kd.bos.service.operation.Draft;
import kd.bos.service.operation.Invalid;
import kd.bos.service.operation.Save;
import kd.bos.service.operation.Submit;
import kd.bos.service.operation.UnAudit;
import kd.bos.service.operation.UnSubmit;
import kd.bos.service.operation.Valid;

public class CtOperateBfFacade
implements IEntityLifecycleFacade {
    private Log log = LogFactory.getLog(CtOperateBfFacade.class);
    public ICtBFTrackerEngineProxy trankerEngine;
    public Map<String, Object> operateMetaMap;
    public int bfTrackerOpType;

    public FacadeResult afterInitialize(Map<String, Object> params) {
        MainEntityType mainEntityType = params.get("dataEntityType") != null ? (MainEntityType)params.get("dataEntityType") : null;
        this.operateMetaMap = params.get("operateMetaMap") != null ? (Map)params.get("operateMetaMap") : null;
        OperateOption operateOption = params.get("option") != null ? (OperateOption)params.get("option") : null;
        this.trankerEngine = (ICtBFTrackerEngineProxy)BOTPServiceFactory.getPrototypeService(ICtBFTrackerEngineProxy.class);
        IEntityOperateService owner = params.get("owner") != null ? (IEntityOperateService)params.get("owner") : null;
        this.bfTrackerOpType = this.getOperationType(owner);
        this.trankerEngine.init((IDataEntityType)mainEntityType, BFTrackerOpType.valueOf((int)this.bfTrackerOpType), this.operateMetaMap, operateOption);
        return this.getResultSuccess();
    }

    private int getOperationType(IEntityOperateService owner) {
        int operationType = BFTrackerOpType.Unknown.getValue();
        if (owner instanceof Save) {
            operationType = BFTrackerOpType.Save.getValue();
        } else if (owner instanceof Draft) {
            operationType = BFTrackerOpType.Draft.getValue();
        } else if (owner instanceof Audit) {
            operationType = BFTrackerOpType.Audit.getValue();
        } else if (owner instanceof UnAudit) {
            operationType = BFTrackerOpType.UnAudit.getValue();
        } else if (owner instanceof Valid) {
            operationType = BFTrackerOpType.UnCancel.getValue();
        } else if (owner instanceof Submit) {
            operationType = BFTrackerOpType.Save.getValue();
        } else if (owner instanceof UnSubmit) {
            operationType = BFTrackerOpType.Save.getValue();
        } else if (owner instanceof Delete) {
            operationType = BFTrackerOpType.Delete.getValue();
        } else if (owner instanceof Invalid) {
            Object link;
            boolean keepLink = false;
            operationType = BFTrackerOpType.Delete.getValue();
            Map parametar = (Map)this.operateMetaMap.get("parameter");
            if (parametar != null && (link = parametar.get("KeepLink")) != null) {
                keepLink = Boolean.parseBoolean(link.toString());
                operationType = keepLink ? BFTrackerOpType.Cancel.getValue() : BFTrackerOpType.Delete.getValue();
            }
        }
        if (BFTrackerOpType.Unknown.getValue() == operationType) {
            this.log.info("\u672a\u77e5\u64cd\u4f5c\u7c7b\u578b\uff0c\u4e0d\u8fdb\u884c\u53cd\u5199\u3002");
        }
        return operationType;
    }

    public FacadeResult afterPreparePropertys(Map<String, Object> params) {
        List fieldKeys;
        Object[] ids = params.get("ids") != null ? (Object[])params.get("ids") : null;
        List list = fieldKeys = params.get("fieldKeys") != null ? (List)params.get("fieldKeys") : null;
        if (BFTrackerOpType.Delete.getValue() == this.bfTrackerOpType) {
            return this.getResultSuccess();
        }
        this.trankerEngine.preparePropertys(ids, fieldKeys);
        return this.getResultSuccess();
    }

    public FacadeResult beforeCallOperationTransaction(Map<String, Object> params) {
        DynamicObject[] objs;
        DynamicObject[] dynamicObjectArray = objs = params.get("objs") != null ? (DynamicObject[])params.get("objs") : null;
        if (BFTrackerOpType.Delete.getValue() != this.bfTrackerOpType) {
            return this.getResultSuccess();
        }
        this.trankerEngine.execute(objs);
        this.trankerEngine.saveBeforeTrans();
        return this.getResultSuccess();
    }

    public FacadeResult afterUpdateBillStatus(Map<String, Object> params) {
        DynamicObject[] objs;
        DynamicObject[] dynamicObjectArray = objs = params.get("objs") != null ? (DynamicObject[])params.get("objs") : null;
        if (BFTrackerOpType.Delete.getValue() == this.bfTrackerOpType) {
            return this.getResultSuccess();
        }
        this.trankerEngine.execute(objs);
        this.trankerEngine.saveBeforeTrans();
        return this.getResultSuccess();
    }

    public FacadeResult beforeExecuteOperate(Map<String, Object> params) {
        this.trankerEngine.saveBeginTrans();
        return this.getResultSuccess();
    }

    public FacadeResult afterExecuteOperate(Map<String, Object> params) {
        this.trankerEngine.saveTrans();
        return this.getResultSuccess();
    }

    public FacadeResult callOperation(Map<String, Object> params) {
        this.trankerEngine.saveAfterTrans();
        return this.getResultSuccess();
    }

    public FacadeResult afterCommit(Map<String, Object> params) {
        this.trankerEngine.saveFinally();
        return this.getResultSuccess();
    }

    public FacadeResult afterRelease() {
        this.trankerEngine.release();
        return this.getResultSuccess();
    }

    public FacadeResult afterRollback(Map<String, Object> params) {
        this.trankerEngine.rollbackSave();
        return this.getResultSuccess();
    }

    private FacadeResult getResultSuccess() {
        return new FacadeResult(){
            {
                this.setCode(3);
                this.setSuccess(true);
            }
        };
    }
}

