/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.facade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.ctbotp.CtBotpUniqueService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.link.CtBillTcLk;
import kd.bos.entity.ctbotp.link.CtBotpUnique;
import kd.bos.exception.KDBizException;
import kd.bos.service.botp.track.BFTrackerOpType;
import kd.bos.service.ctbotp.facade.CtBotpOperateSevice;
import kd.bos.service.ctbotp.facade.ICtBotpOperateService;
import kd.bos.service.ctbotp.helper.CtTrackerTypes;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class CtSaveOperateSeviceImpl
extends CtBotpOperateSevice {
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-ctbotp";

    public ICtBotpOperateService getInstance() {
        return new CtSaveOperateSeviceImpl();
    }

    @Override
    public void init(OperateOption operateOption, int bfTrackerOpType, MainEntityType mainEntityType) {
        String tcLinks;
        String isCtBotpOpt;
        boolean isCtBotp;
        super.init(operateOption, bfTrackerOpType, mainEntityType);
        if (!this.context.isContinueExecution()) {
            return;
        }
        if (BFTrackerOpType.Save.getValue() == bfTrackerOpType && (isCtBotp = Boolean.parseBoolean(isCtBotpOpt = operateOption.getVariableValue("opt_ctbotp_isctbotp", "false"))) && StringUtils.isNotBlank((CharSequence)(tcLinks = operateOption.getVariableValue("opt_ctbotp_billlks_tc", null)))) {
            this.context.setCtBillTcLks(SerializationUtils.fromJsonStringToList((String)tcLinks, CtBillTcLk.class));
        }
    }

    @Override
    public void afterExecuteOperate(Map<String, Object> params) {
        if (!this.context.isContinueExecution()) {
            return;
        }
        if (CollectionUtils.isEmpty(this.context.getCtBillTcLks())) {
            return;
        }
        if (!this.hasCttcTable()) {
            String message = String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u76ee\u6807\u5355\uff1a%s\u7684\u8de8\u79df\u6237\u5173\u8054\u914d\u7f6eTC\u8868", (String)"CtSaveOperateSeviceImpl_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.context.getMainEntityType().getDisplayName().getLocaleValue());
            throw new KDBizException(message);
        }
        List<DynamicObject> dynamicObjects = this.buildTcLkDynamics(this.context.getCtBillTcLks());
        SaveServiceHelper.save((IDataEntityType)this.context.getTrackerTypes().getEntryTrackerType(), (Object[])dynamicObjects.toArray(new DynamicObject[0]));
        this.saveCtBotpUnique();
    }

    private void saveCtBotpUnique() {
        List<CtBotpUnique> ctBotpUniqueList = this.buildCtBotpUnique(this.context.getCtBillTcLks());
        CtBotpUniqueService.addCtBotpUniques((String)this.context.getMainEntityType().getDBRouteKey(), (CtBotpUnique[])ctBotpUniqueList.toArray(new CtBotpUnique[0]), null);
    }

    private List<CtBotpUnique> buildCtBotpUnique(List<CtBillTcLk> ctBillTcLks) {
        ArrayList<CtBotpUnique> ctBotpUniques = new ArrayList<CtBotpUnique>(16);
        HashSet<Long> alreadyUniqueKey = new HashSet<Long>(16);
        for (CtBillTcLk ctBillTcLk : ctBillTcLks) {
            if (alreadyUniqueKey.contains(ctBillTcLk.gettBillId())) continue;
            CtBotpUnique ctBotpUnique = new CtBotpUnique();
            ctBotpUnique.setsTenantCode(ctBillTcLk.getsTenantCode());
            ctBotpUnique.setsAccountId(ctBillTcLk.getsAccountId());
            ctBotpUnique.setsEntityKey(ctBillTcLk.getsEntityKey());
            ctBotpUnique.setsBillId(Long.valueOf(ctBillTcLk.getsBillId()));
            ctBotpUnique.settEntityKey(ctBillTcLk.gettEntityKey());
            ctBotpUnique.settBillId(Long.valueOf(ctBillTcLk.gettBillId()));
            ctBotpUniques.add(ctBotpUnique);
            alreadyUniqueKey.add(ctBillTcLk.gettBillId());
        }
        return ctBotpUniques;
    }

    private List<DynamicObject> buildTcLkDynamics(List<CtBillTcLk> ctBillTcLks) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        CtTrackerTypes ctTrackerTypes = CtTrackerTypes.buildTrackerTypes((BillEntityType)this.context.getMainEntityType());
        for (CtBillTcLk ctBillTcLk : ctBillTcLks) {
            DynamicObject row = new DynamicObject((DynamicObjectType)ctTrackerTypes.getEntryTrackerType());
            ctTrackerTypes.getTc_sTenantCodeProp().setValueFast((Object)row, (Object)ctBillTcLk.getsTenantCode());
            ctTrackerTypes.getTc_sAccountIdProp().setValueFast((Object)row, (Object)ctBillTcLk.getsAccountId());
            ctTrackerTypes.getTc_sEntityKeyProp().setValueFast((Object)row, (Object)ctBillTcLk.getsEntityKey());
            ctTrackerTypes.getTC_sTableIdProp().setValueFast((Object)row, (Object)ctBillTcLk.getsTableId());
            ctTrackerTypes.getTc_sLkEntityKeyProp().setValueFast((Object)row, (Object)ctBillTcLk.getsLkEntityKey());
            ctTrackerTypes.getTc_sLkTableIdProp().setValueFast((Object)row, (Object)ctBillTcLk.getsLkTableId());
            ctTrackerTypes.getTC_sBillIdProp().setValueFast((Object)row, (Object)ctBillTcLk.getsBillId());
            ctTrackerTypes.getTC_sIdProp().setValueFast((Object)row, (Object)ctBillTcLk.getsId());
            ctTrackerTypes.getTc_tTenantCodeProp().setValueFast((Object)row, (Object)ctBillTcLk.gettTenantCode());
            ctTrackerTypes.getTc_tAccountIdProp().setValueFast((Object)row, (Object)ctBillTcLk.gettAccountId());
            ctTrackerTypes.getTc_tEntityKeyProp().setValueFast((Object)row, (Object)ctBillTcLk.gettEntityKey());
            ctTrackerTypes.getTC_tTableIdProp().setValueFast((Object)row, (Object)ctBillTcLk.gettTableId());
            ctTrackerTypes.getTc_tLkEntityKeyProp().setValueFast((Object)row, (Object)ctBillTcLk.gettLkEntityKey());
            ctTrackerTypes.getTc_tLkTableIdProp().setValueFast((Object)row, (Object)ctBillTcLk.gettLkTableId());
            ctTrackerTypes.getTC_tBillIdProp().setValueFast((Object)row, (Object)ctBillTcLk.gettBillId());
            ctTrackerTypes.getTC_tIdProp().setValueFast((Object)row, (Object)ctBillTcLk.gettId());
            ctTrackerTypes.getTc_syncModelProp().setValueFast((Object)row, (Object)ctBillTcLk.getSyncModel());
            ctTrackerTypes.getTc_ruleVerPkIdProp().setValueFast((Object)row, (Object)ctBillTcLk.getRuleVerPkId());
            ctTrackerTypes.getTc_createTimeProp().setValueFast((Object)row, (Object)new Date());
            dynamicObjects.add(row);
        }
        return dynamicObjects;
    }
}

