/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.facade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.IEntityOperateService;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.facade.FacadeResult;
import kd.bos.facade.entity.IEntityLifecycleFacade;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.track.BFTrackerOpType;
import kd.bos.service.ctbotp.facade.CtBotpOperateSevice;
import kd.bos.service.ctbotp.facade.CtSaveOperateSeviceImpl;
import kd.bos.service.ctbotp.facade.ICtBotpOperateService;
import kd.bos.service.ctbotp.service.CtBillLkServiceHelper;
import kd.bos.service.operation.Audit;
import kd.bos.service.operation.Delete;
import kd.bos.service.operation.Draft;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.service.operation.Invalid;
import kd.bos.service.operation.Save;
import kd.bos.service.operation.Submit;
import kd.bos.service.operation.UnAudit;
import kd.bos.service.operation.UnSubmit;
import kd.bos.service.operation.Valid;
import kd.bos.util.CtCustomParamsUtil;

public class OperateSyncFacade
implements IEntityLifecycleFacade {
    private Log log = LogFactory.getLog(OperateSyncFacade.class);
    private static final String BOS_MSERVICE_CTBOTP = "bos-mservice-ctbotp";
    public Map<String, Object> operateMetaMap;
    private ICtBotpOperateService iCtBotpOperateService;
    public int opType;

    public FacadeResult afterInitialize(Map<String, Object> params) {
        this.log.info("OperateSyncFacade.afterInitialize");
        MainEntityType mainEntityType = params.get("dataEntityType") != null ? (MainEntityType)params.get("dataEntityType") : null;
        OperateOption operateOption = params.get("option") != null ? (OperateOption)params.get("option") : null;
        this.operateMetaMap = params.get("operateMetaMap") != null ? (Map)params.get("operateMetaMap") : null;
        IEntityOperateService owner = params.get("owner") != null ? (IEntityOperateService)params.get("owner") : null;
        this.opType = this.getOperationType(owner);
        this.iCtBotpOperateService = this.getCtBotpOperateService(this.opType);
        this.iCtBotpOperateService.afterInitialize(mainEntityType, operateOption, this.opType);
        return this.getResultSuccess();
    }

    private int getOperationType(IEntityOperateService owner) {
        int operationType = BFTrackerOpType.Unknown.getValue();
        if (owner instanceof Save) {
            operationType = BFTrackerOpType.Save.getValue();
        } else if (owner instanceof Draft) {
            operationType = BFTrackerOpType.Draft.getValue();
        } else if (owner instanceof Audit) {
            operationType = BFTrackerOpType.Audit.getValue();
        } else if (owner instanceof UnAudit) {
            operationType = BFTrackerOpType.UnAudit.getValue();
        } else if (owner instanceof Valid) {
            operationType = BFTrackerOpType.UnCancel.getValue();
        } else if (owner instanceof Submit) {
            operationType = BFTrackerOpType.Save.getValue();
        } else if (owner instanceof UnSubmit) {
            operationType = BFTrackerOpType.Save.getValue();
        } else if (owner instanceof Delete) {
            operationType = BFTrackerOpType.Delete.getValue();
        } else if (owner instanceof Invalid) {
            Object link;
            boolean keepLink = false;
            operationType = BFTrackerOpType.Delete.getValue();
            Map parametar = (Map)this.operateMetaMap.get("parameter");
            if (parametar != null && (link = parametar.get("KeepLink")) != null) {
                keepLink = Boolean.parseBoolean(link.toString());
                operationType = keepLink ? BFTrackerOpType.Cancel.getValue() : BFTrackerOpType.Delete.getValue();
            }
        }
        if (BFTrackerOpType.Unknown.getValue() == operationType) {
            this.log.info("\u672a\u77e5\u64cd\u4f5c\u7c7b\u578b\uff0c\u4e0d\u8fdb\u884c\u53cd\u5199\u3002");
        }
        return operationType;
    }

    private ICtBotpOperateService getCtBotpOperateService(int opType) {
        if (BFTrackerOpType.Save.getValue() == opType) {
            return new CtSaveOperateSeviceImpl();
        }
        return new CtBotpOperateSevice();
    }

    private boolean isCheckCtBotpLk(IEntityOperateService owner, OperateOption option) {
        return option != null && Boolean.parseBoolean(option.getVariableValue("ischeckctbotplk", "false"));
    }

    private boolean isReverseOpType(IEntityOperateService owner) {
        if (owner instanceof Delete) {
            return true;
        }
        if (owner instanceof Invalid) {
            return true;
        }
        if (owner instanceof UnSubmit) {
            return true;
        }
        return owner instanceof UnAudit;
    }

    private String getOperationName(IEntityOperateService owner, String operationKey) {
        String opName = operationKey;
        if (owner instanceof Delete) {
            opName = ((Delete)owner).getOpName();
        } else if (owner instanceof Invalid) {
            opName = ((Invalid)owner).getOpName();
        } else if (owner instanceof UnSubmit) {
            opName = ((UnSubmit)owner).getOpName();
        } else if (owner instanceof UnAudit) {
            opName = ((UnAudit)owner).getOpName();
        } else if (owner instanceof EntityOperateService) {
            opName = ((EntityOperateService)owner).getOpName();
        }
        return opName;
    }

    private boolean checkHasBiilLk() {
        boolean sysParams = Boolean.parseBoolean(System.getProperty("KEY_CTBOTP_CHECK_HASBILLLK", "true"));
        boolean customParams = CtCustomParamsUtil.getCustomParamsParam((String)"KEY_CTBOTP_CHECK_HASBILLLK");
        return sysParams && customParams;
    }

    public FacadeResult beforeCallOperationTransaction(Map<String, Object> params) {
        this.iCtBotpOperateService.beforeCallOperationTransaction(params);
        return this.getResultSuccess();
    }

    public FacadeResult beforeExecuteOperate(Map<String, Object> params) {
        this.iCtBotpOperateService.beforeExecuteOperate(params);
        return this.getResultSuccess();
    }

    public FacadeResult afterExecuteOperate(Map<String, Object> params) {
        this.iCtBotpOperateService.afterExecuteOperate(params);
        return this.getResultSuccess();
    }

    public FacadeResult callOperation(Map<String, Object> params) {
        this.iCtBotpOperateService.callOperation(params);
        return this.getResultSuccess();
    }

    public FacadeResult afterCommit(Map<String, Object> params) {
        this.iCtBotpOperateService.afterCommit(params);
        return this.getResultSuccess();
    }

    public FacadeResult afterRollback(Map<String, Object> params) {
        this.iCtBotpOperateService.afterRollback(params);
        return this.getResultSuccess();
    }

    public FacadeResult afterRelease() {
        this.iCtBotpOperateService.afterRelease();
        return this.getResultSuccess();
    }

    public FacadeResult beforeDoExecute(Map<String, Object> params) {
        OperateOption option;
        if (!this.checkHasBiilLk()) {
            return this.getResultSuccess();
        }
        IEntityOperateService owner = params.get("owner") != null ? (IEntityOperateService)params.get("owner") : null;
        boolean isCheckCtBotpLk = this.isCheckCtBotpLk(owner, option = params.get("option") != null ? (OperateOption)params.get("option") : null);
        if (!isCheckCtBotpLk) {
            return this.getResultSuccess();
        }
        MainEntityType mainEntityType = (MainEntityType)params.get("mainEntityType");
        if (!(mainEntityType.getPrimaryKey() instanceof LongProp)) {
            return this.getResultSuccess();
        }
        DynamicObject[] dynCol = (DynamicObject[])params.get("dataEntities");
        String billNoFldKey = "";
        if (mainEntityType instanceof BillEntityType) {
            billNoFldKey = ((BillEntityType)mainEntityType).getBillNo();
        }
        String tEntityKey = mainEntityType.getName();
        String tenantCode = RequestContext.get().getTenantCode();
        String accountId = RequestContext.get().getAccountId();
        ArrayList<Long> pkList = new ArrayList<Long>(dynCol.length);
        HashMap<Object, String> billNos = new HashMap<Object, String>(dynCol.length);
        for (DynamicObject dyn : dynCol) {
            pkList.add((Long)dyn.getPkValue());
            String billNo = String.valueOf(dyn.getPkValue());
            if (StringUtils.isNotBlank((CharSequence)billNoFldKey)) {
                billNo = dyn.getString(billNoFldKey);
            }
            billNos.put(dyn.getPkValue(), billNo);
        }
        Map<Long, Boolean> hasCtBillLkMap = CtBillLkServiceHelper.hasCtBillLksUp(tenantCode, accountId, tEntityKey, pkList);
        OperationResult operationResult = (OperationResult)params.get("operationResult");
        boolean hasCtBillLks = false;
        String operationKey = (String)params.get("operationKey");
        String operationName = this.getOperationName(owner, operationKey);
        for (Map.Entry<Long, Boolean> hasCtBillLkEntry : hasCtBillLkMap.entrySet()) {
            Long pk = hasCtBillLkEntry.getKey();
            Boolean hasCtBillLkEntryValue = hasCtBillLkEntry.getValue();
            if (!hasCtBillLkEntryValue.booleanValue()) continue;
            String billNo = (String)billNos.get(pk);
            String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5b58\u5728\u8de8\u79df\u6237\u6e90\u5355\uff0c\u4e0d\u5141\u8bb8%2$s\u3002", (String)"OperateSyncFacade_0", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]), billNo, operationName);
            operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", (Object)pk, 0, 0, "hasCtBillLk", operationName, msg, ErrorLevel.FatalError));
            hasCtBillLks = true;
        }
        if (hasCtBillLks) {
            return this.getResultFail();
        }
        return this.getResultSuccess();
    }

    private FacadeResult getResultSuccess() {
        return new FacadeResult(){
            {
                this.setCode(3);
                this.setSuccess(true);
            }
        };
    }

    private FacadeResult getResultFail() {
        return new FacadeResult(){
            {
                this.setCode(6);
                this.setSuccess(true);
            }
        };
    }
}

