/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.helper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ctbotp.CtAttachmentPanelMapItem;
import kd.bos.entity.ctbotp.CtAttachmentPanelMapPolicy;
import kd.bos.entity.ctbotp.CtDataAttachmentFieldValue;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.dto.CtAttachmentPanelApDto;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.openapi.param.CtAttachmentDownloadArgs;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.batchrequest.CtSaveAttachmentFieldSetValueRequest;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.FileNameUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

public class CtAttachmentConvertHelper {
    private static Logger log = Logger.getLogger(CtAttachmentConvertHelper.class);
    private static final String BOS_MSERVICE_CTBOTP = "bos-mservice-ctbotp";
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"CtAttachmentPanelConvertHelper", (int)5);

    public static void batchSaveAttachmentPanelData(CtSaveContext context, List<Object> successPkIds) {
        List<CtDataEntity> successData = CtAttachmentConvertHelper.filterSuccessData(context, successPkIds);
        if (CollectionUtils.isEmpty(successData)) {
            return;
        }
        Map<Long, Long> tSyncLogIdMapping = CtAttachmentConvertHelper.getTSyncLogIdMapping(context);
        int batchSize = CtAttachmentConvertHelper.getAttachmentSaveBatchSize();
        while (successData.size() > 0) {
            List<CtDataEntity> curBarchDataList = successData.size() > batchSize ? successData.subList(0, batchSize) : successData;
            ArrayList<DynamicObject> curBarchAttachmentSyncLogList = new ArrayList<DynamicObject>();
            for (CtDataEntity ctDataEntity : curBarchDataList) {
                List<DynamicObject> attachmentSyncLogList = CtAttachmentConvertHelper.createAttachmentSyncLogList(context, ctDataEntity, tSyncLogIdMapping);
                curBarchAttachmentSyncLogList.addAll(attachmentSyncLogList);
            }
            Object[] attachmentPanels = CtAttachmentConvertHelper.createAttachmentForAttPanel(context, curBarchDataList);
            if (attachmentPanels != null && attachmentPanels.length > 0) {
                log.info((Object)("batchSaveAttachmentPanelData successIds size is : " + attachmentPanels.length));
            }
            curBarchDataList.clear();
            CtAttachmentConvertHelper.syncAttachmentFile(curBarchAttachmentSyncLogList);
        }
    }

    private static void batchClearAttachmentPanelData(CtSaveContext context, List<CtDataEntity> curBarchDataList) {
        CtAttachmentPanelMapPolicy ctAttachmentPanelMapPolicy = context.getRule().getCtAttachmentPanelMapPolicy();
        HashSet<String> targetBillPkSet = new HashSet<String>(curBarchDataList.size());
        for (CtDataEntity ctDataEntity : curBarchDataList) {
            targetBillPkSet.add(String.valueOf(ctDataEntity.getId()));
        }
        ArrayList<String> attKeyList = new ArrayList<String>();
        for (CtAttachmentPanelMapItem item : ctAttachmentPanelMapPolicy.getItems()) {
            if (!StringUtils.isNotBlank((CharSequence)item.getSourceAttachmentPanel()) || !StringUtils.isNotBlank((CharSequence)item.getTargetAttachmentPanel())) continue;
            attKeyList.add(item.getTargetAttachmentPanel());
        }
        if (CollectionUtils.isNotEmpty(targetBillPkSet) && CollectionUtils.isNotEmpty(attKeyList)) {
            QFilter qFilter = new QFilter("finterid", "in", targetBillPkSet);
            QFilter attKeyFilter = new QFilter("fattachmentpanel", "in", attKeyList);
            Map toBeDelteAttachment = BusinessDataServiceHelper.loadFromCache((String)"bos_attachment", (QFilter[])new QFilter[]{qFilter, attKeyFilter});
            HashSet<String> attUrlSet = new HashSet<String>(toBeDelteAttachment.size());
            for (DynamicObject attachmentPanelObj : toBeDelteAttachment.values()) {
                attUrlSet.add(attachmentPanelObj.getString("ffileid"));
            }
            DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{qFilter, attKeyFilter});
            try {
                if (CollectionUtils.isNotEmpty(attUrlSet)) {
                    for (String url : attUrlSet) {
                        FileServiceFactory.getAttachmentFileService().delete(url);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("remove att error : " + e));
            }
        }
    }

    private static List<CtDataEntity> filterSuccessData(CtSaveContext context, List<Object> successPkIds) {
        List data = context.getCtSaveArgs().getData();
        ArrayList<CtDataEntity> successData = new ArrayList<CtDataEntity>();
        for (CtDataEntity ctDataEntity : data) {
            if (!successPkIds.contains(ctDataEntity.getId()) || !CollectionUtils.isNotEmpty((Collection)ctDataEntity.getAttachmentPanelMapList())) continue;
            successData.add(ctDataEntity);
        }
        return successData;
    }

    private static Map<Long, Long> getTSyncLogIdMapping(CtSaveContext context) {
        List<SyncLog> syncLogs = context.gettSyncLogs();
        HashMap<Long, Long> tSyncLogIdMapping = new HashMap<Long, Long>(syncLogs.size());
        for (SyncLog syncLog : syncLogs) {
            tSyncLogIdMapping.put(syncLog.getTbillId(), syncLog.getId());
        }
        return tSyncLogIdMapping;
    }

    private static int getAttachmentSaveBatchSize() {
        return SystemPropertyUtils.getInteger((String)RequestContext.get().getTenantId(), (String)"KEY_CTBOTP_SAVEATTACH_BATCHSIZE", (Integer)100);
    }

    private static Object[] createAttachmentForAttPanel(CtSaveContext context, List<CtDataEntity> curBarchDataList) {
        int size = curBarchDataList.size();
        MainEntityType attachmentPanelEntityType = EntityMetadataCache.getDataEntityType((String)"bos_attachment");
        ArrayList<DynamicObject> batchAttachmentPanelObjList = new ArrayList<DynamicObject>(size);
        for (CtDataEntity ctDataEntity : curBarchDataList) {
            List attachmentPanelMapList = ctDataEntity.getAttachmentPanelMapList();
            List<DynamicObject> attachmentPanelObjList = CtAttachmentConvertHelper.convertAttachmentMapsToDynObjs(attachmentPanelMapList, attachmentPanelEntityType);
            batchAttachmentPanelObjList.addAll(attachmentPanelObjList);
        }
        if (context.getRule().isMirrorSync() && context.getRule().isMirrorUpdate()) {
            CtAttachmentConvertHelper.batchClearAttachmentPanelData(context, curBarchDataList);
        }
        if (batchAttachmentPanelObjList.size() > 0) {
            DynamicObject[] dynamicObjects = batchAttachmentPanelObjList.toArray(new DynamicObject[0]);
            return SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        return null;
    }

    private static List<DynamicObject> convertAttachmentMapsToDynObjs(List<Map<String, Object>> attachmentPanelMapList, MainEntityType attachmentPanelEntityType) {
        Date now = new Date();
        ArrayList<DynamicObject> attachmentDynObjList = new ArrayList<DynamicObject>(attachmentPanelMapList.size());
        DataEntityPropertyCollection properties = attachmentPanelEntityType.getProperties();
        for (Map<String, Object> attachmentPanelMap : attachmentPanelMapList) {
            DynamicObject attachmentDynObj = new DynamicObject((DynamicObjectType)attachmentPanelEntityType);
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                if (!attachmentPanelMap.containsKey(propertyName)) continue;
                Object propertyValue = attachmentPanelMap.get(propertyName);
                if (property instanceof TextProp) {
                    attachmentDynObj.set(property, (Object)String.valueOf(propertyValue));
                    continue;
                }
                if (property instanceof LongProp || property instanceof IntegerProp || property instanceof BillStatusProp) {
                    attachmentDynObj.set(property, propertyValue);
                    continue;
                }
                if (!(property instanceof DateTimeProp)) continue;
                try {
                    attachmentDynObj.set(property, (Object)simpleDateFormat.parse(String.valueOf(propertyValue)));
                }
                catch (ParseException e) {
                    log.warn((Object)("formatdata error,data propertyValue is " + propertyValue));
                    attachmentDynObj.set(property, (Object)now);
                }
            }
            attachmentDynObjList.add(attachmentDynObj);
        }
        return attachmentDynObjList;
    }

    private static List<DynamicObject> createAttachmentSyncLogList(CtSaveContext context, CtDataEntity ctDataEntity, Map<Long, Long> tSyncLogIdMapping) {
        List attachmentPanelMapList = ctDataEntity.getAttachmentPanelMapList();
        ArrayList<DynamicObject> attachmentSyncLogList = new ArrayList<DynamicObject>(attachmentPanelMapList.size());
        long[] attachmentPanelIds = DB.genLongIds((String)"bos_attachment", (int)attachmentPanelMapList.size());
        long[] attsynclogIds = DB.genLongIds((String)"bos_ctbotp_attsynclog", (int)attachmentPanelMapList.size());
        int i = 0;
        for (Map attachmentPanelMap : attachmentPanelMapList) {
            attachmentPanelMap.put("id", attachmentPanelIds[i]);
            DynamicObject attachmentSyncLog = CtAttachmentConvertHelper.createAttachmentSyncLog(attsynclogIds[i], attachmentPanelMap, ctDataEntity, context, tSyncLogIdMapping);
            attachmentSyncLogList.add(attachmentSyncLog);
            CtAttachmentConvertHelper.setAttPanelBingdingProperty(attachmentPanelMap);
            ++i;
        }
        return attachmentSyncLogList;
    }

    private static void setAttPanelBingdingProperty(Map<String, Object> attachmentPanelMap) {
        attachmentPanelMap.put("fbilltype", attachmentPanelMap.remove("target_fbilltype"));
        attachmentPanelMap.put("finterid", attachmentPanelMap.remove("target_finterid"));
        attachmentPanelMap.put("fattachmentpanel", attachmentPanelMap.remove("target_fattachmentpanel"));
        attachmentPanelMap.put("fnumber", AttachmentServiceHelper.generateUid() + "-ctbtop");
        attachmentPanelMap.put("ffileid", "");
        String ctUplodingPre = ResManager.loadKDString((String)"\u9644\u4ef6\u534f\u540c\u4e0a\u4f20\u4e2d\uff1a", (String)"CtAttachmentPanelConvertHelper_2", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]);
        attachmentPanelMap.put("fattachmentname", ctUplodingPre + attachmentPanelMap.get("fattachmentname"));
        attachmentPanelMap.remove("source_appId");
    }

    private static DynamicObject createAttachmentSyncLog(long attsynclogId, Map<String, Object> attachmentPanelMap, CtDataEntity ctDataEntity, CtSaveContext context, Map<Long, Long> tSyncLogIdMapping) {
        long attPkId = (Long)attachmentPanelMap.get("id");
        String sourceEntityNum = String.valueOf(attachmentPanelMap.get("fbilltype"));
        String sourceBillPkId = String.valueOf(attachmentPanelMap.get("finterid"));
        String sourceAttKey = String.valueOf(attachmentPanelMap.get("fattachmentpanel"));
        String sourcePath = String.valueOf(attachmentPanelMap.get("ffileid"));
        String sourceAppId = String.valueOf(attachmentPanelMap.get("source_appId"));
        String sourceAttachmentname = String.valueOf(attachmentPanelMap.get("fattachmentname"));
        String uploadPath = CtAttachmentConvertHelper.genAttachmentUploadPath(context, attachmentPanelMap, ctDataEntity);
        String sAccountId = context.getCtSaveArgs().getsAccountId();
        String sTenantCode = context.getCtSaveArgs().getsTenantCode();
        CtAttachmentDownloadArgs downloadArgs = new CtAttachmentDownloadArgs(sourceEntityNum, sourceBillPkId, sourceAttKey, sourcePath, sourceAppId, sourceAttachmentname, uploadPath, sAccountId, sTenantCode);
        MainEntityType attachmentSyncLogType = EntityMetadataCache.getDataEntityType((String)"bos_ctbotp_attsynclog");
        DynamicObject attachmentSyncLog = new DynamicObject((DynamicObjectType)attachmentSyncLogType);
        attachmentSyncLog.set("id", (Object)attsynclogId);
        attachmentSyncLog.set("tsynclogid", (Object)tSyncLogIdMapping.get(ctDataEntity.getId()));
        attachmentSyncLog.set("tbillid", (Object)ctDataEntity.getId());
        attachmentSyncLog.set("atttype", (Object)1);
        attachmentSyncLog.set("attpkid", (Object)attPkId);
        attachmentSyncLog.set("param_tag", (Object)SerializationUtils.toJsonString((Object)((Object)downloadArgs)));
        attachmentSyncLog.set("status", (Object)0);
        attachmentSyncLog.set("creater", (Object)RequestContext.get().getCurrUserId());
        return attachmentSyncLog;
    }

    private static String genAttachmentUploadPath(CtSaveContext context, Map<String, Object> attachmentPanelMap, CtDataEntity ctDataEntity) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String appId = context.getTargetMainType().getAppId();
        String entityNumber = context.getTargetMainType().getName();
        Long pkId = ctDataEntity.getId();
        String fileName = String.valueOf(attachmentPanelMap.get("fattachmentname"));
        String uuid = UUID.randomUUID().toString().replace("-", "");
        return FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)entityNumber, (Object)pkId, (String)(uuid + "/" + AttachmentServiceHelper.replaceSpeSymbol((String)fileName)));
    }

    public static String genAttachmentFieldUploadPath(long attPkId, String fileName) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        return FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (Object)attPkId, (String)(uuid + "/" + AttachmentServiceHelper.replaceSpeSymbol((String)fileName)));
    }

    public static void syncAttachmentFile(Collection<DynamicObject> syncAttachmentLogList) {
        threadPool.execute(() -> {
            HashMap<Long, Map<String, Object>> attPanelUpdateAttachmentData = new HashMap<Long, Map<String, Object>>();
            HashMap<Long, Map<String, Object>> attFieldUpdateAttachmentData = new HashMap<Long, Map<String, Object>>();
            Date now = new Date();
            for (DynamicObject syncAttachmentLog : syncAttachmentLogList) {
                try {
                    if (!CtAttachmentConvertHelper.canRetrySyncAtt(now, syncAttachmentLog)) continue;
                    String apiParam = syncAttachmentLog.getString("param_tag");
                    CtAttachmentDownloadArgs downloadArgs = (CtAttachmentDownloadArgs)((Object)((Object)SerializationUtils.fromJsonString((String)apiParam, CtAttachmentDownloadArgs.class)));
                    String resultData = CtBotpApiUtils.postForDownloadFile(downloadArgs.getTenantCode(), downloadArgs.getAccountId(), CtApiUrlEnum.GETATTACHMENT, downloadArgs);
                    Map openApiResult = (Map)SerializationUtils.fromJsonString((String)resultData, Map.class);
                    String filePath = String.valueOf(openApiResult.get("data"));
                    CtAttachmentConvertHelper.fillAttPanelUpdateData(attPanelUpdateAttachmentData, syncAttachmentLog, downloadArgs, filePath);
                    CtAttachmentConvertHelper.fillAttFieldUpdateData(attFieldUpdateAttachmentData, syncAttachmentLog, downloadArgs, filePath);
                    syncAttachmentLog.set("faildesc", (Object)"");
                    syncAttachmentLog.set("status", (Object)1);
                }
                catch (Exception e) {
                    log.error((Object)e);
                    syncAttachmentLog.set("status", (Object)2);
                    syncAttachmentLog.set("faildesc", (Object)e.getMessage());
                }
                finally {
                    syncAttachmentLog.set("param", (Object)("traceid:" + RequestContext.get().getTraceId()));
                    syncAttachmentLog.set("lastretrytime", (Object)now);
                }
            }
            try {
                CtAttachmentConvertHelper.batchUpdateAttachment(attFieldUpdateAttachmentData, "bd_attachment");
                CtAttachmentConvertHelper.batchUpdateAttachment(attPanelUpdateAttachmentData, "bos_attachment");
            }
            catch (Exception e) {
                log.error((Object)e);
                for (DynamicObject syncAttachmentLog : syncAttachmentLogList) {
                    syncAttachmentLog.set("status", (Object)2);
                    String msg = String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u4f46\u66f4\u65b0\u9644\u4ef6url\u5931\u8d25\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7\uff1a%s", (String)"CtAttachmentPanelConvertHelper_1", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]), e.getMessage());
                    msg = msg.substring(1999);
                    syncAttachmentLog.set("faildesc", (Object)msg);
                }
            }
            finally {
                SaveServiceHelper.save((DynamicObject[])syncAttachmentLogList.toArray(new DynamicObject[syncAttachmentLogList.size()]));
            }
        });
    }

    private static void fillAttPanelUpdateData(Map<Long, Map<String, Object>> attPanelUpdateAttachmentData, DynamicObject syncAttachmentLog, CtAttachmentDownloadArgs downloadArgs, String filePath) {
        HashMap<String, String> attFiledMap = new HashMap<String, String>();
        String atttype = syncAttachmentLog.getString("atttype");
        long attPkId = syncAttachmentLog.getLong("attpkid");
        if (!"1".equals(atttype)) {
            return;
        }
        attFiledMap.put("ffileid", filePath);
        attFiledMap.put("fattachmentname", downloadArgs.getFileName());
        attPanelUpdateAttachmentData.put(attPkId, attFiledMap);
    }

    private static void fillAttFieldUpdateData(Map<Long, Map<String, Object>> attFieldUpdateAttachmentData, DynamicObject syncAttachmentLog, CtAttachmentDownloadArgs downloadArgs, String filePath) {
        HashMap<String, String> attFiledMap = new HashMap<String, String>();
        String atttype = syncAttachmentLog.getString("atttype");
        long attPkId = syncAttachmentLog.getLong("attpkid");
        if (!"2".equals(atttype)) {
            return;
        }
        attFiledMap.put("url", filePath);
        attFiledMap.put("name", downloadArgs.getFileName());
        attFieldUpdateAttachmentData.put(attPkId, attFiledMap);
    }

    private static void batchUpdateAttachment(Map<Long, Map<String, Object>> updateAttachmentData, String attEntityNumber) {
        Set<Long> attPkIdSet = updateAttachmentData.keySet();
        if (attPkIdSet.size() == 0) {
            return;
        }
        Map attachmentMap = BusinessDataServiceHelper.loadFromCache((Object[])attPkIdSet.toArray(new Object[attPkIdSet.size()]), (String)attEntityNumber);
        Collection updateAttachs = attachmentMap.values();
        for (DynamicObject updateAttachment : updateAttachs) {
            Object attPkId = updateAttachment.getPkValue();
            Map<String, Object> updateFieldMap = updateAttachmentData.get(attPkId);
            for (Map.Entry<String, Object> updateFieldEntry : updateFieldMap.entrySet()) {
                if ("name".equals(updateFieldEntry.getKey())) {
                    ILocaleString fileNameLocaleString = updateAttachment.getLocaleString("name");
                    for (Map.Entry fileNameEntry : fileNameLocaleString.entrySet()) {
                        fileNameLocaleString.put(fileNameEntry.getKey(), (Object)String.valueOf(updateFieldEntry.getValue()));
                    }
                    updateAttachment.set(updateFieldEntry.getKey(), (Object)fileNameLocaleString);
                    continue;
                }
                updateAttachment.set(updateFieldEntry.getKey(), updateFieldEntry.getValue());
            }
        }
        if (updateAttachs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateAttachs.toArray(new DynamicObject[updateAttachs.size()]));
        }
    }

    private static boolean canRetrySyncAtt(Date now, DynamicObject syncAttachmentLog) {
        Date lastRetryTime;
        if ("1".equals(syncAttachmentLog.getString("status"))) {
            return false;
        }
        return !"0".equals(syncAttachmentLog.getString("status")) || (lastRetryTime = syncAttachmentLog.getDate("lastretrytime")) == null || !now.before(DateUtils.addMinutes((Date)lastRetryTime, (int)3));
    }

    public static List<CtAttachmentPanelApDto> getAttachmentPanelApForApi(String formId, String localId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List aps = formMetadata.getItems().stream().filter(item -> item instanceof AttachmentPanelAp).collect(Collectors.toList());
        ArrayList<CtAttachmentPanelApDto> attPanelApList = new ArrayList<CtAttachmentPanelApDto>(aps.size());
        Collections.sort(aps, new Comparator<ControlAp<?>>(){

            @Override
            public int compare(ControlAp<?> o1, ControlAp<?> o2) {
                int compareValue = 0;
                compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
                if (compareValue != 0) {
                    return compareValue;
                }
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
        for (ControlAp ap : aps) {
            CtAttachmentPanelApDto attachmentPanelApDto = new CtAttachmentPanelApDto(ap.getKey(), (String)ap.getName().getItem(localId));
            attPanelApList.add(attachmentPanelApDto);
        }
        return attPanelApList;
    }

    public static void batchSaveAttachmentFieldData(List<CtSaveAttachmentFieldSetValueRequest> requestList, CtSaveContext context) {
        if (CollectionUtils.isEmpty(requestList)) {
            return;
        }
        Map<Long, Long> tSyncLogIdMapping = CtAttachmentConvertHelper.getTSyncLogIdMapping(context);
        ArrayList<DynamicObject> curBarchAttachmentSyncLogList = new ArrayList<DynamicObject>();
        for (CtSaveAttachmentFieldSetValueRequest request : requestList) {
            Object[] attachmentFields;
            CtDataAttachmentFieldValue ctDataAttachmentFieldValue = request.getCtDataAttachmentFieldValue();
            List attachmentFiledMapList = ctDataAttachmentFieldValue.getAttachmentFiledMapList();
            if (CollectionUtils.isEmpty((Collection)attachmentFiledMapList)) continue;
            List<DynamicObject> attachmentSyncLogList = CtAttachmentConvertHelper.createAttachmentFieldSyncLogList(attachmentFiledMapList, request, tSyncLogIdMapping);
            curBarchAttachmentSyncLogList.addAll(attachmentSyncLogList);
            if (context.getRule().isMirrorSync() && context.getRule().isMirrorUpdate()) {
                CtAttachmentConvertHelper.batchClearAttachmentFiledData(request, attachmentFiledMapList, context);
            }
            if ((attachmentFields = CtAttachmentConvertHelper.createAttachmentForAttField(attachmentFiledMapList)) != null && attachmentFields.length > 0) {
                log.info((Object)("batchSaveAttachmentFieldData attachmentFields successIds size is : " + attachmentFields.length));
            }
            request.setNewValue(attachmentFields);
            request.setValue();
        }
        CtAttachmentConvertHelper.syncAttachmentFile(curBarchAttachmentSyncLogList);
    }

    private static List<DynamicObject> createAttachmentFieldSyncLogList(List<Map<String, Object>> attachmentFiledMapList, CtSaveAttachmentFieldSetValueRequest request, Map<Long, Long> tSyncLogIdMapping) {
        ArrayList<DynamicObject> attachmentSyncLogList = new ArrayList<DynamicObject>(attachmentFiledMapList.size());
        long[] attachmentFieldIds = DB.genLongIds((String)"bd_attachment", (int)attachmentFiledMapList.size());
        long[] attsynclogIds = DB.genLongIds((String)"bos_ctbotp_attsynclog", (int)attachmentFiledMapList.size());
        int i = 0;
        for (Map<String, Object> attachmentFiledMap : attachmentFiledMapList) {
            attachmentFiledMap.put("id", attachmentFieldIds[i]);
            attachmentFiledMap.put("tbillid", request.getTargetBillId());
            attachmentFiledMap.put("name", CtAttachmentConvertHelper.getFileNameLocalString(attachmentFiledMap));
            DynamicObject attachmentSyncLog = CtAttachmentConvertHelper.createAttachmentFieldSyncLog(attsynclogIds[i], attachmentFiledMap, tSyncLogIdMapping);
            attachmentSyncLogList.add(attachmentSyncLog);
            CtAttachmentConvertHelper.setAttFieldProperty(attachmentFiledMap);
            ++i;
        }
        return attachmentSyncLogList;
    }

    private static void setAttFieldProperty(Map<String, Object> attachmentFiledMap) {
        attachmentFiledMap.put("url", "");
        LocaleString fileNameLocaleString = (LocaleString)attachmentFiledMap.get("name");
        String ctUplodingPre = ResManager.loadKDString((String)"\u9644\u4ef6\u534f\u540c\u4e0a\u4f20\u4e2d\uff1a", (String)"CtAttachmentPanelConvertHelper_2", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]);
        for (Map.Entry fileNameEntry : fileNameLocaleString.entrySet()) {
            String fileName = (String)fileNameEntry.getValue();
            fileNameLocaleString.put((String)fileNameEntry.getKey(), (Object)(ctUplodingPre + fileName));
        }
        attachmentFiledMap.put("name", fileNameLocaleString);
        attachmentFiledMap.put("uid", AttachmentServiceHelper.generateUid() + "-ctbtop");
        attachmentFiledMap.put("number", UUID.randomUUID());
        attachmentFiledMap.remove("sourceAppId");
        attachmentFiledMap.remove("sourceEntityNum");
        attachmentFiledMap.remove("sourceBillPkId");
        attachmentFiledMap.remove("sourceEntryPkId");
        attachmentFiledMap.remove("sourceAttKey");
        attachmentFiledMap.remove("sAccountId");
        attachmentFiledMap.remove("sTenantCode");
    }

    private static DynamicObject createAttachmentFieldSyncLog(long attsynclogId, Map<String, Object> attachmentFiledMap, Map<Long, Long> tSyncLogIdMapping) {
        long attPkId = (Long)attachmentFiledMap.get("id");
        String sourceEntityNum = (String)attachmentFiledMap.get("sourceEntityNum");
        Object sourceBillPkId = attachmentFiledMap.get("sourceBillPkId");
        Object sourceEntryPkId = attachmentFiledMap.get("sourceEntryPkId");
        String sourceAttKey = (String)attachmentFiledMap.get("sourceAttKey");
        String sourceAppId = (String)attachmentFiledMap.get("sourceAppId");
        String sAccountId = (String)attachmentFiledMap.get("sAccountId");
        String sTenantCode = (String)attachmentFiledMap.get("sTenantCode");
        String sourcePath = (String)attachmentFiledMap.get("url");
        LocaleString fileNameLocaleString = (LocaleString)attachmentFiledMap.get("name");
        String sourceAttachmentname = (String)fileNameLocaleString.get((Object)Lang.get().toString());
        String uploadPath = CtAttachmentConvertHelper.genAttachmentFieldUploadPath(attPkId, sourceAttachmentname);
        CtAttachmentDownloadArgs downloadArgs = new CtAttachmentDownloadArgs(sourceEntityNum, sourceBillPkId, sourceAttKey, sourcePath, sourceAppId, sourceAttachmentname, uploadPath, sAccountId, sTenantCode);
        downloadArgs.setAttParentPkId(sourceEntryPkId);
        MainEntityType attachmentSyncLogType = EntityMetadataCache.getDataEntityType((String)"bos_ctbotp_attsynclog");
        DynamicObject attachmentSyncLog = new DynamicObject((DynamicObjectType)attachmentSyncLogType);
        attachmentSyncLog.set("id", (Object)attsynclogId);
        Object tBillId = attachmentFiledMap.get("tbillid");
        attachmentSyncLog.set("tsynclogid", (Object)tSyncLogIdMapping.get(tBillId));
        attachmentSyncLog.set("tbillid", tBillId);
        attachmentSyncLog.set("atttype", (Object)2);
        attachmentSyncLog.set("attpkid", attachmentFiledMap.get("id"));
        attachmentSyncLog.set("param_tag", (Object)SerializationUtils.toJsonString((Object)((Object)downloadArgs)));
        attachmentSyncLog.set("status", (Object)0);
        attachmentSyncLog.set("creater", (Object)RequestContext.get().getCurrUserId());
        return attachmentSyncLog;
    }

    private static LocaleString getFileNameLocalString(Map<String, Object> attachmentFiledMap) {
        LocaleString filenameLocaleString = new LocaleString("DEFAULTFILENAME");
        if (!(attachmentFiledMap.get("multilanguagetext") instanceof List)) {
            return filenameLocaleString;
        }
        List fileNameList = (List)attachmentFiledMap.get("multilanguagetext");
        for (Map fileMap : fileNameList) {
            Object localeid = fileMap.get("localeid");
            Object fileName = fileMap.get("name");
            filenameLocaleString.put(String.valueOf(localeid), (Object)String.valueOf(fileName));
        }
        return filenameLocaleString;
    }

    private static Object[] createAttachmentForAttField(List<Map<String, Object>> attachmentFiledMapList) {
        MainEntityType attachmentPanelEntityType = EntityMetadataCache.getDataEntityType((String)"bd_attachment");
        List<DynamicObject> attachmentFieldObjList = CtAttachmentConvertHelper.convertAttachmentMapsToDynObjs(attachmentFiledMapList, attachmentPanelEntityType);
        if (attachmentFieldObjList.size() > 0) {
            DynamicObject[] dynamicObjects = attachmentFieldObjList.toArray(new DynamicObject[0]);
            return SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        return null;
    }

    private static void batchClearAttachmentFiledData(CtSaveAttachmentFieldSetValueRequest request, List<Map<String, Object>> attachmentFiledMapList, CtSaveContext context) {
        String attFieldTableName = request.getTargetAttachmentProp().getAlias();
        if (StringUtils.isBlank((CharSequence)attFieldTableName)) {
            return;
        }
        String tgtEntityNum = context.getCtSaveArgs().gettEntityKey();
        DynamicObject tgtBillObj = BusinessDataServiceHelper.loadSingleFromCache((Object)request.getTargetBillId(), (String)tgtEntityNum);
        if (tgtBillObj == null) {
            return;
        }
        AttachmentProp attachmentProp = request.getTargetAttachmentProp();
        ArrayList<Object> attFieldPkList = new ArrayList<Object>();
        HashSet<String> attUrlSet = new HashSet<String>();
        HashSet<Object> attBaseSet = new HashSet<Object>();
        if (attachmentProp.getParent() instanceof SubEntryType) {
            DynamicObjectCollection entryEntityCol = tgtBillObj.getDynamicObjectCollection(attachmentProp.getParent().getParent().getName());
            for (DynamicObject entryRowDynObj : entryEntityCol) {
                DynamicObjectCollection subEntryEntityCol = entryRowDynObj.getDynamicObjectCollection(attachmentProp.getParent().getName());
                for (DynamicObject subEntryRowDynObj : subEntryEntityCol) {
                    CtAttachmentConvertHelper.collectAttFieldRemoveInfo(subEntryRowDynObj, attachmentProp, attFieldPkList, attUrlSet, attBaseSet);
                }
            }
            return;
        }
        if (attachmentProp.getParent() instanceof EntryType) {
            DynamicObjectCollection entryEntityCol = tgtBillObj.getDynamicObjectCollection(attachmentProp.getParent().getName());
            for (DynamicObject entryRowDynObj : entryEntityCol) {
                CtAttachmentConvertHelper.collectAttFieldRemoveInfo(entryRowDynObj, attachmentProp, attFieldPkList, attUrlSet, attBaseSet);
            }
            return;
        }
        CtAttachmentConvertHelper.collectAttFieldRemoveInfo(tgtBillObj, attachmentProp, attFieldPkList, attUrlSet, attBaseSet);
        if (CollectionUtils.isNotEmpty(attFieldPkList)) {
            CtAttachmentConvertHelper.removeRelateTable(tgtEntityNum, attFieldTableName, attFieldPkList);
        }
        if (CollectionUtils.isNotEmpty(attBaseSet)) {
            DeleteServiceHelper.delete((String)"bd_attachment", (QFilter[])new QFilter[]{new QFilter("id", "in", attBaseSet)});
        }
        try {
            if (CollectionUtils.isNotEmpty(attUrlSet)) {
                for (String url : attUrlSet) {
                    FileServiceFactory.getAttachmentFileService().delete(url);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("remove att error : " + e));
        }
    }

    private static void collectAttFieldRemoveInfo(DynamicObject tgtBillObj, AttachmentProp attachmentProp, List<Object> attFieldPkList, Set<String> attUrlSet, Set<Object> attBaseSet) {
        Object attachmentCollection = attachmentProp.getValue((Object)tgtBillObj);
        if (attachmentCollection instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection attachmentDynCollection = (MulBasedataDynamicObjectCollection)attachmentCollection;
            for (DynamicObject attDynObj : attachmentDynCollection) {
                attFieldPkList.add(attDynObj.getPkValue());
                attUrlSet.add(attDynObj.getDynamicObject("fbasedataid").getString("url"));
                attBaseSet.add(attDynObj.get("fbasedataid_id"));
            }
        }
    }

    private static void removeRelateTable(String formId, String tableName, List<Object> attFieldPkList) {
        SqlParameter[] sqlParams = new SqlParameter[attFieldPkList.size()];
        StringBuilder sql = new StringBuilder("DELETE FROM ").append(tableName).append(" WHERE FPKID in ( ");
        for (int i = 0; i < attFieldPkList.size(); ++i) {
            sql.append(" ?, ");
            sqlParams[i] = new SqlParameter(":FPKID", -5, attFieldPkList.get(i));
        }
        sql.deleteCharAt(sql.lastIndexOf(","));
        sql.append(" ) ");
        CtAttachmentConvertHelper.executeDeleteSql(formId, sql.toString(), sqlParams);
    }

    private static void executeDeleteSql(String formId, String sql, SqlParameter[] sqlParams) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        DBRoute dBRoute = new DBRoute(type.getDBRouteKey());
        DB.execute((DBRoute)dBRoute, (String)sql, (Object[])sqlParams);
    }
}

