/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.sync.TSyncLogService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtConvertRuleCache;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.constants.CtSyncLogConst;
import kd.bos.entity.ctbotp.constants.SyncStatusEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.runtime.CtSaveArgs;
import kd.bos.entity.ctbotp.runtime.CtSaveOperationResult;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.BillInfoManage;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.CtSaveResultManager;
import kd.bos.service.ctbotp.save.actions.AbstractCtSaveAction;
import kd.bos.service.ctbotp.save.actions.CtConvertToDynamicObAction;
import kd.bos.service.ctbotp.save.actions.CtCreateSavePlugAction;
import kd.bos.service.ctbotp.save.actions.CtCreateTSyncLogAction;
import kd.bos.service.ctbotp.save.actions.CtInitAction;
import kd.bos.service.ctbotp.save.actions.CtSaveAction;
import kd.bos.service.ctbotp.save.actions.CtSaveAgainCheckAction;
import kd.bos.service.ctbotp.save.actions.CtSaveBillRouteAction;
import kd.bos.service.ctbotp.save.actions.CtSaveDataMutexAction;
import kd.bos.service.ctbotp.save.actions.CtSaveSyncRouteAction;
import kd.bos.service.ctbotp.save.batchactions.CtBatchConvertToDynamicObAction;
import kd.bos.service.ctbotp.save.batchactions.CtBatchCreateTSyncLogAction;
import kd.bos.service.ctbotp.save.batchactions.CtBatchInitAction;
import kd.bos.service.ctbotp.save.batchactions.CtBatchSaveAgainCheckAction;
import kd.bos.service.ctbotp.utils.SyncRuleRecUtil;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtSaveEngine {
    private static final Log log = LogFactory.getLog((String)"ConvertEngine");
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-ctbotp";
    private List<AbstractCtSaveAction> pushActions;

    public void syncData() {
        CtSaveArgs ctPushArgs = new CtSaveArgs();
        this.ctSave(ctPushArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtSaveOperationResult ctSave(CtSaveArgs args) {
        log.info("begin ctSave:" + args.getRuleId() + "|" + args.getRuleVerId() + "|" + args.getRuleExtVerId());
        CtSaveOperationResult result = new CtSaveOperationResult();
        CtSaveContext context = this.createContext(args);
        CtSaveResultManager resultManager = new CtSaveResultManager();
        try {
            this.checkParams(context, resultManager);
            List<AbstractCtSaveAction> runAction = null;
            runAction = this.createSaveActions(context, resultManager);
            for (AbstractCtSaveAction action : runAction) {
                action.action();
            }
        }
        catch (KDBizException exp) {
            result.setException(true);
            result.setSuccess(false);
            result.setMessage(JSON.toJSONString((Object)((Object)exp)));
            log.warn((Throwable)exp);
        }
        catch (Exception exp) {
            result.setException(true);
            result.setSuccess(false);
            result.setMessage(JSON.toJSONString((Object)exp));
            for (Long id : context.getBillIdMaps().keySet()) {
                resultManager.getReporter().addFailId(id, JSON.toJSONString((Object)exp).substring(0, 500));
            }
            log.warn((Throwable)exp);
        }
        finally {
            CtSaveDataMutexAction.releasePushMutex(context.getTargetMainType().getName(), context.getDataMutexKeys());
        }
        this.merageResult(result, resultManager, context);
        this.updateTSyncLog(context, resultManager, result);
        return result;
    }

    private void checkParams(CtSaveContext context, CtSaveResultManager resultManager) {
        if (context.getRule() == null) {
            String notFoundMsg = String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8f6c\u6362\u89c4\u5219\uff0c\u8f6c\u6362\u89c4\u5219id\uff1a%s", (String)"CtSaveEngine_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), context.getCtSaveArgs().getRuleId());
            throw new KDBizException(notFoundMsg);
        }
    }

    private void merageResult(CtSaveOperationResult result, CtSaveResultManager resultManager, CtSaveContext context) {
        result.setReporter(resultManager.getReporter());
        Set successIds = new HashSet(16);
        if (resultManager != null && resultManager.getReporter() != null && CollectionUtils.isNotEmpty((Collection)resultManager.getReporter().getSuccessIds())) {
            successIds = resultManager.getReporter().getSuccessIds();
            Map<Long, String> billNoMap = BillInfoManage.loadBillNoFromDB(context.getCtSaveArgs().gettEntityKey(), successIds.toArray());
            if (MapUtils.isEmpty(billNoMap)) {
                return;
            }
            resultManager.settBillNoMap(billNoMap);
        }
        result.settBillNoMap(resultManager.gettBillNoMap());
        result.setSuccess(resultManager.getTargetReporter().isSuccess());
        this.filterSetBillLks(result, resultManager, context);
    }

    private void filterSetBillLks(CtSaveOperationResult result, CtSaveResultManager resultManager, CtSaveContext context) {
        if (resultManager == null) {
            return;
        }
        if (resultManager.getReporter() == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)resultManager.getReporter().getSuccessIds())) {
            return;
        }
        List<CtBillLk> ctBillLks = resultManager.getCtBillLks();
        ArrayList<CtBillLk> ctBillLkList = new ArrayList<CtBillLk>(16);
        Set successIds = resultManager.getReporter().getSuccessIds();
        for (CtBillLk ctBillLk : ctBillLks) {
            if (!CollectionUtils.isNotEmpty((Collection)successIds) || !successIds.contains(ctBillLk.getTBillId())) continue;
            ctBillLkList.add(ctBillLk);
        }
        result.setCtBillLks(ctBillLkList);
    }

    private void updateTSyncLog(CtSaveContext context, CtSaveResultManager ctSaveResultManager, CtSaveOperationResult ctSaveOperationResult) {
        String errorMsg = null;
        if (ctSaveOperationResult.isException()) {
            errorMsg = ctSaveOperationResult.getMessage();
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)CtSyncLogConst.SYNC_FORMID_T);
        if (CollectionUtils.isEmpty(context.gettSyncLogs())) {
            return;
        }
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(context.gettSyncLogs().size());
        for (SyncLog tSyncLog : context.gettSyncLogs()) {
            DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
            obj.set("id", (Object)tSyncLog.getId());
            obj.set("ttenantcode", (Object)RequestContext.get().getTenantId());
            obj.set("tAccountId", (Object)RequestContext.get().getAccountId());
            Long tbillId = tSyncLog.getTbillId();
            obj.set("tbillno", (Object)ctSaveResultManager.gettBillNoMap().get(tbillId));
            if (!ctSaveOperationResult.isException()) {
                Set successIds = ctSaveResultManager.getReporter().getSuccessIds();
                Map errorIds = ctSaveResultManager.getReporter().getFailIds();
                if (successIds.contains(tbillId)) {
                    obj.set("status", (Object)SyncStatusEnum.S.getStatus());
                } else {
                    obj.set("desc_tag", errorIds.get(tSyncLog.getSbillId()));
                    obj.set("status", (Object)SyncStatusEnum.F.getStatus());
                }
            } else {
                obj.set("desc_tag", (Object)errorMsg);
                obj.set("status", (Object)SyncStatusEnum.F.getStatus());
            }
            obj.set("updatetime", (Object)new Date());
            dynamicObjects.add(obj);
        }
        if (CollectionUtils.isNotEmpty(dynamicObjects)) {
            TSyncLogService.create().update(dynamicObjects);
        }
    }

    private CtSaveContext createContext(CtSaveArgs args) {
        CtSaveContext context = new CtSaveContext();
        context.setCtSaveArgs(args);
        BillEntityType tgtMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)args.gettEntityKey());
        context.setTargetMainType(tgtMainType);
        CtConvertRuleElement ctConvertRuleElement = this.loadRule(context);
        context.setRule(ctConvertRuleElement);
        context.setCheckPushAgain(args.isCheckPushAgain());
        return context;
    }

    private CtConvertRuleElement loadRule(CtSaveContext context) {
        CtSaveArgs args = context.getCtSaveArgs();
        if (args != null && StringUtils.isNotBlank((CharSequence)context.getCtSaveArgs().getRuleId())) {
            CtConvertRuleElement rule = CtConvertRuleCache.loadRuleByVerId((String)args.getRuleId(), (String)String.valueOf(args.getRuleVerId()), (String)String.valueOf(args.getRuleExtVerId()));
            if (rule == null) {
                return null;
            }
            SyncRuleRecUtil.updateSyncRuleRec(rule);
            return rule;
        }
        return null;
    }

    private List<AbstractCtSaveAction> createSaveActions(CtSaveContext context, CtSaveResultManager ctSaveResultManager) {
        if (SyncTypeEnum.FORWARD.getValue().equals(context.getCtSaveArgs().getSyncType())) {
            if (context.getCtSaveArgs().isBatchPush()) {
                return this.createSaveForwardBatchActions(context, ctSaveResultManager);
            }
            if (context.getRule().isMirrorSync() && context.getRule().isMirrorUpdate()) {
                return this.createSaveCoverActions(context, ctSaveResultManager);
            }
            return this.createSaveForwardActions(context, ctSaveResultManager);
        }
        return this.createSaveReverseActions(context, ctSaveResultManager);
    }

    private List<AbstractCtSaveAction> createSaveForwardActions(CtSaveContext context, CtSaveResultManager ctSaveResultManager) {
        if (this.pushActions == null) {
            this.pushActions = new ArrayList<AbstractCtSaveAction>(8);
            this.pushActions.add(new CtInitAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveSyncRouteAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveDataMutexAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveAgainCheckAction(context, ctSaveResultManager));
            this.pushActions.add(new CtCreateTSyncLogAction(context, ctSaveResultManager));
            this.pushActions.add(new CtCreateSavePlugAction(context, ctSaveResultManager));
            this.pushActions.add(new CtConvertToDynamicObAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveBillRouteAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveAction(context, ctSaveResultManager));
        }
        return this.pushActions;
    }

    private List<AbstractCtSaveAction> createSaveForwardBatchActions(CtSaveContext context, CtSaveResultManager ctSaveResultManager) {
        if (this.pushActions == null) {
            this.pushActions = new ArrayList<AbstractCtSaveAction>(8);
            this.pushActions.add(new CtBatchInitAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveSyncRouteAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveDataMutexAction(context, ctSaveResultManager));
            this.pushActions.add(new CtBatchSaveAgainCheckAction(context, ctSaveResultManager));
            this.pushActions.add(new CtBatchCreateTSyncLogAction(context, ctSaveResultManager));
            this.pushActions.add(new CtCreateSavePlugAction(context, ctSaveResultManager));
            this.pushActions.add(new CtBatchConvertToDynamicObAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveAction(context, ctSaveResultManager));
        }
        return this.pushActions;
    }

    private List<AbstractCtSaveAction> createSaveReverseActions(CtSaveContext context, CtSaveResultManager ctSaveResultManager) {
        if (this.pushActions == null) {
            this.pushActions = new ArrayList<AbstractCtSaveAction>(8);
            this.pushActions.add(new CtInitAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveDataMutexAction(context, ctSaveResultManager));
            this.pushActions.add(new CtCreateTSyncLogAction(context, ctSaveResultManager));
            this.pushActions.add(new CtCreateSavePlugAction(context, ctSaveResultManager));
            this.pushActions.add(new CtConvertToDynamicObAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveAction(context, ctSaveResultManager));
        }
        return this.pushActions;
    }

    private List<AbstractCtSaveAction> createSaveCoverActions(CtSaveContext context, CtSaveResultManager ctSaveResultManager) {
        if (this.pushActions == null) {
            this.pushActions = new ArrayList<AbstractCtSaveAction>(8);
            this.pushActions.add(new CtInitAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveSyncRouteAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveDataMutexAction(context, ctSaveResultManager));
            this.pushActions.add(new CtCreateTSyncLogAction(context, ctSaveResultManager));
            this.pushActions.add(new CtCreateSavePlugAction(context, ctSaveResultManager));
            this.pushActions.add(new CtConvertToDynamicObAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveBillRouteAction(context, ctSaveResultManager));
            this.pushActions.add(new CtSaveAction(context, ctSaveResultManager));
        }
        return this.pushActions;
    }
}

