/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.BillLayoutSchemeService;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.bill.BillLayoutParameter;
import kd.bos.entity.bill.BillLayoutSchemeAssignEntity;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.CtBillTypeMapParser;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtDataEntityField;
import kd.bos.entity.ctbotp.constants.SyncModelEnum;
import kd.bos.entity.ctbotp.constants.SyncNodeEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtBillTcLk;
import kd.bos.entity.ctbotp.plugin.save.args.AfterBatchSetBaseDataEventArg;
import kd.bos.entity.ctbotp.plugin.save.args.BeforeFieldMappingEventArgs;
import kd.bos.entity.ctbotp.plugin.save.args.BeforeSaveEventArgs;
import kd.bos.entity.ctbotp.runtime.CtReportManager;
import kd.bos.entity.ctbotp.runtime.CtSaveArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IDefValueProvider;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.ctbotp.CtConvertRuleVer;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.business.datamodel.CtBillDefValueProvider;
import kd.bos.service.ctbotp.business.datamodel.CtBillTypeDefValueProvider;
import kd.bos.service.ctbotp.business.datamodel.CtDrawDataModel;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.mapping.ICtMappingField;
import kd.bos.service.ctbotp.convert.report.ICtBuildDetailReport;
import kd.bos.service.ctbotp.helper.CtTrackerTypes;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.CtSaveResultManager;
import kd.bos.service.ctbotp.save.actions.AbstractCtSaveAction;
import kd.bos.service.ctbotp.save.batchrequest.CtSaveBatchRequestManager;
import kd.bos.service.ctbotp.save.mapping.ICtSaveMappingField;
import kd.bos.service.ctbotp.save.org.CtSaveSetMainOrgManager;
import kd.bos.service.ctbotp.utils.CtBillInfoUtils;
import kd.bos.service.metadata.CtBOTPMetadataReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtConvertToDynamicObAction
extends AbstractCtSaveAction {
    private static final Log log = LogFactory.getLog(CtConvertToDynamicObAction.class);
    private static final String DEFAULT_BILLTYPE_ID = "DEFAULT_BILLTYPE_ID";
    private static final String THREAD_CACHE_KEY_BLANK_DATAENTITY = "botp_blank_dataentity";
    private Map<String, DynamicObject> blankDataEntitys = new HashMap<String, DynamicObject>();
    private CtLinkEntityMap linkEntityMap = null;
    private CtSaveBatchRequestManager batchRequestManager;
    protected CtDrawDataModel modelProxy;
    private BillEntityType targetMainType = null;
    private MainOrgProp mainOrgProp = null;
    private Long defOrgId = null;
    private Long tTableId;
    private ICtBuildDetailReport buildReport = null;
    private ICtMappingField mappingBillType = null;
    private ICtGetValueMode srcBillTypeReader = null;
    private BillTypeProp billTypeProp = null;
    private Map<Object, DynamicObject> targetBillTypeObjs = null;
    private CtBillTypeMapParser billTypeMapParser = null;
    private IDataEntityType billLinkType;
    private List<CtDataEntity> ctDataEntities;
    private String syncType;
    private Long ruleVerPkId;
    public static final String ConvExtDataKey_IsNewEntity = "isNewEntity";
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-ctbotp";
    private Map<Object, DynamicObject> coverDynamicObject = new HashMap<Object, DynamicObject>(8);
    private CtSaveSetMainOrgManager setMainOrgManager;

    private void initVar() {
        this.batchRequestManager = this.resultManager.getBatchRequestManager();
        this.batchRequestManager.setCtSaveResultManager(this.resultManager);
        this.batchRequestManager.initialize(this.context, this.resultManager);
        TableDefine tableDefine = CtConvertMetaServiceHelper.loadMainTableDefine((String)this.context.getTargetMainType().getName());
        this.tTableId = tableDefine.getTableId();
        this.targetMainType = this.context.getTargetMainType();
        if (StringUtils.isNotBlank((CharSequence)this.targetMainType.getMainOrg())) {
            this.mainOrgProp = (MainOrgProp)this.targetMainType.getProperty(this.targetMainType.getMainOrg());
        }
        for (IDataEntityProperty property : this.targetMainType.getProperties()) {
            if (!(property instanceof BillTypeProp)) continue;
            this.billTypeProp = (BillTypeProp)property;
            break;
        }
        this.billLinkType = OrmUtils.getDataEntityType(CtBillLk.class);
        this.billTypeMapParser = new CtBillTypeMapParser();
        this.targetBillTypeObjs = this.loadBillTypeObjs();
        this.ctDataEntities = this.context.getCtSaveArgs().getData();
        this.syncType = this.context.getCtSaveArgs().getSyncType();
        this.ruleVerPkId = this.getRuleVerPkId(this.context.getCtSaveArgs());
        this.modelProxy = this.createDataModel();
        this.setMainOrgManager = new CtSaveSetMainOrgManager(this.context, this.resultManager, this.mainOrgProp, this.modelProxy, this.defOrgId, this.buildReport);
    }

    private Long getRuleVerPkId(CtSaveArgs args) {
        CtConvertRuleVer ruleVer = CtBOTPMetadataReader.loadCtConvertRuleByVerId((String)args.getRuleId(), (String)(args.getRuleVerId() == null ? null : String.valueOf(args.getRuleVerId())), args.getRuleExtVerId() == null ? null : String.valueOf(args.getRuleExtVerId()));
        return ruleVer.getFid();
    }

    public CtConvertToDynamicObAction(CtSaveContext context, CtSaveResultManager ctSaveResultManager) {
        super(context, ctSaveResultManager);
    }

    private CtDrawDataModel createDataModel() {
        HashMap services = new HashMap();
        String targetEntityNumber = this.context.getCtSaveArgs().gettEntityKey();
        String pageId = UUID.randomUUID().toString();
        CtDrawDataModel model = new CtDrawDataModel(targetEntityNumber, pageId, services);
        return model;
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.initVar();
        List<Object> dynamicObjects = new ArrayList<DynamicObject>(16);
        ArrayList<CtBillLk> ctBillLks = new ArrayList<CtBillLk>();
        BeforeFieldMappingEventArgs beforeFieldMappingEventArgs = new BeforeFieldMappingEventArgs(this.ctDataEntities);
        this.context.getPlugInProxy().firebeBoreFieldMapping(beforeFieldMappingEventArgs);
        this.modelProxy.beginInit();
        this.collectCoverBill(this.ctDataEntities);
        String notFoundMsg = ResManager.loadKDString((String)"\u53cd\u5199\u8986\u76d6\u65f6\u901a\u8fc7id\u627e\u4e0d\u5230\u76ee\u6807\u5355\u6570\u636e\u3002", (String)"CtConvertToDynamicObAction_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
        String notSaveStatusMsg = ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u4e0d\u80fd\u955c\u50cf\u66f4\u65b0\u3002", (String)"CtConvertToDynamicObAction_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
        String failCreateDataMsg = ResManager.loadKDString((String)"\u521b\u5efa\u76ee\u6807\u5355\u6570\u636e\u5305\u5931\u8d25\u3002", (String)"CtConvertToDynamicObAction_3", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
        String logOrgMsg = ResManager.loadKDString((String)"\u521b\u5efa\u6570\u636e\u5305\u4e4b\u540e\u83b7\u53d6\u6570\u636e\u5305\u4e2d\u7ec4\u7ec7\uff1a%s", (String)"CtConvertToDynamicObAction_4", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
        String failCreateOrgMsg = ResManager.loadKDString((String)"\u76ee\u6807\u5355\u4e3b\u7ec4\u7ec7\u8d4b\u503c\u5931\u8d25\u3002", (String)"CtConvertToDynamicObAction_5", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
        for (CtDataEntity ctDataEntity : this.ctDataEntities) {
            DynamicObject headObj = null;
            Object id = null;
            Long sBillId = null;
            if (SyncTypeEnum.FORWARD.getValue().equals(this.syncType)) {
                if (ctDataEntity.isConver()) {
                    if (!this.coverDynamicObject.containsKey(ctDataEntity.getId())) {
                        this.addErrorMsg(this.resultManager, ctDataEntity, notFoundMsg);
                        continue;
                    }
                    if (!CtBillInfoUtils.isSaveStatusBill(this.coverDynamicObject.get(ctDataEntity.getId()))) {
                        this.addErrorMsg(this.resultManager, ctDataEntity, notSaveStatusMsg);
                        continue;
                    }
                    headObj = this.coverDynamicObject.get(ctDataEntity.getId());
                    id = headObj.getPkValue();
                } else {
                    Long mainOrgId;
                    StringBuilder errMessage = new StringBuilder();
                    if (!this.createNewData(ctDataEntity, errMessage)) {
                        if (StringUtils.isNotBlank((CharSequence)errMessage.toString())) {
                            failCreateDataMsg = errMessage.toString();
                        }
                        this.addErrorMsg(this.resultManager, ctDataEntity, failCreateDataMsg);
                        continue;
                    }
                    headObj = this.modelProxy.getDataEntity();
                    if (StringUtils.isNotBlank((CharSequence)this.context.getTargetMainType().getMainOrg()) && headObj != null && ((mainOrgId = Long.valueOf(headObj.getLong(this.context.getTargetMainType().getMainOrg() + "_id"))) == null || mainOrgId == 0L)) {
                        log.info(String.format(logOrgMsg, mainOrgId));
                        this.addErrorMsg(this.resultManager, ctDataEntity, failCreateOrgMsg);
                        continue;
                    }
                    id = this.genTargetBillId((MainEntityType)this.context.getTargetMainType(), headObj, ctDataEntity.getId());
                }
            } else {
                headObj = new DynamicObject((DynamicObjectType)this.targetMainType);
                CtBillLk ctBillLk = this.genCtBillLk(ctDataEntity);
                id = ctBillLk.getTBillId();
                sBillId = ctBillLk.getSBillId();
                this.setTargetBillId((MainEntityType)this.context.getTargetMainType(), headObj, ctBillLk.getTBillId());
            }
            if (SyncTypeEnum.FORWARD.getValue().equals(this.context.getCtSaveArgs().getSyncType()) && headObj != null) {
                sBillId = this.collectLinks(ctBillLks, ctDataEntity, Long.parseLong(headObj.getPkValue().toString()));
            }
            if (StringUtils.isNotBlank((CharSequence)this.context.getTargetMainType().getMainOrg()) && headObj != null) {
                log.info("\u5b57\u6bb5\u6620\u5c04\u4e4b\u524d\u83b7\u53d6\u6570\u636e\u5305\u4e2d\u7ec4\u7ec7\uff1a" + headObj.getString(this.context.getTargetMainType().getMainOrg() + "_id"));
            }
            this.modelProxy.draw(headObj);
            if (SyncTypeEnum.FORWARD.getValue().equals(this.syncType)) {
                this.deleteEntityRows();
            }
            for (CtDataEntityField ctDataEntityField : ctDataEntity.getFields()) {
                ICtSaveMappingField iCtSaveMappingField = ICtSaveMappingField.create(this.context, ctDataEntityField);
                iCtSaveMappingField.calcAndMappingValue(headObj, ctDataEntityField.getValue(), this.batchRequestManager);
            }
            if (StringUtils.isNotBlank((CharSequence)this.context.getTargetMainType().getMainOrg()) && headObj != null) {
                log.info("\u5b57\u6bb5\u6620\u5c04\u4e4b\u540e\u83b7\u53d6\u6570\u636e\u5305\u4e2d\u7ec4\u7ec7\uff1a" + headObj.getString(this.context.getTargetMainType().getMainOrg() + "_id"));
            }
            if (SyncTypeEnum.FORWARD.getValue().equals(this.syncType)) {
                this.createClildEntity(this.context.getTargetMainType().getName(), headObj, ctDataEntity, id);
            }
            dynamicObjects.add(headObj);
            this.context.getBillMaps().put(sBillId, (Long)id);
        }
        this.modelProxy.endInit();
        this.doBatchRequest(dynamicObjects);
        if (StringUtils.isNotBlank((CharSequence)this.context.getTargetMainType().getMainOrg()) && CollectionUtils.isNotEmpty(dynamicObjects)) {
            log.info("\u6279\u91cf\u5904\u7406\u4e4b\u540e\u6570\u636e\u5305\u4e2d\u7ec4\u7ec71\uff1a" + ((DynamicObject)dynamicObjects.get(0)).getString(this.context.getTargetMainType().getMainOrg() + "_id"));
        }
        this.filterFail(dynamicObjects, ctBillLks);
        BeforeSaveEventArgs beforeEventArgs = new BeforeSaveEventArgs(dynamicObjects);
        this.context.getPlugInProxy().fireBeforeSave(beforeEventArgs);
        dynamicObjects = beforeEventArgs.getDynamicObjects();
        this.resultManager.setCtBillLks(ctBillLks);
        this.resultManager.setTargetDataObjects(dynamicObjects);
    }

    private List<Long> getSBillIds(CtDataEntity ctDataEntity) {
        List ctDataEntities = ctDataEntity.getChildEntity("billhead_lk");
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (CtDataEntity ctLink : ctDataEntities) {
            if (CollectionUtils.isEmpty((Collection)ctLink.getFields())) continue;
            for (CtDataEntityField ctDataEntityField : ctLink.getFields()) {
                if (!"sBillId".equals(ctDataEntityField.getName())) continue;
                Long sBillId = Long.valueOf(ctDataEntityField.getValue().getValue());
                billIds.add(sBillId);
            }
        }
        return billIds;
    }

    private void collectCoverBill(List<CtDataEntity> ctDataEntities) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (CtDataEntity ctDataEntity : ctDataEntities) {
            if (!ctDataEntity.isConver()) continue;
            ids.add(ctDataEntity.getId());
        }
        Map<Object, DynamicObject> dynamicObjectMap = this.modelProxy.loadReferenceDataBatch((DynamicObjectType)this.targetMainType, ids.toArray(new Object[0]));
        this.coverDynamicObject = dynamicObjectMap;
    }

    private void addErrorMsg(CtSaveResultManager resultManager, CtDataEntity ctDataEntity, String msg) {
        List<Long> sBillIds = this.getSBillIds(ctDataEntity);
        for (Long id : sBillIds) {
            resultManager.getReporter().getFailIds().put(id, msg);
        }
    }

    private void filterFail(List<DynamicObject> dynamicObjects, List<CtBillLk> ctBillLks) {
        CtReportManager targetReporter = this.batchRequestManager.getCtSaveResultManager().getTargetReporter();
        if (targetReporter != null && MapUtils.isNotEmpty((Map)targetReporter.getFailIds())) {
            Iterator<DynamicObject> iterator = dynamicObjects.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = iterator.next();
                Object id = dynamicObject.getPkValue();
                if (!targetReporter.getFailIds().containsKey(id)) continue;
                iterator.remove();
                if (!CollectionUtils.isNotEmpty(ctBillLks)) continue;
                ctBillLks.removeIf(a -> Objects.equals(a.getTBillId(), id));
            }
            CtReportManager ctReportManager = this.batchRequestManager.getCtSaveResultManager().getReporter();
            for (Map.Entry entry : targetReporter.getFailIds().entrySet()) {
                if (!MapUtils.isNotEmpty(this.context.getBillIdMaps())) continue;
                Set<Long> sIds = this.context.getBillIdMaps().get(entry.getKey());
                for (Long id : sIds) {
                    String errorMsg = (String)entry.getValue();
                    ctReportManager.getFailIds().put(id, errorMsg);
                }
            }
        }
        this.batchRequestManager.getCtSaveResultManager().setCtBillLks(ctBillLks);
    }

    private ICtSaveMappingField getMainOrgMapping(CtDataEntity ctDataEntity) {
        ICtSaveMappingField ctSaveMappingField = null;
        for (CtDataEntityField ctDataEntityField : ctDataEntity.getFields()) {
            if (StringUtils.isBlank((CharSequence)this.context.getTargetMainType().getMainOrg())) {
                return null;
            }
            if (!this.context.getTargetMainType().getMainOrg().equals(ctDataEntityField.getName())) continue;
            ctSaveMappingField = ICtSaveMappingField.create(this.context, ctDataEntityField);
            return ctSaveMappingField;
        }
        return null;
    }

    private Long collectLinks(List<CtBillLk> ctBillLks, CtDataEntity ctDataEntity, Long tBillId) {
        List ctDataEntities = ctDataEntity.getChildEntity("billhead_lk");
        Long sbillId = null;
        for (CtDataEntity ctLink : ctDataEntities) {
            CtBillLk ctBillLk = new CtBillLk();
            if (CollectionUtils.isNotEmpty((Collection)ctLink.getFields())) {
                for (CtDataEntityField ctDataEntityField : ctLink.getFields()) {
                    switch (ctDataEntityField.getName()) {
                        case "sBillId": {
                            Long sBillId = Long.valueOf(String.valueOf(ctDataEntityField.getValue().getValue()));
                            ctBillLk.setSBillId(sBillId);
                            sbillId = sBillId;
                            break;
                        }
                        case "sTenantCode": {
                            ctBillLk.setsTenantCode(String.valueOf(ctDataEntityField.getValue().getValue()));
                            break;
                        }
                        case "sAccountId": {
                            ctBillLk.setsAccountId(String.valueOf(ctDataEntityField.getValue().getValue()));
                            break;
                        }
                        case "sEntityKey": {
                            ctBillLk.setsEntityKey(String.valueOf(ctDataEntityField.getValue().getValue()));
                            break;
                        }
                        case "sTableId": {
                            ctBillLk.setSTableId(Long.valueOf(ctDataEntityField.getValue().getValue()));
                            break;
                        }
                    }
                }
            }
            ctBillLk.setTBillId(tBillId);
            ctBillLk.settEntityKey(this.context.getTargetMainType().getName());
            ctBillLk.setTTableId(this.tTableId);
            ctBillLk.settAccountId(RequestContext.get().getAccountId());
            ctBillLk.settTenantCode(RequestContext.get().getTenantId());
            ctBillLks.add(ctBillLk);
        }
        return sbillId;
    }

    private void splitErrorInfoByBill(Set<Object> pkIds, OperationResult saveResult, List<IOperateInfo> opFailInfos, Map<Object, List<IOperateInfo>> billErrors) {
        OperateErrorInfo errInfo;
        if (saveResult.getSuccessPkIds() != null && saveResult.getSuccessPkIds().isEmpty() && StringUtils.isNotBlank((CharSequence)saveResult.getMessage())) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(saveResult.getMessage());
            opFailInfos.add((IOperateInfo)errInfo);
        }
        for (IOperateInfo info : saveResult.getAllErrorOrValidateInfo()) {
            Object pkValue = info.getPkValue();
            if (!pkIds.contains(pkValue)) {
                opFailInfos.add(info);
                continue;
            }
            if (!billErrors.containsKey(pkValue)) {
                billErrors.put(pkValue, new ArrayList());
            }
            billErrors.get(pkValue).add(info);
        }
        if (opFailInfos.isEmpty()) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u7684\u4fdd\u5b58\u5931\u8d25\u3002", (String)"CtConvertToDynamicObAction_6", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            opFailInfos.add((IOperateInfo)errInfo);
        }
    }

    private void createClildEntity(String parentEntityKey, DynamicObject headObj, CtDataEntity ctDataEntity, Object tid) {
        boolean isConver = ctDataEntity.isConver();
        if (ctDataEntity == null || ctDataEntity.getChildEntitys() == null || ctDataEntity.getChildEntitys().size() == 0) {
            return;
        }
        for (Map.Entry dataMap : ctDataEntity.getChildEntitys().entrySet()) {
            String entryKey = (String)dataMap.getKey();
            List ctDataEntities = (List)dataMap.getValue();
            if (CollectionUtils.isEmpty((Collection)ctDataEntities) || "billhead_lk".equals(entryKey)) continue;
            String lkKey = parentEntityKey + "_lk";
            if (lkKey.equals(entryKey)) {
                List<CtBillTcLk> ctBillTcLks;
                if (ctDataEntity.isConver() || !CollectionUtils.isNotEmpty(ctBillTcLks = this.collectTcLks(ctDataEntities, headObj.getPkValue(), tid))) continue;
                this.resultManager.getTcLks().addAll(ctBillTcLks);
                continue;
            }
            int count = ctDataEntities.size();
            this.batchCreateNewEntryRow(entryKey, count);
            long[] ids = DB.genGlobalLongIds((int)count);
            int rowIndex = 0;
            for (CtDataEntity entryDataEntity : ctDataEntities) {
                DynamicObject entryObj = this.modelProxy.getEntryEntity(entryKey, rowIndex);
                ISimpleProperty primaryKey = entryObj.getDataEntityType().getPrimaryKey();
                long entryId = ids[rowIndex];
                entryDataEntity.setId(Long.valueOf(entryId));
                entryObj.set((IDataEntityProperty)primaryKey, (Object)entryId);
                for (CtDataEntityField ctDataEntityField : entryDataEntity.getFields()) {
                    ICtSaveMappingField iCtSaveMappingField = ICtSaveMappingField.create(this.context, ctDataEntityField);
                    iCtSaveMappingField.calcAndMappingValue(entryObj, ctDataEntityField.getValue(), this.batchRequestManager);
                }
                this.createClildSubEntry(entryKey, headObj, rowIndex, entryDataEntity, entryId, isConver);
                ++rowIndex;
            }
        }
    }

    private void deleteEntityRows() {
        Map entityTypeMap = this.modelProxy.getDataEntityType().getAllEntities();
        for (EntityType entityType : entityTypeMap.values()) {
            DynamicObjectCollection dynamicObjects;
            if (entityType instanceof BillEntityType || CollectionUtils.isEmpty((Collection)(dynamicObjects = this.modelProxy.getEntryEntity(entityType.getName())))) continue;
            if (entityType instanceof SubEntryType) {
                this.modelProxy.deleteEntryData(entityType.getName());
                continue;
            }
            if (!(entityType instanceof EntryType)) continue;
            this.modelProxy.deleteEntryData(entityType.getName());
        }
    }

    private List<CtBillTcLk> collectTcLks(List<CtDataEntity> ctDataEntities, Object id, Object tId) {
        ArrayList<CtBillTcLk> ctBillTcLks = new ArrayList<CtBillTcLk>(16);
        for (CtDataEntity ctLink : ctDataEntities) {
            CtBillTcLk ctBillTcLk = new CtBillTcLk();
            if (!CollectionUtils.isNotEmpty((Collection)ctLink.getFields())) continue;
            HashMap<String, Long> tableIdMap = new HashMap<String, Long>(16);
            for (CtDataEntityField ctDataEntityField : ctLink.getFields()) {
                switch (ctDataEntityField.getName()) {
                    case "sTenantCode": {
                        ctBillTcLk.setsTenantCode(String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "sAccountId": {
                        ctBillTcLk.setsAccountId(String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "sEntityKey": {
                        ctBillTcLk.setsEntityKey(String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "sTableId": {
                        ctBillTcLk.setsTableId(Long.parseLong(String.valueOf(ctDataEntityField.getValue().getValue())));
                        break;
                    }
                    case "sLkEntityKey": {
                        ctBillTcLk.setsLkEntityKey(String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "sLkTableId": {
                        Long sLkTableId = Long.valueOf(String.valueOf(ctDataEntityField.getValue().getValue()));
                        ctBillTcLk.setsLkTableId(sLkTableId.longValue());
                        break;
                    }
                    case "sBillId": {
                        Long sBillId = Long.valueOf(String.valueOf(ctDataEntityField.getValue().getValue()));
                        ctBillTcLk.setsBillId(sBillId.longValue());
                        break;
                    }
                    case "sId": {
                        Long sId = Long.valueOf(String.valueOf(ctDataEntityField.getValue().getValue()));
                        ctBillTcLk.setsId(sId.longValue());
                        break;
                    }
                    case "tTenantCode": {
                        ctBillTcLk.settTenantCode(String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "tAccountId": {
                        ctBillTcLk.settAccountId(String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "tEntityKey": {
                        String tEntityKey = String.valueOf(ctDataEntityField.getValue().getValue());
                        ctBillTcLk.settEntityKey(tEntityKey);
                        if (tableIdMap.containsKey(tEntityKey)) break;
                        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)this.context.getTargetMainType().getName(), (String)this.context.getTargetMainType().getName());
                        tableIdMap.put(tEntityKey, tableDefine.getTableId());
                        break;
                    }
                    case "tTableId": {
                        break;
                    }
                    case "tLkEntityKey": {
                        String tLkEntityKey = String.valueOf(ctDataEntityField.getValue().getValue());
                        ctBillTcLk.settLkEntityKey(String.valueOf(ctDataEntityField.getValue().getValue()));
                        if (tableIdMap.containsKey(tLkEntityKey)) break;
                        TableDefine loadTableDefine = EntityMetadataCache.loadTableDefine((String)this.context.getTargetMainType().getName(), (String)tLkEntityKey);
                        tableIdMap.put(tLkEntityKey, loadTableDefine.getTableId());
                        break;
                    }
                    case "tLkTableId": {
                        break;
                    }
                    case "tId": {
                        ctBillTcLk.settId(((Long)tId).longValue());
                        break;
                    }
                }
            }
            ctBillTcLk.settBillId(((Long)id).longValue());
            ctBillTcLk.settId(((Long)tId).longValue());
            ctBillTcLk.settTableId(((Long)tableIdMap.get(ctBillTcLk.gettEntityKey())).longValue());
            ctBillTcLk.settLkTableId(((Long)tableIdMap.get(ctBillTcLk.gettLkEntityKey())).longValue());
            boolean isMirrorSync = this.context.getRule().isMirrorSync();
            if (isMirrorSync) {
                ctBillTcLk.setSyncModel(SyncModelEnum.MIRROR.getValue());
            } else {
                ctBillTcLk.setSyncModel(SyncModelEnum.NORMAL.getValue());
            }
            ctBillTcLk.setRuleVerPkId(this.ruleVerPkId.longValue());
            ctBillTcLks.add(ctBillTcLk);
        }
        return ctBillTcLks;
    }

    private List<DynamicObject> collectTcLkDynamics(List<CtDataEntity> ctDataEntities, Object tId) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        CtTrackerTypes ctTrackerTypes = CtTrackerTypes.buildTrackerTypes(this.context.getTargetMainType());
        for (CtDataEntity ctLink : ctDataEntities) {
            DynamicObject row = new DynamicObject((DynamicObjectType)ctTrackerTypes.getEntryTrackerType());
            boolean isMirrorSync = this.context.getRule().isMirrorSync();
            if (isMirrorSync) {
                row.set("syncModel", (Object)SyncModelEnum.MIRROR.getValue());
            } else {
                row.set("syncModel", (Object)SyncModelEnum.NORMAL.getValue());
            }
            if (!CollectionUtils.isNotEmpty((Collection)ctLink.getFields())) continue;
            for (CtDataEntityField ctDataEntityField : ctLink.getFields()) {
                switch (ctDataEntityField.getName()) {
                    case "sTenantCode": {
                        ctTrackerTypes.getTc_sTenantCodeProp().setValueFast((Object)row, (Object)String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "sAccountId": {
                        ctTrackerTypes.getTc_sAccountIdProp().setValueFast((Object)row, (Object)String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "sEntityKey": {
                        ctTrackerTypes.getTc_sEntityKeyProp().setValueFast((Object)row, (Object)String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "sLkEntityKey": {
                        ctTrackerTypes.getTc_sLkEntityKeyProp().setValueFast((Object)row, (Object)String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "sLkTableId": {
                        Long sLkTableId = Long.valueOf(String.valueOf(ctDataEntityField.getValue().getValue()));
                        ctTrackerTypes.getTc_sLkTableIdProp().setValueFast((Object)row, (Object)sLkTableId);
                        break;
                    }
                    case "sBillId": {
                        Long sBillId = Long.valueOf(String.valueOf(ctDataEntityField.getValue().getValue()));
                        ctTrackerTypes.getTC_sBillIdProp().setValueFast((Object)row, (Object)sBillId);
                        break;
                    }
                    case "sId": {
                        Long sId = Long.valueOf(String.valueOf(ctDataEntityField.getValue().getValue()));
                        ctTrackerTypes.getTC_sIdProp().setValueFast((Object)row, (Object)sId);
                        break;
                    }
                    case "tTenantCode": {
                        ctTrackerTypes.getTc_tTenantCodeProp().setValueFast((Object)row, (Object)String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "tEntityKey": {
                        ctTrackerTypes.getTc_tEntityKeyProp().setValueFast((Object)row, (Object)String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "tLkEntityKey": {
                        ctTrackerTypes.getTc_tLkEntityKeyProp().setValueFast((Object)row, (Object)String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "tLkTableId": {
                        Long tLkTableId = Long.valueOf(String.valueOf(ctDataEntityField.getValue().getValue()));
                        ctTrackerTypes.getTc_tLkTableIdProp().setValueFast((Object)row, (Object)tLkTableId);
                        break;
                    }
                    case "tBillId": {
                        Long tBillId = Long.valueOf(String.valueOf(ctDataEntityField.getValue().getValue()));
                        ctTrackerTypes.getTC_tBillIdProp().setValueFast((Object)row, (Object)tBillId);
                        break;
                    }
                    case "tId": {
                        ctTrackerTypes.getTC_tIdProp().setValueFast((Object)row, tId);
                        break;
                    }
                }
            }
            dynamicObjects.add(row);
        }
        return dynamicObjects;
    }

    private int batchCreateNewEntryRow(String entryKey, int count) {
        int rowCount = this.modelProxy.getEntryRowCount(entryKey);
        int rowIndex = 0;
        if (count > rowCount) {
            this.modelProxy.batchCreateNewEntryRow(entryKey, count - rowCount);
        }
        return rowIndex;
    }

    private void createClildSubEntry(String entityKey, DynamicObject headObj, int entryRowIndex, CtDataEntity ctDataEntity, Object id, boolean isCover) {
        if (ctDataEntity == null || ctDataEntity.getChildEntitys() == null || ctDataEntity.getChildEntitys().size() == 0) {
            return;
        }
        for (Map.Entry dataMap : ctDataEntity.getChildEntitys().entrySet()) {
            String subEntryKey = (String)dataMap.getKey();
            List ctDataEntities = (List)dataMap.getValue();
            if ("billhead_lk".equals(subEntryKey)) continue;
            String lkKey = entityKey + "_lk";
            if (subEntryKey.equals(lkKey)) {
                List<CtBillTcLk> ctBillTcLks;
                if (isCover || !CollectionUtils.isNotEmpty(ctBillTcLks = this.collectTcLks(ctDataEntities, headObj.getPkValue(), id))) continue;
                this.resultManager.getTcLks().addAll(ctBillTcLks);
                continue;
            }
            int count = ctDataEntities.size();
            this.modelProxy.setEntryCurrentRowIndex(entityKey, entryRowIndex);
            this.batchCreateNewEntryRow(subEntryKey, count);
            long[] ids = DB.genGlobalLongIds((int)count);
            int subRowIndex = 0;
            for (CtDataEntity entryDataEntity : ctDataEntities) {
                DynamicObject entryObj = this.modelProxy.getEntryEntity(subEntryKey, subRowIndex);
                ISimpleProperty primaryKey = entryObj.getDataEntityType().getPrimaryKey();
                long subId = ids[subRowIndex];
                entryDataEntity.setId(Long.valueOf(subId));
                entryObj.set((IDataEntityProperty)primaryKey, (Object)subId);
                for (CtDataEntityField ctDataEntityField : entryDataEntity.getFields()) {
                    ICtSaveMappingField iCtSaveMappingField = ICtSaveMappingField.create(this.context, ctDataEntityField);
                    iCtSaveMappingField.calcAndMappingValue(entryObj, ctDataEntityField.getValue(), this.batchRequestManager);
                }
                ++subRowIndex;
                this.createClildEntity(subEntryKey, headObj, entryDataEntity, subId);
            }
        }
    }

    private void doBatchRequest(List<DynamicObject> dynamicObjects) {
        this.batchRequestManager.batchSetBasedataValue();
        if (this.batchRequestManager.getBatchOrgSepr().isFail()) {
            // empty if block
        }
        AfterBatchSetBaseDataEventArg afterBatchSetBaseDataEventArg = new AfterBatchSetBaseDataEventArg(this.ctDataEntities, dynamicObjects);
        this.context.getPlugInProxy().fireAfterBatchSetBaseData(afterBatchSetBaseDataEventArg);
        this.batchRequestManager.batchSetRefBillValue();
        if (this.batchRequestManager.getBatchRefBill().isFail()) {
            // empty if block
        }
        this.loadReferenceObject(dynamicObjects);
        this.batchRequestManager.batchAfterSetBasedataValue();
        this.batchRequestManager.batchSetFlexValue();
        this.batchRequestManager.batchSetItemClassValue();
        this.batchRequestManager.batchSetAttachmentValue();
    }

    private void loadReferenceObject(List<DynamicObject> dynamicObjects) {
        BusinessDataReader.loadRefence((Object[])dynamicObjects.toArray(), (IDataEntityType)this.context.getTargetMainType());
    }

    protected boolean createNewData(CtDataEntity ctDataEntity, StringBuilder errMessage) {
        if (this.mainOrgProp != null) {
            this.setMainOrgManager.setMainOrgMapping(this.getMainOrgMapping(ctDataEntity));
            boolean flagForMainOrg = this.setMainOrgManager.setMainOrgForModel(errMessage);
            if (!flagForMainOrg) {
                if (errMessage != null) {
                    // empty if block
                }
                return false;
            }
        }
        if (!this.setBillType(ctDataEntity)) {
            return false;
        }
        this.modelProxy.createNewData(this.getBlankDataEntity((IDataModel)this.modelProxy));
        return true;
    }

    public Object getLkFieldVal(CtDataEntity ctDataEntity, String FieldName) {
        List ctDataEntities = ctDataEntity.getChildEntity("billhead_lk");
        for (CtDataEntity ctLink : ctDataEntities) {
            CtBillLk ctBillLk = new CtBillLk();
            if (!CollectionUtils.isNotEmpty((Collection)ctLink.getFields())) continue;
            for (CtDataEntityField ctDataEntityField : ctLink.getFields()) {
                if (!FieldName.equals(ctDataEntityField.getName())) continue;
                return ctDataEntityField.getValue();
            }
        }
        return null;
    }

    private Object getBlankDataEntity(final IDataModel model) {
        Object billTypeId;
        Object mainOrgId = this.mainOrgProp == null ? null : model.getContextVariable(this.mainOrgProp.getName());
        String key = String.format("%s_%s", mainOrgId, billTypeId = this.billTypeProp == null ? null : model.getContextVariable(DEFAULT_BILLTYPE_ID));
        if (!this.blankDataEntitys.containsKey(key)) {
            String threadCacheKey = String.format("%s_%s_%s", THREAD_CACHE_KEY_BLANK_DATAENTITY, this.targetMainType.getName(), key);
            DynamicObject cacheObj = (DynamicObject)ThreadCache.get((Object)threadCacheKey, (CacheLoader)new CacheLoader<DynamicObject>(){

                public DynamicObject load() {
                    model.beginInit();
                    model.createNewData();
                    model.clearNoDataRow();
                    model.endInit();
                    return model.getDataEntity();
                }
            });
            this.blankDataEntitys.put(key, cacheObj);
        }
        return (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)this.blankDataEntitys.get(key)), (boolean)false, (boolean)true);
    }

    private Object genTargetBillId(MainEntityType mainType, DynamicObject billObj, Object id) {
        ISimpleProperty pkProp = mainType.getPrimaryKey();
        pkProp.setValue((Object)billObj, id);
        return id;
    }

    private CtBillLk genCtBillLk(CtDataEntity ctDataEntity) {
        List ctDataEntities = ctDataEntity.getChildEntity("billhead_lk");
        CtBillLk ctBillLk = new CtBillLk();
        CtDataEntity ctLink = (CtDataEntity)ctDataEntities.get(0);
        if (ctLink == null) {
            return ctBillLk;
        }
        if (CollectionUtils.isNotEmpty((Collection)ctLink.getFields())) {
            for (CtDataEntityField ctDataEntityField : ctLink.getFields()) {
                switch (ctDataEntityField.getName()) {
                    case "sBillId": {
                        Long sBillId = Long.valueOf(String.valueOf(ctDataEntityField.getValue().getValue()));
                        ctBillLk.setSBillId(sBillId);
                        break;
                    }
                    case "sTenantCode": {
                        ctBillLk.setsTenantCode(String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "sEntityKey": {
                        ctBillLk.setsEntityKey(String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "tBillId": {
                        Long tBillId = Long.valueOf(String.valueOf(ctDataEntityField.getValue().getValue()));
                        ctBillLk.setTBillId(tBillId);
                        break;
                    }
                    case "tTenantCode": {
                        ctBillLk.settTenantCode(String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                    case "tEntityKey": {
                        ctBillLk.settEntityKey(String.valueOf(ctDataEntityField.getValue().getValue()));
                        break;
                    }
                }
            }
        }
        return ctBillLk;
    }

    private void setTargetBillId(MainEntityType mainType, DynamicObject billObj, Long billId) {
        ISimpleProperty pkProp = mainType.getPrimaryKey();
        pkProp.setValue((Object)billObj, (Object)billId);
    }

    private boolean setBillType(CtDataEntity ctDataEntity) {
        if (this.billTypeProp == null) {
            this.setLayoutScheme(null);
            return true;
        }
        this.modelProxy.removeContextVariable(DEFAULT_BILLTYPE_ID);
        this.modelProxy.removeContextVariable(this.billTypeProp.getName());
        OutValue mappingId = new OutValue();
        OutValue mappingName = new OutValue();
        Long billTypeId = null;
        Long srcBillTypeId = null;
        if (ctDataEntity.getBillTypeInfo() != null && ctDataEntity.getBillTypeInfo().getsBillTypeId() != null && ctDataEntity.getBillTypeInfo().getsBillTypeId() != 0L) {
            srcBillTypeId = ctDataEntity.getBillTypeInfo().getsBillTypeId();
        }
        DynamicObject[] billTypeObjs = this.targetBillTypeObjs.values().toArray(new DynamicObject[0]);
        this.billTypeMapParser.tryGetTargetBillTypeIds(this.context.getRule().getCtBillTypeMapPolicy(), srcBillTypeId, billTypeObjs, SyncNodeEnum.TARGET);
        if (this.billTypeMapParser.isCannotPushAnyOne()) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\uff0c\u7981\u6b62\u5f53\u524d\u6e90\u5355\u5355\u636e\u7c7b\u578b\uff0c\u4e0b\u63a8\u5230%s", (String)"CtConvertToDynamicObAction_7", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), this.targetMainType.getDisplayName().toString());
            this.resultManager.getReporter().addFailId(ctDataEntity.getSrcBillId(), failMessage);
            return false;
        }
        if (this.billTypeMapParser.getOutBillTypeIds().isEmpty()) {
            String failMessage = ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\u914d\u7f6e\u6709\u8bef\uff0c\u5f53\u524d\u6e90\u5355\u7c7b\u578b\uff0c\u627e\u4e0d\u5230\u53ef\u8f6c\u6362\u7684\u76ee\u6807\u5355\u7c7b\u578b", (String)"CtConvertToDynamicObAction_8", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
            this.resultManager.getReporter().addFailId(ctDataEntity.getSrcBillId(), failMessage);
            return false;
        }
        if (!this.billTypeMapParser.getOutBillTypeIds().isEmpty() && (billTypeId = this.getEnabledBillTypeId(ctDataEntity, this.billTypeMapParser.getOutBillTypeIds())) == null) {
            return false;
        }
        if (billTypeId != null && Long.compare(0L, billTypeId) != 0) {
            this.modelProxy.putContextVariable(DEFAULT_BILLTYPE_ID, billTypeId);
            CtBillTypeDefValueProvider defValueProvider = new CtBillTypeDefValueProvider(billTypeId);
            this.modelProxy.addService(IDefValueProvider.class, (Object)defValueProvider);
            this.setLayoutScheme(billTypeId);
            return true;
        }
        String failMessage = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u5b57\u6bb5\u503c\u8ba1\u7b97\u5931\u8d25", (String)"CtConvertToDynamicObAction_9", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), this.targetMainType.getDisplayName().toString(), this.billTypeProp.getDisplayName().toString());
        this.resultManager.getReporter().addFailId(ctDataEntity.getSrcBillId(), failMessage);
        return false;
    }

    private void setLayoutScheme(Object billTypePkId) {
        Long layoutSchemeId = this.getLayoutSchemeId(billTypePkId);
        if (layoutSchemeId != null) {
            CtBillDefValueProvider billDefValueProvider = new CtBillDefValueProvider(layoutSchemeId);
            this.modelProxy.addService(IDefValueProvider.class, (Object)billDefValueProvider);
        }
    }

    private Long getLayoutSchemeId(Object billTypePkId) {
        BillLayoutParameter blp = new BillLayoutParameter();
        Long newOrgValue = this.defOrgId;
        long orgId = 0L;
        if (newOrgValue != null) {
            orgId = newOrgValue;
        }
        blp.setOrgId(orgId);
        long billTypeId = 0L;
        if (StringUtils.isNotBlank((Object)billTypePkId)) {
            billTypeId = Long.parseLong(billTypePkId.toString());
        }
        blp.setBillTypeId(billTypeId);
        BillLayoutSchemeAssignEntity layoutScheme = BillLayoutSchemeService.getLayoutScheme((String)this.targetMainType.getName(), (BillLayoutParameter)blp);
        Long layoutSchemeId = null;
        if (layoutScheme != null) {
            layoutSchemeId = layoutScheme.getId();
        }
        return layoutSchemeId;
    }

    private boolean execMappingBillType(CtDataEntity ctDataEntity, OutValue<Long> mappingId, OutValue<String> mappingName) {
        Long billTypeId = null;
        if (ctDataEntity.getBillTypeInfo().gettBillTypeId() == null) {
            return true;
        }
        billTypeId = ctDataEntity.getBillTypeInfo().gettBillTypeId();
        if (billTypeId == null || Long.compare(0L, billTypeId) == 0) {
            return true;
        }
        mappingId.set((Object)billTypeId);
        if (!this.targetBillTypeObjs.containsKey(billTypeId)) {
            Object[] objs = BusinessDataReader.load((Object[])new Object[]{billTypeId}, (IDataEntityType)this.billTypeProp.getDynamicComplexPropertyType());
            if (objs != null && objs.length > 0) {
                DynamicObject dynamicObject = (DynamicObject)objs[0];
            }
            return false;
        }
        DynamicObject billTypeObj = this.targetBillTypeObjs.get(billTypeId);
        String billTypeName = billTypeObj.get("name").toString();
        String status = billTypeObj.getString("status");
        String enable = billTypeObj.getString("enable");
        if (!StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)enable)) {
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)"C", (CharSequence)status)) {
            return false;
        }
        mappingName.set((Object)billTypeName);
        return true;
    }

    private Long getEnabledBillTypeId(CtDataEntity ctDataEntity, List<Long> billTypeIds) {
        Long billTypeId = null;
        ArrayList<String> unAuditNames = new ArrayList<String>();
        ArrayList<String> disableNames = new ArrayList<String>();
        for (Long id : billTypeIds) {
            DynamicObject billTypeObj = this.targetBillTypeObjs.get(id);
            if (billTypeObj == null) continue;
            String billTypeName = billTypeObj.get("name").toString();
            if (!this.isEnabledBillType(billTypeObj)) {
                disableNames.add(billTypeName);
                continue;
            }
            if (!this.isAuditdBillType(billTypeObj)) {
                unAuditNames.add(billTypeName);
                continue;
            }
            billTypeId = id;
            break;
        }
        if (billTypeId == null) {
            String failMessage = null;
            failMessage = !disableNames.isEmpty() && !unAuditNames.isEmpty() ? String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u3010%1$s\u3011\u672a\u5ba1\u6838\uff0c\u3010%2$s\u3011\u5df2\u7981\u7528", (String)"CtConvertToDynamicObAction_10", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), StringUtils.join((Object[])unAuditNames.toArray(), (String)","), StringUtils.join((Object[])disableNames.toArray(), (String)",")) : (!unAuditNames.isEmpty() ? String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u672a\u5ba1\u6838", (String)"CtConvertToDynamicObAction_11", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), StringUtils.join((Object[])unAuditNames.toArray(), (String)",")) : (!disableNames.isEmpty() ? String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u5df2\u7981\u7528", (String)"CtConvertToDynamicObAction_12", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), StringUtils.join((Object[])disableNames.toArray(), (String)",")) : String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u5df2\u88ab\u5220\u9664", (String)"CtConvertToDynamicObAction_13", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), StringUtils.join((Object[])billTypeIds.toArray(), (String)","))));
            this.batchRequestManager.getCtSaveResultManager().getReporter().addFailId(ctDataEntity.getSrcBillId(), failMessage);
        }
        return billTypeId;
    }

    private boolean isAuditdBillType(DynamicObject billTypeObj) {
        String status = billTypeObj.getString("status");
        return StringUtils.equalsIgnoreCase((CharSequence)"C", (CharSequence)status);
    }

    private boolean isEnabledBillType(DynamicObject billTypeObj) {
        String enable = billTypeObj.getString("enable");
        return StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)enable);
    }

    private Map<Object, DynamicObject> loadBillTypeObjs() {
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)this.targetMainType.getName())};
        return BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id, number, name, status, enable, isdefault", (QFilter[])filters);
    }
}

