/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtDataEntityField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.CtSaveResultManager;
import kd.bos.service.ctbotp.save.actions.AbstractCtSaveAction;
import kd.bos.util.CollectionUtils;

public class CtInitAction
extends AbstractCtSaveAction {
    private static final Log log = LogFactory.getLog(CtInitAction.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-ctbotp";

    public CtInitAction(CtSaveContext context, CtSaveResultManager ctSaveResultManager) {
        super(context, ctSaveResultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        List ctDataEntities = this.context.getCtSaveArgs().getData();
        for (CtDataEntity ctDataEntity : ctDataEntities) {
            List<Long> sBillIds = this.getSBillIds(ctDataEntity);
            this.context.getBillIdMaps().put(ctDataEntity.getId(), new HashSet<Long>(sBillIds));
            if (!ctDataEntity.isConver()) continue;
            this.context.getCoverTBillIds().add(ctDataEntity.getId());
        }
    }

    private List<Long> getSBillIds(CtDataEntity ctDataEntity) {
        List ctDataEntities = ctDataEntity.getChildEntity("billhead_lk");
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (CtDataEntity ctLink : ctDataEntities) {
            if (CollectionUtils.isEmpty((Collection)ctLink.getFields())) continue;
            for (CtDataEntityField ctDataEntityField : ctLink.getFields()) {
                if (!"sBillId".equals(ctDataEntityField.getName())) continue;
                Long sBillId = Long.valueOf(ctDataEntityField.getValue().getValue());
                billIds.add(sBillId);
            }
        }
        return billIds;
    }
}

