/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtDataEntityField;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mutex.DataMutex;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.CtSaveResultManager;
import kd.bos.service.ctbotp.save.actions.AbstractCtSaveAction;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.CollectionUtils;

public class CtSaveDataMutexAction
extends AbstractCtSaveAction {
    private static final String DATA_MUTEX_KEY_SUCCESS = "success";
    private static final String DATA_MUTEX_MC_ON_KEY = "bos_push_data_mutex_on";
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private static final String DATA_MUTEX_GROUPID = "ctbotp_save_targetbill";
    private Set<String> dataMutexKeys = new HashSet<String>();

    private boolean isRequireDataMutex() {
        return true;
    }

    private Map<String, Long> getKeys() {
        List<CtBillLk> ctBillLks = this.getLinks();
        HashMap<String, Long> ctBillLkMap = new HashMap<String, Long>(ctBillLks.size());
        for (CtBillLk ctBillLk : ctBillLks) {
            StringBuilder key = new StringBuilder();
            key.append(ctBillLk.getsTenantCode());
            key.append(ctBillLk.getsAccountId());
            key.append(ctBillLk.getsEntityKey());
            key.append(ctBillLk.getSBillId());
            this.dataMutexKeys.add(key.toString());
            ctBillLkMap.put(key.toString(), ctBillLk.getSBillId());
        }
        return ctBillLkMap;
    }

    private List<CtBillLk> getLinks() {
        List ctDataEntityList = this.context.getCtSaveArgs().getData();
        ArrayList<CtBillLk> ctBillLks = new ArrayList<CtBillLk>();
        for (CtDataEntity ctDataEntity : ctDataEntityList) {
            List ctDataEntities = ctDataEntity.getChildEntity("billhead_lk");
            for (CtDataEntity ctLink : ctDataEntities) {
                CtBillLk ctBillLk = new CtBillLk();
                if (CollectionUtils.isNotEmpty((Collection)ctLink.getFields())) {
                    for (CtDataEntityField ctDataEntityField : ctLink.getFields()) {
                        switch (ctDataEntityField.getName()) {
                            case "sBillId": {
                                Long sBillId = Long.valueOf(ctDataEntityField.getValue().getValue());
                                ctBillLk.setSBillId(sBillId);
                                break;
                            }
                            case "sTenantCode": {
                                ctBillLk.setsTenantCode(ctDataEntityField.getValue().getValue());
                                break;
                            }
                            case "sAccountId": {
                                ctBillLk.setsAccountId(ctDataEntityField.getValue().getValue());
                                break;
                            }
                            case "sEntityKey": {
                                ctBillLk.setsEntityKey(ctDataEntityField.getValue().getValue());
                                break;
                            }
                        }
                    }
                }
                ctBillLks.add(ctBillLk);
            }
        }
        return ctBillLks;
    }

    private boolean forceRequireDataMutex() {
        String tenantId = RequestContext.get().getTenantId();
        return SystemPropertyUtils.getBoolean((String)tenantId, (String)DATA_MUTEX_MC_ON_KEY);
    }

    public CtSaveDataMutexAction(CtSaveContext context, CtSaveResultManager ctSaveResultManager) {
        super(context, ctSaveResultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        Map<String, Long> srcBills = this.getKeys();
        this.dataMutexKeys = srcBills.keySet();
        HashMap<String, Map<String, Object>> fails = new HashMap<String, Map<String, Object>>(this.dataMutexKeys.size());
        Set<String> successIds = this.startNetworkCtrl(this.dataMutexKeys, fails);
        this.context.setDataMutexKeys(successIds);
        if (!successIds.isEmpty()) {
            for (Map.Entry<String, Long> entry : srcBills.entrySet()) {
                Long srcBillId = entry.getValue();
                String key = entry.getKey();
                if (!successIds.contains(key)) continue;
                this.context.getDataMutexBillids().add(srcBillId);
            }
        }
        if (!fails.isEmpty()) {
            String failMessage = ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362\u7533\u8bf7\u7f51\u7edc\u4e92\u65a5\u5931\u8d25\uff0c\u5176\u4ed6\u4eba\u6b63\u5728\u5904\u7406\u6e90\u5355\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"DataMutexAction_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
            HashSet<Long> reportIds = new HashSet<Long>();
            for (Map.Entry<String, Long> entry : srcBills.entrySet()) {
                Map ret;
                Long srcBillId = entry.getValue();
                String key = entry.getKey();
                if (reportIds.contains(srcBillId) || (ret = (Map)fails.get(key)) == null) continue;
                reportIds.add(srcBillId);
                Object userId = ret.get("userid");
                if (userId == null) {
                    this.getResultManager().getReporter().addFailId(srcBillId, failMessage);
                    continue;
                }
                DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(userId.toString()), (String)"bos_user", (String)"name");
                if (userObj != null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362\u7533\u8bf7\u7f51\u7edc\u4e92\u65a5\u5931\u8d25\uff0c%s\u6b63\u5728\u5904\u7406\u6e90\u5355\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"DataMutexAction_4", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), userObj.getString("name"));
                    this.getResultManager().getReporter().addFailId(srcBillId, msg);
                    continue;
                }
                this.getResultManager().getReporter().addFailId(srcBillId, failMessage);
            }
        }
        if (this.context.getDataMutexBillids().isEmpty()) {
            this.context.setSkipNextAction(true);
        }
    }

    private Set<String> startNetworkCtrl(Set<String> srcBillIds, Map<String, Map<String, Object>> fails) {
        if (srcBillIds.isEmpty()) {
            return new HashSet<String>();
        }
        boolean strict = true;
        String srcEntityNumber = this.context.getTargetMainType().getName();
        Map<String, Map<String, Object>> mutexResult = CtSaveDataMutexAction.requirePushMutex(srcEntityNumber, srcBillIds, strict);
        HashSet<String> successIds = new HashSet<String>();
        for (String srcBillId : srcBillIds) {
            Map<String, Object> ret = mutexResult.get(srcBillId);
            if (ret == null) {
                successIds.add(srcBillId);
                continue;
            }
            Boolean success = (Boolean)ret.get(DATA_MUTEX_KEY_SUCCESS);
            if (success != null && success.booleanValue()) {
                successIds.add(srcBillId);
                continue;
            }
            fails.put(srcBillId, ret);
        }
        return successIds;
    }

    public static Map<String, Map<String, Object>> requirePushMutex(String srcEntityNumber, Set<String> srcBillIds, boolean isStrict) {
        if (srcBillIds == null || srcBillIds.isEmpty()) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        if (StringUtils.isBlank((CharSequence)srcEntityNumber)) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        ArrayList mutexRequireList = new ArrayList(srcBillIds.size());
        for (String srcBillId : srcBillIds) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put("dataObjId", srcBillId);
            requireParam.put("groupId", DATA_MUTEX_GROUPID);
            requireParam.put("entityKey", srcEntityNumber);
            requireParam.put("operationKey", "ctbotp_save");
            requireParam.put("isStrict", isStrict);
            mutexRequireList.add(requireParam);
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(srcBillIds.size());
        HashMap<String, Boolean> success = new HashMap<String, Boolean>(1);
        success.put(DATA_MUTEX_KEY_SUCCESS, Boolean.TRUE);
        try (DataMutex dataMutex = DataMutex.create();){
            Map mutexResult = dataMutex.batchrequire(mutexRequireList);
            for (Map.Entry mutexItem : mutexResult.entrySet()) {
                String srcBillId = (String)mutexItem.getKey();
                Boolean ret = (Boolean)mutexItem.getValue();
                if (ret.booleanValue()) {
                    result.put(srcBillId, success);
                    continue;
                }
                HashMap<String, Boolean> failed = new HashMap<String, Boolean>(4);
                failed.put(DATA_MUTEX_KEY_SUCCESS, Boolean.FALSE);
                Map lockInfo = dataMutex.getLockInfo(srcBillId, "default_netctrl", srcEntityNumber);
                if (lockInfo != null) {
                    failed.putAll(lockInfo);
                }
                result.put(srcBillId, failed);
            }
        }
        catch (IOException e) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"DataMutexAction_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Boolean> releasePushMutex(String srcEntityNumber, Set<String> srcBillIds) {
        if (srcBillIds == null) return new HashMap<String, Boolean>(0);
        if (srcBillIds.isEmpty()) {
            return new HashMap<String, Boolean>(0);
        }
        if (StringUtils.isBlank((CharSequence)srcEntityNumber)) {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(srcBillIds.size());
            Iterator<String> iterator = srcBillIds.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                result.put(string, Boolean.FALSE);
            }
            return result;
        }
        ArrayList mutexRequireList = new ArrayList(srcBillIds.size());
        for (String string : srcBillIds) {
            HashMap<String, String> requireParam = new HashMap<String, String>();
            requireParam.put("dataObjId", string);
            requireParam.put("groupId", DATA_MUTEX_GROUPID);
            requireParam.put("entityKey", srcEntityNumber);
            requireParam.put("operationKey", "ctbotp_save");
            mutexRequireList.add(requireParam);
        }
        try {
            Throwable throwable = null;
            try (DataMutex dataMutex = DataMutex.create();){
                Map map = dataMutex.batchRelease(mutexRequireList);
                return map;
            }
            catch (Throwable map) {
                Throwable throwable3 = map;
                throw map;
            }
        }
        catch (IOException e) {
            ErrorCode errorCode = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"DataMutexAction_2", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, errorCode, new Object[0]);
        }
    }
}

