/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.batchrequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtFieldMapItem;
import kd.bos.entity.ctbotp.runtime.CtReportManager;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.CtSaveResultManager;
import kd.bos.service.ctbotp.save.batchrequest.CtSaveBatchOrgSeprFieldSetValue;
import kd.bos.service.ctbotp.save.batchrequest.CtSaveRefBillFieldGroupKey;
import kd.bos.service.ctbotp.save.batchrequest.CtSaveRefBillFieldSetValueRequest;

public class CtSaveBatchRefBillFieldSetValue {
    private static final Log log = LogFactory.getLog(CtSaveBatchOrgSeprFieldSetValue.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-botp";
    private CtSaveResultManager ctSaveResultManager;
    private CtReportManager reportManager;
    private boolean fail = false;
    private BillEntityType targetMainType;
    private List<CtSaveRefBillFieldSetValueRequest> requests = new ArrayList<CtSaveRefBillFieldSetValueRequest>();

    public CtSaveBatchRefBillFieldSetValue(CtSaveContext ctSaveContext, CtSaveResultManager ctSaveResultManager) {
        this.ctSaveResultManager = ctSaveResultManager;
        this.reportManager = ctSaveResultManager.getReporter();
        this.targetMainType = ctSaveContext.getTargetMainType();
        this.fail = false;
    }

    public BillEntityType getTargetMainType() {
        return this.targetMainType;
    }

    public List<CtSaveRefBillFieldSetValueRequest> getRequests() {
        return this.requests;
    }

    public boolean isFail() {
        return this.fail;
    }

    public void batchDo() {
        HashMap fields = new HashMap();
        for (CtSaveRefBillFieldSetValueRequest ctSaveRefBillFieldSetValueRequest : this.requests) {
            BillEntityType refBDType;
            RefBillProp field = ctSaveRefBillFieldSetValueRequest.getTargetFieldProp();
            CtSaveRefBillFieldGroupKey groupKey = new CtSaveRefBillFieldGroupKey(field, refBDType = (BillEntityType)field.getComplexType());
            if (!fields.containsKey(groupKey)) {
                fields.put(groupKey, new ArrayList());
            }
            ((List)fields.get(groupKey)).add(ctSaveRefBillFieldSetValueRequest);
        }
        for (Map.Entry entry : fields.entrySet()) {
            this.setFieldValue((CtSaveRefBillFieldGroupKey)entry.getKey(), (List)entry.getValue());
        }
    }

    private void setFieldValue(CtSaveRefBillFieldGroupKey fldGroupKey, List<CtSaveRefBillFieldSetValueRequest> fldRequests) {
        RefBillProp targetFieldProp = fldGroupKey.getTargetFieldProp();
        String useOrgPropName = this.getUseOrgFieldKey(targetFieldProp);
        if (StringUtils.isBlank((CharSequence)useOrgPropName)) {
            this.setSrcFieldValue(fldRequests);
            return;
        }
        List<CtSaveRefBillFieldSetValueRequest> changeOrgRequests = this.findOrgChangedRequests(fldGroupKey, fldRequests, useOrgPropName);
        if (changeOrgRequests.isEmpty()) {
            return;
        }
        Map<Long, List<CtSaveRefBillFieldSetValueRequest>> dctByUseOrg = this.groupByOrg(targetFieldProp, useOrgPropName, changeOrgRequests);
        for (Map.Entry<Long, List<CtSaveRefBillFieldSetValueRequest>> entry : dctByUseOrg.entrySet()) {
            Long useOrgId = entry.getKey();
            if (Long.compare(useOrgId, 0L) == 0) {
                this.setSrcFieldValue(entry.getValue());
                continue;
            }
            ArrayList<CtSaveRefBillFieldSetValueRequest> orgRequests = new ArrayList<CtSaveRefBillFieldSetValueRequest>(entry.getValue().size());
            for (CtSaveRefBillFieldSetValueRequest request : entry.getValue()) {
                orgRequests.add(request);
            }
            for (CtSaveRefBillFieldSetValueRequest request : orgRequests) {
                Object obj = request.getSourceRefId();
                if (obj != null) {
                    request.setTargetRefId(obj);
                    request.setValue();
                    continue;
                }
                this.addErrorMessage(fldGroupKey, useOrgPropName, useOrgId, request);
            }
        }
    }

    private List<CtSaveRefBillFieldSetValueRequest> findOrgChangedRequests(CtSaveRefBillFieldGroupKey fldGroupKey, List<CtSaveRefBillFieldSetValueRequest> fldRequests, String useOrgFld) {
        ArrayList<CtSaveRefBillFieldSetValueRequest> changeOrgRequests = new ArrayList<CtSaveRefBillFieldSetValueRequest>(fldRequests);
        return changeOrgRequests;
    }

    private BillEntityType getSrcFldRefType(CtFieldMapItem fieldMapItem, BillEntityType targetFldRefType) {
        BillEntityType refBDType = null;
        refBDType = targetFldRefType;
        return refBDType;
    }

    private Map<Long, List<CtSaveRefBillFieldSetValueRequest>> groupByOrg(RefBillProp targetFieldProp, String useOrgPropName, List<CtSaveRefBillFieldSetValueRequest> requests) {
        HashMap<Long, List<CtSaveRefBillFieldSetValueRequest>> dctByUseOrg = new HashMap<Long, List<CtSaveRefBillFieldSetValueRequest>>();
        RowDataModel rowDataModel = new RowDataModel(targetFieldProp.getParent().getName(), (MainEntityType)this.targetMainType);
        for (CtSaveRefBillFieldSetValueRequest request : requests) {
            rowDataModel.setRowContext(request.getActiveRow());
            DynamicObject useOrg = (DynamicObject)rowDataModel.getValue(useOrgPropName);
            Long useOrgId = 0L;
            if (useOrg != null) {
                useOrgId = (Long)useOrg.getPkValue();
            }
            if (!dctByUseOrg.containsKey(useOrgId)) {
                dctByUseOrg.put(useOrgId, new ArrayList());
            }
            ((List)dctByUseOrg.get(useOrgId)).add(request);
        }
        return dctByUseOrg;
    }

    private void setSrcFieldValue(List<CtSaveRefBillFieldSetValueRequest> requests) {
        for (CtSaveRefBillFieldSetValueRequest request : requests) {
            request.setTargetRefId(request.getSourceRefId());
            request.setValue();
        }
    }

    private String getUseOrgFieldKey(RefBillProp targetFieldProp) {
        if (StringUtils.isNotBlank((CharSequence)targetFieldProp.getOrgProp())) {
            return targetFieldProp.getOrgProp();
        }
        if (StringUtils.isNotBlank((CharSequence)this.targetMainType.getMainOrg())) {
            return this.targetMainType.getMainOrg();
        }
        return null;
    }

    private String getBDDisplayValue(BasedataProp bdProp, Object id) {
        if (id == null) {
            return null;
        }
        DynamicObjectType bdType = bdProp.getDynamicComplexPropertyType();
        Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{id}, (DynamicObjectType)bdType);
        if (objs.isEmpty() || !objs.containsKey(id)) {
            return String.valueOf(id);
        }
        return bdProp.getDisplayValue(objs.get(id));
    }

    private String getBillDisplayValue(RefBillProp refBillProp, Object id) {
        if (id == null) {
            return null;
        }
        DynamicObjectType bdType = refBillProp.getDynamicComplexPropertyType();
        Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{id}, (DynamicObjectType)bdType);
        if (objs.isEmpty() || !objs.containsKey(id)) {
            return String.valueOf(id);
        }
        return refBillProp.getDisplayValue(objs.get(id));
    }

    private void addErrorMessage(CtSaveRefBillFieldGroupKey fldGroupKey, String useOrgPropName, Long useOrgId, CtSaveRefBillFieldSetValueRequest request) {
        String bdDisplayValue = request.getTargetFieldProp().getName();
        OrgProp useOrgProp = (OrgProp)this.targetMainType.findProperty(useOrgPropName);
        String orgDisplayValue = this.getBDDisplayValue((BasedataProp)useOrgProp, useOrgId);
        Object failMessage = null;
        for (DynamicObject sourceRow : request.getSourceRows()) {
            this.fail = true;
        }
    }
}

