/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.lk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.sync.CtSyncBillRouteService;
import kd.bos.ctbotp.sync.CtSyncRouteService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ctbotp.apiparam.CtSyncRouteArgs;
import kd.bos.entity.ctbotp.link.CtBillIdLink;
import kd.bos.entity.ctbotp.link.CtBillSyncRoute;
import kd.bos.entity.ctbotp.runtime.CtBFTable;
import kd.bos.entity.ctbotp.runtime.CtBillEntryInfo;
import kd.bos.entity.ctbotp.sync.SyncRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtBotpRouteManage {
    private static final String selectFields = "id,stenantcode,saccountid,sentitykey,sbillid,ttenantcode,taccountid,tentitykey,tbillid";
    private static final String KEY_STENANTCODE = "stenantcode";
    private static final String KEY_SACCOUNTID = "saccountid";
    private static final String KEY_SENTITYKEY = "sentitykey";
    private static final String KEY_SBILLID = "sbillid";
    private static final String KEY_TTENANTCODE = "ttenantcode";
    private static final String KEY_TACCOUNTID = "taccountid";
    private static final String KEY_TENTITYKEY = "tentitykey";
    private static final String KEY_TBILLID = "tbillid";
    private static final Log log = LogFactory.getLog(CtBotpRouteManage.class);

    public static void addAllRoute(CtSyncRouteArgs ctSyncRouteArgs) {
        SyncRoute syncRoute = new SyncRoute();
        syncRoute.setStenantCode(ctSyncRouteArgs.getStenantCode());
        syncRoute.setsAccountId(ctSyncRouteArgs.getsAccountId());
        syncRoute.setsEntityKey(ctSyncRouteArgs.getsEntityKey());
        syncRoute.setTtenantCode(ctSyncRouteArgs.getTtenantCode());
        syncRoute.settAccountId(ctSyncRouteArgs.gettAccountId());
        syncRoute.settEntityKey(ctSyncRouteArgs.gettEntityKey());
        syncRoute.setCreateTime(new Date());
        CtSyncRouteService.addSyncRoute((SyncRoute)syncRoute);
        ArrayList<CtBillSyncRoute> ctBillSyncRoutes = new ArrayList<CtBillSyncRoute>(16);
        if (CollectionUtils.isNotEmpty((Collection)ctSyncRouteArgs.getBillIdLinks())) {
            for (CtBillIdLink ctBillIdLink : ctSyncRouteArgs.getBillIdLinks()) {
                CtBillSyncRoute ctBillSyncRoute = new CtBillSyncRoute();
                ctBillSyncRoute.setId(Long.valueOf(ID.genLongId()));
                ctBillSyncRoute.setsTenantCode(ctSyncRouteArgs.getStenantCode());
                ctBillSyncRoute.setsAccountId(ctSyncRouteArgs.getsAccountId());
                ctBillSyncRoute.setsEntityKey(ctSyncRouteArgs.getsEntityKey());
                ctBillSyncRoute.setSBillId(ctBillIdLink.getsBillId());
                ctBillSyncRoute.settTenantCode(ctSyncRouteArgs.getTtenantCode());
                ctBillSyncRoute.settAccountId(ctSyncRouteArgs.gettAccountId());
                ctBillSyncRoute.settEntityKey(ctSyncRouteArgs.gettEntityKey());
                ctBillSyncRoute.setTBillId(ctBillIdLink.gettBillId());
                ctBillSyncRoute.setCreateTime(new Date());
                ctBillSyncRoutes.add(ctBillSyncRoute);
            }
        }
        CtBotpRouteManage.addBotpBillRoute(ctBillSyncRoutes);
    }

    public static void addBotpBillRoute(List<CtBillSyncRoute> ctBillSyncRoutes) {
        if (CollectionUtils.isEmpty(ctBillSyncRoutes)) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            List sBillIds = ctBillSyncRoutes.stream().map(a -> a.getSBillId()).collect(Collectors.toList());
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter(KEY_SBILLID, "in", sBillIds));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_ctbotp_billroute", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]));
            HashSet<CtBillSyncRoute> history = new HashSet<CtBillSyncRoute>(16);
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    CtBillSyncRoute ctBillSyncRoute = new CtBillSyncRoute();
                    ctBillSyncRoute.setsTenantCode(dynamicObject.getString(KEY_STENANTCODE));
                    ctBillSyncRoute.setsAccountId(dynamicObject.getString(KEY_SACCOUNTID));
                    ctBillSyncRoute.setsEntityKey(dynamicObject.getString(KEY_SENTITYKEY));
                    ctBillSyncRoute.setSBillId(Long.valueOf(dynamicObject.getLong(KEY_SBILLID)));
                    ctBillSyncRoute.settTenantCode(dynamicObject.getString(KEY_TTENANTCODE));
                    ctBillSyncRoute.settAccountId(dynamicObject.getString(KEY_TACCOUNTID));
                    ctBillSyncRoute.settEntityKey(dynamicObject.getString(KEY_TENTITYKEY));
                    ctBillSyncRoute.setTBillId(Long.valueOf(dynamicObject.getLong(KEY_TBILLID)));
                    history.add(ctBillSyncRoute);
                }
            }
            ArrayList<CtBillSyncRoute> add = new ArrayList<CtBillSyncRoute>(16);
            for (CtBillSyncRoute ctBillSyncRoute : ctBillSyncRoutes) {
                if (history.contains(ctBillSyncRoute)) continue;
                add.add(ctBillSyncRoute);
            }
            if (CollectionUtils.isEmpty(add)) {
                return;
            }
            try {
                IDataEntityType billLinkType = OrmUtils.getDataEntityType(CtBillSyncRoute.class);
                SaveServiceHelper.save((IDataEntityType)billLinkType, (Object[])add.toArray());
            }
            catch (Exception e) {
                h.markRollback();
                log.error((Throwable)e);
                throw new KDException(new ErrorCode("OperateSyncFacade.saveLinks", e.getMessage()), new Object[0]);
            }
        }
    }

    public static List<SyncRoute> getBillSyncRouteDown(String sTenantCode, String sAccountId, String sEntityKey, List<Long> sBillIds) {
        List syncRoutes = CtSyncRouteService.getSyncRouteDown((String)sTenantCode, (String)sAccountId, (String)sEntityKey);
        if (CollectionUtils.isEmpty((Collection)syncRoutes)) {
            return new ArrayList<SyncRoute>();
        }
        List billRouteDowns = CtSyncBillRouteService.getSyncRouteDown((String)sTenantCode, (String)sAccountId, (String)sEntityKey, sBillIds);
        if (CollectionUtils.isEmpty((Collection)billRouteDowns)) {
            return new ArrayList<SyncRoute>();
        }
        Iterator iterator = syncRoutes.iterator();
        while (iterator.hasNext()) {
            SyncRoute syncRoute = (SyncRoute)iterator.next();
            if (billRouteDowns.contains(syncRoute)) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty((Collection)syncRoutes)) {
            return new ArrayList<SyncRoute>();
        }
        return syncRoutes;
    }

    public static List<SyncRoute> getBillSyncRouteUp(String tTenantCode, String tAccountId, String tEntityKey, List<Long> tBillIds) {
        List syncRoutes = CtSyncRouteService.getSyncRouteUp((String)tTenantCode, (String)tAccountId, (String)tEntityKey);
        if (CollectionUtils.isEmpty((Collection)syncRoutes)) {
            return new ArrayList<SyncRoute>();
        }
        List billRouteUps = CtSyncBillRouteService.getSyncRouteUp((String)tTenantCode, (String)tAccountId, (String)tEntityKey, tBillIds);
        if (CollectionUtils.isEmpty((Collection)billRouteUps)) {
            return new ArrayList<SyncRoute>();
        }
        Iterator iterator = syncRoutes.iterator();
        while (iterator.hasNext()) {
            SyncRoute syncRoute = (SyncRoute)iterator.next();
            if (billRouteUps.contains(syncRoute)) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty((Collection)syncRoutes)) {
            return new ArrayList<SyncRoute>();
        }
        return syncRoutes;
    }

    public static List<SyncRoute> getEntrySyncRouteUpBatch(Map<CtBFTable, Map<String, CtBillEntryInfo>> ctBfRowMap) {
        HashMap<CtBFTable, List<Long>> ctBFTableListMap = new HashMap<CtBFTable, List<Long>>(16);
        for (Map.Entry<CtBFTable, Map<String, CtBillEntryInfo>> entry : ctBfRowMap.entrySet()) {
            HashSet ids = new HashSet(16);
            Map<String, CtBillEntryInfo> ctBillEntryInfoMap = entry.getValue();
            for (Map.Entry<String, CtBillEntryInfo> entryInfoEntry : ctBillEntryInfoMap.entrySet()) {
                CtBillEntryInfo ctBillEntryInfo = entryInfoEntry.getValue();
                ids.addAll(ctBillEntryInfo.getBillIds());
            }
            ctBFTableListMap.put(entry.getKey(), new ArrayList(ids));
        }
        return CtBotpRouteManage.getBillSyncRouteUpBatch(ctBFTableListMap);
    }

    public static List<SyncRoute> getBillSyncRouteUpBatch(Map<CtBFTable, List<Long>> ctBfRowMap) {
        if (MapUtils.isEmpty(ctBfRowMap)) {
            return new ArrayList<SyncRoute>();
        }
        List entityKeys = ctBfRowMap.keySet().stream().map(a -> a.getMainEntityKey()).collect(Collectors.toList());
        List syncRoutes = CtSyncRouteService.getSyncRouteUp((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), entityKeys);
        if (CollectionUtils.isEmpty((Collection)syncRoutes)) {
            return new ArrayList<SyncRoute>();
        }
        ArrayList allIds = new ArrayList(16);
        for (Map.Entry<CtBFTable, List<Long>> entry : ctBfRowMap.entrySet()) {
            allIds.addAll(entry.getValue());
        }
        List syncRouteList = CtSyncBillRouteService.getSyncRouteUpByIds(allIds);
        if (CollectionUtils.isEmpty((Collection)syncRouteList)) {
            return new ArrayList<SyncRoute>();
        }
        Iterator iterator = syncRoutes.iterator();
        while (iterator.hasNext()) {
            SyncRoute syncRoute = (SyncRoute)iterator.next();
            if (syncRouteList.contains(syncRoute)) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty((Collection)syncRoutes)) {
            return new ArrayList<SyncRoute>();
        }
        return syncRoutes;
    }

    public static List<SyncRoute> getEntrySyncRouteDownBatch(Map<CtBFTable, Map<String, CtBillEntryInfo>> ctBfRowMap) {
        HashMap<CtBFTable, List<Long>> ctBFTableListMap = new HashMap<CtBFTable, List<Long>>(16);
        for (Map.Entry<CtBFTable, Map<String, CtBillEntryInfo>> entry : ctBfRowMap.entrySet()) {
            HashSet ids = new HashSet(16);
            Map<String, CtBillEntryInfo> ctBillEntryInfoMap = entry.getValue();
            for (Map.Entry<String, CtBillEntryInfo> entryInfoEntry : ctBillEntryInfoMap.entrySet()) {
                CtBillEntryInfo ctBillEntryInfo = entryInfoEntry.getValue();
                ids.addAll(ctBillEntryInfo.getBillIds());
            }
            ctBFTableListMap.put(entry.getKey(), new ArrayList(ids));
        }
        return CtBotpRouteManage.getBillSyncRouteDownBatch(ctBFTableListMap);
    }

    public static List<SyncRoute> getBillSyncRouteDownBatch(Map<CtBFTable, List<Long>> ctBfRowMap) {
        if (MapUtils.isEmpty(ctBfRowMap)) {
            return new ArrayList<SyncRoute>();
        }
        List entityKeys = ctBfRowMap.keySet().stream().map(a -> a.getMainEntityKey()).collect(Collectors.toList());
        List syncRoutes = CtSyncRouteService.getSyncRouteDown((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), entityKeys);
        if (CollectionUtils.isEmpty((Collection)syncRoutes)) {
            return new ArrayList<SyncRoute>();
        }
        ArrayList allIds = new ArrayList(16);
        for (Map.Entry<CtBFTable, List<Long>> entry : ctBfRowMap.entrySet()) {
            allIds.addAll(entry.getValue());
        }
        List syncRouteList = CtSyncBillRouteService.getSyncRouteDownByIds(allIds);
        if (CollectionUtils.isEmpty((Collection)syncRouteList)) {
            return new ArrayList<SyncRoute>();
        }
        Iterator iterator = syncRoutes.iterator();
        while (iterator.hasNext()) {
            SyncRoute syncRoute = (SyncRoute)iterator.next();
            if (syncRouteList.contains(syncRoute)) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty((Collection)syncRoutes)) {
            return new ArrayList<SyncRoute>();
        }
        return syncRoutes;
    }

    private static SyncRoute buildSSyncRoute(String sTenantCode, String sAccountId, String sEntityKey, CtBFTable ctBFTable) {
        SyncRoute syncRoute = new SyncRoute();
        syncRoute.setStenantCode(sTenantCode);
        syncRoute.setsAccountId(sAccountId);
        syncRoute.setsEntityKey(sEntityKey);
        syncRoute.setTtenantCode(ctBFTable.getTenantId());
        syncRoute.settAccountId(ctBFTable.getAccountId());
        syncRoute.settEntityKey(ctBFTable.getMainEntityKey());
        return syncRoute;
    }

    private static SyncRoute buildTSyncRoute(String tTenantCode, String tAccountId, String tEntityKey, CtBFTable ctBFTable) {
        SyncRoute syncRoute = new SyncRoute();
        syncRoute.setStenantCode(ctBFTable.getTenantId());
        syncRoute.setsAccountId(ctBFTable.getAccountId());
        syncRoute.setsEntityKey(ctBFTable.getMainEntityKey());
        syncRoute.setTtenantCode(tTenantCode);
        syncRoute.settAccountId(tAccountId);
        syncRoute.settEntityKey(tEntityKey);
        return syncRoute;
    }
}

