/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ctbotp.CtDataBaseDataValue;
import kd.bos.entity.ctbotp.CtDataEntityField;
import kd.bos.entity.ctbotp.CtDataEntityFieldValue;
import kd.bos.entity.ctbotp.constants.CtBillPropEnum;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.service.ctbotp.CtBaseDataHelper;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.DynamicObjectUtil;
import kd.bos.service.ctbotp.save.batchrequest.CtSaveBatchRequestManager;
import kd.bos.service.ctbotp.save.batchrequest.CtSaveOrgSeprFieldSetValueRequest;
import kd.bos.service.ctbotp.save.mapping.AbstractCtSaveMappingOrgSplitField;
import org.apache.commons.collections.MapUtils;

public class CtSaveMappingBaseDataField
extends AbstractCtSaveMappingOrgSplitField {
    public BasedataProp getTargetFieldProp() {
        return (BasedataProp)super.getTargetFieldProp();
    }

    @Override
    public void initialize(CtSaveContext ctSaveContext, CtDataEntityField ctDataEntityField, DynamicProperty fieldProp) {
        this.targetFieldProp = fieldProp;
        this.ctDataEntityField = ctDataEntityField;
    }

    @Override
    public synchronized void calcAndMappingValue(DynamicObject activeRow, CtDataEntityFieldValue value, CtSaveBatchRequestManager batchRequestManager) {
        if (StringUtils.isBlank((Object)value) || StringUtils.isBlank((Object)value.getBaseDataValue()) || StringUtils.isBlank((CharSequence)value.getBaseDataValue().getId()) && StringUtils.isBlank((CharSequence)value.getBaseDataValue().getNumber())) {
            return;
        }
        if (this.getTargetFieldProp() instanceof BillTypeProp || this.getTargetFieldProp() instanceof MainOrgProp) {
            return;
        }
        boolean isOrg = false;
        if (this.getTargetFieldProp() instanceof OrgProp) {
            isOrg = true;
        }
        CtSaveOrgSeprFieldSetValueRequest setValueRequest = new CtSaveOrgSeprFieldSetValueRequest();
        setValueRequest.setTargetFieldProp((DynamicProperty)this.getTargetFieldProp());
        setValueRequest.setActiveRow(activeRow);
        setValueRequest.setBaseDataInfo(value.getBaseDataValue());
        setValueRequest.setTargetBillId(DynamicObjectUtil.getBillIdByDynamic(activeRow));
        setValueRequest.setCtDataEntityField(this.ctDataEntityField);
        setValueRequest.setOrg(isOrg);
        if (isOrg) {
            batchRequestManager.getBatchOrgSepr().getRequests().add(0, setValueRequest);
        } else {
            batchRequestManager.getBatchOrgSepr().getRequests().add(setValueRequest);
        }
    }

    @Override
    public synchronized Object calcMapValue() {
        HashMap<String, String> idNumberMaps = new HashMap<String, String>(16);
        BasedataEntityType bdType = (BasedataEntityType)this.getTargetFieldProp().getComplexType();
        CtDataBaseDataValue ctDataBaseDataValue = this.ctDataEntityField.getValue().getBaseDataValue();
        if (ctDataBaseDataValue != null) {
            if (ctDataBaseDataValue.getId() != null) {
                idNumberMaps.put(ctDataBaseDataValue.getId(), ctDataBaseDataValue.getNumber());
            } else {
                idNumberMaps.put("0", ctDataBaseDataValue.getNumber());
            }
        }
        HashSet<String> idSet = new HashSet();
        idSet = idNumberMaps.keySet();
        HashMap<String, String> idSelectMap = CtBaseDataHelper.getBaseDataSet(CtBillPropEnum.ID, bdType, bdType.getPrimaryKey().getName(), idSet);
        ArrayList numList = new ArrayList();
        for (Map.Entry entry : idNumberMaps.entrySet()) {
            if (idSelectMap.containsKey(entry.getKey()) && ctDataBaseDataValue.getNumber() == null || idSelectMap.containsKey(entry.getKey()) && idSelectMap.get(ctDataBaseDataValue.getId()).equals(ctDataBaseDataValue.getNumber()) || !StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            numList.add(entry.getValue());
        }
        HashSet<String> moreThanOneNum = new HashSet<String>(16);
        HashMap<String, String> numIdMaps = new HashMap<String, String>(16);
        List<CtDataBaseDataValue> numSelectLists = CtBaseDataHelper.getBaseDataInfosByNumber(bdType, bdType.getNumberProperty(), numList);
        for (CtDataBaseDataValue ctDataBaseDataValueNum : numSelectLists) {
            if (ctDataBaseDataValueNum == null || !StringUtils.isNotBlank((CharSequence)ctDataBaseDataValueNum.getNumber())) continue;
            if (MapUtils.isNotEmpty(numIdMaps) && numIdMaps.containsKey(ctDataBaseDataValueNum.getNumber())) {
                moreThanOneNum.add(ctDataBaseDataValueNum.getNumber());
            }
            numIdMaps.put(ctDataBaseDataValueNum.getNumber(), ctDataBaseDataValueNum.getId());
        }
        if (ctDataBaseDataValue != null) {
            String id;
            if (idSelectMap.containsKey(ctDataBaseDataValue.getId()) && (ctDataBaseDataValue.getNumber() == null || idSelectMap.get(ctDataBaseDataValue.getId()).equals(ctDataBaseDataValue.getNumber()))) {
                if (bdType.getPrimaryKey() instanceof LongProp) {
                    return Long.parseLong(ctDataBaseDataValue.getId());
                }
                return ctDataBaseDataValue.getId();
            }
            if ((!StringUtils.isNotBlank((CharSequence)ctDataBaseDataValue.getNumber()) || !moreThanOneNum.contains(ctDataBaseDataValue.getNumber())) && StringUtils.isNotBlank((CharSequence)ctDataBaseDataValue.getNumber()) && MapUtils.isNotEmpty(numIdMaps) && (id = (String)numIdMaps.get(ctDataBaseDataValue.getNumber())) != null) {
                if (bdType.getPrimaryKey() instanceof LongProp) {
                    return Long.parseLong(id);
                }
                return id;
            }
        }
        return null;
    }
}

