/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.org;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ctbotp.save.org.CtSaveGetMainOrgProcess;
import kd.bos.service.ctbotp.save.org.CtSaveHandoverOrgManager;
import kd.bos.service.ctbotp.save.org.CtSaveMainOrgContext;
import kd.bos.service.ctbotp.save.org.CtSaveMainOrgResult;
import kd.bos.service.ctbotp.save.org.CtSavePermOrgManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;

class CtSaveGetMainOrgForMapping
extends CtSaveGetMainOrgProcess {
    private static final Log log = LogFactory.getLog(CtSaveGetMainOrgForMapping.class);

    public CtSaveGetMainOrgForMapping(CtSaveMainOrgContext context, CtSavePermOrgManager permOrgManager, CtSaveHandoverOrgManager handoverOrgManager) {
        super(context, permOrgManager, handoverOrgManager);
    }

    @Override
    protected Long get() {
        if (this.context.getMappingMainOrg() == null) {
            return null;
        }
        Long pushDefOrgId = this.context.getDefOrgId();
        return this.calcMainOrg(pushDefOrgId);
    }

    @Override
    protected CtSaveMainOrgResult check(Long orgId) {
        log.info("CtSaveGetMainOrgForMapping orgId:{}", (Object)orgId);
        if (this.context.getMappingMainOrg() == null) {
            return null;
        }
        if (orgId == null) {
            String failMessage = this.buildErrMessageForMainOrg("orgId is null");
            return CtSaveMainOrgResult.fail(failMessage, CtSaveMainOrgResult.FailType.NORMAL_REPORT);
        }
        Map orgObjs = BusinessDataServiceHelper.loadFromCache((Object[])new Long[]{orgId}, (DynamicObjectType)this.context.getMainOrgProp().getDynamicComplexPropertyType());
        DynamicObject calcOrgObj = (DynamicObject)orgObjs.get(orgId);
        if (calcOrgObj == null) {
            String failMessage = this.buildErrMessageForMainOrg("calcOrgObj is null");
            return CtSaveMainOrgResult.fail(failMessage, CtSaveMainOrgResult.FailType.NORMAL_REPORT);
        }
        HasPermOrgResult permResult = this.permOrgManager.loadPermOrgResult();
        HashSet authOrgIds = new HashSet(permResult.getHasPermOrgs());
        if (this.context.getMainOrgProp().canBeMainOrg(((Long)calcOrgObj.getPkValue()).longValue(), !permResult.hasAllOrgPerm(), authOrgIds)) {
            return CtSaveMainOrgResult.success((Long)calcOrgObj.getPkValue());
        }
        String failMessage = "";
        failMessage = permResult.hasAllOrgPerm() ? String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8ba1\u7b97\u51fa\u7684\u7ec4\u7ec7\u3010%3$s\u3011\u4e0d\u7b26\u5408\u76ee\u6807\u5355\u7ec4\u7ec7\u804c\u80fd\u8981\u6c42", (String)"CreateTargetBillAction_24", (String)"bos-mservice-botp", (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString(), this.context.getMainOrgProp().getDisplayName().toString(), calcOrgObj.getString("name")) : (!authOrgIds.contains((Long)calcOrgObj.getPkValue()) ? String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8ba1\u7b97\u51fa\u7684\u7ec4\u7ec7\u3010%3$s\u3011\u6ca1\u6709\u65b0\u589e\u6743\u9650", (String)"CreateTargetBillAction_25", (String)"bos-mservice-botp", (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString(), this.context.getMainOrgProp().getDisplayName().toString(), calcOrgObj.getString("name")) : String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8ba1\u7b97\u51fa\u7684\u7ec4\u7ec7\u3010%3$s\u3011\u4e0d\u7b26\u5408\u76ee\u6807\u5355\u7ec4\u7ec7\u804c\u80fd\u8981\u6c42", (String)"CreateTargetBillAction_24", (String)"bos-mservice-botp", (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString(), this.context.getMainOrgProp().getDisplayName().toString(), calcOrgObj.getString("name")));
        return CtSaveMainOrgResult.fail(failMessage, CtSaveMainOrgResult.FailType.NORMAL_REPORT);
    }

    private Long calcMainOrg(Long defOrgId) {
        if (this.context.getMappingMainOrg() != null) {
            Long calcOrgId = (Long)this.context.getMappingMainOrg().calcMapValue();
            if (calcOrgId == null || Long.compare(0L, calcOrgId) == 0) {
                return null;
            }
            return calcOrgId;
        }
        return null;
    }

    @VisibleForTesting
    protected String buildErrMessageForMainOrg(String fail) {
        String failMessage = fail;
        if (this.context.getMappingMainOrg() == null) {
            failMessage = String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u3010%1$s\u3011\u3010%2$s\u3011\u5b57\u6bb5\u7684\u53d6\u503c\u516c\u5f0f\uff1b", (String)"CreateTargetBillAction_23", (String)"bos-mservice-botp", (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString(), this.context.getMainOrgProp().getDisplayName().toString());
        }
        return failMessage;
    }
}

