/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.org;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.business.datamodel.CtDrawDataModel;
import kd.bos.service.ctbotp.convert.report.ICtBuildDetailReport;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.CtSaveResultManager;
import kd.bos.service.ctbotp.save.mapping.ICtSaveMappingField;
import kd.bos.service.ctbotp.save.org.CtSaveGetMainOrgForDefaul;
import kd.bos.service.ctbotp.save.org.CtSaveGetMainOrgForMapping;
import kd.bos.service.ctbotp.save.org.CtSaveGetMainOrgForOrgId;
import kd.bos.service.ctbotp.save.org.CtSaveGetMainOrgProcess;
import kd.bos.service.ctbotp.save.org.CtSaveHandoverOrgManager;
import kd.bos.service.ctbotp.save.org.CtSaveMainOrgContext;
import kd.bos.service.ctbotp.save.org.CtSaveMainOrgResult;
import kd.bos.service.ctbotp.save.org.CtSavePermOrgManager;

public class CtSaveSetMainOrgManager {
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private static final Log log = LogFactory.getLog(CtSaveSetMainOrgManager.class);
    private CtSaveMainOrgContext context;
    private CtDrawDataModel modelProxy;
    private CtSavePermOrgManager permOrgManager;
    private CtSaveHandoverOrgManager handoverOrgManager;
    private CtSaveGetMainOrgProcess pushargsProcess;
    private CtSaveGetMainOrgProcess defaulProcess;
    private CtSaveGetMainOrgProcess mappingProcess;

    public CtSaveSetMainOrgManager(CtSaveContext ruleContext, CtSaveResultManager ctSaveResultManager, MainOrgProp mainOrgProp, CtDrawDataModel modelProxy, Long defOrgId, ICtBuildDetailReport buildReport) {
        this.context = new CtSaveMainOrgContext(ruleContext, ctSaveResultManager, mainOrgProp, modelProxy, defOrgId, buildReport);
        this.permOrgManager = new CtSavePermOrgManager(this.context);
        this.handoverOrgManager = new CtSaveHandoverOrgManager();
        this.mappingProcess = new CtSaveGetMainOrgForMapping(this.context, this.permOrgManager, this.handoverOrgManager);
        this.pushargsProcess = new CtSaveGetMainOrgForOrgId(this.context, this.permOrgManager, this.handoverOrgManager);
        this.defaulProcess = new CtSaveGetMainOrgForDefaul(this.context, this.permOrgManager, this.handoverOrgManager);
    }

    public boolean setMainOrgForModel(StringBuilder errMessage) {
        CtSaveMainOrgResult result = this.getMainOrg();
        log.info("\u83b7\u53d6\u4e3b\u7ec4\u7ec7\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString((Object)result));
        if (result.isFail()) {
            if (result.getFailType() == CtSaveMainOrgResult.FailType.BREAK_REPORT) {
                errMessage.append(result.getFailMessage());
            }
            if (result.getFailType() == CtSaveMainOrgResult.FailType.NORMAL_REPORT) {
                errMessage.append(result.getFailMessage());
            }
            return false;
        }
        if (result.getOrgId() == null || result.getOrgId() == 0L) {
            return false;
        }
        log.info("\u8bbe\u7f6e\u4e3b\u7ec4\u7ec7\u4fe1\u606f\uff1a" + this.context.getMainOrgProp().getName() + SerializationUtils.toJsonString((Object)result.getOrgId()));
        this.context.getModelProxy().putContextVariable(this.context.getMainOrgProp().getName(), result.getOrgId());
        return true;
    }

    private CtSaveMainOrgResult getMainOrg() {
        CtSaveMainOrgResult resultFromMapping;
        CtSaveMainOrgResult resultFromParam = this.checkParams();
        if (resultFromParam != null) {
            return resultFromParam;
        }
        this.context.getModelProxy().removeContextVariable("SELECT_ORG_ID");
        this.context.getModelProxy().removeContextVariable(this.context.getMainOrgProp().getName());
        if (this.permOrgManager.isHasRight(this.context.getConvertContext())) {
            this.context.getModelProxy().putContextVariable("hasright", String.valueOf(true));
        }
        if ((resultFromMapping = this.mappingProcess.getMainOrgId()) != null) {
            return resultFromMapping;
        }
        CtSaveMainOrgResult resultFromPush = this.pushargsProcess.getMainOrgId();
        if (resultFromPush != null) {
            return resultFromPush;
        }
        CtSaveMainOrgResult resultFromDef = this.defaulProcess.getMainOrgId();
        if (resultFromDef != null) {
            return resultFromDef;
        }
        return this.buildFailResult();
    }

    @VisibleForTesting
    protected CtSaveMainOrgResult checkParams() {
        if (this.context.getMainOrgProp() == null) {
            return CtSaveMainOrgResult.empty();
        }
        return null;
    }

    private CtSaveMainOrgResult buildFailResult() {
        return CtSaveMainOrgResult.empty();
    }

    private void addErrorReport(List<DynamicObject> sourceRows, String failMessage) {
        for (DynamicObject dynamicObject : sourceRows) {
        }
    }

    public CtSaveMainOrgContext getContext() {
        return this.context;
    }

    public void setContext(CtSaveMainOrgContext context) {
        this.context = context;
    }

    public void setMainOrgMapping(ICtSaveMappingField ctSaveMappingField) {
        this.context.setMappingMainOrg(ctSaveMappingField);
    }
}

