/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ctbotp.apiparam.CtSyncRouteArgs;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.link.CtAddLinkArgs;
import kd.bos.entity.ctbotp.link.CtBillIdLink;
import kd.bos.entity.ctbotp.link.CtBillTcLk;
import kd.bos.entity.ctbotp.link.CtLinkItem;
import kd.bos.entity.ctbotp.sync.SyncRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.helper.CtTrackerTypes;
import kd.bos.service.ctbotp.save.lk.CtBotpRouteManage;
import kd.bos.service.ctbotp.service.ICtBillLkAddService;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtBillLkAddServiceImpl
implements ICtBillLkAddService {
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-ctbotp";
    private Log log = LogFactory.getLog(CtBillLkAddServiceImpl.class);
    private SyncRoute syncRoute;
    private CtSyncRouteArgs ctSyncRouteArgs;
    private List<CtBillTcLk> ctBillTcLks = new ArrayList<CtBillTcLk>(16);

    @Override
    public void init(CtAddLinkArgs ctAddLinkArgs) {
        if (ctAddLinkArgs == null || CollectionUtils.isEmpty((Collection)ctAddLinkArgs.getCtLinkItems())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a", (String)"CtBillLkAddServiceImpl_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
        }
        this.initUpSyncRouteArgs(ctAddLinkArgs);
        this.initSyncRoute(ctAddLinkArgs);
        for (CtLinkItem ctLinkItem : ctAddLinkArgs.getCtLinkItems()) {
            this.initCtBillTcLks(ctAddLinkArgs, ctLinkItem);
        }
    }

    @Override
    public void addUpTenantSyncRoute() {
        String result = CtBotpApiUtils.post(this.ctSyncRouteArgs.getStenantCode(), this.ctSyncRouteArgs.getsAccountId(), CtApiUrlEnum.ADDSYNCROUTE, SerializationUtils.toJsonString((Object)this.ctSyncRouteArgs));
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u7ef4\u62a4\u4e0a\u6e38\u540c\u6b65\u8def\u7ebf\u63a5\u53e3\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"CtBillLkAddServiceImpl_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
        }
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        if (MapUtils.isEmpty((Map)openApiResult)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u7ef4\u62a4\u4e0a\u6e38\u540c\u6b65\u8def\u7ebf\u63a5\u53e3\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"CtBillLkAddServiceImpl_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
        }
        String errorMsg = null;
        if (!openApiResult.get("errorCode").equals("0")) {
            Object message = openApiResult.get("message");
            errorMsg = StringUtils.isNotBlank(message) ? message.toString() : String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7ef4\u62a4\u4e0a\u6e38\u540c\u6b65\u8def\u7ebf\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002\u9519\u8bef\u7801\uff1a%s", (String)"CtBillLkAddServiceImpl_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), openApiResult.get("errorCode"));
            throw new KDBizException(errorMsg);
        }
        Object data = openApiResult.get("data");
        if (StringUtils.isNotBlank(data)) {
            throw new KDBizException(data.toString());
        }
    }

    @Override
    public void addSyncRoute() {
        CtBotpRouteManage.addAllRoute(this.ctSyncRouteArgs);
    }

    @Override
    public void addTc() {
        BillEntityType billEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.syncRoute.gettEntityKey());
        CtTrackerTypes ctTrackerTypes = CtTrackerTypes.buildTrackerTypes(billEntityType);
        List<DynamicObject> dynamicObjects = this.buildTcLkDynamics(this.ctBillTcLks, ctTrackerTypes);
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((IDataEntityType)ctTrackerTypes.getEntryTrackerType(), (Object[])dynamicObjects.toArray(new DynamicObject[0]));
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    @Override
    public void operateAdd() {
        this.addUpTenantSyncRoute();
        this.addSyncRoute();
        this.addTc();
    }

    private void initUpSyncRouteArgs(CtAddLinkArgs ctAddLinkArgs) {
        CtSyncRouteArgs ctSyncRouteArg = new CtSyncRouteArgs();
        ctSyncRouteArg.setStenantCode(ctAddLinkArgs.getsTenantCode());
        ctSyncRouteArg.setsAccountId(ctAddLinkArgs.getsAccountId());
        ctSyncRouteArg.setsEntityKey(ctAddLinkArgs.getsEntityKey());
        ctSyncRouteArg.setTtenantCode(ctAddLinkArgs.gettTenantCode());
        ctSyncRouteArg.settAccountId(ctAddLinkArgs.gettAccountId());
        ctSyncRouteArg.settEntityKey(ctAddLinkArgs.gettEntityKey());
        ctSyncRouteArg.setStenantCode(ctAddLinkArgs.getsTenantCode());
        ArrayList<CtBillIdLink> ctBillIdLinks = new ArrayList<CtBillIdLink>(16);
        for (CtLinkItem ctLinkItem : ctAddLinkArgs.getCtLinkItems()) {
            CtBillIdLink ctBillIdLink = new CtBillIdLink();
            ctBillIdLink.setsBillId(ctLinkItem.getsBillId());
            ctBillIdLink.settBillId(ctLinkItem.gettBillId());
            ctBillIdLinks.add(ctBillIdLink);
        }
        ctSyncRouteArg.setBillIdLinks(ctBillIdLinks);
        this.ctSyncRouteArgs = ctSyncRouteArg;
    }

    private void initSyncRoute(CtAddLinkArgs ctAddLinkArgs) {
        SyncRoute syncRoute = new SyncRoute();
        syncRoute.setStenantCode(ctAddLinkArgs.getsTenantCode());
        syncRoute.setsAccountId(ctAddLinkArgs.getsAccountId());
        syncRoute.setsEntityKey(ctAddLinkArgs.getsEntityKey());
        syncRoute.setTtenantCode(ctAddLinkArgs.gettTenantCode());
        syncRoute.settAccountId(ctAddLinkArgs.gettAccountId());
        syncRoute.settEntityKey(ctAddLinkArgs.gettEntityKey());
        syncRoute.setStenantCode(ctAddLinkArgs.getsTenantCode());
        this.syncRoute = syncRoute;
    }

    private void initCtBillTcLks(CtAddLinkArgs ctAddLinkArgs, CtLinkItem ctLinkItem) {
        CtBillTcLk ctBillTcLk = new CtBillTcLk();
        ctBillTcLk.setsTenantCode(ctAddLinkArgs.getsTenantCode());
        ctBillTcLk.setsAccountId(ctAddLinkArgs.getsAccountId());
        ctBillTcLk.setsEntityKey(ctAddLinkArgs.getsEntityKey());
        ctBillTcLk.setsTableId(ctAddLinkArgs.getsTableId().longValue());
        ctBillTcLk.setsLkEntityKey(ctLinkItem.getsLkEntityKey());
        ctBillTcLk.setsLkTableId(ctLinkItem.getsLkTableId().longValue());
        ctBillTcLk.setsBillId(ctLinkItem.getsBillId().longValue());
        ctBillTcLk.setsId(ctLinkItem.getsId().longValue());
        ctBillTcLk.settTenantCode(ctAddLinkArgs.gettTenantCode());
        ctBillTcLk.settAccountId(ctAddLinkArgs.gettAccountId());
        ctBillTcLk.settEntityKey(ctAddLinkArgs.gettEntityKey());
        ctBillTcLk.settLkEntityKey(ctLinkItem.getsLkEntityKey());
        ctBillTcLk.settBillId(ctLinkItem.gettBillId().longValue());
        ctBillTcLk.settId(ctLinkItem.gettId().longValue());
        ctBillTcLk.settTableId(ctAddLinkArgs.gettTableId().longValue());
        ctBillTcLk.settLkTableId(ctLinkItem.gettLkTableId().longValue());
        this.ctBillTcLks.add(ctBillTcLk);
    }

    private List<DynamicObject> buildTcLkDynamics(List<CtBillTcLk> ctBillTcLks, CtTrackerTypes ctTrackerTypes) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        for (CtBillTcLk ctBillTcLk : ctBillTcLks) {
            DynamicObject row = new DynamicObject((DynamicObjectType)ctTrackerTypes.getEntryTrackerType());
            ctTrackerTypes.getTc_sTenantCodeProp().setValueFast((Object)row, (Object)ctBillTcLk.getsTenantCode());
            ctTrackerTypes.getTc_sAccountIdProp().setValueFast((Object)row, (Object)ctBillTcLk.getsAccountId());
            ctTrackerTypes.getTc_sEntityKeyProp().setValueFast((Object)row, (Object)ctBillTcLk.getsEntityKey());
            ctTrackerTypes.getTC_sTableIdProp().setValueFast((Object)row, (Object)ctBillTcLk.getsTableId());
            ctTrackerTypes.getTc_sLkEntityKeyProp().setValueFast((Object)row, (Object)ctBillTcLk.getsLkEntityKey());
            ctTrackerTypes.getTc_sLkTableIdProp().setValueFast((Object)row, (Object)ctBillTcLk.getsLkTableId());
            ctTrackerTypes.getTC_sBillIdProp().setValueFast((Object)row, (Object)ctBillTcLk.getsBillId());
            ctTrackerTypes.getTC_sIdProp().setValueFast((Object)row, (Object)ctBillTcLk.getsId());
            ctTrackerTypes.getTc_tTenantCodeProp().setValueFast((Object)row, (Object)ctBillTcLk.gettTenantCode());
            ctTrackerTypes.getTc_tAccountIdProp().setValueFast((Object)row, (Object)ctBillTcLk.gettAccountId());
            ctTrackerTypes.getTc_tEntityKeyProp().setValueFast((Object)row, (Object)ctBillTcLk.gettEntityKey());
            ctTrackerTypes.getTC_tTableIdProp().setValueFast((Object)row, (Object)ctBillTcLk.gettTableId());
            ctTrackerTypes.getTc_tLkEntityKeyProp().setValueFast((Object)row, (Object)ctBillTcLk.gettLkEntityKey());
            ctTrackerTypes.getTc_tLkTableIdProp().setValueFast((Object)row, (Object)ctBillTcLk.gettLkTableId());
            ctTrackerTypes.getTC_tBillIdProp().setValueFast((Object)row, (Object)ctBillTcLk.gettBillId());
            ctTrackerTypes.getTC_tIdProp().setValueFast((Object)row, (Object)ctBillTcLk.gettId());
            ctTrackerTypes.getTc_createTimeProp().setValueFast((Object)row, (Object)new Date());
            dynamicObjects.add(row);
        }
        return dynamicObjects;
    }
}

