/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.ctbotp.CtBusinessFlowDataService;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkRes;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.link.CtAddLinkArgs;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtEntryLkDownQueryArgs;
import kd.bos.entity.ctbotp.link.CtEntryLkUpQueryArgs;
import kd.bos.entity.ctbotp.link.CtLkDownQueryArgs;
import kd.bos.entity.ctbotp.link.CtLkUpQueryArgs;
import kd.bos.entity.ctbotp.link.CtQueryMirrorBillArgs;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkDownNode;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;
import kd.bos.entity.ctbotp.sync.SyncRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.save.lk.CtBotpRouteManage;
import kd.bos.service.ctbotp.service.CtBillLkBusinessService;
import kd.bos.service.ctbotp.service.CtBillLkQueryService;
import kd.bos.service.ctbotp.service.CtEntryLkQueryService;
import kd.bos.service.ctbotp.utils.BeanCopyUtils;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;

public class CtBillLkServiceHelper {
    private static Log log = LogFactory.getLog((String)"CtBillLkServiceHelper");
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-ctbotp";

    public static List<CtBillLkRes> getDirtMirrorBill(CtQueryMirrorBillArgs args) {
        ArrayList<CtBillLkRes> mirrorBill = new ArrayList<CtBillLkRes>(16);
        CtLkDownQueryArgs ctLkDownQueryArgs = new CtLkDownQueryArgs();
        ctLkDownQueryArgs.setsTenantCode(args.getTenantCode());
        ctLkDownQueryArgs.setsAccountId(args.getAccountId());
        ctLkDownQueryArgs.setsEntityKey(args.getEntityKey());
        ctLkDownQueryArgs.setsBillIds(args.getBillIds());
        List<CtBillLkRes> billLkDowns = CtBillLkServiceHelper.getDirtBillLkDown(ctLkDownQueryArgs);
        if (billLkDowns.size() > 0) {
            mirrorBill.addAll(billLkDowns);
        }
        CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
        ctLkUpQueryArgs.settTenantCode(args.getTenantCode());
        ctLkUpQueryArgs.settAccountId(args.getAccountId());
        ctLkUpQueryArgs.settEntityKey(args.getEntityKey());
        ctLkUpQueryArgs.settBillIds(args.getBillIds());
        List<CtBillLkRes> billLkUps = CtBillLkServiceHelper.getDirtBillLkUp(ctLkUpQueryArgs);
        if (billLkUps.size() > 0) {
            mirrorBill.addAll(billLkUps);
        }
        mirrorBill = mirrorBill.stream().filter(bill -> bill.getsSyncModel().equals("1") || bill.gettSyncModel().equals("1")).collect(Collectors.toList());
        return mirrorBill;
    }

    public static List<CtBillLkRes> getDirtBillLkDown(CtLkDownQueryArgs ctLkDownQueryArgs) {
        ArrayList<CtBillLkRes> ctBillLks = new ArrayList<CtBillLkRes>(16);
        List<SyncRoute> syncRoutes = CtBotpRouteManage.getBillSyncRouteDown(ctLkDownQueryArgs.getsTenantCode(), ctLkDownQueryArgs.getsAccountId(), ctLkDownQueryArgs.getsEntityKey(), ctLkDownQueryArgs.getsBillIds());
        HashSet<String> hasRequestSyncRouteSet = new HashSet<String>(16);
        for (SyncRoute syncRoute : syncRoutes) {
            String uniKey = syncRoute.getTtenantCode() + syncRoute.gettAccountId();
            if (hasRequestSyncRouteSet.contains(uniKey)) continue;
            hasRequestSyncRouteSet.add(uniKey);
            String result = CtBotpApiUtils.post(syncRoute.getTtenantCode(), syncRoute.gettAccountId(), CtApiUrlEnum.GETCTDIRTBILLLKDOWN, SerializationUtils.toJsonString((Object)ctLkDownQueryArgs));
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            List itCtBillLks = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(openApiResult.get("data")), CtBillLkRes.class);
            ctBillLks.addAll(itCtBillLks);
        }
        return ctBillLks;
    }

    public static List<CtBillLkRes> getDirtBillLkUp(CtLkUpQueryArgs ctLkUpQueryArgs) {
        ArrayList<CtBillLkRes> ctBillLkResList = new ArrayList<CtBillLkRes>(16);
        List ctBillLkList = CtBillLinkService.getCtDirtBillLkUp((CtLkUpQueryArgs)ctLkUpQueryArgs);
        for (CtBillLk ctBillLk : ctBillLkList) {
            CtBillLkRes ctBillLkRes = BeanCopyUtils.toCtBillLkRes(ctBillLk);
            ctBillLkResList.add(ctBillLkRes);
        }
        return ctBillLkResList;
    }

    public static Map<Long, CtBFRowLinkUpNode> loadBillLinkUpNodes(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds, boolean onlyDirtSource) {
        try {
            String upLoodParam = ResManager.loadKDString((String)"\u4e0a\u67e5\u63a5\u53e3\u53c2\u6570", (String)"CtBillLkServiceHelper_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
            StringBuilder args = new StringBuilder();
            args.append(upLoodParam);
            args.append("tTenantCode:");
            args.append(tTenantCode);
            args.append(",tAccountId:");
            args.append(tAccountId);
            args.append(",entityNumber:");
            args.append(entityNumber);
            args.append(",billIds:");
            args.append(JSON.toJSONString((Object)billIds));
            log.info(args.toString());
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        List<Object> allRows = new ArrayList();
        allRows = onlyDirtSource ? CtBillLkQueryService.loadBillLinkUpRowsDirt(tTenantCode, tAccountId, entityNumber, billIds) : CtBillLkQueryService.loadBillLinkUpRowsFull(tTenantCode, tAccountId, entityNumber, billIds);
        log.info("before build:" + SerializationUtils.toJsonString(allRows));
        Map ctBFRowLinkUpNodeMap = service.getLinkTreeBuilder().buildBillLinkUpNodes(tTenantCode, tAccountId, entityNumber, billIds, allRows);
        try {
            log.info("uplook result ctBFRowLinkUpNodeMap\uff1a" + SerializationUtils.toJsonString((Object)ctBFRowLinkUpNodeMap));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return ctBFRowLinkUpNodeMap;
    }

    public static Map<Long, CtBFRowLinkDownNode> loadBillLinkDownNodes(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        try {
            String downLoodParam = ResManager.loadKDString((String)"\u4e0b\u67e5\u63a5\u53e3\u53c2\u6570", (String)"CtBillLkServiceHelper_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
            StringBuilder args = new StringBuilder();
            args.append(downLoodParam);
            args.append("sTenantCode:");
            args.append(sTenantCode);
            args.append(",sAccountId:");
            args.append(sAccountId);
            args.append(",entityNumber:");
            args.append(entityNumber);
            args.append(",billIds:");
            args.append(JSON.toJSONString((Object)billIds));
            log.info(args.toString());
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        List<Object> ctBFRows = new ArrayList();
        ctBFRows = onlyDirtTarget ? CtBillLkQueryService.loadBillLinkDownDirt(sTenantCode, sAccountId, entityNumber, billIds) : CtBillLkQueryService.loadBillLinkDownRowsFull(sTenantCode, sAccountId, entityNumber, billIds);
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        log.info("before build:" + SerializationUtils.toJsonString(ctBFRows));
        Map ctBFRowLinkDownNodeMap = service.getLinkTreeBuilder().buildBillLinkDownNodes(sTenantCode, sAccountId, entityNumber, billIds, ctBFRows);
        try {
            log.info("downlook result ctBFRowLinkDownNodeMap\uff1a" + SerializationUtils.toJsonString((Object)ctBFRowLinkDownNodeMap));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return ctBFRowLinkDownNodeMap;
    }

    public static List<CtBFRowLinkUpNode> loadEntryLinkUpNodes(CtEntryLkUpQueryArgs ctEntryLkUpQueryArgs) {
        try {
            String upLoodParam = ResManager.loadKDString((String)"\u4e0a\u67e5\u63a5\u53e3\u53c2\u6570", (String)"CtBillLkServiceHelper_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
            StringBuilder args = new StringBuilder();
            args.append(upLoodParam);
            args.append("arrg:");
            args.append(JSON.toJSONString((Object)ctEntryLkUpQueryArgs));
            log.info(args.toString());
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        List<Object> allRows = new ArrayList();
        allRows = ctEntryLkUpQueryArgs.isOnlyDirtTarget() ? CtEntryLkQueryService.loadEntryLinkUpRowsDirt(ctEntryLkUpQueryArgs) : CtEntryLkQueryService.loadEntryLinkUpRowsFull(ctEntryLkUpQueryArgs);
        log.info("before build:" + SerializationUtils.toJsonString(allRows));
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)ctEntryLkUpQueryArgs.gettMainEntityKey(), (String)ctEntryLkUpQueryArgs.gettEntryKey());
        List ctBFRowLinkUpNodes = service.getLinkTreeBuilder().buildLinkUpNodes(ctEntryLkUpQueryArgs.gettTenantCode(), ctEntryLkUpQueryArgs.gettAccountId(), allRows, tableDefine.getTableId(), ctEntryLkUpQueryArgs.gettEntryIds().toArray(new Long[0]));
        try {
            log.info("uplook result ctBFRowLinkUpNodeMap\uff1a" + SerializationUtils.toJsonString((Object)ctBFRowLinkUpNodes));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return ctBFRowLinkUpNodes;
    }

    public static List<CtBFRowLinkDownNode> loadEntryLinkDownNodes(CtEntryLkDownQueryArgs ctEntryLkDownQueryArgs) {
        try {
            String downLoodParam = ResManager.loadKDString((String)"\u4e0b\u67e5\u63a5\u53e3\u53c2\u6570", (String)"CtBillLkServiceHelper_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
            StringBuilder args = new StringBuilder();
            args.append(downLoodParam);
            args.append("args:");
            args.append(SerializationUtils.toJsonString((Object)ctEntryLkDownQueryArgs));
            log.info(args.toString());
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        List<Object> ctBFRows = new ArrayList();
        ctBFRows = ctEntryLkDownQueryArgs.isOnlyDirtTarget() ? CtEntryLkQueryService.loadEntryLinkDownDirt(ctEntryLkDownQueryArgs) : CtEntryLkQueryService.loadEntryLinkDownRowsFull(ctEntryLkDownQueryArgs);
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        log.info("before build:" + SerializationUtils.toJsonString(ctBFRows));
        List ctBFRowLinkDownNodeMap = service.getLinkTreeBuilder().buildLinkDownNodes(ctEntryLkDownQueryArgs.getsTenantCode(), ctEntryLkDownQueryArgs.getsAccountId(), ctEntryLkDownQueryArgs.getsMainEntityKey(), ctEntryLkDownQueryArgs.getsEntryKey(), ctEntryLkDownQueryArgs.getsEntryIds().toArray(new Long[0]), ctBFRows);
        try {
            log.info("downlook result ctBFRowLinkDownNodeMap\uff1a" + SerializationUtils.toJsonString((Object)ctBFRowLinkDownNodeMap));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return ctBFRowLinkDownNodeMap;
    }

    public static void addCtBillLinks(CtAddLinkArgs ctAddLinkArgs) {
        CtBillLkBusinessService.addCtBillLinks(ctAddLinkArgs);
    }

    public static Map<Long, Boolean> hasCtBillLksUp(String tTenantCode, String tAccountId, String tEntitykey, List<Long> pkIds) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(pkIds.size());
        for (Long pkId : pkIds) {
            resultMap.put(pkId, Boolean.FALSE);
        }
        CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
        ctLkUpQueryArgs.settTenantCode(tTenantCode);
        ctLkUpQueryArgs.settAccountId(tAccountId);
        ctLkUpQueryArgs.settEntityKey(tEntitykey);
        ctLkUpQueryArgs.settBillIds(pkIds);
        List<CtBillLkRes> ctDirtBillLkUp = CtBillLkServiceHelper.getDirtBillLkUp(ctLkUpQueryArgs);
        for (CtBillLkRes ctBillLk : ctDirtBillLkUp) {
            resultMap.put(ctBillLk.gettBillId(), Boolean.TRUE);
        }
        return resultMap;
    }

    public static Map<Long, Boolean> hasCtBillLksDown(String sTenantCode, String sAccountId, String sEntitykey, List<Long> pkIds) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(pkIds.size());
        for (Long pkId : pkIds) {
            resultMap.put(pkId, Boolean.FALSE);
        }
        CtLkDownQueryArgs ctLkDownQueryArgs = new CtLkDownQueryArgs();
        ctLkDownQueryArgs.setsTenantCode(sTenantCode);
        ctLkDownQueryArgs.setsAccountId(sAccountId);
        ctLkDownQueryArgs.setsEntityKey(sEntitykey);
        ctLkDownQueryArgs.setsBillIds(pkIds);
        List<CtBillLkRes> ctDirtBillLkDown = CtBillLkServiceHelper.getDirtBillLkDown(ctLkDownQueryArgs);
        for (CtBillLkRes ctBillLk : ctDirtBillLkDown) {
            resultMap.put(ctBillLk.getsBillId(), Boolean.TRUE);
        }
        return resultMap;
    }
}

