/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.sync;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.ctbotp.sync.GSyncLogService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.constants.CtSyncLogConst;
import kd.bos.entity.ctbotp.constants.SyncStatusEnum;
import kd.bos.entity.ctbotp.runtime.CtSaveArgs;
import kd.bos.entity.ctbotp.runtime.CtSaveOperationResult;
import kd.bos.entity.ctbotp.runtime.CtSyncArgs;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.sync.ICtSyncEngineService;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.util.CollectionUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.MapUtils;

public abstract class AbstractCtSyncEngine
implements ICtSyncEngineService {
    private static final Log log = LogFactory.getLog(AbstractCtSyncEngine.class);
    private static final String BOS_MSERVICE_CTBOTP = "bos-mservice-ctbotp";

    public abstract List<SyncLog> beforeAddGSyncLog(CtSyncArgs var1);

    public abstract void updateSucccessStatus(SyncLog var1, DynamicObject var2);

    @Override
    public void addGSyncLog(CtSyncArgs args) {
        List<SyncLog> gSyncLogs = this.beforeAddGSyncLog(args);
        if (CollectionUtils.isEmpty(gSyncLogs)) {
            return;
        }
        this.addGSyncLog(gSyncLogs);
    }

    @Override
    public CtSaveOperationResult save(CtSyncArgs args) {
        CtSaveOperationResult ctSaveOperationResult = this.ctSave(args);
        return ctSaveOperationResult;
    }

    @Override
    public void updateGSyncLog(CtSaveOperationResult ctSaveOperationResult, CtSyncArgs ctSyncArgs) {
        String errorMsg = null;
        if (ctSaveOperationResult.isException()) {
            errorMsg = ctSaveOperationResult.getMessage();
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)CtSyncLogConst.SYNC_FORMID_G);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        for (SyncLog gSyncLog : ctSyncArgs.getsSyncLogs()) {
            DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
            obj.set("id", (Object)gSyncLog.getId());
            obj.set("ttenantcode", (Object)ctSyncArgs.gettTenantCode());
            obj.set("tAccountId", (Object)ctSyncArgs.gettAccountId());
            Long tbillId = gSyncLog.getTbillId();
            obj.set("tbillid", (Object)tbillId);
            if (ctSaveOperationResult != null && MapUtils.isNotEmpty((Map)ctSaveOperationResult.gettBillNoMap())) {
                obj.set("tbillno", ctSaveOperationResult.gettBillNoMap().get(tbillId));
            }
            if (!ctSaveOperationResult.isException()) {
                Set successIds = ctSaveOperationResult.getReporter().getSuccessIds();
                Map errorIds = ctSaveOperationResult.getReporter().getFailIds();
                if (successIds.contains(tbillId)) {
                    this.updateSucccessStatus(gSyncLog, obj);
                } else {
                    obj.set("desc_tag", errorIds.get(gSyncLog.getSbillId()));
                    obj.set("status", (Object)SyncStatusEnum.F.getStatus());
                }
            } else {
                obj.set("desc_tag", (Object)errorMsg);
                obj.set("status", (Object)SyncStatusEnum.F.getStatus());
            }
            obj.set("updatetime", (Object)new Date());
            dynamicObjects.add(obj);
        }
        if (CollectionUtils.isNotEmpty(dynamicObjects)) {
            GSyncLogService.create().updateNoTx(dynamicObjects);
        }
    }

    protected CtSaveOperationResult ctSave(CtSyncArgs args) {
        CtSaveArgs ctSaveArgs = new CtSaveArgs();
        try {
            BeanUtils.copyProperties((Object)ctSaveArgs, (Object)args);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        String result = null;
        try {
            result = CtBotpApiUtils.post(ctSaveArgs.gettTenantCode(), ctSaveArgs.gettAccountId(), CtApiUrlEnum.CTSAVE, SerializationUtils.toJsonString((Object)ctSaveArgs));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        CtSaveOperationResult ctSaveOperationResult = new CtSaveOperationResult();
        String errorMsg = "";
        if (result == null) {
            errorMsg = ResManager.loadKDString((String)"\u8c03\u7528\u4fdd\u5b58\u76ee\u6807\u5355\u63a5\u53e3\u5f02\u5e38\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"AbstractCtSyncEngine_0", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]);
            ctSaveOperationResult.setException(Boolean.TRUE.booleanValue());
            ctSaveOperationResult.setMessage(errorMsg);
            return ctSaveOperationResult;
        }
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        if (openApiResult != null && !openApiResult.get("errorCode").equals("0")) {
            ctSaveOperationResult.setException(Boolean.TRUE.booleanValue());
            Object message = openApiResult.get("message");
            errorMsg = StringUtils.isNotBlank(message) ? message.toString() : String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4fdd\u5b58\u76ee\u6807\u5355\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002\u9519\u8bef\u7801\uff1a%s", (String)"AbstractCtSyncEngine_1", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]), openApiResult.get("errorCode"));
            ctSaveOperationResult.setMessage(errorMsg);
            return ctSaveOperationResult;
        }
        if (openApiResult != null && openApiResult.get("data") != null) {
            ctSaveOperationResult = (CtSaveOperationResult)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(openApiResult.get("data")), CtSaveOperationResult.class);
        }
        return ctSaveOperationResult;
    }

    protected void addGSyncLog(List<SyncLog> gSyncLogs) {
        GSyncLogService gSyncLogService = new GSyncLogService();
        gSyncLogService.addSyncLogs(gSyncLogs);
    }
}

