/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.sync;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ctbotp.runtime.CtSaveOperationResult;
import kd.bos.entity.ctbotp.runtime.CtSyncArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.sync.AbstractCtSyncEngine;
import kd.bos.service.ctbotp.sync.CtSyncEngineBatchImpl;
import kd.bos.service.ctbotp.sync.CtSyncEngineImpl;
import kd.bos.service.ctbotp.sync.ICtSyncEngineService;

public class CtSyncEngine {
    private static final Log log = LogFactory.getLog(CtSyncEngine.class);

    public CtSaveOperationResult ctSync(CtSyncArgs args) {
        ICtSyncEngineService ctSyncEngineService = this.getCtSyncEngineService(args.isBatchPush());
        ctSyncEngineService.addGSyncLog(args);
        CtSaveOperationResult ctSaveOperationResult = ctSyncEngineService.save(args);
        try (TXHandle h = TX.requiresNew();){
            try {
                ctSyncEngineService.updateGSyncLog(ctSaveOperationResult, args);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return ctSaveOperationResult;
    }

    private ICtSyncEngineService getCtSyncEngineService(boolean isBatchPush) {
        AbstractCtSyncEngine ctSyncEngineService = null;
        ctSyncEngineService = isBatchPush ? new CtSyncEngineBatchImpl() : new CtSyncEngineImpl();
        return ctSyncEngineService;
    }
}

