/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.CtLinkSetElement;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ctbotp.log.CtBOTPLog;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtBeforeSaveTransEventArgs;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtFinishWriteBackEventArgs;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtRollbackSaveEventArgs;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.service.botp.track.BFTrackerOpType;
import kd.bos.service.ctbotp.track.CtBFTracker;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerDoNothing;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.CtWriteBackRetryer;
import kd.bos.service.ctbotp.track.CtWriteBacker;
import kd.bos.service.ctbotp.track.bizentity.CtSourceBillInfo;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtTrackerTypes;
import kd.bos.service.ctbotp.track.helper.ICtSaveTracker;
import kd.bos.service.ctbotp.track.opcontroller.ICtOpController;
import kd.bos.xdb.hint.ShardingHintContext;

public class CtBFTrackerEngine {
    private static final String BFTRACKER_ENGINE_PREPARE_PROPERTYS = "BFTrackerEngine.preparePropertys(billids, fieldKeys)";
    private static final String BFTRACKER_ENGINE_EXECUTE = "BFTrackerEngine.execute(dataEntities)";
    private CtBFTrackerContext trackerContext;
    private CtBFTrackerResult trackerResult;
    private CtBFTrackerDbService dbService;
    boolean needLink = false;
    private boolean enterTrans = false;

    public CtBFTrackerEngine() {
    }

    @Deprecated
    public CtBFTrackerEngine(IDataEntityType entityType, BFTrackerOpType opType, Map<String, Object> opMeta, OperationContext opContext) {
        this(entityType, opType, opMeta, opContext, OperateOption.create());
    }

    public CtBFTrackerEngine(IDataEntityType entityType, BFTrackerOpType opType, Map<String, Object> opMeta, OperationContext opContext, OperateOption option) {
        this.needLink = false;
        BillEntityType mainType = null;
        if (entityType instanceof BillEntityType) {
            mainType = (BillEntityType)entityType;
        }
        if (mainType == null) {
            return;
        }
        if (mainType.getPrimaryKey() instanceof VarcharProp) {
            return;
        }
        if (opType == BFTrackerOpType.Unknown) {
            return;
        }
        this.trackerContext = new CtBFTrackerContext(mainType, opType, opMeta, opContext, option);
        this.trackerResult = new CtBFTrackerResult();
        CtLinkSetElement linkSet = this.loadLinkSet();
        this.trackerContext.setLinkSet(linkSet);
        if (!this.isValidLinkSet(linkSet)) {
            this.getOperateLog().info("BFTrackerEngine(), return because of !isValidLinkSet");
            return;
        }
        this.trackerContext.createPlugInProxy();
        String statusFldKey = this.loadStatusFldKey(mainType, opType, opMeta);
        this.trackerContext.setStatusFldKey(statusFldKey);
        CtTrackerTypes trackerTypes = this.buildTrackerTypes(this.trackerContext.getTargetMainType(), linkSet);
        this.trackerContext.setTrackerTypes(trackerTypes);
        this.dbService = this.createDbService();
        this.trackerContext.setDbService(this.dbService);
        this.needLink = true;
    }

    public OperateLog getOperateLog() {
        if (this.trackerContext != null) {
            return this.trackerContext.getOperateLog();
        }
        return OperateLog.get((boolean)false);
    }

    public void setOperateLog(OperateLog operateLog) {
        this.trackerContext.setOperateLog(operateLog);
    }

    public void preparePropertys(List<String> fieldKeys) {
        if (!this.needLink) {
            return;
        }
        this.getOperateLog().info("BFTrackerEngine.preparePropertys(fieldKeys)");
        this.trackerContext.preparePropertys(fieldKeys);
    }

    public void preparePropertys(Object[] billIds, List<String> fieldKeys) {
        if (!this.needLink) {
            return;
        }
        this.getOperateLog().beginMothed(BFTRACKER_ENGINE_PREPARE_PROPERTYS, null);
        ArrayList<Long> ids = new ArrayList<Long>(billIds.length);
        for (Object billId : billIds) {
            if (billId == null) continue;
            Long id = null;
            if (billId.getClass() == String.class) {
                id = StringUtils.isBlank((Object)billId) ? 0L : Long.parseLong((String)billId);
            } else if (billId.getClass() == Integer.class) {
                id = Long.parseLong(String.valueOf(billId));
            } else if (billId.getClass() == Long.class) {
                id = (Long)billId;
            }
            if (id == null) continue;
            ids.add(id);
        }
        if (ids.isEmpty() || !this.trackerContext.getDbService().existSnapshot(ids.toArray(new Long[0]))) {
            this.needLink = false;
            this.getOperateLog().endMothed(BFTRACKER_ENGINE_PREPARE_PROPERTYS, "BFTrackerEngine.preparePropertys(billids, fieldKeys), return false because of !existSnapshot");
            return;
        }
        this.trackerContext.preparePropertys(fieldKeys);
        this.getOperateLog().endMothed(BFTRACKER_ENGINE_PREPARE_PROPERTYS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DynamicObject[] dataEntities) {
        IDataEntityType dt;
        if (!this.needLink) {
            return;
        }
        this.getOperateLog().beginMothed(BFTRACKER_ENGINE_EXECUTE, BFTRACKER_ENGINE_EXECUTE);
        this.trackerContext.setProgressTip(ResManager.loadKDString((String)"\u5f00\u59cb\u8bb0\u5f55\u5173\u8054\u5173\u7cfb\u4e0e\u53cd\u5199\u6e90\u5355", (String)"BFTrackerEngine_0", (String)"bos-mservice-botp", (Object[])new Object[0]));
        for (DynamicObject obj : dataEntities) {
            this.trackerContext.getTargetBillIds().add(obj.getPkValue());
        }
        Map<CtBFTracker, DynamicObject[]> trackers = this.createBFTrackers(dataEntities);
        ShardingHintContext ctx = null;
        if (dataEntities.length != 0 && ShardingHinter.isSharding((String)(dt = dataEntities[0].getDataEntityType()).getAlias()) && (ctx = ShardingHinter.tryHint((IDataEntityType)dt, (Object[])this.trackerContext.getTargetBillIds().toArray())) != null) {
            ctx.set();
        }
        try {
            for (Map.Entry<CtBFTracker, DynamicObject[]> item : trackers.entrySet()) {
                CtBFTracker tracker = item.getKey();
                tracker.execute(item.getValue());
            }
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        this.getOperateLog().endMothed(BFTRACKER_ENGINE_EXECUTE, null);
    }

    public void saveBeforeTrans() {
        if (!this.needLink) {
            return;
        }
        this.getOperateLog().beginMothed("BFTrackerEngine.saveBeforeTrans()", null);
        CtBeforeSaveTransEventArgs eventArgs = new CtBeforeSaveTransEventArgs();
        this.trackerContext.getPlugInProxy().fireBeforeSaveTrans(eventArgs);
        ICtSaveTracker.get().saveBeforeTrans(this.trackerContext, this.trackerResult, this.dbService);
        this.getOperateLog().endMothed("BFTrackerEngine.saveBeforeTrans()", null);
    }

    public void saveBeginTrans() {
        if (!this.needLink) {
            return;
        }
        this.getOperateLog().beginMothed("BFTrackerEngine.saveBeginTrans()", null);
        this.enterTrans = true;
        ICtSaveTracker.get().saveBeginTrans(this.trackerContext, this.trackerResult, this.dbService);
        this.getOperateLog().endMothed("BFTrackerEngine.saveBeginTrans()", null);
    }

    public void saveTrans() {
        if (!this.needLink) {
            return;
        }
        this.getOperateLog().beginMothed("BFTrackerEngine.saveTrans()", null);
        this.enterTrans = true;
        ICtSaveTracker.get().saveTrans(this.trackerContext, this.trackerResult, this.dbService);
        this.getOperateLog().endMothed("BFTrackerEngine.saveTrans()", null);
    }

    public void saveAfterTrans() {
        if (!this.needLink) {
            return;
        }
        this.getOperateLog().beginMothed("BFTrackerEngine.saveAfterTrans()", null);
        ICtSaveTracker.get().saveAfterTrans(this.trackerContext, this.trackerResult, this.dbService);
        this.getOperateLog().endMothed("BFTrackerEngine.saveAfterTrans()", null);
    }

    public void rollbackSave() {
        if (!this.needLink) {
            return;
        }
        this.getOperateLog().beginMothed("BFTrackerEngine.rollbackSave()", null);
        ICtSaveTracker.get().rollbackSave(this.trackerContext, this.trackerResult, this.dbService);
        this.releaseWriteBackDataMutex();
        CtRollbackSaveEventArgs eventArgs = new CtRollbackSaveEventArgs();
        this.trackerContext.getPlugInProxy().fireRollbackSave(eventArgs);
        this.getOperateLog().endMothed("BFTrackerEngine.rollbackSave()", null);
    }

    public void saveFinally() {
        if (!this.needLink) {
            return;
        }
        this.getOperateLog().beginMothed("BFTrackerEngine.saveFinally()", null);
        ICtSaveTracker.get().saveFinally(this.trackerContext, this.trackerResult, this.dbService);
        this.releaseWriteBackDataMutex();
        CtFinishWriteBackEventArgs eventArgs = new CtFinishWriteBackEventArgs();
        this.trackerContext.getPlugInProxy().fireFinishWriteBack(eventArgs);
        this.getOperateLog().endMothed("BFTrackerEngine.saveFinally()", null);
    }

    public void release() {
        if (!this.needLink) {
            return;
        }
        this.getOperateLog().beginMothed("BFTrackerEngine.release()", null);
        if (!this.enterTrans) {
            this.releaseWriteBackDataMutex();
        }
        this.getOperateLog().endMothed("BFTrackerEngine.release()", null);
    }

    public OperationResult retry(CtBOTPLog[] wbLogs) {
        ICtOpController opController = ICtOpController.create(this.trackerContext.getOpType());
        CtWriteBackRetryer writebacker = new CtWriteBackRetryer(this.trackerContext, this.trackerResult, opController, this.dbService);
        this.trackerContext.setTargetSubMainType(this.trackerContext.getTargetMainType());
        writebacker.retry(wbLogs);
        this.saveTrans();
        this.saveAfterTrans();
        this.saveFinally();
        for (CtBOTPLog wbLog : wbLogs) {
            if (writebacker.getFailWbLogIds().contains(wbLog.getId())) continue;
            writebacker.getOpResult().getSuccessPkIds().add(wbLog.getId());
        }
        return writebacker.getOpResult();
    }

    private String loadStatusFldKey(BillEntityType mainType, BFTrackerOpType opType, Map<String, Object> opMeta) {
        Map saveOpMeta;
        String opStatusFldKey;
        String statusFldKey = mainType.getBillStatus();
        if (opMeta != null && (opType == BFTrackerOpType.Draft || opType == BFTrackerOpType.Save || opType == BFTrackerOpType.Audit || opType == BFTrackerOpType.UnAudit)) {
            String opStatusFldKey2 = this.getOpStatusFldKey(opMeta);
            if (StringUtils.isNotBlank((CharSequence)opStatusFldKey2)) {
                statusFldKey = opStatusFldKey2;
            }
        } else if (StringUtils.isBlank((CharSequence)statusFldKey) && StringUtils.isNotBlank((CharSequence)(opStatusFldKey = this.getOpStatusFldKey(saveOpMeta = EntityMetadataCache.getDataEntityOperate((String)mainType.getName(), (String)"save"))))) {
            statusFldKey = opStatusFldKey;
        }
        return statusFldKey;
    }

    private String getAuditStatus(BillEntityType mainType) {
        String statusValue;
        Map opParameter;
        Map auditOpMeta;
        String auditStatus = BillStatus.C.name();
        String audit = EntityMetadataCache.getDataEntityOperations((String)mainType.getName()).getAudit();
        if (StringUtils.isNotBlank((CharSequence)audit) && (auditOpMeta = EntityMetadataCache.getDataEntityOperate((String)mainType.getName(), (String)audit)) != null && (opParameter = (Map)auditOpMeta.get("parameter")) != null && StringUtils.isNotBlank((CharSequence)(statusValue = (String)opParameter.get("value")))) {
            auditStatus = statusValue;
        }
        return auditStatus;
    }

    private String getOpStatusFldKey(Map<String, Object> opMeta) {
        Map opParameter;
        String statusFldKey = "";
        if (opMeta != null && (opParameter = (Map)opMeta.get("parameter")) != null) {
            statusFldKey = (String)opParameter.get("statusProp");
        }
        return statusFldKey;
    }

    private CtLinkSetElement loadLinkSet() {
        return new CtLinkSetElement();
    }

    private boolean isValidLinkSet(CtLinkSetElement linkSet) {
        return linkSet != null && !linkSet.getItems().isEmpty() && StringUtils.isNotBlank((CharSequence)linkSet.getCtTrackerTable()) && StringUtils.isNotBlank((CharSequence)linkSet.getCtWbSnapTable());
    }

    private CtTrackerTypes buildTrackerTypes(BillEntityType mainType, CtLinkSetElement linkSet) {
        BillEntityType snapshotType = (BillEntityType)EntityMetadataCache.getDataEntityTypeNoCache((String)"ctbotp_snapshot");
        snapshotType.setAlias(linkSet.getCtTrackerTable());
        snapshotType.setDBRouteKey(mainType.getDBRouteKey());
        EntryType wbEntryType = (EntryType)((EntryProp)snapshotType.findProperty("ctwbsnapentity")).getItemType();
        wbEntryType.setAlias(linkSet.getCtWbSnapTable());
        wbEntryType.setDBRouteKey(mainType.getDBRouteKey());
        BillEntityType entryTrackerType = (BillEntityType)EntityMetadataCache.getDataEntityTypeNoCache((String)"ctbotp_snapshot_tc");
        entryTrackerType.setAlias(linkSet.getCtTrackerTable());
        entryTrackerType.setDBRouteKey(mainType.getDBRouteKey());
        BillEntityType wbItemType = (BillEntityType)EntityMetadataCache.getDataEntityTypeNoCache((String)"ctbotp_snapshot_wb");
        wbItemType.setAlias(linkSet.getCtWbSnapTable());
        wbItemType.setDBRouteKey(mainType.getDBRouteKey());
        return new CtTrackerTypes(snapshotType, entryTrackerType, wbItemType);
    }

    private CtBFTrackerDbService createDbService() {
        CtBFTrackerDbService db = new CtBFTrackerDbService();
        db.setCtTrackerTypes(this.trackerContext.getTrackerTypes());
        db.setTargetSubMainType(this.trackerContext.getTargetMainType());
        return db;
    }

    private Map<CtBFTracker, DynamicObject[]> createBFTrackers(DynamicObject[] dataEntities) {
        BFTrackerOpType opType = this.trackerContext.getOpType();
        Map<CtBFTracker, DynamicObject[]> mapTrackers = new HashMap<CtBFTracker, DynamicObject[]>();
        if (!this.needLink || dataEntities.length == 0 || opType == BFTrackerOpType.Unknown) {
            CtBFTrackerDoNothing donothing = new CtBFTrackerDoNothing();
            mapTrackers.put(donothing, dataEntities);
            return mapTrackers;
        }
        BillEntityType subMainType = (BillEntityType)dataEntities[0].getDataEntityType();
        this.trackerContext.setTargetSubMainType(subMainType);
        if (opType == BFTrackerOpType.Draft || opType == BFTrackerOpType.Save || opType == BFTrackerOpType.UnCancel) {
            mapTrackers = this.createBFTrackersByStatus(dataEntities);
        } else {
            ICtOpController opController = ICtOpController.create(opType);
            CtWriteBacker writebacker = new CtWriteBacker(this.trackerContext, this.trackerResult, opController, this.dbService);
            mapTrackers.put(writebacker, dataEntities);
        }
        return mapTrackers;
    }

    private Map<CtBFTracker, DynamicObject[]> createBFTrackersByStatus(DynamicObject[] dataEntities) {
        BillEntityType subMainType = this.trackerContext.getTargetSubMainType();
        String statusFldKey = this.trackerContext.getStatusFldKey();
        IDataEntityProperty statusProp = null;
        if (StringUtils.isNotBlank((CharSequence)statusFldKey)) {
            statusProp = subMainType.findProperty(statusFldKey);
        }
        HashMap<CtBFTracker, DynamicObject[]> mapTrackers = new HashMap<CtBFTracker, DynamicObject[]>();
        if (statusProp == null) {
            ICtOpController opController = ICtOpController.create(BFTrackerOpType.Save);
            CtWriteBacker tracker = new CtWriteBacker(this.trackerContext, this.trackerResult, opController, this.dbService);
            mapTrackers.put(tracker, dataEntities);
        } else {
            HashMap dataMap = new HashMap();
            for (DynamicObject dataEntity : dataEntities) {
                String status = (String)statusProp.getValueFast((Object)dataEntity);
                if (StringUtils.isBlank((CharSequence)status)) {
                    status = BillStatus.Z.name();
                }
                if (!dataMap.containsKey(status)) {
                    dataMap.put(status, new ArrayList());
                }
                ((List)dataMap.get(status)).add(dataEntity);
            }
            for (Map.Entry entry : dataMap.entrySet()) {
                CtWriteBacker writebacker;
                ICtOpController opController;
                String status = (String)entry.getKey();
                if (status.equalsIgnoreCase(this.getAuditStatus(this.trackerContext.getTargetMainType()))) {
                    opController = ICtOpController.create(BFTrackerOpType.Audit);
                    writebacker = new CtWriteBacker(this.trackerContext, this.trackerResult, opController, this.dbService);
                    mapTrackers.put(writebacker, ((List)entry.getValue()).toArray(new DynamicObject[0]));
                    continue;
                }
                opController = ICtOpController.create(BFTrackerOpType.Save);
                writebacker = new CtWriteBacker(this.trackerContext, this.trackerResult, opController, this.dbService);
                mapTrackers.put(writebacker, ((List)entry.getValue()).toArray(new DynamicObject[0]));
            }
        }
        return mapTrackers;
    }

    private void releaseWriteBackDataMutex() {
        if (this.trackerResult != null && this.trackerResult.getSrcBillInfos() != null) {
            try (TXHandle h = TX.notSupported();){
                StringBuilder errMsg = new StringBuilder();
                for (CtSourceBillInfo sourceBillInfo : this.trackerResult.getSrcBillInfos().values()) {
                    if (sourceBillInfo.isSaveByNewThread()) continue;
                    sourceBillInfo.releaseDataMutex(errMsg);
                }
            }
        }
    }
}

