/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.log.AbstractCtDetailLogInfo;
import kd.bos.entity.ctbotp.log.CtBOTPLog;
import kd.bos.entity.ctbotp.log.CtTCLogDetailInfo;
import kd.bos.entity.ctbotp.log.CtTCLogRow;
import kd.bos.entity.ctbotp.log.CtWBLogDetailInfo;
import kd.bos.entity.ctbotp.log.CtWBLogRow;
import kd.bos.entity.ctbotp.log.CtWFLogDetailInfo;
import kd.bos.entity.ctbotp.log.CtWVLogDetailInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.track.CtBFTrackerBatchContext;
import kd.bos.service.ctbotp.track.CtBFTrackerBatchResult;
import kd.bos.service.ctbotp.track.CtBFTrackerOpContext;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.CtWriteBackContext;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtRowLinkId;
import kd.bos.service.ctbotp.track.bizentity.CtSheet;
import kd.bos.service.ctbotp.track.bizentity.CtSheets;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.bizentity.CtWSRow;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class CtBFTrackerLog {
    private static final Log LOG = LogFactory.getLog(CtBFTrackerLog.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-botp";
    private static final String FORMID_BOTP_LOG = "botp_log";
    private static final String KEY_CLOSE_LOG = "closelog";
    private static final String KEY_WRITEVALUE_LOG = "writevaluelog";
    private static final String KEY_KEEP_WRITEBACK_LOG = "writebacklog";
    private static final String KEY_ENTRY_TRACKER_SBILLID = "sbillid";
    private static final String KEY_ENTRY_TRACKER_STABLEID = "stableid";
    private static final String KEY_ENTRY_TRACKER_SID = "sid";
    private static final String KEY_ENTRY_TRACKER_TTABLEID = "ttableid";
    private static final String KEY_ENTRY_TRACKER_TID = "tid";
    private static final String KEY_WRITE_FID = "fid";
    private static final String KEY_WRITE_RULEVER = "ruleverid";
    private static final String KEY_WRITE_RULEITEM = "ruleitemid";
    private static final String KEY_WRITE_SBILLID = "wb_sbillid";
    private static final String KEY_WRITE_STABLEID = "wb_stableid";
    private static final String KEY_WRITE_SID = "wb_sid";
    private static final String KEY_WRITE_VALUE = "wb_value";
    public long taskId = DB.genGlobalLongId();
    private Date startTime = TimeServiceHelper.now();
    private long userId = RequestContext.get().getCurrUserId();
    private List<CtBOTPLog> toTargetLogs = new ArrayList<CtBOTPLog>();
    private Map<Long, List<CtBOTPLog>> toSourceLogs = new HashMap<Long, List<CtBOTPLog>>(1);
    private Map<CtRowLinkId, CtBOTPLog> wvLogs = new HashMap<CtRowLinkId, CtBOTPLog>();
    private Map<Long, CtRowLinkId> tcId2RowLinks = new HashMap<Long, CtRowLinkId>();
    private Map<Long, CtRowLinkId> wbId2RowLinks = new HashMap<Long, CtRowLinkId>();
    private Map<Long, Long> wbId2TcIds = new HashMap<Long, Long>();
    private Map<String, TableDefine> mainTableDefines = new HashMap<String, TableDefine>();
    private Map<Long, TableDefine> entryTableDefines = new HashMap<Long, TableDefine>();
    private Map<Long, String> dbRouteKeys = new HashMap<Long, String>();
    public Map<String, Map<Object, String>> allBillNos = new HashMap<String, Map<Object, String>>();
    private Boolean closeLog = null;
    private Boolean writeValueLog = null;
    private Boolean keepWriteBackLog = null;
    public static final Map<String, String> OPTYPES = new HashMap<String, String>();

    public List<CtBOTPLog> getToTargetLogs() {
        return this.toTargetLogs;
    }

    public List<CtBOTPLog> getToSourceLogs(String srcEntityNumber) {
        Long sTableId = this.loadMainTableId(srcEntityNumber);
        ArrayList<CtBOTPLog> logs = new ArrayList<CtBOTPLog>();
        for (Map.Entry<CtRowLinkId, CtBOTPLog> entry : this.wvLogs.entrySet()) {
            if (Long.compare(entry.getKey().getSTableId(), sTableId) != 0) continue;
            logs.add(entry.getValue());
        }
        List<CtBOTPLog> wfLogs = this.toSourceLogs.get(sTableId);
        if (wfLogs != null) {
            logs.addAll(wfLogs);
        }
        return logs;
    }

    public synchronized void addWriteBackLogs(CtLinkItemContext ctLinkItemContext, CtBFTrackerBatchContext batchContext, CtBFTrackerBatchResult batchResult) {
        if (this.isCloseLog().booleanValue()) {
            return;
        }
        try {
            if (this.createBlankEntryTrackerLog(ctLinkItemContext, batchContext, batchResult)) {
                return;
            }
            this.allBillNos = this.batchLoadBillNos(ctLinkItemContext, batchResult.getSnapshot(), batchResult.getSheets());
            ArrayList<CtWBLogRow> histWRuleLogRows = new ArrayList<CtWBLogRow>();
            Map<CtRowLinkId, CtBOTPLog> tcLogs = this.buildTcLogs(ctLinkItemContext, batchContext, batchResult, histWRuleLogRows);
            HashMap<Long, CtBOTPLog> wfLogs = new HashMap<Long, CtBOTPLog>(1);
            Map<CtRowLinkId, Map<CtRowLinkId, CtBOTPLog>> wbLogsByTc = this.buildWbLogs(ctLinkItemContext, batchContext, batchResult, histWRuleLogRows, tcLogs, wfLogs);
            for (CtBOTPLog log : this.wvLogs.values()) {
                this.fillBillNo(log);
            }
            boolean existWBLog = false;
            for (Map.Entry<CtRowLinkId, Map<CtRowLinkId, CtBOTPLog>> entry1 : wbLogsByTc.entrySet()) {
                CtBOTPLog tcLog = tcLogs.get(entry1.getKey());
                if (tcLog == null) continue;
                existWBLog = false;
                for (Map.Entry<CtRowLinkId, CtBOTPLog> entry2 : entry1.getValue().entrySet()) {
                    CtBOTPLog wbLog = entry2.getValue();
                    CtWBLogDetailInfo wbLogDetailInfo = (CtWBLogDetailInfo)wbLog.getDetailInfo();
                    if (wbLogDetailInfo.getAddWBs().isEmpty() && wbLogDetailInfo.getDelWbIds().isEmpty()) continue;
                    CtBOTPLog wfLog = (CtBOTPLog)wfLogs.get(wbLog.getId());
                    if (wfLog != null) {
                        this.toTargetLogs.add(wbLog);
                        this.toSourceLogs.computeIfAbsent(wfLog.getSTableId(), s -> new ArrayList()).add(wfLog);
                        existWBLog = true;
                        continue;
                    }
                    LOG.info(String.format("\u53cd\u5199\u65e5\u5fd7\uff0c\u53cd\u5199\u9700\u6c42\u65e5\u5fd7[%s]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u53cd\u5199\u7ed3\u679c\u65e5\u5fd7", wbLog.getId()));
                }
                if (!existWBLog) continue;
                this.toTargetLogs.add(tcLog);
            }
            this.tcId2RowLinks.clear();
            this.wbId2RowLinks.clear();
            this.wbId2TcIds.clear();
        }
        catch (Throwable exp) {
            LOG.error(exp);
        }
    }

    public synchronized void addRetryWriteBackLogs(CtLinkItemContext ctLinkItemContext, CtSheets snapshots, CtSheets sheets, CtBOTPLog[] wbLogs) {
        try {
            for (CtBOTPLog wbLog : wbLogs) {
                CtRowLinkId rowLinkId_wb = new CtRowLinkId(wbLog.getSTableId(), wbLog.getSBillId(), wbLog.getTTableId(), wbLog.getTBillId());
                CtBOTPLog wfLog = this.createWriteFinishLog(ctLinkItemContext, rowLinkId_wb, wbLog);
                wfLog.setRemark(ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199", (String)"BFTrackerLog_6", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
                this.toSourceLogs.computeIfAbsent(wfLog.getSTableId(), s -> new ArrayList()).add(wfLog);
                if (StringUtils.isNotBlank((CharSequence)wbLog.getSentityNumber()) && StringUtils.isNotBlank((CharSequence)wbLog.getSBillno())) {
                    this.allBillNos.computeIfAbsent(wbLog.getSentityNumber(), s -> new HashMap()).put(wbLog.getSBillId(), wbLog.getSBillno());
                }
                if (!StringUtils.isNotBlank((CharSequence)wbLog.getTentityNumber()) || !StringUtils.isNotBlank((CharSequence)wbLog.getTBillno())) continue;
                this.allBillNos.computeIfAbsent(wbLog.getTentityNumber(), s -> new HashMap()).put(wbLog.getTBillId(), wbLog.getTBillno());
            }
            for (CtBOTPLog log : this.wvLogs.values()) {
                this.fillBillNo(log);
            }
        }
        catch (Throwable exp) {
            LOG.error(exp);
        }
    }

    public synchronized void addWriteValue(CtWriteBackContext writebackContextCt, CtWSRow wsRow, String srcFld, Object oldValue, String op, Object writeVal, Object newValue) {
        if (this.isCloseLog().booleanValue() || !this.isWriteValueLog().booleanValue()) {
            return;
        }
        try {
            Long tBillId;
            Long tMainTableId;
            CtRowLinkId rowLinkId;
            CtBOTPLog log;
            Long sMainTableId = wsRow.getSId().getMainTableId();
            Long sBillId = wsRow.getSId().getBillId();
            Long sEntryId = wsRow.getSId().getEntryId();
            String sEntityKey = writebackContextCt.getSrcMainType().getName();
            if (wsRow.getSrcActiveRow() != null) {
                sEntityKey = wsRow.getSrcActiveRow().getDataEntityType().getName();
            }
            if ((log = this.wvLogs.get(rowLinkId = new CtRowLinkId(sMainTableId, sBillId, tMainTableId = wsRow.getParent().getParent().getId().getMainTableId(), tBillId = wsRow.getParent().getParent().getId().getBillId()))) == null) {
                log = this.createWriteValueLog(writebackContextCt.getCtLinkItemContext(), rowLinkId);
                this.wvLogs.put(rowLinkId, log);
            }
            String desc = String.format("[rv=%s, ri=%s, id=%s] %s %s %s = %s", wsRow.getParent().getRuleVerId(), wsRow.getParent().getRuleItemId(), wsRow.getParent().getParent().getId().getEntryId(), oldValue, op, writeVal, newValue);
            CtWVLogDetailInfo wvLogDetailInfo = (CtWVLogDetailInfo)log.getDetailInfo();
            wvLogDetailInfo.addWriteValue(sEntityKey, sEntryId, srcFld, oldValue, newValue, desc);
        }
        catch (Throwable exp) {
            LOG.error(exp);
        }
    }

    private Map<CtRowLinkId, CtBOTPLog> buildTcLogs(CtLinkItemContext ctLinkItemContext, CtBFTrackerBatchContext batchContext, CtBFTrackerBatchResult batchResult, List<CtWBLogRow> histWbRows) {
        CtRowLinkId rowLinkId;
        HashMap<CtRowLinkId, CtBOTPLog> tcLogs = new HashMap<CtRowLinkId, CtBOTPLog>(1);
        CtSheets snapshots = batchResult.getSnapshot();
        for (CtSheet sheet : snapshots.values()) {
            for (CtRow row : sheet.getCtRows().values()) {
                rowLinkId = new CtRowLinkId(row.getSId().getMainTableId(), row.getSId().getBillId(), row.getId().getMainTableId(), row.getId().getBillId());
                CtBOTPLog tcLog = (CtBOTPLog)tcLogs.get(rowLinkId);
                if (tcLog == null) {
                    tcLog = this.createEntryTrackerLog(ctLinkItemContext, rowLinkId);
                    tcLogs.put(rowLinkId, tcLog);
                }
                CtTCLogRow tcRow = this.buildTcRow(row, histWbRows);
                this.tcId2RowLinks.put(tcRow.getId(), rowLinkId);
                CtTCLogDetailInfo tcLogDetailInfo = (CtTCLogDetailInfo)tcLog.getDetailInfo();
                tcLogDetailInfo.getHistRows().add(tcRow);
            }
        }
        for (Long tcId : batchResult.getDelEntryTrackerIds()) {
            CtBOTPLog log;
            CtRowLinkId rowLinkId2 = this.tcId2RowLinks.get(tcId);
            if (rowLinkId2 == null || (log = (CtBOTPLog)tcLogs.get(rowLinkId2)) == null || log.getDetailInfo() == null) continue;
            CtTCLogDetailInfo tcLogDetailInfo = (CtTCLogDetailInfo)log.getDetailInfo();
            tcLogDetailInfo.getDelTcIds().add(tcId);
        }
        for (DynamicObject entryTrackerObj : batchResult.getNewEntryTrackers()) {
            Long tBillId = entryTrackerObj.getLong("tbillid");
            CtTCLogRow tcRow = this.buildTcRow(tBillId, entryTrackerObj);
            rowLinkId = new CtRowLinkId(this.loadMainTableId(tcRow.getSt()), tcRow.getSb(), this.loadMainTableId(tcRow.getTt()), tcRow.getTb());
            this.tcId2RowLinks.put(tcRow.getId(), rowLinkId);
            CtBOTPLog log = (CtBOTPLog)tcLogs.get(rowLinkId);
            if (log == null) {
                log = this.createEntryTrackerLog(ctLinkItemContext, rowLinkId);
                tcLogs.put(rowLinkId, log);
            }
            CtTCLogDetailInfo tcLogDetailInfo = (CtTCLogDetailInfo)log.getDetailInfo();
            tcLogDetailInfo.getAddRows().add(tcRow);
        }
        return tcLogs;
    }

    private Map<CtRowLinkId, Map<CtRowLinkId, CtBOTPLog>> buildWbLogs(CtLinkItemContext ctLinkItemContext, CtBFTrackerBatchContext batchContext, CtBFTrackerBatchResult batchResult, List<CtWBLogRow> histWbRows, Map<CtRowLinkId, CtBOTPLog> tcLogs, Map<Long, CtBOTPLog> wfLogs) {
        Long tcId;
        HashMap<CtRowLinkId, Map<CtRowLinkId, CtBOTPLog>> wbLogsByTc = new HashMap<CtRowLinkId, Map<CtRowLinkId, CtBOTPLog>>(1);
        for (CtWBLogRow wRuleLogRow : histWbRows) {
            CtBOTPLog wbLog = this.createOrGetWriteBackLog(ctLinkItemContext, tcLogs, wbLogsByTc, wfLogs, wRuleLogRow);
            if (wbLog == null) continue;
            CtWBLogDetailInfo wbLogDetailInfo = (CtWBLogDetailInfo)wbLog.getDetailInfo();
            wbLogDetailInfo.getHistWBs().add(wRuleLogRow);
        }
        for (Long wbId : batchResult.getDelWBIds()) {
            CtBOTPLog wbLog;
            tcId = this.wbId2TcIds.get(wbId);
            CtRowLinkId rowLinkId_wb = this.wbId2RowLinks.get(wbId);
            CtRowLinkId rowLinkId_tc = this.tcId2RowLinks.get(tcId);
            Map wbLogsByWb = (Map)wbLogsByTc.get(rowLinkId_tc);
            if (wbLogsByWb == null || (wbLog = (CtBOTPLog)wbLogsByWb.get(rowLinkId_wb)) == null) continue;
            CtWBLogDetailInfo wbLogDetailInfo = (CtWBLogDetailInfo)wbLog.getDetailInfo();
            wbLogDetailInfo.getDelWbIds().add(wbId);
        }
        for (DynamicObject wbItemObj : batchResult.getNewWBItems()) {
            Long tBillId;
            tcId = wbItemObj.getLong(KEY_WRITE_FID);
            CtRowLinkId rowLinkId_tc = this.tcId2RowLinks.get(tcId);
            Long tMainTableId = ctLinkItemContext.getMainTableId();
            CtWBLogRow wbLogRow = this.buildWbRow(tMainTableId, tBillId = rowLinkId_tc.getTEntryId(), tcId, wbItemObj);
            CtBOTPLog wbLog = this.createOrGetWriteBackLog(ctLinkItemContext, tcLogs, wbLogsByTc, wfLogs, wbLogRow);
            if (wbLog == null) continue;
            CtWBLogDetailInfo wbLogDetailInfo = (CtWBLogDetailInfo)wbLog.getDetailInfo();
            wbLogDetailInfo.getAddWBs().add(wbLogRow);
        }
        return wbLogsByTc;
    }

    private boolean createBlankEntryTrackerLog(CtLinkItemContext ctLinkItemContext, CtBFTrackerBatchContext batchContext, CtBFTrackerBatchResult batchResult) {
        return batchResult.getDelEntryTrackerIds().isEmpty() && batchResult.getDelWBIds().isEmpty() && batchResult.getNewEntryTrackers().isEmpty() && batchResult.getNewWBItems().isEmpty();
    }

    private CtBOTPLog createBlankBotpLog(CtLinkItemContext ctLinkItemContext, CtRowLinkId rowLinkId) {
        CtBOTPLog log = new CtBOTPLog();
        log.setId(DB.genGlobalLongId());
        log.setTaskId(this.taskId);
        log.setSTableId(rowLinkId.getSTableId().longValue());
        log.setSBillId(rowLinkId.getSEntryId().longValue());
        log.setTTableId(rowLinkId.getTTableId().longValue());
        log.setTBillId(rowLinkId.getTEntryId().longValue());
        if (rowLinkId.getSTableId() != null && Long.compare(0L, rowLinkId.getSTableId()) != 0) {
            log.setSentityNumber(this.loadEntityNumber(rowLinkId.getSTableId()));
            log.setSBillno(this.getBillNo(rowLinkId.getSTableId(), rowLinkId.getSEntryId()));
        }
        if (rowLinkId.getTTableId() != null && Long.compare(0L, rowLinkId.getTTableId()) != 0) {
            log.setTentityNumber(this.loadEntityNumber(rowLinkId.getTTableId()));
            log.setTBillno(this.getBillNo(rowLinkId.getTTableId(), rowLinkId.getTEntryId()));
        }
        log.setUserId(this.userId);
        log.setOpType(this.getOpType(ctLinkItemContext.getTrackerOpContext()));
        log.setStartTime(this.startTime);
        return log;
    }

    private CtBOTPLog createEntryTrackerLog(CtLinkItemContext ctLinkItemContext, CtRowLinkId rowLinkId) {
        CtBOTPLog log = this.createBlankBotpLog(ctLinkItemContext, rowLinkId);
        log.setStatus("1");
        log.setLogType("T");
        CtTCLogDetailInfo tcLogDetailInfo = new CtTCLogDetailInfo();
        tcLogDetailInfo.setEntityKey(ctLinkItemContext.getLinkSetItem().getCtParentEntityKey());
        tcLogDetailInfo.setLinkEntryKey(ctLinkItemContext.getLinkSetItem().getCtLinkEntityKey());
        log.setDetailInfo((AbstractCtDetailLogInfo)tcLogDetailInfo);
        return log;
    }

    private CtBOTPLog createWriteBackLog(CtLinkItemContext ctLinkItemContext, CtRowLinkId rowLinkId) {
        CtBOTPLog log = this.createBlankBotpLog(ctLinkItemContext, rowLinkId);
        log.setStatus("0");
        log.setLogType("W");
        CtWBLogDetailInfo wbLogDetailInfo = new CtWBLogDetailInfo();
        String opKey = null;
        if (ctLinkItemContext.getTrackerContext().getOpMeta() != null) {
            opKey = (String)ctLinkItemContext.getTrackerContext().getOpMeta().get("key");
        }
        wbLogDetailInfo.setOpKey(opKey);
        wbLogDetailInfo.setOpType(ctLinkItemContext.getTrackerOpContext().getOpController().getOpType());
        wbLogDetailInfo.setEntityKey(ctLinkItemContext.getLinkSetItem().getCtParentEntityKey());
        wbLogDetailInfo.setLinkEntryKey(ctLinkItemContext.getLinkSetItem().getCtLinkEntityKey());
        wbLogDetailInfo.setSdbRouteKey(this.loadDBRouteKey(log.getSTableId()));
        log.setDetailInfo((AbstractCtDetailLogInfo)wbLogDetailInfo);
        return log;
    }

    private CtBOTPLog createWriteFinishLog(CtLinkItemContext ctLinkItemContext, CtRowLinkId rowLinkId, CtBOTPLog wbLog) {
        CtBOTPLog log = this.createBlankBotpLog(ctLinkItemContext, rowLinkId);
        log.setParentId(wbLog.getId());
        log.setTaskId(this.taskId);
        log.setSentityNumber(wbLog.getSentityNumber());
        log.setSBillno(wbLog.getSBillno());
        log.setTentityNumber(wbLog.getTentityNumber());
        log.setTBillno(wbLog.getTBillno());
        log.setStatus("1");
        log.setLogType("F");
        CtWFLogDetailInfo wfLogDetailInfo = new CtWFLogDetailInfo();
        wfLogDetailInfo.setTdbRouteKey(ctLinkItemContext.getTrackerContext().getTargetMainType().getDBRouteKey());
        wfLogDetailInfo.setTNumber(ctLinkItemContext.getTrackerContext().getTargetMainType().getName());
        wfLogDetailInfo.setEntityKey(ctLinkItemContext.getLinkSetItem().getCtParentEntityKey());
        wfLogDetailInfo.setLinkEntryKey(ctLinkItemContext.getLinkSetItem().getCtLinkEntityKey());
        log.setDetailInfo((AbstractCtDetailLogInfo)wfLogDetailInfo);
        return log;
    }

    private CtBOTPLog createWriteValueLog(CtLinkItemContext ctLinkItemContext, CtRowLinkId rowLinkId) {
        CtBOTPLog log = this.createBlankBotpLog(ctLinkItemContext, rowLinkId);
        log.setStatus("1");
        log.setLogType("V");
        CtWVLogDetailInfo wvLogDetailInfo = new CtWVLogDetailInfo();
        wvLogDetailInfo.setTdbRouteKey(ctLinkItemContext.getTrackerContext().getTargetMainType().getDBRouteKey());
        wvLogDetailInfo.setTNumber(ctLinkItemContext.getTrackerContext().getTargetMainType().getName());
        log.setDetailInfo((AbstractCtDetailLogInfo)wvLogDetailInfo);
        return log;
    }

    private CtBOTPLog createOrGetWriteBackLog(CtLinkItemContext ctLinkItemContext, Map<CtRowLinkId, CtBOTPLog> tcLogs, Map<CtRowLinkId, Map<CtRowLinkId, CtBOTPLog>> wbLogsByTc, Map<Long, CtBOTPLog> wfLogs, CtWBLogRow wbLogRow) {
        CtBOTPLog wfLog;
        Map wbLogsByWb;
        CtBOTPLog wbLog;
        Long wbId = wbLogRow.getId();
        Long tcId = wbLogRow.getTc();
        CtRowLinkId rowLinkId_wb = this.wbId2RowLinks.get(wbId);
        CtRowLinkId rowLinkId_tc = this.tcId2RowLinks.get(tcId);
        if (!this.isKeepWriteBackLog().booleanValue()) {
            String sDbRouteKey = this.loadDBRouteKey(rowLinkId_wb.getSTableId());
            if (this.equalsDatabase(ctLinkItemContext.getTrackerContext().getTargetMainType().getDBRouteKey(), sDbRouteKey)) {
                return null;
            }
        }
        if ((wbLog = (CtBOTPLog)(wbLogsByWb = wbLogsByTc.computeIfAbsent(rowLinkId_tc, s -> new HashMap())).get(rowLinkId_wb)) == null) {
            wbLog = this.createWriteBackLog(ctLinkItemContext, rowLinkId_wb);
            wbLogsByWb.put(rowLinkId_wb, wbLog);
            CtBOTPLog tcLog = tcLogs.get(rowLinkId_tc);
            if (tcLog != null) {
                wbLog.setParentId(tcLog.getId());
            }
        }
        if ((wfLog = wfLogs.get(wbLog.getId())) == null) {
            wfLog = this.createWriteFinishLog(ctLinkItemContext, rowLinkId_wb, wbLog);
            wfLogs.put(wbLog.getId(), wfLog);
        }
        return wbLog;
    }

    private CtTCLogRow buildTcRow(CtRow row, List<CtWBLogRow> histWbRows) {
        CtTCLogRow entryTrackeLogRow = new CtTCLogRow();
        entryTrackeLogRow.setId(row.getEntryTrackerId().longValue());
        entryTrackeLogRow.setSb(row.getSId().getBillId().longValue());
        entryTrackeLogRow.setSt(row.getSId().getTableId().longValue());
        entryTrackeLogRow.setSi(row.getSId().getEntryId().longValue());
        entryTrackeLogRow.setTb(row.getId().getBillId().longValue());
        entryTrackeLogRow.setTt(row.getId().getTableId().longValue());
        entryTrackeLogRow.setTi(row.getId().getEntryId().longValue());
        for (CtWRule wRule : row.getWrules().values()) {
            for (CtWSRow wsRow : wRule.getHistorySourceRows().values()) {
                CtWBLogRow wbRow = this.buildWbRow(row, wRule, wsRow);
                histWbRows.add(wbRow);
            }
        }
        return entryTrackeLogRow;
    }

    private CtTCLogRow buildTcRow(Long tBillId, DynamicObject entryTrackerObj) {
        CtTCLogRow entryTrackeLogRow = new CtTCLogRow();
        Long tcId = (Long)entryTrackerObj.getPkValue();
        entryTrackeLogRow.setId(tcId.longValue());
        entryTrackeLogRow.setSb(entryTrackerObj.getLong(KEY_ENTRY_TRACKER_SBILLID));
        entryTrackeLogRow.setSt(entryTrackerObj.getLong(KEY_ENTRY_TRACKER_STABLEID));
        entryTrackeLogRow.setSi(entryTrackerObj.getLong(KEY_ENTRY_TRACKER_SID));
        entryTrackeLogRow.setTb(tBillId.longValue());
        entryTrackeLogRow.setTt(entryTrackerObj.getLong(KEY_ENTRY_TRACKER_TTABLEID));
        entryTrackeLogRow.setTi(entryTrackerObj.getLong(KEY_ENTRY_TRACKER_TID));
        return entryTrackeLogRow;
    }

    private CtWBLogRow buildWbRow(CtRow row, CtWRule wRule, CtWSRow wsRow) {
        CtWBLogRow wbLogRow = new CtWBLogRow();
        wbLogRow.setTc(row.getEntryTrackerId().longValue());
        wbLogRow.setId(wsRow.getWBEntryId().longValue());
        if (wsRow.getWBEntryId() != null && Long.compare(0L, wsRow.getWBEntryId()) != 0) {
            CtRowLinkId rowLinkId = new CtRowLinkId(wsRow.getSId().getMainTableId(), wsRow.getSId().getBillId(), row.getId().getMainTableId(), row.getId().getBillId());
            this.wbId2RowLinks.put(wbLogRow.getId(), rowLinkId);
            this.wbId2TcIds.put(wbLogRow.getId(), wbLogRow.getTc());
        }
        wbLogRow.setRv(wRule.getRuleVerId().longValue());
        wbLogRow.setRi(wRule.getRuleItemId().longValue());
        wbLogRow.setSb(wsRow.getSId().getBillId().longValue());
        wbLogRow.setSt(wsRow.getSId().getTableId().longValue());
        wbLogRow.setSi(wsRow.getSId().getEntryId().longValue());
        wbLogRow.setV(wsRow.getVal());
        return wbLogRow;
    }

    private CtWBLogRow buildWbRow(Long tMainTableId, Long tBillId, Long tcId, DynamicObject wbItemObj) {
        CtWBLogRow wbLogRow = new CtWBLogRow();
        Long wbId = (Long)wbItemObj.getPkValue();
        wbLogRow.setTc(tcId.longValue());
        wbLogRow.setId(((Long)wbItemObj.getPkValue()).longValue());
        wbLogRow.setRv(wbItemObj.getLong(KEY_WRITE_RULEVER));
        wbLogRow.setRi(wbItemObj.getLong(KEY_WRITE_RULEITEM));
        wbLogRow.setSb(wbItemObj.getLong(KEY_WRITE_SBILLID));
        wbLogRow.setSt(wbItemObj.getLong(KEY_WRITE_STABLEID));
        wbLogRow.setSi(wbItemObj.getLong(KEY_WRITE_SID));
        wbLogRow.setV(wbItemObj.getBigDecimal(KEY_WRITE_VALUE));
        Long sMainTableId = this.loadMainTableId(wbLogRow.getSt());
        CtRowLinkId rowLinkId = new CtRowLinkId(sMainTableId, wbLogRow.getSb(), tMainTableId, tBillId);
        this.wbId2RowLinks.put(wbId, rowLinkId);
        this.wbId2TcIds.put(wbId, tcId);
        return wbLogRow;
    }

    private Long loadMainTableId(String entityNumber) {
        TableDefine tableDefine = this.mainTableDefines.get(entityNumber);
        if (tableDefine == null) {
            tableDefine = EntityMetadataCache.loadTableDefine((String)entityNumber, (String)entityNumber);
            this.mainTableDefines.put(entityNumber, tableDefine);
        }
        if (tableDefine == null) {
            return 0L;
        }
        return tableDefine.getTableId();
    }

    private Long loadMainTableId(Long entryTableId) {
        TableDefine tableDefine = this.entryTableDefines.get(entryTableId);
        if (tableDefine == null) {
            tableDefine = EntityMetadataCache.loadTableDefine((Long)entryTableId);
            this.entryTableDefines.put(entryTableId, tableDefine);
        }
        if (tableDefine == null) {
            return 0L;
        }
        return this.loadMainTableId(tableDefine.getEntityNumber());
    }

    private String loadEntityNumber(Long tableId) {
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)tableId);
        if (tableDefine == null) {
            return "";
        }
        return tableDefine.getEntityNumber();
    }

    private String loadDBRouteKey(Long tableId) {
        String dbRouteKey = this.dbRouteKeys.get(tableId);
        if (dbRouteKey != null) {
            return dbRouteKey;
        }
        String entityNumber = this.loadEntityNumber(tableId);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        dbRouteKey = mainType.getDBRouteKey();
        this.dbRouteKeys.put(tableId, dbRouteKey);
        return dbRouteKey;
    }

    private Boolean isCloseLog() {
        if (this.closeLog != null) {
            return this.closeLog;
        }
        try {
            Object optionValue = SystemParamServiceHelper.getBillParameter((String)FORMID_BOTP_LOG, (String)KEY_CLOSE_LOG);
            this.closeLog = optionValue == null ? Boolean.FALSE : (Boolean)optionValue;
        }
        catch (Throwable exp) {
            LOG.error(exp);
            this.closeLog = Boolean.FALSE;
        }
        return this.closeLog;
    }

    private Boolean isWriteValueLog() {
        if (this.writeValueLog != null) {
            return this.writeValueLog;
        }
        try {
            Object optionValue = SystemParamServiceHelper.getBillParameter((String)FORMID_BOTP_LOG, (String)KEY_WRITEVALUE_LOG);
            this.writeValueLog = optionValue == null ? Boolean.FALSE : (Boolean)optionValue;
        }
        catch (Throwable exp) {
            LOG.error(exp);
            this.writeValueLog = Boolean.FALSE;
        }
        return this.writeValueLog;
    }

    private Boolean isKeepWriteBackLog() {
        if (this.keepWriteBackLog != null) {
            return this.keepWriteBackLog;
        }
        try {
            Object optionValue = SystemParamServiceHelper.getBillParameter((String)FORMID_BOTP_LOG, (String)KEY_KEEP_WRITEBACK_LOG);
            this.keepWriteBackLog = optionValue == null ? Boolean.FALSE : (Boolean)optionValue;
        }
        catch (Throwable exp) {
            LOG.error(exp);
            this.keepWriteBackLog = Boolean.FALSE;
        }
        return this.keepWriteBackLog;
    }

    private boolean equalsDatabase(String dbRouteKey1, String dbRouteKey2) {
        return StringUtils.equalsIgnoreCase((CharSequence)dbRouteKey1, (CharSequence)dbRouteKey2);
    }

    private String getOpType(CtBFTrackerOpContext opContext) {
        String opType = "";
        String opMetaType = null;
        if (opContext.getTrackerContext().getOpMeta() != null) {
            opMetaType = (String)opContext.getTrackerContext().getOpMeta().get("type");
        }
        if (StringUtils.isNotBlank(opMetaType) && OPTYPES.containsKey(opMetaType)) {
            return OPTYPES.get(opMetaType);
        }
        switch (opContext.getOpController().getOpType()) {
            case Save: {
                opType = "S";
                break;
            }
            case Draft: {
                opType = "S";
                break;
            }
            case Delete: {
                opType = "D";
                break;
            }
            case Audit: {
                opType = "A";
                break;
            }
            case UnAudit: {
                opType = "U";
                break;
            }
            case UnCancel: {
                opType = "V";
                break;
            }
            case Cancel: {
                opType = "I";
                break;
            }
        }
        return opType;
    }

    public Map<String, Map<Object, String>> batchLoadBillNos(CtLinkItemContext ctLinkItemContext, CtSheets snapshots, CtSheets sheets) {
        HashMap<String, Map<Object, String>> billNos = new HashMap<String, Map<Object, String>>();
        Map tBillNos = billNos.computeIfAbsent(ctLinkItemContext.getTrackerContext().getTargetMainType().getName(), s -> new HashMap());
        for (CtSheet sheet : sheets.values()) {
            CtRow row;
            String tbillNo;
            if (sheet.getCtRows().isEmpty() || (tbillNo = this.getBillNo((row = (CtRow)sheet.getCtRows().entrySet().iterator().next().getValue()).getEntityRow())) == null) continue;
            tBillNos.put(sheet.getBillId(), tbillNo);
        }
        HashMap<Long, Set<Long>> billIds = new HashMap<Long, Set<Long>>();
        this.getSBillIdInSheets(sheets, billNos, billIds);
        this.getSBillIdInSheets(snapshots, billNos, billIds);
        for (Map.Entry entry : billIds.entrySet()) {
            String key;
            MainEntityType mainType;
            String sEntityNumber = this.loadEntityNumber((Long)entry.getKey());
            Map sBillNos = billNos.computeIfAbsent(sEntityNumber, s -> new HashMap());
            Set sBillIds = (Set)entry.getValue();
            ArrayList<Long> ids = new ArrayList<Long>(sBillIds.size());
            for (Long sBillId : sBillIds) {
                if (sBillNos.containsKey(sBillId)) continue;
                ids.add(sBillId);
            }
            if (ids.isEmpty() || !((mainType = EntityMetadataCache.getDataEntityType((String)sEntityNumber)) instanceof BillEntityType) || StringUtils.isBlank((CharSequence)(key = ((BillEntityType)mainType).getBillNo()))) continue;
            QFilter[] qFilters = new QFilter[]{new QFilter(mainType.getPrimaryKey().getName(), "in", ids)};
            String selectFields = mainType.getPrimaryKey().getName() + "," + key;
            DataSet ds = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".batchLoadBillNos"), (String)sEntityNumber, (String)selectFields, (QFilter[])qFilters, null);
            Throwable throwable = null;
            try {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Long sBillId = row.getLong(0);
                    String sBillNo = row.getString(1);
                    sBillNos.put(sBillId, sBillNo);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        return billNos;
    }

    private void getSBillIdInSheets(CtSheets sheets, Map<String, Map<Object, String>> billNos, Map<Long, Set<Long>> billIds) {
        for (CtSheet sheet : sheets.values()) {
            for (CtRow row : sheet.getCtRows().values()) {
                billIds.computeIfAbsent(row.getId().getMainTableId(), s -> new HashSet()).add(row.getId().getBillId());
                billIds.computeIfAbsent(row.getSId().getMainTableId(), s -> new HashSet()).add(row.getSId().getBillId());
                for (CtWRule wRule : row.getWrules().values()) {
                    for (CtWSRow wsRow : wRule.getHistorySourceRows().values()) {
                        billIds.computeIfAbsent(wsRow.getSId().getMainTableId(), s -> new HashSet()).add(wsRow.getSId().getBillId());
                    }
                    for (CtWSRow wsRow : wRule.getExecuteSourceRows().values()) {
                        String sBillNo = this.getBillNo(wsRow.getSrcActiveRow());
                        if (sBillNo != null) {
                            Map sBillNos = billNos.computeIfAbsent(this.loadEntityNumber(wsRow.getSId().getMainTableId()), s -> new HashMap());
                            sBillNos.put(wsRow.getSId().getBillId(), sBillNo);
                            continue;
                        }
                        Set sBillIds = billIds.computeIfAbsent(wsRow.getSId().getMainTableId(), s -> new HashSet());
                        sBillIds.add(wsRow.getSId().getBillId());
                    }
                }
            }
        }
    }

    private void fillBillNo(CtBOTPLog log) {
        if (Long.compare(0L, log.getSTableId()) != 0) {
            log.setSentityNumber(this.loadEntityNumber(log.getSTableId()));
            log.setSBillno(this.getBillNo(log.getSTableId(), (Long)log.getSBillId()));
        }
        if (Long.compare(0L, log.getTTableId()) != 0) {
            log.setTentityNumber(this.loadEntityNumber(log.getTTableId()));
            log.setTBillno(this.getBillNo(log.getTTableId(), (Long)log.getTBillId()));
        }
    }

    private String getBillNo(DynamicObject activeRow) {
        BillEntityType mainType;
        String key;
        if (activeRow == null) {
            return null;
        }
        DynamicObject head = null;
        if (activeRow.getDataEntityType() instanceof MainEntityType) {
            head = activeRow;
        } else {
            for (DynamicObject parent = (DynamicObject)activeRow.getParent(); parent != null; parent = (DynamicObject)parent.getParent()) {
                if (!(parent.getDataEntityType() instanceof MainEntityType)) continue;
                head = parent;
                break;
            }
        }
        if (head == null) {
            return null;
        }
        if (head.getDataEntityType() instanceof BillEntityType && (key = (mainType = (BillEntityType)head.getDataEntityType()).getBillNo()) != null && mainType.getProperties().containsKey((Object)key)) {
            return head.getString(key);
        }
        return null;
    }

    public String getBillNo(Long tableId, Long billId) {
        String entityNumber = this.loadEntityNumber(tableId);
        return this.getBillNo(entityNumber, billId);
    }

    public String getBillNo(String entityNumber, Long billId) {
        Map<Object, String> sBillNos = this.allBillNos.get(entityNumber);
        if (sBillNos == null) {
            return null;
        }
        return sBillNos.get(billId);
    }

    static {
        OPTYPES.put("save", "S");
        OPTYPES.put("delete", "D");
        OPTYPES.put("submit", "B");
        OPTYPES.put("unsubmit", "C");
        OPTYPES.put("audit", "A");
        OPTYPES.put("unaudit", "U");
        OPTYPES.put("invalid", "I");
        OPTYPES.put("valid", "V");
    }
}

