/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;

public class CtWriteBackContext {
    private CtBFTrackerContext trackerContext;
    private CtLinkItemContext ctLinkItemContext;
    private CtBFTrackerResult trackerResult;
    private CtBFTrackerDbService dbService;
    private Map<Long, CtWRuleCompiler> rules = new HashMap<Long, CtWRuleCompiler>();
    private BillEntityType srcMainType;
    private BillEntityType srcSubMainType;
    private Map<String, EntryType> srcEntryTypes = new HashMap<String, EntryType>(1);
    private List<String> srcSelectFields;
    private Set<Long> srcBillIds = new HashSet<Long>();
    private Map<Long, Set<Long>> srcEntryIds = new HashMap<Long, Set<Long>>(1);

    public CtWriteBackContext(CtBFTrackerContext trackerContext, CtLinkItemContext ctLinkItemContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
        this.trackerContext = trackerContext;
        this.ctLinkItemContext = ctLinkItemContext;
        this.trackerResult = trackerResult;
        this.dbService = dbService;
    }

    public Map<Long, CtWRuleCompiler> getRules() {
        return this.rules;
    }

    public void setRules(Map<Long, CtWRuleCompiler> rules) {
        this.rules.clear();
        this.rules.putAll(rules);
        this.srcMainType = this.rules.entrySet().iterator().next().getValue().getSourceMainType();
        this.srcEntryTypes.clear();
        this.srcBillIds.clear();
        this.srcEntryIds.clear();
    }

    public CtBFTrackerContext getTrackerContext() {
        return this.trackerContext;
    }

    public CtBFTrackerResult getTrackerResult() {
        return this.trackerResult;
    }

    public CtLinkItemContext getCtLinkItemContext() {
        return this.ctLinkItemContext;
    }

    public void setCtLinkItemContext(CtLinkItemContext ctLinkItemContext) {
        this.ctLinkItemContext = ctLinkItemContext;
    }

    public CtBFTrackerDbService getDbService() {
        return this.dbService;
    }

    public BillEntityType getSrcMainType() {
        return this.srcMainType;
    }

    public BillEntityType getSrcSubMainType() {
        return this.srcSubMainType;
    }

    public void setSrcSubMainType(BillEntityType srcSubMainType) {
        this.srcSubMainType = srcSubMainType;
    }

    public String buildSrcBillInfoKey() {
        if (this.srcSubMainType != null && StringUtils.isNotBlank((CharSequence)this.srcSubMainType.getExtendName())) {
            return this.srcSubMainType.getExtendName();
        }
        return this.srcMainType.getName();
    }

    public Map<String, EntryType> getSrcEntryTypes() {
        return this.srcEntryTypes;
    }

    public List<String> getSrcSelectFields() {
        return this.srcSelectFields;
    }

    public void setSrcSelectFields(List<String> srcSelectFields) {
        this.srcSelectFields = srcSelectFields;
    }

    public Set<Long> getSrcBillIds() {
        return this.srcBillIds;
    }

    public Map<Long, Set<Long>> getSrcEntryIds() {
        return this.srcEntryIds;
    }
}

