/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IModifierProperty;
import kd.bos.dataentity.metadata.IModifyTimeProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtAfterBuildSourceBillIdsEventArgs;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtAfterReadSourceBillEventArgs;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtBeforeReadSourceBillEventArgs;
import kd.bos.entity.ctbotp.runtime.CtWriteBackRuleElement;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.CtWriteBackContext;
import kd.bos.service.ctbotp.track.bizentity.CtRowId;
import kd.bos.service.ctbotp.track.bizentity.CtSourceBillInfo;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.bizentity.CtWSRow;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;
import kd.bos.service.ctbotp.track.wblogicunit.ICtWriteBackLogic;
import kd.bos.xdb.hint.ShardingHintContext;

public class CtWriteBackEngine {
    private static final String KEY_BILLID = "billid";
    private static final String ISOPENINTENTLOCKS = "isOpenIntentLocks";
    private CtBFTrackerContext trackerContext;
    private CtBFTrackerResult trackerResult;
    private CtBFTrackerDbService dbService;
    private CtWriteBackContext ctWriteBackContext;
    private List<ICtWriteBackLogic> writeLogics = new ArrayList<ICtWriteBackLogic>();
    private Map<Long, Long> currentEntryBillIdMap;
    private boolean useSharding;
    private static Log log = LogFactory.getLog(CtWriteBackEngine.class);

    public CtWriteBackEngine(CtWriteBackContext ctWriteBackContext) {
        this.trackerContext = ctWriteBackContext.getTrackerContext();
        this.trackerResult = ctWriteBackContext.getTrackerResult();
        this.dbService = ctWriteBackContext.getDbService();
        this.ctWriteBackContext = ctWriteBackContext;
        this.writeLogics.addAll(ICtWriteBackLogic.create(ctWriteBackContext));
    }

    public void doWriteBack(Map<Long, CtWRuleCompiler> rules, List<CtWRule> wRules) {
        this.ctWriteBackContext.setRules(rules);
        this.useSharding = ShardingHinter.isSharding((String)this.ctWriteBackContext.getSrcMainType().getAlias());
        if (this.useSharding) {
            this.currentEntryBillIdMap = new HashMap<Long, Long>();
        }
        this.getSrcBillIds(wRules, this.ctWriteBackContext.getSrcBillIds(), this.ctWriteBackContext.getSrcEntryIds());
        this.buildSubSrcMainType(rules, wRules);
        ExtendedDataEntitySet srcDataSet = this.loadSrcBillData(wRules);
        if (srcDataSet == null) {
            return;
        }
        Map<Long, List<CtWRule>> dctWRuleByTableId = this.bindSrcRowObj(wRules, srcDataSet);
        this.execWriteLogic(dctWRuleByTableId);
        this.mergeSourceObjs(srcDataSet);
    }

    private void getSrcBillIds(List<CtWRule> wRules, Set<Long> billIds, Map<Long, Set<Long>> entryIds) {
        for (CtWRule wRule : wRules) {
            this.getSrcBillIds(wRule.getCurrSourceRows().values(), billIds, entryIds);
            this.getSrcBillIds(wRule.getHistorySourceRows().values(), billIds, entryIds);
        }
        Map<Long, CtWRuleCompiler> rules = this.ctWriteBackContext.getRules();
        ArrayList<CtWriteBackRuleElement> ruleElements = new ArrayList<CtWriteBackRuleElement>(rules.size());
        for (CtWRuleCompiler ruleCompiler : rules.values()) {
            ruleElements.add(ruleCompiler.getRule());
        }
        CtAfterBuildSourceBillIdsEventArgs eventArgs = this.fireAfterBuildSourceBillIds(this.ctWriteBackContext.getSrcMainType(), ruleElements, billIds);
        this.getSrcBillIdsByEvent(billIds, entryIds, eventArgs);
    }

    private void getSrcBillIds(Collection<CtWSRow> wsRows, Set<Long> billIds, Map<Long, Set<Long>> entryIds) {
        for (CtWSRow wsRow : wsRows) {
            CtRowId rowId = wsRow.getSId();
            long billId = rowId.getBillId();
            long tableId = rowId.getTableId();
            billIds.add(billId);
            if (rowId.getMainTableId() == tableId) continue;
            Set<Long> set = entryIds.get(tableId);
            if (set == null) {
                set = new HashSet<Long>();
                entryIds.put(tableId, set);
            }
            long entryId = rowId.getEntryId();
            set.add(entryId);
            if (!this.useSharding) continue;
            this.currentEntryBillIdMap.put(entryId, billId);
        }
    }

    private void getSrcBillIdsByEvent(Set<Long> billIds, Map<Long, Set<Long>> entryIds, CtAfterBuildSourceBillIdsEventArgs eventArgs) {
        List entryIdMode = eventArgs.getEntryInfos();
        for (CtAfterBuildSourceBillIdsEventArgs.EntryInfo idMode : entryIdMode) {
            billIds.add(idMode.getBillId());
            Long entryTableId = idMode.getEntryTableId();
            Long entryId = idMode.getEntryId();
            if (entryId == null || entryTableId == null) continue;
            Set set = entryIds.computeIfAbsent(entryTableId, k -> new HashSet());
            set.add(entryId);
            if (!this.useSharding) continue;
            this.currentEntryBillIdMap.put(entryId, idMode.getBillId());
        }
    }

    private void buildSubSrcMainType(Map<Long, CtWRuleCompiler> rules, List<CtWRule> wRules) {
        BillEntityType srcMainType = this.ctWriteBackContext.getSrcMainType();
        ArrayList<String> selectFields = new ArrayList<String>();
        HashSet<String> entryKeys = new HashSet<String>(1);
        selectFields.add("id");
        if (StringUtils.isNotBlank((CharSequence)srcMainType.getBillNo())) {
            selectFields.add(srcMainType.getBillNo());
        }
        Map entityMap = srcMainType.getAllEntities();
        for (Map.Entry entry : entityMap.entrySet()) {
            IModifyTimeProperty modifyTimeProperty;
            EntityType entityType = (EntityType)entry.getValue();
            IModifierProperty modifierProperty = entityType.getModifierProperty();
            if (modifierProperty != null) {
                selectFields.add(modifierProperty.getName());
            }
            if ((modifyTimeProperty = entityType.getModifyTimeProperty()) == null) continue;
            selectFields.add(modifyTimeProperty.getName());
        }
        for (CtWRuleCompiler ctWRuleCompiler : rules.values()) {
            selectFields.addAll(ctWRuleCompiler.getSourceFields().keySet());
        }
        HashSet<Long> sTableIds = new HashSet<Long>(this.ctWriteBackContext.getSrcEntryIds().keySet());
        for (Long l : sTableIds) {
            TableDefine tableDefine = this.dbService.loadTableDefine(l);
            if (!StringUtils.equals((CharSequence)tableDefine.getEntityNumber(), (CharSequence)srcMainType.getName()) || !srcMainType.getAllEntities().containsKey(tableDefine.getEntityKey())) continue;
            EntityType entityType = (EntityType)srcMainType.getAllEntities().get(tableDefine.getEntityKey());
            if (entityType instanceof SubEntryType) {
                selectFields.add(entityType.getParent().getName() + ".id");
                selectFields.add(entityType.getParent().getName() + ".seq");
                selectFields.add(entityType.getName() + ".id");
                selectFields.add(entityType.getName() + ".seq");
                entryKeys.add(entityType.getParent().getName());
                continue;
            }
            if (!(entityType instanceof EntryType)) continue;
            selectFields.add(tableDefine.getEntityKey() + ".id");
            selectFields.add(tableDefine.getEntityKey() + ".seq");
            entryKeys.add(entityType.getName());
        }
        ArrayList<CtWriteBackRuleElement> arrayList = new ArrayList<CtWriteBackRuleElement>(rules.size());
        for (CtWRuleCompiler ruleCompiler : rules.values()) {
            arrayList.add(ruleCompiler.getRule());
        }
        CtBeforeReadSourceBillEventArgs ctBeforeReadSourceBillEventArgs = this.fireBeforeReadSourceBill(srcMainType, arrayList);
        selectFields.addAll(ctBeforeReadSourceBillEventArgs.getFieldKeys());
        BillEntityType subMainType = (BillEntityType)EntityMetadataCache.getSubDataEntityType((String)srcMainType.getName(), selectFields);
        BillEntityType srcSubMainType = CtBFTrackerContext.buildLocalSubMainType(subMainType, entryKeys, this.ctWriteBackContext.getSrcEntryTypes());
        this.ctWriteBackContext.setSrcSubMainType(srcSubMainType);
        this.ctWriteBackContext.setSrcSelectFields(selectFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedDataEntitySet loadSrcBillData(List<CtWRule> wRules) {
        if (this.ctWriteBackContext.getSrcBillIds().isEmpty()) {
            return null;
        }
        CtSourceBillInfo sourceBillInfo = this.trackerResult.getSrcBillInfos().get(this.ctWriteBackContext.buildSrcBillInfoKey());
        if (sourceBillInfo == null) {
            sourceBillInfo = new CtSourceBillInfo(this.ctWriteBackContext.getSrcMainType(), this.ctWriteBackContext.getSrcSubMainType(), this.ctWriteBackContext.getSrcSelectFields());
            this.trackerResult.getSrcBillInfos().put(this.ctWriteBackContext.buildSrcBillInfoKey(), sourceBillInfo);
        }
        HashMap<Long, DynamicObject> headObjs = new HashMap<Long, DynamicObject>();
        ArrayList<Long> billIds = new ArrayList<Long>(1);
        BillEntityType srcSubMainType = this.ctWriteBackContext.getSrcSubMainType();
        CtSourceBillInfo ctSourceBillInfo = sourceBillInfo;
        synchronized (ctSourceBillInfo) {
            for (Long l : this.ctWriteBackContext.getSrcBillIds()) {
                DynamicObject dynamicObject = sourceBillInfo.getHeadObj(l);
                if (dynamicObject != null) {
                    headObjs.put(l, dynamicObject);
                    continue;
                }
                billIds.add(l);
            }
            if (!billIds.isEmpty()) {
                this.startNetworkCtrl(billIds);
                String msg = String.format(ResManager.loadKDString((String)"\u53cd\u5199\u5f15\u64ce\uff0c\u8bfb\u53d6\u6e90\u5355\u5f00\u59cb\uff1a%1$s, %2$s(%3$s bills)", (String)"WriteBackEngine_3", (String)"bos-mservice-botp", (Object[])new Object[0]), srcSubMainType.getName(), billIds.get(0), billIds.size());
                log.info(msg);
                DynamicObject[] dynamicObjectArray = BusinessDataReader.load((Object[])billIds.toArray(), (DynamicObjectType)srcSubMainType, (Boolean)Boolean.TRUE);
                if (dynamicObjectArray != null && dynamicObjectArray.length > 0) {
                    for (DynamicObject billObj : dynamicObjectArray) {
                        headObjs.put((Long)billObj.getPkValue(), billObj);
                    }
                    sourceBillInfo.addHeadObjs(dynamicObjectArray, this.ctWriteBackContext.getCtLinkItemContext().isSplitPage());
                }
            }
        }
        billIds = null;
        if (headObjs.isEmpty()) {
            return null;
        }
        HashMap entryIds = new HashMap();
        for (Map.Entry<Long, Set<Long>> entry : this.ctWriteBackContext.getSrcEntryIds().entrySet()) {
            Long l = entry.getKey();
            TableDefine tableDefine = this.dbService.loadTableDefine(l);
            EntityType entityType = (EntityType)this.ctWriteBackContext.getSrcSubMainType().getAllEntities().get(tableDefine.getEntityKey());
            Map<Long, Set<Long>> subEntryIds = new HashMap<Long, Set<Long>>(16);
            if (entityType instanceof SubEntryType) {
                EntryType parentEntryType = (EntryType)entityType.getParent();
                if (!entryIds.containsKey(parentEntryType.getName())) {
                    entryIds.put(parentEntryType.getName(), new HashMap());
                }
                subEntryIds = (Map)entryIds.get(parentEntryType.getName());
            } else if (entityType instanceof EntryType) {
                if (!entryIds.containsKey(entityType.getName())) {
                    entryIds.put(entityType.getName(), new HashMap());
                }
                subEntryIds = (Map)entryIds.get(entityType.getName());
            }
            subEntryIds.put(l, entry.getValue());
        }
        HashMap billRows = new HashMap();
        for (Map.Entry entry : entryIds.entrySet()) {
            EntryType entryType = this.ctWriteBackContext.getSrcEntryTypes().get(entry.getKey());
            DynamicObject[] rows = this.loadSrcEntryRows(sourceBillInfo, entryType, (Map)entry.getValue());
            DynamicProperty billProp = entryType.getProperty(KEY_BILLID);
            for (DynamicObject row : rows) {
                Long billId = (Long)billProp.getValueFast((Object)row);
                if (!billRows.containsKey(billId)) {
                    billRows.put(billId, new ArrayList());
                }
                ((List)billRows.get(billId)).add(row);
            }
            for (Map.Entry entry2 : billRows.entrySet()) {
                DynamicObject headObj = (DynamicObject)headObjs.get(entry2.getKey());
                if (headObj == null) {
                    ErrorCode ec = new ErrorCode("WriteBackEngine.loadSrcBillData.billId.NotExists", String.format(ResManager.loadKDString((String)"\u6e90\u5355\u5206\u5f55\u884c%s\uff0c\u5b9e\u9645\u5bf9\u5e94\u7684\u6e90\u5355\u5185\u7801\u548c\u5173\u8054\u5173\u7cfb\u4e2d\u586b\u5199\u7684\u6e90\u5355\u5185\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u5173\u8054\u5173\u7cfb\u662f\u5426\u586b\u5199\u6709\u8bef", (String)"WriteBackEngine_2", (String)"bos-mservice-botp", (Object[])new Object[0]), ((DynamicObject)((List)entry2.getValue()).get(0)).getPkValue()));
                    log.error(ec.getMessage());
                    continue;
                }
                DynamicObjectCollection entryRows = headObj.getDynamicObjectCollection(entryType.getName());
                for (DynamicObject entryRow : (List)entry2.getValue()) {
                    entryRows.add((Object)entryRow);
                }
            }
            billRows.clear();
        }
        ExtendedDataEntitySet extendedDataEntitySet = new ExtendedDataEntitySet();
        extendedDataEntitySet.Parse(headObjs.values().toArray(new DynamicObject[0]), (MainEntityType)srcSubMainType);
        this.fireAfterReadSourceBill(srcSubMainType, headObjs.values().toArray(new DynamicObject[0]));
        return extendedDataEntitySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject[] loadSrcEntryRows(CtSourceBillInfo sourceBillInfo, EntryType entryType, Map<Long, Set<Long>> subEntryIds) {
        HashSet<Long> entryIds = new HashSet<Long>();
        ORM orm = ORM.create();
        for (Map.Entry<Long, Set<Long>> mapItem : subEntryIds.entrySet()) {
            Long sTableId = mapItem.getKey();
            TableDefine tableDefine = this.dbService.loadTableDefine(sTableId);
            if (StringUtils.equals((CharSequence)tableDefine.getEntityKey(), (CharSequence)entryType.getName())) {
                entryIds.addAll((Collection)mapItem.getValue());
                continue;
            }
            String subEntryPKName = entryType.getName() + "." + tableDefine.getEntityKey() + ".id";
            String selectString = "id, " + entryType.getName() + ".id f1";
            QFilter qFilter = new QFilter(subEntryPKName, "in", mapItem.getValue());
            DataSet dSet = orm.queryDataSet("WriteBackEngine.loadSrcEntryRows", sourceBillInfo.getMainType().getName(), selectString, new QFilter[]{qFilter});
            Throwable throwable = null;
            try {
                while (dSet.hasNext()) {
                    Row row = dSet.next();
                    entryIds.add(row.getLong("f1"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dSet == null) continue;
                if (throwable != null) {
                    try {
                        dSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dSet.close();
            }
        }
        ArrayList<DynamicObject> entryRowObjs = new ArrayList<DynamicObject>(entryIds.size());
        ArrayList<Long> readEntryIds = new ArrayList<Long>(entryIds.size());
        Map<Long, DynamicObject> existEntryRows = sourceBillInfo.getEntryRowObjs().get(entryType);
        if (existEntryRows == null) {
            existEntryRows = new HashMap<Long, DynamicObject>();
        }
        for (Long entryId : entryIds) {
            DynamicObject dynamicObject = existEntryRows.get(entryId);
            if (dynamicObject != null) {
                entryRowObjs.add(dynamicObject);
                continue;
            }
            readEntryIds.add(entryId);
        }
        if (!readEntryIds.isEmpty()) {
            DynamicObject[] objs;
            ShardingHintContext ctx = null;
            if (this.useSharding) {
                HashSet<Long> billIds = new HashSet<Long>(16);
                for (Long entryId : readEntryIds) {
                    billIds.add(this.currentEntryBillIdMap.get(entryId));
                }
                ctx = ShardingHinter.tryHint((IDataEntityType)this.ctWriteBackContext.getSrcMainType(), (Object[])billIds.toArray());
            }
            if (ctx != null) {
                ctx.set();
                try {
                    objs = BusinessDataReader.load((Object[])readEntryIds.toArray(), (DynamicObjectType)entryType, (Boolean)Boolean.TRUE);
                    entryRowObjs.addAll(Arrays.asList(objs));
                }
                finally {
                    ctx.close();
                }
            } else {
                objs = BusinessDataReader.load((Object[])readEntryIds.toArray(), (DynamicObjectType)entryType, (Boolean)Boolean.TRUE);
                entryRowObjs.addAll(Arrays.asList(objs));
            }
        }
        return entryRowObjs.toArray(new DynamicObject[0]);
    }

    private boolean isMutexSourceBill() {
        String paramValue = this.ctWriteBackContext.getTrackerContext().getOption().getVariableValue("mutex_writeback", String.valueOf(true));
        return Boolean.parseBoolean(paramValue);
    }

    private void startNetworkCtrl(List<Long> billIds) {
        String mutextryCount;
        if (!this.isMutexSourceBill()) {
            this.trackerContext.getOperateLog().info("WriteBackEngine.startNetworkCtrl() return false becuase of isMutexSourceBill() == false");
            return;
        }
        if (billIds == null || billIds.isEmpty()) {
            this.trackerContext.getOperateLog().info("WriteBackEngine.startNetworkCtrl() return false becuase of billIds.isEmpty");
            return;
        }
        HashSet<String> mutexSuccessIds = new HashSet<String>();
        for (CtSourceBillInfo ctSourceBillInfo : this.trackerResult.getSrcBillInfos().values()) {
            if (!StringUtils.equals((CharSequence)ctSourceBillInfo.getMainType().getName(), (CharSequence)this.ctWriteBackContext.getSrcMainType().getName())) continue;
            mutexSuccessIds.addAll(ctSourceBillInfo.getMutexDataIds());
        }
        HashSet<String> srcBillIds = new HashSet<String>(billIds.size());
        for (Long idValue : billIds) {
            String objId = String.valueOf(idValue);
            if (mutexSuccessIds.contains(objId)) continue;
            srcBillIds.add(objId);
        }
        if (srcBillIds.isEmpty()) {
            this.trackerContext.getOperateLog().info("WriteBackEngine.startNetworkCtrl() return false becuase of all billIds has mutex success.");
            return;
        }
        CtSourceBillInfo ctSourceBillInfo = this.trackerResult.getSrcBillInfos().get(this.ctWriteBackContext.buildSrcBillInfoKey());
        boolean openIntentLocks = this.isOpenIntentLocks();
        ctSourceBillInfo.setMutexGroupId("writeback");
        ctSourceBillInfo.setMutexStrict(true);
        ctSourceBillInfo.setOpenIntentClocks(openIntentLocks);
        String sameMutexCount = this.ctWriteBackContext.getTrackerContext().getOption().getVariableValue("max_same_mutex_id_count", null);
        if (StringUtils.isNotBlank((CharSequence)sameMutexCount)) {
            ctSourceBillInfo.setMAX_SAME_COUNT_MUTEX_ID(Integer.parseInt(sameMutexCount));
        }
        if (StringUtils.isNotBlank((CharSequence)(mutextryCount = this.ctWriteBackContext.getTrackerContext().getOption().getVariableValue("max_try_again_count", null)))) {
            ctSourceBillInfo.setMUTEX_TRY_AGAIN(Integer.parseInt(mutextryCount));
        }
        ctSourceBillInfo.startNetworkCtrl(srcBillIds);
    }

    private Map<Long, List<CtWRule>> bindSrcRowObj(List<CtWRule> wRules, ExtendedDataEntitySet srcDataSet) {
        HashMap<Long, List<CtWRule>> dctWRuleByTableId = new HashMap<Long, List<CtWRule>>();
        for (CtWRule ctWRule : wRules) {
            if (ctWRule.getExecuteSourceRows().isEmpty()) continue;
            CtRowId sId = (CtRowId)((Object)ctWRule.getExecuteSourceRows().keySet().iterator().next());
            Long sTableId = sId.getTableId();
            if (!dctWRuleByTableId.containsKey(sTableId)) {
                ArrayList list = new ArrayList();
                dctWRuleByTableId.put(sTableId, list);
            }
            ((List)dctWRuleByTableId.get(sTableId)).add(ctWRule);
        }
        for (Map.Entry entry : dctWRuleByTableId.entrySet()) {
            Long sTableId = (Long)entry.getKey();
            List list = (List)entry.getValue();
            TableDefine tableDefine = this.dbService.loadTableDefine(sTableId);
            String entityKey = tableDefine.getEntityKey();
            ExtendedDataEntity[] extSrcRows = srcDataSet.FindByEntityKey(entityKey);
            HashMap<Long, DynamicObject> mapSrcRows = new HashMap<Long, DynamicObject>(extSrcRows.length);
            for (ExtendedDataEntity extSrcRow : extSrcRows) {
                Long entryId = (Long)extSrcRow.getDataEntity().getPkValue();
                mapSrcRows.put(entryId, extSrcRow.getDataEntity());
            }
            for (CtWRule wRule : list) {
                ArrayList notExistRowIds = new ArrayList(wRule.getExecuteSourceRows().size());
                for (Map.Entry wsRowItem : wRule.getExecuteSourceRows().entrySet()) {
                    CtWSRow wsRow = (CtWSRow)wsRowItem.getValue();
                    DynamicObject srcActiveRow = (DynamicObject)mapSrcRows.get(wsRow.getSId().getEntryId());
                    if (srcActiveRow != null) {
                        wsRow.setSrcActiveRow(srcActiveRow);
                        continue;
                    }
                    notExistRowIds.add(wsRowItem.getKey());
                }
                for (CtRowId sId : notExistRowIds) {
                    wRule.getExecuteSourceRows().remove((Object)sId);
                }
            }
        }
        return dctWRuleByTableId;
    }

    private void execWriteLogic(Map<Long, List<CtWRule>> wRules) {
        for (Map.Entry<Long, List<CtWRule>> entry : wRules.entrySet()) {
            Long sTableId = entry.getKey();
            List<CtWRule> list = entry.getValue();
            TableDefine tableDefine = this.dbService.loadTableDefine(sTableId);
            RowDataModel rowDataModel = new RowDataModel(tableDefine.getEntityKey(), (MainEntityType)this.ctWriteBackContext.getSrcSubMainType());
            for (ICtWriteBackLogic action : this.writeLogics) {
                action.doWriteBack(rowDataModel, list);
            }
        }
    }

    private void mergeSourceObjs(ExtendedDataEntitySet srcDataSet) {
        CtSourceBillInfo sourceBillInfo = this.trackerResult.getSrcBillInfos().get(this.ctWriteBackContext.buildSrcBillInfoKey());
        if (sourceBillInfo == null) {
            return;
        }
        ExtendedDataEntity[] dataEntities = srcDataSet.FindByEntityKey(this.ctWriteBackContext.getSrcSubMainType().getName());
        DynamicObject[] headObjs = new DynamicObject[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            headObjs[i] = dataEntities[i].getDataEntity();
            for (Map.Entry<String, EntryType> entry : this.ctWriteBackContext.getSrcEntryTypes().entrySet()) {
                DynamicObjectCollection rows = headObjs[i].getDynamicObjectCollection(entry.getKey());
                rows.clear();
                rows.getDeleteRows().clear();
            }
        }
        sourceBillInfo.addHeadObjs(headObjs, this.ctWriteBackContext.getCtLinkItemContext().isSplitPage());
        for (Map.Entry<String, EntryType> entry : this.ctWriteBackContext.getSrcEntryTypes().entrySet()) {
            ExtendedDataEntity[] entryDataEntities = srcDataSet.FindByEntityKey(entry.getKey());
            DynamicObject[] entryRows = new DynamicObject[entryDataEntities.length];
            for (int i = 0; i < entryDataEntities.length; ++i) {
                entryRows[i] = entryDataEntities[i].getDataEntity();
            }
            sourceBillInfo.addEntryRowObjs((EntityType)entry.getValue(), entryRows, this.ctWriteBackContext.getCtLinkItemContext().isSplitPage());
        }
    }

    private CtAfterBuildSourceBillIdsEventArgs fireAfterBuildSourceBillIds(BillEntityType srcMainType, List<CtWriteBackRuleElement> ruleElements, Set<Long> billIds) {
        CtAfterBuildSourceBillIdsEventArgs eventArgs = new CtAfterBuildSourceBillIdsEventArgs(srcMainType, ruleElements, billIds);
        this.trackerContext.getPlugInProxy().fireAfterBuildSourceBillIds(eventArgs);
        return eventArgs;
    }

    private CtBeforeReadSourceBillEventArgs fireBeforeReadSourceBill(BillEntityType srcMainType, List<CtWriteBackRuleElement> ruleElements) {
        CtBeforeReadSourceBillEventArgs eventArgs = new CtBeforeReadSourceBillEventArgs(srcMainType, ruleElements);
        eventArgs.setSrcBillIds(this.ctWriteBackContext.getSrcBillIds());
        this.trackerContext.getPlugInProxy().fireBeforeReadSourceBill(eventArgs);
        return eventArgs;
    }

    private CtAfterReadSourceBillEventArgs fireAfterReadSourceBill(BillEntityType srcMainType, DynamicObject[] srcDataEntities) {
        CtAfterReadSourceBillEventArgs eventArgs = new CtAfterReadSourceBillEventArgs(srcMainType, srcDataEntities);
        this.ctWriteBackContext.getTrackerContext().getPlugInProxy().fireAfterReadSourceBill(eventArgs);
        return eventArgs;
    }

    private boolean isOpenIntentLocks() {
        OperateOption option = this.trackerContext.getOption();
        boolean isOpenIntentLocks = false;
        if (option != null && option.containsVariable(ISOPENINTENTLOCKS)) {
            isOpenIntentLocks = Boolean.parseBoolean(option.getVariableValue(ISOPENINTENTLOCKS));
        }
        return isOpenIntentLocks;
    }
}

