/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.actions;

import java.util.HashSet;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerOpContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.actions.AbstractCtTrackAction;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtSheet;
import kd.bos.service.ctbotp.track.bizentity.CtSheets;
import kd.bos.service.ctbotp.track.helper.CtBillTrackerBuilder;

public class CtBuildSheetAction
extends AbstractCtTrackAction {
    public CtBuildSheetAction(CtBFTrackerContext trackerContext, CtBFTrackerOpContext trackerOpContext, CtLinkItemContext linkItemContext, CtBFTrackerResult trackerResult, CtBillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        CtSheets sheets = null;
        CtSheets snapshot = null;
        if (this.batchContext.getEntryIds() == null) {
            sheets = this.opController.createSheets(this.linkItemContext, this.trackerOpContext.getDataEntities());
            HashSet<Long> entryIds = new HashSet<Long>(this.linkItemContext.getCurrPageEntryIds());
            entryIds.addAll(this.linkItemContext.getCurrPageEntryOids());
            snapshot = this.opController.createSubSnapshotSheets(this.linkItemContext, entryIds);
        } else {
            sheets = this.opController.createSubSheets(this.linkItemContext, this.trackerOpContext.getDataEntities(), this.trackerOpContext.getBillIds(), this.batchContext.getEntryIds());
            snapshot = this.trackerOpContext.getOpController().createSubSnapshotSheets(this.linkItemContext, this.batchContext.getEntryIds());
        }
        this.batchResult.setSheets(sheets);
        this.batchResult.setSnapshot(snapshot);
        if (sheets.isEmpty() && snapshot.isEmpty()) {
            this.batchResult.setSkipNextAction(true);
        }
        if (!snapshot.isEmpty()) {
            this.trackerOpContext.setHasSnapshot(true);
            HashSet<Long> srcMainTableIds = new HashSet<Long>(1);
            HashSet<Long> srcBillIds = new HashSet<Long>(1);
            for (CtSheet histSheet : snapshot.values()) {
                for (CtRow row : histSheet.getCtRows().values()) {
                    srcMainTableIds.add(row.getSId().getMainTableId());
                    srcBillIds.add(row.getSId().getBillId());
                }
            }
            this.trackerOpContext.getHistSrcMainTableIds().addAll(srcMainTableIds);
            this.trackerOpContext.getHistSrcBillIds().addAll(srcBillIds);
        }
    }
}

