/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerOpContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.actions.AbstractCtTrackAction;
import kd.bos.service.ctbotp.track.bizentity.CtAED;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.helper.CtBillTrackerBuilder;
import kd.bos.service.ctbotp.track.helper.CtSheetSync;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;

public class CtCalcRealAmountAction
extends AbstractCtTrackAction {
    public CtCalcRealAmountAction(CtBFTrackerContext trackerContext, CtBFTrackerOpContext trackerOpContext, CtLinkItemContext linkItemContext, CtBFTrackerResult trackerResult, CtBillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        CtAED<CtRow> aedRows = this.batchResult.getAEDRows();
        Map<Long, CtWRuleCompiler> allRuleVers = this.trackerOpContext.getAllRuleVers();
        List<CtWRule> lstWRules = this.mergeWRuleWithHistory(aedRows);
        CtSheetSync.calcRealAmount(allRuleVers, lstWRules);
        this.batchResult.setWRules(lstWRules);
    }

    private List<CtWRule> mergeWRuleWithHistory(CtAED<CtRow> aedRows) {
        CtWRule wRule;
        CtAED<CtWRule> aedWRule = CtSheetSync.syncWRules(aedRows);
        int size = aedWRule.getDeleteList().size() + aedWRule.getEditList().size() + aedWRule.getAddList().size();
        ArrayList<CtWRule> wrules = new ArrayList<CtWRule>(size);
        for (CtWRule ctWRule : aedWRule.getDeleteList()) {
            wRule = CtWRule.mergeHistoryRow(null, ctWRule);
            wrules.add(wRule);
        }
        for (Tuple tuple : aedWRule.getEditList()) {
            CtWRule currWRule = (CtWRule)tuple.item1;
            CtWRule snapWRule = (CtWRule)tuple.item2;
            CtWRule wRule2 = CtWRule.mergeHistoryRow(currWRule, snapWRule);
            wrules.add(wRule2);
        }
        for (CtWRule ctWRule : aedWRule.getAddList()) {
            wRule = CtWRule.mergeHistoryRow(ctWRule, null);
            wrules.add(wRule);
        }
        return wrules;
    }
}

